/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RQuiet1TxF_BIS.c
 * DESCRIPTION:      Implements the TX state function for the states
 *                   R-QUIET1 in G.dmt.bis.
 *
 **********************************************************************/
// ******************************************************************
// RQuiet1TxF_bis.c
//
// History
//
// 19/04/2010 Nihar: Fix for Link hole against VINAX DSLAM(Failing in reverb3).
//       The fix includes Tx boost in Rquiet1 by 1.5db if  Vinax with 0xA38B Co Vendor ID
//       and if the loop length > 3500M
//       Grep for PERF_US_ALL_VINAX_TxPwrBoost1.5dB
//
// 22/07/2010 Nihar : Reducing Tx power by 3 dB (in DELT mode)
//               when measured PGA in C-COMB1 is above 21 dB
//               Reduction of TX power by 3dB for loops up to 3kft when DELT is used
//               Grep for IOP_DS_BisPlus_CNXT_ReduceTxPwrDELT
//
// 22/07/2010 Nihar: Move the Tx power boost by 1dB from R-Quiet1 Tx to R-Reverb1 Tx
//              only against CNXT COs as they were giving more PCB otherwise. For
//                   all other COs, it stays here. To enable it for CNXT, cw INFO 103 0 0x4
//                   Grep for PERF_US_ALL_ALL_TxPwrBoost1dB
//
// 25/01/2012 Sriram Shastry : Upstream CRC's are seen against the Connexant E67.15.1 Co in the Mid range loops.Modified the Tssi index and value to
// reduce the US CRC's.
// Grep for : Enhancement_US_BISPlus_CNXT_USCRC_MidrangeLoops
// 28/05/2012 Raghu M : Annex M TX PSD adjustments for all the 9 masks. TX Var gain is adjusted
//            to meet the varoius masks.
//            Grep for JIRA: XDSLRTFW-407
//
// 24/12/2012 Vinjam: From G.992.5J Mask-9 PSD measurements, TxPSD has a head room of ~6dB
//            Boosted Tx power by 6dB for G.92.5J Mask-9.
//
// 24/1/2013 Vinjam: Re-adjusted Tx power using "gus_TxGain_NoCutBack" to meet the TxPSD.
//           Also fxied a bug in adding "6dB' compensation for "IFFFT" scaleback stages.
//           Grep for XDSLRTFW-296 FIX_US_PLUS_ALL_MeetTxPsdIn5Jmodes
// 2/04/2013 Mahesh Set proper fuse data in AFE regs BIAS1 & DAC1_MISC1 & adjusted PSDs for all modes
//       Grep for XDSLRTFW-785: Bug_All_All_All_PsdAfeReg
//
// 13/03/2014 Sriram Shastry : Increase US data rate against  BRCM CO for A.1.4.3 24 HDSL NEXT impairment_testprofile AU_RA_L_30000K
//          Grep for XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise
//
// 14/03/2014 Anantha Ramu: Distributed Tx gains among registers V_TX_VARGAIN & V_HBFILT_CFG output scaling, to remove overflows. Also reduced
//            Tx gain to minimise CRCs which arise during temperature chamber test.
//            Grep for: XDSLRTFW-1611
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "states.h"
#include "tx_ops.h"
#include "TxTneSt.h"
#include "RCombTxF_bis.h"
#include "RReverbTxF_bis.h"
#include "hndshk_Data.h"
#include "ec_init.h"
#include "ifft_cutback.h"
#include "STR_IOf.h"
#include "const.h"
#include "fifo.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

// XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (START)
// Restore Tx gain from G.hs Tx power boost
// 20*log10(X/2^14)=YdB  X = (2^14) * 10^(YdB/20)
#ifdef ISDN
#define TX_PWR_MINUS_6_DB        (8211)       // tx power reduced by -6.0dB
#define TX_PWR_MINUS_5_DB        (9213)       // tx power reduced by -5.0dB
#define TX_PWR_MINUS_4_DB        (10338)      // tx power reduced by -4.0dB
#define TX_PWR_MINUS_3_DB        (11599)      // tx power reduced by -3.0dB
#endif
// XDSLRTFW-772 IOP_US_ADSL_B_ALL_VINAX_BoostTxPower (END)

/**********************************************************************
 * Function: RQuiet1TxF_BIS
 *
 * Description: Implements the states R_QUIET1_TX_BIS
 **********************************************************************/
#define MINIMUM_GHS_TONE_PWR_AT_300m_CNXTD57       20650


//XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)
extern int16 gus_TxGain_ADSL2_AnnexM[9];
extern int16 gus_TxGain_ADSL2Plus_AnnexM[9];
//XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (END)

extern int configure_vargain(void); // XDSLRTFW-1850: Cleanup of Tx path configuration(Start_End)

void RQuiet1TxF_BIS(void)
{
//   int32 l_temp;
//   int16 s_temp;
   uint16 us_TxGainChangeFactor1 = 0, us_TxGainChangeFactor2 = 0;

   if(gl_TxSymbolCount == 0)
   {

      gft_BIS_TX_transition = FALSE;   // Initialize flag
      TxToneSetUp(0,0,0);           // Send R-QUIET symbol
      gft_IFFT_On = FALSE;       // No need to do IFFT for R-QUIET symbol

      gt_TaskArray[TX_FRAME_START].TimeCriticalTask=TxProcessTones;

      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         gt_StateMachCntrl.l_TXCurrentStateLen = R_QUIET1_MAX_TX_LEN_BIS - 1;
      else
            gt_StateMachCntrl.l_TXCurrentStateLen = R_QUIET1_MAX_TX_LEN_BIS_DIAG - 1;
   }

   if(gft_BIS_TX_transition == TRUE)   // Waiting fpr RX to go to the next state
   {

#ifdef ISDN
      gus_TxSineGain = gus_TxGain_NoCutBack;
      LoadTxSineGain();
#endif
   gs_TxNextState = R_COMB1_TX_BIS;
   gpF_TxStateFunc = (PtrToFunc)RComb1TxF_BIS;


     //XDSLRTFW-1887 (Start)
     if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_R_REVERB_2)
     {
        //Freeze CPE Tx in state: R-REVERB-2
        gs_TxStateJumpFrom = R_QUIET5_TX_BIS;
        gs_RxStateJumpFrom = R_C_REVERB2_RX_BIS;
     }
     else if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_R_REVERB_7)
     {
        //Freeze CPE Tx in state: R-REVERB-7
        gs_TxStateJumpFrom = R_SEGUE4_TX_BIS;
        gs_RxStateJumpFrom = R_C_REVERB7_RX_BIS;
     }
     else if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_R_MEDLEY)
     {
        //Freeze CPE Tx in state: R-MEDLEY
        gs_TxStateJumpFrom = R_EXCHMARKER_TX_BIS;
        gs_RxStateJumpFrom = R_C_MEDLEY_RX_BIS;
     }
     else if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_SHOWTIME)
     {
        //Freeze CPE Tx in Showtime with CO defined fine gains
        gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 = 0;
        gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset1 = 0;
        TESTArray[TEST_SuppressErrorReportingToME] = (int16)0xFFFF;
     }
     else if (TESTArray[TEST_FREEZE_CPE_TX] & TEST_FREEZE_CPE_TX_SHOWTIME_UNITY_GAIN)
     {
        //Freeze CPE Tx in Showtime with unity fine gains
        gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 = 0;
        gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset1 = 0;
        TESTArray[TEST_SuppressErrorReportingToME] = (int16)0xFFFF;

        TESTArray[TEST_Control3] |= TEST_ForceUpStreamFineGainsToUnity;
     }
     //XDSLRTFW-1887 (End)

   gft_BIS_TX_transition = FALSE;
   }
}
#if 0

// XDSLRTFW-1850: Cleanup of Tx path configuration (Start)
int configure_vargain(void)
{
    return 0;
}
#endif
// XDSLRTFW-1850: Cleanup of Tx path configuration (End)
