/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RQuiet2SITxF_BIS.c
 * DESCRIPTION:      Implements the TX state function for the state
 *                   R-QUIET2_SI_TX_BIS in G.bis.
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "states.h"
#include "tx_ops.h"
#include "TxTneSt.h"
#include "RCombTxF_bis.h"
#include "RReverbTxF_bis.h"
#include "hndshk_Data.h"


/**********************************************************************
 * Function: RQuiet2SITxF_BIS
 *
 * Description: Implements the states R_QUIET2_SI_TX_BIS
 **********************************************************************/

void RQuiet2SITxF_BIS(void)
{

   if(gl_TxSymbolCount == 0)
   {
      TxToneSetUp(0,0,0);           // Send R-QUIET symbol
      gft_IFFT_On = FALSE;       // No need to do IFFT for R-QUIET symbol
   }

   if(gl_TxSymbolCount == 256-1)
   {
      gs_TxNextState  = R_COMB1_TX_BIS;
      gpF_TxStateFunc   = (PtrToFunc)RComb1TxF_BIS;
   }
}
