/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "states.h"
#include "tx_ops.h"
#include "TxTneSt.h"
#include "RQuietTxF_bis.h"
#include "stateini.h"
#ifdef TARGET_HW
#include "codeswap.h"
#include "soc_codeswap.h"
#endif

/**********************************************************************
 * Function: RQuiet2TxF_BIS
 *
 * Description: Implements the states R_QUIET2_TX_BIS
 **********************************************************************/

void RQuiet2TxF_BIS(void)
{
   if(gl_TxSymbolCount == 0)
   {
      gft_BIS_TX_transition = FALSE;   // Initialize flag
      TxToneSetUp(0,0,0);           // Send R-QUIET symbol
      gft_IFFT_On = FALSE;       // No need to do IFFT for R-QUIET symbol

      //Initiate sending autonomous message requesting for desired TC driver
      //(i.e. ATM or PTM/EFM) to be loaded
      Set_AutoMsg_FW_PPE_TcMode();  /* XDSLRTFW-3068 */

      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         gt_StateMachCntrl.l_TXCurrentStateLen = R_QUIET2_NORMAL_MAX_TX_LEN_BIS - 1;
      else
         gt_StateMachCntrl.l_TXCurrentStateLen = R_QUIET2_TX_LEN_BIS_DIAG - 1;

   }

#ifdef TARGET_HW
   //switch to codeswap duplicate of RQuiet2TxF once DISC2 page is completely swapped in
   if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_DISC3))
   {
#endif
      /* Switch the R-QUIET2 TX state function to the one that resides in */
      /* DISC2 */
      gpF_TxStateFunc = (PtrToFunc)RQuiet2TxF_BIS_CS;
#ifdef TARGET_HW
   }
   else if (gl_TxSymbolCount > gt_StateMachCntrl.l_TXCurrentStateLen) {
      /* if timeout occurs, go to exception state */
      gs_TxNextState = FAIL_TX;
        gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_CODESWAP_ERR;
      }

#endif

}
