/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "states.h"
#include "tx_ops.h"
#include "TxTneSt.h"
#include "RCombTxF_bis.h"
#include "RReverbTxF_bis.h"
#include "hndshk_Data.h"


/**********************************************************************
 * Function: RQuiet2TxF_BIS
 *
 * Description: Implements the states R_QUIET2_TX_BIS for codeswap reason
 **********************************************************************/

void RQuiet2TxF_BIS_CS(void)
{
   if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
   {

      if(gft_BIS_TX_transition == TRUE)   // Waiting fpr RX to go to the next state
      {                          // Now ready
      gs_TxNextState = R_COMB2_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RCombTxF_BIS;
      gft_BIS_TX_transition = FALSE;

      }

      /* if timeout occurs, go to exception state */
      if (gl_TxSymbolCount > gt_StateMachCntrl.l_TXCurrentStateLen) {
      gs_TxNextState = FAIL_TX;
        gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RQuiet2Tx_Bis_TIME_OUT;
      }
   }
   else  //if((STATArray[STAT_MacroState] == STAT_LoopDiagMode) && (gs_TxState != R_QUIET1_TX_BIS))
   {
      if(gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen)
   {
      gs_TxNextState = R_COMB2_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RCombTxF_BIS;
   }
   }

}
