/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 *
 **********************************************************************/
 // ******************************************************************
 // RQuiet3TxF_BIS.c
 //
 // History
 //
 // 07/06/2012 Vinjam: Increased the Quiet3 Tx period to make sure that
 //         Receiver extracts all Transmitter referred downstream
 //         virtual noise break points before Rx Triggers the Tx to
 //         change its state (from RQuiet3 to RCOMB3).
 //         Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
 //
 // 07/06/2012 Vinjam: Changed the state transition time for LDM mode
 //      Reason: C-MSG-PCB state symbols increases in LDM mode with
 //      Virtual noise feature enabled. To synchronize Tx & Rx properly this is done.
 //      Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
 // ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "states.h"
#include "tx_ops.h"
#include "TxTneSt.h"
#include "RCombTxF_bis.h"
#include "RReverbTxF_bis.h"
#include "hndshk_Data.h"


/**********************************************************************
 * Function: RQuiet3TxF_BIS
 *
 * Description: Implements the states R_QUIET3_TX_BIS.
 **********************************************************************/

void RQuiet3TxF_BIS(void)
{
   int16 s_R_QUIET3_MAX_TX_LEN_BIS, s_R_QUIET3_TX_LEN_BIS_DIAG;
   uint16 us_NumOfDsVnBreakPoints; //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
   us_NumOfDsVnBreakPoints = gt_DS_RefVirtNoiseLevel_ADSL2.us_NumberOfTones;
   if(us_NumOfDsVnBreakPoints == 0)
   {
      s_R_QUIET3_MAX_TX_LEN_BIS = 410 + 3 * gs_TxNumTones;
   }
   else
   {
      s_R_QUIET3_MAX_TX_LEN_BIS = 410 + (3 * gs_TxNumTones) + (us_NumOfDsVnBreakPoints*3*8*3);
   }
   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)

   //XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START_END)
   s_R_QUIET3_TX_LEN_BIS_DIAG = 778 + (8 * gs_TxNumTones) + (us_NumOfDsVnBreakPoints*3*8*8);

   if(gl_TxSymbolCount == 0)
   {
      gft_BIS_TX_transition = FALSE;   // Initialize flag
      TxToneSetUp(0,0,0);           // Send R-QUIET symbol
      gft_IFFT_On = FALSE;       // No need to do IFFT for R-QUIET symbol


      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         gt_StateMachCntrl.l_TXCurrentStateLen = s_R_QUIET3_MAX_TX_LEN_BIS - 1;
      else
         gt_StateMachCntrl.l_TXCurrentStateLen = s_R_QUIET3_TX_LEN_BIS_DIAG - 1;
   }


   if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
   {

      if(gft_BIS_TX_transition == TRUE)   // Waiting fpr RX to go to the next state
      {                          // Now ready
      gs_TxNextState = R_COMB3_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RCombTxF_BIS;
      gft_BIS_TX_transition = FALSE;

      }

      /* if timeout occurs, go to exception state */
      if (gl_TxSymbolCount > gt_StateMachCntrl.l_TXCurrentStateLen) {
      gs_TxNextState = FAIL_TX;
        gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* Set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RQuietTx_Bis_TIME_OUT;
      }
   }
   else  //if((STATArray[STAT_MacroState] == STAT_LoopDiagMode) && (gs_TxState != R_QUIET1_TX_BIS))
   {
      if(gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen)
   {
      gs_TxNextState = R_COMB3_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RCombTxF_BIS;
   }
   }

}
