/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RQuiet4TxF_BIS.c
 * DESCRIPTION:      Implements the TX state function for the states
 *                   R-QUIET4 in G.dmt.bis.
 *
 **********************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "states.h"
#include "tx_ops.h"
#include "TxTneSt.h"
#include "RCombTxF_bis.h"
#include "RReverbTxF_bis.h"
#include "hndshk_Data.h"


/**********************************************************************
 * Function: RQuiet4TxF_BIS
 *
 * Description: Implements the states R_QUIET4_TX_BIS
 **********************************************************************/

void RQuiet4TxF_BIS(void)
{

   if(gl_TxSymbolCount == 0)
   {
      gft_BIS_TX_transition = FALSE;   // Initialize flag
      TxToneSetUp(0,0,0);           // Send R-QUIET symbol
      gft_IFFT_On = FALSE;       // No need to do IFFT for R-QUIET symbol

      /* If state machine enter this state, then the length of R_QUIET4_TX_BIS is bigger than 0 */
      gt_StateMachCntrl.s_TXFollowingState = R_REVERB2_TX_BIS;
      gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverb2TxF_BIS;

        if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
         gt_StateMachCntrl.l_TXCurrentStateLen = (int32)(gt_RCMsgFmt_bis.us_FMT_R_QUIET4<<9) - 1;
      else
            gt_StateMachCntrl.l_TXCurrentStateLen = R_QUIET4_TX_LEN_BIS_DIAG - 1;
   }


      if(gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen)
   {
        gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
   }

}
