/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RQuiet5TxF_bis.c
 *
 *   Transceiver Training Phase 1 TX State Functions for ATU-R.
 *   Covering the TX states: R_QUIET5.
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "TxTneSt.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "states.h"
#include "RReverbTxF_bis.h"
#include "cmv.h"
#include "AFED_Functions.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RQuiet5TxF_BIS
 *
 *  Description: Transmits R_QUIET5 signal for >= 1024 and <= 16384 symbols.
 *          The state length must also be a multiple of 512.
 *
 *  Prototype: void RQuiet5TxF_BIS(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount - (I) # symbol periods in current TX state
 *      gs_TxNextState   - (O) TX state that will begin next symbol period
 *
 *  Notes: implements state R_QUIET5_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void RQuiet5TxF_BIS(void) {

   if (gl_TxSymbolCount == 0)
   {
      if (gs_TxState == R_QUIET5_TX_BIS)
         TxToneSetUp(0,0,0);
      gft_goto_RReverb3_Flag = FALSE;
   }

   // Program Tx POCO to PD
   if(guc_TxSilence == SILENCE_IN_PROGRESS)
   {
      vrx5afe_POCO_PD();
      guc_TxSilence = SILENCE_WAIT;
   }
   else if (guc_TxSilence == SILENCE_DONE)
   {
      vrx5afe_POCO_PU();
      guc_TxSilence = SILENCE_WAIT;
   }

   if(STATArray[STAT_MacroState] != STAT_ShortInit)
   {
      if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
   {
      /* If the Rx side (RCReverb3RxF()) is done with training its equalizers, it sets gft_goto_RReverb3_Flag to TRUE */
      /* If this flag is set and if the zero-based Tx symbol count is a multiple of 512, go to the next state. */
        if ((gft_goto_RReverb3_Flag == TRUE) && (((gl_TxSymbolCount+1) & 0x01FF)==0)) {

      gs_TxNextState = R_REVERB3_TX_BIS;
         gpF_TxStateFunc = (PtrToFunc)RReverb34TxF_BIS;
      }


      /* if we have transmitted the max. allowed 16384 symbols of quiet, go to fail state */
        if (gl_TxSymbolCount == (R_QUIET5_MAX_TX_LEN_BIS - 1))
      {
      gs_TxNextState = FAIL_TX;
      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /*  set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RQuiet5Tx_Bis_SignalEnd_TIMEOUT;
      }
   }
     else  //if(STATArray[STAT_MacroState] == STAT_LoopDiagMode)
   {
         if (gl_TxSymbolCount == (R_QUIET5_TX_LEN_BIS_DIAG - 1))
      {
           gs_TxNextState = R_REVERB3_TX_BIS;
         gpF_TxStateFunc = (PtrToFunc)RReverb34TxF_BIS;
      }
   }

   }
   else //if(STATArray[STAT_MacroState] == STAT_ShortInit)
   {
       if (gl_TxSymbolCount == (R_QUIET5_TX_LEN_BIS_SI - 1))
      {
          gs_TxNextState = R_REVERB3_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RReverb34TxF_BIS;
      }
   }

}

