/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RQuietL3TxF_bis.c
 *
 *   ATU-R Exchange Phase in diagnostics mode.
 *   Covering the TX states: R_QUIET_L3_TX_BIS
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "fifo.h"
#include "engine_const.h"
#include "states.h"
#include "tx_ops_bis.h"
#include "cmv.h"
#include "const.h"
#include "RCombTxF_bis.h"
#include "TxTneSt.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RQuietL3TxF_BIS
 *
 *
 *  Prototype: void RQuietL3TxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *      gt_StateMachCntrl    -  (O) Maintains state machine control variables
 *
 *  Notes: implements states R_QUIET_L3_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RQuietL3TxF_BIS(void)
{

   if(gl_TxSymbolCount == 0)
   {
      TxToneSetUp(0,0,0);           // Send R-QUIET symbol
      gft_IFFT_On = FALSE;       // No need to do IFFT for R-QUIET symbol
        gs_RxSubState = 0;
      gt_TaskArray[TX_FRAME_START].TimeCriticalTask=TxProcessTones;
      // XDSLRTFW-3548 (Start)
      gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_DiagComplete;
      STATArray[STAT_MacroState] = STAT_DiagComplete;
      gusa_HercADSL_MONIMap_Curr[0] = MONI_DIAG_COMPLETE;
      // XDSLRTFW-3548 (End)
   }

   if(STATArray[STAT_MacroState] == STAT_ShortInit)
   {
   gs_TxNextState = R_COMB1_TX_BIS;
   gpF_TxStateFunc = (PtrToFunc)RComb1TxF_BIS;
   }




}

