/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RReverb1TxF_bis.c
*
*   Transceiver Training Phase 1 TX State Functions for ATU-R.
*   Covering the TX states: R_REVERB1_TX_BIS, R_REVERB2_TX_BIS,
*
*   Notes:
*
*
*------------------------------------------------------------------------
*/
// ******************************************************************
// RReverb1TxF_bis.c
//
// History
//
// 22/07/2010 Nihar: Move the Tx power boost by 1dB from R-Quiet1 Tx to R-Reverb1 Tx
//              only against CNXT COs as they were giving more PCB otherwise. For
//                   all other COs, it stays here. To enable it for CNXT, cw INFO 103 0 0x4
//                   Grep for PERF_US_ALL_ALL_TxPwrBoost1dB
//
//19/08/2010 AdeelJ/Palaksh/Bhadra: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               In case fix is enabled, Transmit new TSSi shaped REVERB spectrum continuously
//               instead of dividing the REVERB state into two types of spectra.
//               This is in order to ensure a constant signal to the CO which should reduce
//               chances of unoptimal TDQ training. The modified REVERB signal also has a
//               wider spectrum as it starts from Tone 2.
//               Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 09/02/2011 Sriram: Use the special TSSI set from SMS00910375 in the range of
//            2100m to 4200m to improve the US rates against CNXT DSLAMs with FW
//            version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 18/04/2011 Sriram: Use the special TSSI set to improve the US rates against CNXT DSLAMs with FW version of 0x10.
//            This feature is controlled by CMV INFO 103 26 0x0002
//            It's enabled by default.
//            Grep for XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Taken out optimized code which reduce the program memory. It needs to be added later.
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
// ******************************************************************
#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "tx_ops_bis.h"
#include "fifo.h"
#include "RReverbTxF_bis.h"
#include "RQuietTxF_bis.h"
#include "RQuiet5TxF_bis.h"
#include "RSegueTxF_bis.h"
#include "RMsg2TxF_bis.h"
#include "states.h"
#include "cmv.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


/*^^^
*------------------------------------------------------------------------
*
*  Name: RReverb1TxF_BIS
*
*  Description: Sends the R_Reverb signal to the ATU-C.  R_Reverb is
*  sent on tones gs_TxFirstChannel to gs_TxLastChannel.
*
*  Prototype: void RReverb1TxF_BIS(void);
*
*  Input Arguments: none
*
*  Output Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*      gs_TxToneBuf[]      - (O) frequency domains samples (set in TxReverbSegue() )
*     gs_TxState        - (I) current TX state
*      gl_TxSymbolCount - (I) # symbol periods in current TX state
*      gs_TxNextState      - (O) TX state that will begin next symbol period
*
*  Notes: implements states R_REVERB1_TX_BIS, R_REVERB2_TX_BIS
*
*
*------------------------------------------------------------------------
*^^^
*/
void RReverb1TxF_BIS(void) {

    if ((gl_TxSymbolCount == 0) || ((guc_HybTssiOff & 0x10) != 0))
    {
        /* RX state machine signals the need for REVERB change using BIT4 in the */
        /* guc_HybTssiOff variable. Clear this bit for future use. */
      //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
   //ADSLRTFW-1344 IOP_A_US_Plus_CNXT_MidloopRateImprove (START_END)
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)

#ifdef ISDN
      //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (End)
        guc_HybTssiOff &= 0xEF;
        if (guc_HybTssiOff == 0)
        {
            /* Set up REVERB signal with TSSI. */
            TxReverbSegueSetUp_Xcvr_Training_BIS(R_REVERB);
        }
        else
        {
            /* Set up REVERB signal without TSSI. */
            TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);
        }
#else // oPOTS begins here
      if (OPTNArray[OPTN_TXPathControl] & 0x01)    // if US performance fix: on
      {
         guc_HybTssiOff &= 0xEF;
            /* Set up REVERB signal with TSSI. */
            TxReverbSegueSetUp_Xcvr_Training_BIS(R_REVERB);
      }
      else
      {
         //XDSLRTFW-238 IOP_A_US_Plus_CNXT_MidloopRateImprove (START_END)
         if((gft_USPerf_Intracom_Gspn) || (gft_USPerf_Gspn)) //XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START_END)
            TxReverbSegueSetUp_Xcvr_Training_BIS(R_REVERB);  //continously send TSSI shaped signal
         else
         {
            //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (End)
            guc_HybTssiOff &= 0xEF;
            if (guc_HybTssiOff == 0)
            {
               /* Set up REVERB signal with TSSI. */
               TxReverbSegueSetUp_Xcvr_Training_BIS(R_REVERB);
            }
            else
            {
               /* Set up REVERB signal without TSSI. */
               TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);
            }
         } //SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (Start_End)
      }

        // PERF_US_ALL_ALL_TxPwrBoost1dB (Start)

      //------------------------------------------------------------------------
      // WARNING: AFED_IncreaseTxPowerInAFE is NOT SUPPORTED IN VRx518 !!!!
      //------------------------------------------------------------------------
        if ((gl_SelectedMode & MODE_ADSL2) && (gs_CurrentCoChipset == GSI_CO_CHIPSET) &&
            (gs_TxState == R_REVERB1_TX_BIS) &&
            (gt_INFX_CMV.us_OperatorSpBits & CMV_TO_DISABLE_DS_PCB)) // BIS or Plus Mode
            AddFunctionToFifo(gp_TxLoadingFunctionFifo, AFED_IncreaseTxPowerInAFE); // XDSLRTFW-1891(Start_End)


        // PERF_US_ALL_ALL_TxPwrBoost1dB (End)                                                                         )
#endif // ifndef ISDN - oPOTS ends here
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)

    }

    if (gl_TxSymbolCount == 0) {

        AddFunctionToFifo(gp_TxLoadingFunctionFifo,Enable_IFFT_Reordering);
        gft_IFFT_On = TRUE;

        /*  state machine control */
        switch (gs_TxState)
        {
        case R_REVERB1_TX_BIS:
            if (STATArray[STAT_MacroState] != STAT_LoopDiagMode)
            {
                if(((gt_RMsgFmt_bis.us_FMT_R_REVERB1 == 0) && (gt_RCMsgFmt_bis.us_FMT_R_REVERB1 == 0))
                        || (STATArray[STAT_MacroState] == STAT_ShortInit))
                gt_StateMachCntrl.l_TXCurrentStateLen = (R_REVERB1_TX_LEN1_BIS-1);
                else
                gt_StateMachCntrl.l_TXCurrentStateLen = (R_REVERB1_TX_LEN2_BIS-1);

                if((gt_RCMsgFmt_bis.us_FMT_R_QUIET4 >0) && (STATArray[STAT_MacroState] != STAT_ShortInit ))/* If CO asks for R-QUIET4 state */
                {
                    gt_StateMachCntrl.s_TXFollowingState  = R_QUIET4_TX_BIS;
                    gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RQuiet4TxF_BIS;
                }
                else
                {
                    gt_StateMachCntrl.s_TXFollowingState  = R_REVERB2_TX_BIS; // Skip R-QUIET4
                    gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverb2TxF_BIS;
                }
            }
            else /* if (STATArray[STAT_MacroState] == STAT_LoopDiagMode) */
            {
                gt_StateMachCntrl.l_TXCurrentStateLen = (R_REVERB1_TX_LEN2_BIS-1);
                gt_StateMachCntrl.s_TXFollowingState  = R_QUIET4_TX_BIS;
                gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RQuiet4TxF_BIS;
            }

            break;
        }

    }

    if((gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen)
            || ((gft_BIS_TX_transition == TRUE) && (STATArray[STAT_MacroState] != STAT_LoopDiagMode)))
    {
        gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
        gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
        gft_BIS_TX_transition = FALSE;
    }
}
