/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb34TxF_bis.c
 *
 *   Transceiver Training Phase 1 TX State Functions for ATU-R.
 *   Covering the TX states: R_REVERB3_TX_BIS, R_REVERB4_TX_BIS,
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */
//*******************************************************************
// RReverb34TxF_bis.c
//
// History
//
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
//*****************************************************************************

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops_bis.h"
#include "fifo.h"
#include "REctTxF.h"
#include "RSegueTxF_bis.h"
#include "RMsg2TxF_bis.h"
#include "states.h"
#include "cmv.h"

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
#include "LL_IOf.h"     //ReadCoreReg(), WriteCoreReg() defined here
#include "STR_ini.h"
#include "STR_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "ec_data.h"

#include "memrymap.h"
#include "datapumpsetup_tx.h"
#include "IRI_Iof.h"
#include "IRI_IOf_tables.h"
#include "IRI_Iof.h"
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb34TxF_BIS
 *
 *  Description: Sends the R_Reverb signal to the ATU-C.
 *
 *  Prototype: void RReverb34TxF_BIS(void);
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gs_TxToneBuf[]     - (O) frequency domains samples (set in TxReverbSegue() )
 *    gs_TxState        - (I) current TX state
 *      gl_TxSymbolCount   - (I) # symbol periods in current TX state
 *      gs_TxNextState     - (O) TX state that will begin next symbol period
 *
 *  Notes: implements states R_REVERB3_TX_BIS, R_REVERB4_TX_BIS
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RReverb34TxF_BIS(void) {
#ifndef ISDN
   uint32 ul_data;         //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start_End)
#endif

   if (gl_TxSymbolCount == 0) {

      /*  set up freq domain REVERB signal in gsa_TxToneBuf input buffer  */
      TxReverbSegueSetUp_Xcvr_Training_BIS(R_REVERB);
      AddFunctionToFifo(gp_TxLoadingFunctionFifo,Enable_IFFT_Reordering);
      gft_IFFT_On = TRUE;

         /*  state machine control */
      switch (gs_TxState)
      {
         case R_REVERB3_TX_BIS:
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
#ifndef ISDN
            if (OPTNArray[OPTN_TXPathControl] & 0x01)    // if US performance fix: on
            {
               //   0x01:     SWITCH_BEFORE_RREVERB3
               //   0x02:     SWITCH_BEFORE_RREVERB4
               //   0x04:     SWITCH_BEFORE_RREVERB5
               //   0x08:     SWITCH_BEFORE_MEDLEY (not supported)
               // 0x80xx:     compensate DECDelay
               if (gus_TxPathControl & 0x1)  // SWITCH_BEFORE_RREVERB5)
               {
                  //gus_TxPathControl = gus_TxPathControl & (~(0x1));   // SWITCH_BEFORE_RREVERB5);
                  if (gus_TxPathControl & 0x1000)  // change tx-filter delay
                  {
                     gula_Strymon_TxIir_Pots_Plus[26] = 26771;
                     gula_Strymon_TxIir_Pots_Plus[28] =     0;
                     gs_TxIIRFilterSelect = TXIIR_POTS_PLUS;
                     LoadTxIir();
                  }
                  if (gus_TxPathControl & 0x2000)  // 1 image
                  {
                     ReadCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, &ul_data);
                     ul_data &= ~(3<<11);
                     ul_data |=(1<<11);
                     WriteCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, ul_data);
                  }
                  if (gus_TxPathControl & 0x4000)  // all images
                  {
                     ReadCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, &ul_data);
                     ul_data &= ~(3<<11);
                     ul_data |=(2<<11);
                     WriteCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, ul_data);
                  }
                  if (gus_TxPathControl & 0x8000)  // SHIFT_DEC)
                  {
                     gs_DEC_SHIFT = gs_DEC_SHIFT_INIT;
                     AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
                  }
               }
            }
#endif
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)
            gt_StateMachCntrl.l_TXCurrentStateLen = (R_REVERB3_TX_LEN_BIS-1);
            gt_StateMachCntrl.s_TXFollowingState  = R_ECT_TX_BIS;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)REctTxF;
            break;

         case R_REVERB4_TX_BIS:
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
#ifndef ISDN
            if (OPTNArray[OPTN_TXPathControl] & 0x01)    // if US performance fix: on
            {
               //   0x01:     SWITCH_BEFORE_RREVERB3
               //   0x02:     SWITCH_BEFORE_RREVERB4
               //   0x04:     SWITCH_BEFORE_RREVERB5
               //   0x08:     SWITCH_BEFORE_MEDLEY (not supported)
               // 0x80xx:     compensate DECDelay
               if (gus_TxPathControl & 0x2)  // SWITCH_BEFORE_RREVERB5)
               {
                  if (gus_TxPathControl & 0x1000)  // change tx-filter delay
                  {
                     gula_Strymon_TxIir_Pots_Plus[26] = 26771;
                     gula_Strymon_TxIir_Pots_Plus[28] =     0;
                     gs_TxIIRFilterSelect = TXIIR_POTS_PLUS;
                     LoadTxIir();
                  }
                  if (gus_TxPathControl & 0x2000)  // 1 image
                  {
                     ReadCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, &ul_data);
                     ul_data &= ~(3<<11);
                     ul_data |=(1<<11);
                     WriteCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, ul_data);
                  }
                  if (gus_TxPathControl & 0x4000)  // all images
                  {
                     ReadCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, &ul_data);
                     ul_data &= ~(3<<11);
                     ul_data |=(2<<11);
                     WriteCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, ul_data);
                  }
                  if (gus_TxPathControl & 0x8000)  // SHIFT_DEC)
                  {
                     gs_DEC_SHIFT = gs_DEC_SHIFT_INIT;
                     AddFunctionToFifo(gp_RxLoadingFunctionFifo,LoadDECTDQ);
                  }
               }
            }
#endif
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)
            gt_StateMachCntrl.l_TXCurrentStateLen = (gs_RCReverb4_rx_len_bis-1);
            gt_StateMachCntrl.s_TXFollowingState  = R_SEGUE1_TX_BIS;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RSegue12TxF_BIS;
            break;
      }

   }

   if((gl_TxSymbolCount == gt_StateMachCntrl.l_TXCurrentStateLen)
   || ((gft_BIS_TX_transition == TRUE) && (STATArray[STAT_MacroState] != STAT_LoopDiagMode)))
   {
        gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;
      gft_BIS_TX_transition = FALSE;
   }
}
