/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb6TxF_bis.c
 *
 *   Transceiver Training Phase 1 TX State Functions for ATU-R.
 *   Covering the TX states: R_REVERB6_TX_BIS
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "fifo.h"
#include "const_bis.h"
#include "states.h"
#include "RSegueTxF_bis.h"
//Socrates codeswap purpose
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb6TxF_BIS
 *
 *  Description: R_REVERB6_TX transmits the R_Reverb signal.
 *
 *  Prototype: void RReverb6TxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *
 *  Notes: implements states R_REVERB6_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RReverb6TxF_BIS(void) {

    if (gl_TxSymbolCount == 0) {

      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);
      gft_IFFT_On = TRUE;
    }

#ifdef BIS_CODESWAP
   if ((gs_RxState >= R_C_REVERB6_RX_BIS) &&
      (guc_FormRParamsState == TRAINING_DONE) &&
      (gs_CodeSwapStatus == CODESWAP_IDLE) &&
      (gs_CodeSwapSection == CSPAGE_BIS_SHOW1))
   {
      gs_CodeSwapStatus = CODESWAP_START;
   }
   if ((gs_CodeSwapStatus == CODESWAP_IDLE) &&
      (gs_CodeSwapSection == CSPAGE_BIS_TXINIT))
#else
   if ((gs_RxState >= R_C_REVERB6_RX_BIS) &&
      (guc_FormRParamsState == TRAINING_DONE))
#endif //BIS_CODESWAP
   {

      if(gl_TxSymbolCount >= (R_REVERB6_TX_BIS_MIN_LEN-1))
      {
         gs_TxNextState = R_SEGUE3_TX_BIS;
         gpF_TxStateFunc = (PtrToFunc)RSegue3TxF_BIS;
      }
   }

   /* Check if time out happens */
   if (gl_TxSymbolCount >= R_REVERB6_TX_BIS_TIMEOUT) {
        gs_TxNextState = FAIL_TX;

      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RReverb6Tx_Bis_TIME_OUT;
    }
}
