/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb7TxF_bis.c
 *
 *   Transceiver Training Phase 1 TX State Functions for ATU-R.
 *   Covering the TX states: R_REVERB7_TX_BIS
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "showinit.h"
#include "tx_ops.h"
#include "fifo.h"
#include "const_bis.h"
#include "states.h"
#include "RSegueTxF_bis.h"
#include "RReverb7TxF_bis.h"

//Socrates codeswap
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb7TxF_BIS
 *
 *  Description: R_REVERB7_TX transmits the R_Reverb signal.
 *
 *  Prototype: void RReverb7TxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *
 *  Notes: implements states R_REVERB7_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define R_REVERB7_WAIT_FOR_CPARAMS_DECODED      (0)
#define R_REVERB7_TX_SHOWTIME_INITIALIZE     (1)
#define R_REVERB7_TX_DATA_PUMP_SETUP         (2)
#define R_REVERB7_TX_CODESWAP_SETUP             (3)

FlagT gft_RxReachReverb = FALSE;
void RReverb7TxF_BIS(void) {
   if (gl_TxSymbolCount == 0)
   {
      gs_TxSubStateCnt =0;
      guc_ShowTimeTxState = TRAINING_WAITING;
      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_REVERB);
      gft_IFFT_On = TRUE;
      gs_TxSubState = R_REVERB7_WAIT_FOR_CPARAMS_DECODED;
    }

    if((gft_RxReachReverb == FALSE) && (gs_RxState == R_C_REVERB7_RX_BIS))
      gft_RxReachReverb = TRUE;

   if(gft_RxReachReverb)
         gs_TxSubStateCnt++;

   if (gft_SkipCparams == FALSE)
   {
      switch(gs_TxSubState)
      {
         case R_REVERB7_WAIT_FOR_CPARAMS_DECODED:

            if ((gs_RxState == R_C_REVERB7_RX_BIS || gs_RxState == R_C_SHOWTIME_RX) && (gft_DecodeCParamsOK == TRUE))
            {

#ifdef BIS_CODESWAP

               if ((gs_CodeSwapStatus == CODESWAP_IDLE) &&
                  (gs_CodeSwapSection == CSPAGE_BIS_TXINIT))
               {
                  gs_CodeSwapStatus = CODESWAP_START;
                  gs_TxSubState = R_REVERB7_TX_CODESWAP_SETUP;
               }
#else
               gs_TxSubState = R_REVERB7_TX_SHOWTIME_INITIALIZE;
#endif
            }
            break;

#ifdef BIS_CODESWAP
         case R_REVERB7_TX_CODESWAP_SETUP:
            // We should transit to showtime Tx initialization after we swap in TXINIT
            if ((gs_CodeSwapSection == CSPAGE_BIS_SHOW2) && (gs_CodeSwapStatus == CODESWAP_IDLE))
                  gs_TxSubState = R_REVERB7_TX_SHOWTIME_INITIALIZE;

            break;
#endif

         case R_REVERB7_TX_SHOWTIME_INITIALIZE:
            gs_TxSubState = R_REVERB7_TX_DATA_PUMP_SETUP;
               guc_ShowTimeTxState = TRAINING_IN_PROGRESS;
#ifdef ADSL_62
            AddFunctionToFifo(gp_RxLoadingFunctionFifo, ClearTxZephyrRegs);
#endif
            AddFunctionToBkgdFifo((PtrToBkgdFunc)BgInitShowTimeTx);
            guc_TxDataPumpState = TRAINING_WAITING;
            break;

         case R_REVERB7_TX_DATA_PUMP_SETUP:
            if ((guc_ShowTimeTxState == TRAINING_DONE) && (guc_TxDataPumpState != TRAINING_DONE))
            {
            AddFunctionToFifo(gp_TxLoadingFunctionFifo,TxDataPumpSetUp);
            }
            break;

      } // switch(gs_TxSubState)
   }

   /* If time for codeswap */
   if ((gft_SkipCparams) ||
      ((gs_TxSubState == R_REVERB7_TX_DATA_PUMP_SETUP) && (guc_TxDataPumpState == TRAINING_DONE)) )
   {
      // For codeswap purpose, we will direct the process go to next page.
#ifdef BIS_CODESWAP
      if ((gs_CodeSwapStatus == CODESWAP_IDLE) && (gs_CodeSwapSection == CSPAGE_BIS_SHOW2) ) {
         gs_CodeSwapStatus = CODESWAP_START;
      }

      // When to swap in SHOWBG1 is taken care of by codeswap.c
      if ((gs_CodeSwapSection == CSPAGE_BIS_SHOWBG1) && (gs_CodeSwapStatus == CODESWAP_IDLE))
#endif //BIS_CODESWAP
         gpF_TxStateFunc = (PtrToFunc)RReverb7TxF_Wait_BIS;
   }

}

#undef R_REVERB7_WAIT_FOR_CPARAMS_DECODED
#undef R_REVERB7_TX_SHOWTIME_INITIALIZE
#undef R_REVERB7_TX_DATA_PUMP_SETUP
