/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RReverb7TxF_bis.c
 *
 *   Transceiver Training Phase 1 TX State Functions for ATU-R.
 *   Covering the TX states: R_REVERB7_TX_BIS
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */
// ******************************************************************
// RReverb7TxF_wait_bis.c
//
// History
//
// 14/04/2014 Hanyu: Ported ADSLRTFW-1391: Additional fix to control Tx R-Segue4 by a flag gft_CTNW_Tx_RSegue4
//                   since CNX5 has variable behavor on different cards/ports.
//                   Set the flag to allow R-Segue4 Tx if C-Segue4 is detected or timeout.
//                   Grep for XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY
//
// ******************************************************************

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "showinit.h"
#include "tx_ops.h"
#include "fifo.h"
#include "const_bis.h"
#include "states.h"
#include "RSegueTxF_bis.h"

//Socrates codeswap
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RReverb7TxF_Wait_BIS
 *
 *  Description: this file is created for codeswap purpose, we will force waiting for the SHOWTIME page swapped in.
 *
 *  Prototype: void RReverb7TxF_WaitBIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount    - (I) # symbol periods in current TX state
 *      gs_TxNextState      - (O) TX state that will begin next symbol period
 *
 *  Notes: implements states R_REVERB7_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
*/
#define LENGTH_AFTER_BOTH_ATU_IN_REVERB7    428

extern FlagT gft_RxReachReverb;
// XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (START)
// A flag to allow R-Segue4 Tx for CTNW CO/DSLAM.
extern FlagT gft_CTNW_Tx_RSegue4;
// XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (END)
int16 gs_TxReverb7_extra = 0;
void RReverb7TxF_Wait_BIS(void) {


     if((gft_RxReachReverb == FALSE) && (gs_RxState == R_C_REVERB7_RX_BIS))
      gft_RxReachReverb = TRUE;

   if(gft_RxReachReverb)
         gs_TxSubStateCnt++;

   // we extend 128 to 428 frames in RReverb7TxF to give enough time for
   // showtime page swapping.
  // XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (START)
  // For Ciena CNX5 DSLAM, set gft_CTNW_Tx_RSegue4 = 1 if and only if
  // C-Segue4 is detected or timeout.
  // To avoid IOP issue with other DSLAMs,
  // gft_CTNW_Tx_RSegue4 = 1 by default.
  if ( (gs_TxSubStateCnt >= (LENGTH_AFTER_BOTH_ATU_IN_REVERB7+gs_TxReverb7_extra)) &&
         (gft_CTNW_Tx_RSegue4) )
  // XDSLRTFW-1595 ADSLRTFW-1391 IOP_DS_BisPlus_CTNW_CSEGUE4_TOOEARLY (END)
   {
      gs_TxNextState = R_SEGUE4_TX_BIS;
      gpF_TxStateFunc = (PtrToFunc)RSegue4TxF_BIS;
   }

   /* Check if time out happens. The second condition is added such that */
   /* gus_ExceptionCode will not be updated by E_CODE_RReverb7Tx_Bis_TIME_OUT */
        /* if CRCs don't match for C-PARAMS messages */
   if ((gs_TxSubStateCnt >= (R_REVERB7_TX_BIS_TIMEOUT - 1 + 10)) && (gl_TxSymbolCount >= (R_REVERB7_TX_BIS_TIMEOUT - 1 + 10)))
   {
      gs_TxNextState = FAIL_TX;

      gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

      /* set exception handler variables */
      gus_ExceptionState   = gs_TxState;
      gus_ExceptionCode = E_CODE_RReverb7Tx_Bis_TIME_OUT;
   }
}

