/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   RSegue12TxF_bis.c
*
*   Transceiver Training Phase 1 TX State Functions for ATU-R.
*   Covering the TX states: R_SEGUE1_TX_BIS, R_SEGUE2_TX_BIS,
*
*   Notes:
*
*
*------------------------------------------------------------------------
*/

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "fifo.h"
#include "engine_const.h"
#include "RReverb5TxF_bis.h"
#include "RMsg1TxF_bis.h"
#include "RParamsTxF_bis.h"
#include "showtime_bis.h"
#include "states.h"
#include "tx_ops_bis.h"
#include "cmv.h"
#include "RMedleyTxF_bis.h"

/*^^^
*------------------------------------------------------------------------
*
*  Name: RSegue12TxF_BIS
*
*  Description: Transmits the R_Segue signal to the ATU-C.
*  This function is reused by several states.
*
*  Prototype: void RSegue12TxF_BIS(void)
*
*  Arguments: none
*
*  Return: none
*
*  Global Variables Used:
*      gl_TxSymbolCount     - (I) # symbol periods in current TX state
*      gs_TxNextState       - (O) TX state that will begin next symbol period
*      gt_StateMachCntrl    -  (O) Maintains state machine control variables
*
*  Notes: implements states R_SEGUE1_TX_BIS, R_SEGUE2_TX_BIS
*
*------------------------------------------------------------------------
*^^^
*/
void RSegue12TxF_BIS(void) {

    if (gl_TxSymbolCount == 0) {

        gft_IFFT_On = TRUE;

        /*  state machine control */
        switch (gs_TxState) {

        case R_SEGUE1_TX_BIS:
            TxReverbSegueSetUp_Xcvr_Training_BIS(R_SEGUE);
            gt_StateMachCntrl.s_TXFollowingState  = R_REVERB5_TX_BIS;
            gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RReverb5TxF_BIS;
            break;

        case R_SEGUE2_TX_BIS:
            TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_SEGUE);

            if(STATArray[STAT_MacroState] != STAT_LoopDiagMode)
            {
                gt_StateMachCntrl.s_TXFollowingState  = R_MSG1_TX_BIS;
                gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RMsg1TxF_BIS;
            }
            else
            {
                gt_StateMachCntrl.s_TXFollowingState  = R_MEDLEY_TX_BIS;
                gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RMedleyTxF_MTDQ_BIS;
            }
            break;

        }
    }


    if (gl_TxSymbolCount == (R_SEGUE_TX_LEN_BIS-1)) {
        /* set the next TX state */
        gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
        gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;

    }

}

