/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSegue4TxF_bis.c
 *
 *   Transceiver Training Phase 1 TX State Functions for ATU-R.
 *   Covering the TX states: R_SEGUE3_TX_BIS, R_SEGUE4_TX_BIS,
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */
//*-------------------------------------------------------------------------------//
// RSegue4TxF_bis.c
//
// History
//
// 21/11/2012 Kannan:
//          1. Added functions to notify PPE that both TX and RX directions leave
//             the showtime state and added an another function to notify PPE that
//             Zephyr Rx is disabled when link is drop from the showtime,
//             i.e bytes stop going to PPE.
//             Grep for "XDSLRTFW-541: Platform_VRX318"
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 27/05/2013 Varun : Added code(Debug option) to capture raw data of all Tx and Rx-
//                   training messages (G.Hs + training) and to initiate the DMA of Debug Buffer
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
//*-------------------------------------------------------------------------------//
#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "fifo.h"
#include "engine_const.h"
#include "RReverb5TxF_bis.h"
#include "RMsg1TxF_bis.h"
#include "RParamsTxF_bis.h"
#include "showtime_bis.h"
#include "states.h"
#include "tx_ops_bis.h"
#include "cmv.h"
#include "RMedleyTxF_bis.h"
#include "trail.h"
#include "DebugBuffer.h"
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
//XDSLRTFW-541: Platform_VRX318 (START_END)
#include "showtime.h"


#ifdef IFX_XTC
   #include "xtc_setup.h"
   #include "ConfigXtcIfTxPath.h"
#endif
#ifdef CUSTOMER_TASKS
   #include "customertasks.h"
#endif


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSegue4TxF_BIS
 *
 *  Description: Transmits the R_Segue signal to the ATU-C.
 *
 *  Prototype: void RSegue4TxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *      gt_StateMachCntrl    -  (O) Maintains state machine control variables
 *
 *  Notes: implements states R_SEGUE4_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */
void RSegue4TxF_BIS(void) {

    if (gl_TxSymbolCount == 0) {

      gft_IFFT_On = TRUE;

      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_SEGUE);
      /* In ADSL2/+ mode, we can always set Tx TDT in Cascade mode */
      /* (not so in DMT mode, hence we dont do this during pre-handshake) */
#ifndef DANUBE
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_MTE_TxDT);
#endif
    }

#ifdef DANUBE
#ifdef TARGET_HW
     // This is part of PPE workaround: TX_FCI_DONE interrupt is disabled
     // in RReverb7TxF_bis state. It is re-enabled in Segue4 before modem
     // enters Showtime.
     if (gl_TxSymbolCount == 2)
           AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_TX_FCI_DONE_Int);
#endif
#endif
   if((guc_ShowTimeTxState != TRAINING_DONE) || (guc_TxDataPumpState != TRAINING_DONE)) {

         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

         /* set exception handler variables */
         gus_ExceptionState   = gs_TxState;
         gus_ExceptionCode = E_CODE_RSegue4Tx_DATA_PUMP_SETUP_Failure;
         return;
   }



#if 0
   if (gft_TxDataPump_On == FALSE &&
      gl_TxSymbolCount > (R_SEGUE_TX_LEN_BIS-FRAME_LATENCY_TX_SHOWTIME- gs_num_preproc_frames))
   {
      gft_TxDataPump_On = TRUE;
   }
#else
   gft_TxDataPump_On |= (gl_TxSymbolCount > (R_SEGUE_TX_LEN_BIS-FRAME_LATENCY_TX_SHOWTIME- gs_num_preproc_frames));
#endif

   if(gl_TxSymbolCount == (R_SEGUE_TX_LEN_BIS-FRAME_LATENCY_TX_SHOWTIME))
   {
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, Enable_MTE_Tx);

   }

#ifdef IFX_XTC
   if ((gft_AlphaeusSel == FALSE) && (gl_TxSymbolCount == (R_SEGUE_TX_LEN_BIS-2)))
   {
      // Enable Tx xTC I/F two frames before showtime
      AddFunctionToFifo(gp_TxLoadingFunctionFifo, EnableTxXtcIF);
   }
#endif

    if (gl_TxSymbolCount == (R_SEGUE_TX_LEN_BIS-1))
   {

   // check if there has been a bitloading failure
      if (gs_InitFailCauseNearEnd != 0 || gs_InitFailCauseFarEnd !=0)
      {
         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;

         gus_ExceptionState   = gs_TxState;
         if(gs_InitFailCauseFarEnd ==1)
            gus_ExceptionCode = E_CODE_FAREND_CONFIGURATION_ERR_BIS;
         else if(gs_InitFailCauseFarEnd ==2)
            gus_ExceptionCode = E_CODE_FAREND_CONFIGURATION_NOT_FEASIBLE_ERR_BIS;
         /* else if (gs_InitFailCauseNearEnd != 0) */
         /* gus_ExceptionCode is set in bitloading part */
      }
      else
      {
         /* Use this variable to indicate progress of any last BgTasks using */
         /* R_NOSHOW page before we bring in SHOWBG1 and SHOWBG2 pages     */
         guc_BkgdTaskState = BKGDTASK_WAITING;
         //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
         //XDSLRTFW-541: Platform_VRX318 (START_END)
         AddFunctionToFifo(gp_TxLoadingFunctionFifo, DFE_PPE_LinkStatus_TxRxShow);

          // XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (START)
          gus_workaround_bits &= (uint16)(~XDSLRTFW1842_ADSL2P_ANXB_POWER_BOOST);   // clear XDSLRTFW1842_ADSL2P_ANXB_POWER_BOOST workaround bit before we enter show time
                                                                                    // this is necessary that we don't unintentionally limit the US TSSI when the loop length gets reduced
          // XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (END)

         /* set the next TX state */
         gs_TxNextState = R_SHOWTIME_TX;
         gpF_TxStateFunc = (PtrToFunc)RShowtimeTxF_BIS;
#ifdef DEBUG_TRACES // XDSLRTFW-597
         LogMessages(1,END_OF_THE_MSG,DEBUG_BUFFER_DELIMETER_TRAINING_END);
         RequestSwap_DebugBuff_GHS_OR_TRAINING_Tomem();
         gt_debugBufStatus.s_debugTrailLen=0;
         if(gt_ReTxConfigInfo.ft_ReTxOn)
            gt_DebugBufferStatus.s_debugBuffer_Size_of_Super_Frame_structure_Bytes=sizeof(gt_DebugBuffSuperframeReTxEnabled);
         else
            gt_DebugBufferStatus.s_debugBuffer_Size_of_Super_Frame_structure_Bytes=sizeof(gt_DebugBuffSuperframe);
#endif // #ifdef DEBUG_TRACES
      }
    }

}

