/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   RSegueLDTxF_bis.c
 *
 *   ATU-R Exchange Phase in diagnostics mode.
 *   Covering the TX states: R_SEGUE_LD_TX_BIS
 *
 *   Notes:
 *
 *
 *------------------------------------------------------------------------
 */

#include "common.h"
#include "rt_state.h"
#include "rt_state_bis.h"
#include "rt_tones.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ops.h"
#include "engine_const.h"
#include "states.h"
#include "tx_ops_bis.h"
#include "RMsgLDTxF_bis.h"
#include "FormRMsgLD_bis.h"
#include "fifo.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: RSegueLDTxF_BIS
 *
 *  Description: Transmits the R_Segue signal to the ATU-C.
 *
 *  Prototype: void RSegueLDTxF_BIS(void)
 *
 *  Arguments: none
 *
 *  Return: none
 *
 *  Global Variables Used:
 *      gl_TxSymbolCount     - (I) # symbol periods in current TX state
 *      gs_TxNextState       - (O) TX state that will begin next symbol period
 *      gt_StateMachCntrl    -  (O) Maintains state machine control variables
 *
 *  Notes: implements states R_SEGUE_LD_TX_BIS
 *
 *------------------------------------------------------------------------
 *^^^
 */

/* DEBUG */
int16 gs_dbgMaxPrepareCnt = -1;
int16 gs_dbgMaxPrepareMsg = -1;
int16 gs_dbgMsgIdxStop = -1;
extern uint8 guc_msg_ld_idx_us;

void RSegueLDTxF_BIS(void)
{

   if (gl_TxSymbolCount == 0)
   {
      gft_IFFT_On = TRUE;

      TxReverbSegueSetUp(gs_TxFirstChannel, gs_TxLastChannel, R_SEGUE);

      /* Prepare the next LD message in background. */
      guc_BkgdTaskState = BKGDTASK_IN_PROGRESS;
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgFormRMsgLD_BIS);

      gt_StateMachCntrl.s_TXFollowingState  = R_MSG_LD_TX_BIS;
      gt_StateMachCntrl.pF_TxFollowingState = (PtrToFunc)RMsgLDTxF_BIS;
   }

   /* DEBUG */
   if (guc_BkgdTaskState == BKGDTASK_DONE)
   {
      guc_BkgdTaskState = BKGDTASK_WAITING;
      if (gs_dbgMaxPrepareCnt < (int16)gl_TxSymbolCount)
      {
         gs_dbgMaxPrepareCnt = (int16)gl_TxSymbolCount;
         gs_dbgMaxPrepareMsg = (int16)guc_msg_ld_idx_us;
      }
   }
   /* END OF DEBUG */

   if (gl_TxSymbolCount == (R_SEGUE_LD_TX_LEN_BIS-1))
   {
      /* set the next TX state */
      gs_TxNextState = gt_StateMachCntrl.s_TXFollowingState;
      gpF_TxStateFunc = gt_StateMachCntrl.pF_TxFollowingState;

      /* DEBUG */
      if (gs_dbgMsgIdxStop == (int16)guc_msg_ld_idx_us)
      {
         gs_TxNextState = FAIL_TX;
         gpF_TxStateFunc = (PtrToFunc)ExceptionHandler;
         /* set exception handler variables */
         gus_ExceptionState   = gs_TxState;
         gus_ExceptionCode = (uint16)1234;
      }
   }

}

