/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _BITLOAD_BIS_H
#define _BITLOAD_BIS_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             bitload_bis.h
 * DESCRIPTION:      Header file for bitload_bis.c.
 *
 **********************************************************************/
// ******************************************************************
// bitload_bis.h
//
// History
//
//
//15/03/2012 Kannan: 16/04/2009 Bhadra: Added code for bitload related changes in Universal Retransmission (G.INP)
//                   Added required variables for bitload.
//                     Grep for SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad to see changes.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// ******************************************************************

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/

extern void DecideForRParams_OneLatency(int16 s_path);
extern void DecideForRParams_TwoLatency(void);
extern void CalcRxBATSetFineGains_bis(void);
extern BkgdFunction BgMedleyBitload_bis;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (Start)
void DecideForRTParams(void);
FlagT get_framingRT(uint16 us_s_COCPE,     uint16 us_d_COCPE,       uint16 us_LpAvailable,
               uint16 us_ETR_min,     uint16 us_ETR_max,       uint16 us_net_max,
                  uint16 us_SpMinInvers, uint16 us_QSmin,         uint16 us_QSmax,
               uint16 us_RTmemMax,    uint16 us_delay_max,     uint16 us_INP_min,
               uint16 us_INP_min_rein, uint16 ft_ia_rein_flag, uint16 us_SHINEratio,
               uint16 us_CIP);

RTParam_t get_framingparamsRT(uint16 us_Lp,           uint16 us_Rp,      uint16 us_SpMinInvers,
                        uint16 us_SpMax,        uint16 us_QSmin,   uint16 us_QSmax,
                        uint16 us_s_COCPE,      uint16 us_d_COCPE, uint16 us_RTmemMax,
                        uint16 us_delay_max,    uint16 us_INP_min, uint16 us_INP_min_rein,
//FEATURE_DS_BisPlus_ALL_UReTx_net_max_modifications Begin
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links Begin
                        uint16 ft_ia_rein_flag, uint16 us_SHINEratio, uint16 us_net_max,
                         FlagT *pft_INP_met);
//SMS01527653:FIX_DS_BisPlus_ALL_ReTx_Expected_no_link_to_ST_but_links End
//FEATURE_DS_BisPlus_ALL_UReTx_net_max_modifications End

//SMS01436600:FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start_End)
FlagT ReTx_PreBitSwapProcessing(int16 s_delta_margin);
FlagT Assign_Bits_For_LP0(int16 *ps_TotalBitsSupported,uint16 *pus_LpAvailable, int16 *ps_MinToneLp0);
void Check_LP1_Available(uint16 *pus_LpAvailable,int16 s_MaxToneForFast);
//FlagT Assign_Bits_For_LP1(uint16 us_LpAvailable, int16 s_MinToneLp0);
FlagT Assign_Bits_For_LP1(uint16 *pus_LpAvailable,
   int16 s_MinToneLp0,
   uint16 *pus_nc1bit,
   uint16 *pus_nc2bit,
   uint16 *pus_nc3bit,
   uint16  *pus_maxbitstoreduce);
//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (End)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

FlagT Choose_PMS_Params(int16 *s_BitsPerPMDSymbol, int16 s_D, int16 s_R,  int16 *ps_M, int16 *ps_T, int16 *ps_Bpn,  int16 s_max_latency,int16 s_p,int16 s_DeltaLp);
FlagT Choose_PMS_Params_Ph2(int16 *s_BitsPerPMDSymbol, int16 s_D, int16 s_R,  int16 *ps_M, int16 *ps_T, int16 *ps_Bpn, int16 *ps_CWSize, int16 s_max_latency, int16 s_p);
int16 Calc_CWSize( int16 *ps_L, int16 s_D, int16 s_R, int16 s_max_latency,int16 s_p,int16 s_DeltaLp);
#ifndef TARGET_HW
int16 Choose_Rp(int16 s_CWSize, int16 s_L, int16 s_D, int16 s_p);
#endif
FlagT Choose_Best_Mp(int16 s_CWSize, int16 s_L, int16 s_D, int16 *ps_M, int16 *ps_T, int16 *ps_Bpn, int16 s_R, int16 s_p,int16 s_DeltaLp);
#ifndef TARGET_HW
void VerifyBitLoadingParameters(void);
#endif
void Save_ValidPMS( int16 s_D,int16 s_M, int16 s_R, int16 s_T, int16 s_L, int16 *psa_Bpn, int16 s_p, PMSBitload_t *gt_PMSParams);

FlagT Check_PMSConstr(int16 s_D, int16 s_R, int16 s_M, int16 s_T, int16 *ps_Bpn, int16 s_L, int16 s_maxlatency);
void CompRate(int16 *ps_Bpn, int16 s_T, int16 s_L, int16 s_MinNetDataRateToConsider, int16 s_M, int16 s_R, int32 *pl_datarate,  int32 *pl_temp_diff_datarate, int16 *ps_delta_Lp, int32 *pl_mindatarate, int32 *pl_maxdatarate);
void load_BestSavedPMS(int16 *ps_D, int16 *ps_R, int16 *ps_M, int16 *ps_T, int16 *ps_L, int16 *ps_Bpn, int16 s_p, PMSBitload_t *pt_save_PMS);
void CompareFractions( FlagT ft_FindLarge, int16 s_beta_numer, int16 s_beta_denom, int16 *ps_result_numer, int16 *ps_result_denom);
int16 CheckCoPrime(int16 s_D, int16 s_CWSize);
#endif
