/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _CONST_BIS_H
#define _CONST_BIS_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: const_bis.h
;
;  This is a header file containing constant definitions specific to g.dmt.bis
;
;***************************************************************************/
// ******************************************************************
// const_bis.h
//
// History
//
// 20/08/2010  Sriram Shastry. Some BRCM COs prefer AnnexL
//                       in mid loops which causes failing test requirements
//                       due to low US rates. We retrain at this loop range,
//                       around 8kft to 15kft, and disable AnnexL so that
//                       ADSL2+ will be selected. The error code and loop length
//                       definitons are added for this feature.
//                      Grep for SMS00790593 IOP_DS_BRCM_BisPlus_DisableAnxL
//
// 20/08/2010  Sriram Shastry: Added error code definition for CNXT D57 shortloop Tx cutpower
//                       Grep for SMS00820348 IOP_DS_Bis_CNXT_D57ShortLoopTxPowerCut
//
// 05/08/2010 Nihar : Added the constant to indicate the size of the INP variable with respect
//       to the number of supported Latency path.
//       Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: IOP fix for SRA Upshift and Downshift not achieving the Target Margin.
//               Modify format of SRA_step initailzer from 16.0 to 8.8 format.
//               This is to calculate the SRA delta Lp for fractional dB steps.
//               Grep for SMS00951973:IOP_DS_BISPlus_ALL_SRATargetMarginFix
//
// 19/08/2010 AdeelJ/Palaksh/Bhadra:  Added Error code for Flag Condition Error in CNXT US rate inprovement fix.
//                    Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//15/03/2012 Kannan: 16/04/2009 Bhadra: Added code for bitload related changes in Universal Retransmission (G.INP)
//                   Added required variables for bitload.
//                     Grep for SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad to see changes.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 18/06/2012 Raghu M: Changes the size REverb Segeu bins used for detection
//                     Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 05/06/2012 Vinjam: Increased "LEN_C_MSGPCB" from "14" to "60" to support for
//            virtual noise break points.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 05/06/2012 Vinjam: Added an exception code "E_CODE_EXCEEDS_MAX16_DS_VN_BREAKPOINTS",
//            while adding support for downstream virtual noise feature.
//            Grep for XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise
//
// 22/03/2013 Ram: Added a new OLRPM state 'L2_SETUP_REVSEQ_DETECTOR', which would aid to call func
//                 ReverbSegueDetectorSetup() in 'Data symbol 1' (during L0 to L2 transition)
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 09/09/2014 ChihWen: Avoid MIPs peaking in L2 entry and exit by moving calculation of FDQ coefficients to background tasks.
//            Grep for XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit
//
// 10/04/2014 Sriram Shastry: Added the workaround requested by AT&T for their special profile
//                   on Alcatel BRCM DSLAMs (ABLT-D, ABLT-A and EBLT-K)
//                   in T1.413, G.dmt, G.lite and Annex L multimode, i.e.
//                   Multimode CPE needs to disable Annex L on short loops.
//                   This workaround is disabled by default with
//                   CMV bit7 = 0 for INFO 103 26.
//                   To enable it, set bit7 = 1 by cw INFO 103 26 0x0080.
//                   Grep for ADSLRTFW-1400_XDSLRTFW-1596_IOP_DS_BisPlus_BRCM_ATT_DisableAnxL
//
// ******************************************************************
#include "const.h"

#define C_TREF_PILOT_TONE  (64)

/* ============================================================================================ */
/* Exception Codes */
/* ============================================================================================ */
//(0~49)  are reserved for common+DMT only error code, see below
//(50~79) are reserved for BIS only Error code, see detail in const_bis.h
//(80~89) are reserved for Kernel Exception Error code, see detail in soc_src\modem\include\interrupt.h
//(90~93) have been used, see const.h
#define E_CODE_RQuiet5Tx_Bis_SignalEnd_TIMEOUT           (((E_COMM    | (Esub_Timeout<<8))<<16)| (50))   /*  Timeout waiting for the equalizers to be trained on the Rx side */
#define E_CODE_RCReverb3Rx_bis_SignalEnd_Failure         (((E_COMM    | (Esub_Timeout<<8))<<16)| (51))   /*  Timeout waiting for the beginning of RCTref2Rx_bis signal */
#define E_CODE_RCTref2_bis_DEC_PATH_DEL_TIMEOUT          (((E_COMM    | (Esub_Unknown<<8))<<16)| (52))   /*  DEC Path Delay timeout */
#define E_CODE_RCTref2_bis_DEC_TRAINING_TIMEOUT          (((E_COMM    | (Esub_Unknown<<8))<<16)| (53))   /*  DEC Training timeout */
#define E_CODE_RReverb5Tx_bis_C_SEGUE1_Failure           (((E_COMM    | (Esub_Timeout<<8))<<16)| (54))   /*  Timeout after RReverb5Tx waiting for C_SEGUE1 */
#define E_CODE_RCReverb4Rx_Bis_C_SEGUE1_Failure          (((E_COMM    | (Esub_Timeout<<8))<<16)| (55))
#define E_CODE_RCMsg1_Bis_CRC_MISMATCH_ERR               (((E_COMMCRC | (Esub_INIT<<8))<<16)   | (56))
#define E_CODE_RCReverb5Rx_Bis_C_SEGUE_Failure           (((E_COMM    | (Esub_Timeout<<8))<<16)| (57))
#define E_CODE_RCMsgFmtRx_Bis_DECOD_ERR                  (((E_COMMCRC | (Esub_INIT<<8))<<16)   | (58))   /*  CRC mismatch for C-MSG-FMT or C-MSG-PCB */
#define E_CODE_RCQuietRx_Bis_TIME_OUT                    (((E_COMM    | (Esub_Timeout<<8))<<16)| (59))
#define E_CODE_RQuietTx_Bis_TIME_OUT                     (((E_COMM    | (Esub_Timeout<<8))<<16)| (60))
#define E_CODE_RCCRC1Rx_Bis_C_MSG2_DECOD_ERR             (((E_COMMCRC | (Esub_INIT<<8))<<16)   | (61))
#define E_CODE_RReverb6Tx_Bis_TIME_OUT                   (((E_COMM    | (Esub_Timeout<<8))<<16)| (62))
#define E_CODE_RCReverb6Rx_Bis_C_SEGUE3_Failure          (((E_COMM    | (Esub_Timeout<<8))<<16)| (63))
#define E_CODE_RCCRC1Rx_Bis_C_PARAMS_DECOD_ERR           (((E_COMMCRC | (Esub_INIT<<8))<<16)   | (64))
#define E_CODE_RCReverb7Rx_Bis_C_SEGUE_Failure           (((E_COMM    | (Esub_Timeout<<8))<<16)| (65))
#define E_CODE_RReverb7Tx_Bis_TIME_OUT                   (((E_COMM    | (Esub_Timeout<<8))<<16)| (66))
#define E_CODE_RCMsg1_Bis_MAX_BITS_PER_TONE_ERROR        (((E_COMMCRC | (Esub_INIT<<8))<<16)   | (67))
//#define E_CODE_BIS_FORM_RPARAMS_BG_INCOMPLETE          (((E_UNKNOWN | (Esub_Unknown<<8))<<16)| (68))
#define E_CODE_RSegue4Tx_DATA_PUMP_SETUP_Failure         (((E_COMM    | (Esub_INIT<<8))<<16)   | (69))
#define E_CODE_BIT_LOADING_FAILURE                       (((E_NOTFEASIBLE | (Esub_INIT<<8))<<16) | (70))    /* Bit-loading failed */
#define E_CODE_FAREND_CONFIGURATION_ERR_BIS              (((E_NOTFEASIBLE | (Esub_INIT<<8))<<16) | (71))
#define E_CODE_FAREND_CONFIGURATION_NOT_FEASIBLE_ERR_BIS (((E_NOTFEASIBLE | (Esub_INIT<<8))<<16) | (72))
#define E_CODE_RCMsgLDRx_BIS_SyncLoss                    (((E_COMM    | (Esub_INIT<<8))<<16)     | (73))
#define E_CODE_CReverb_PGAReq_TooLow                     (((E_UNKNOWN | (Esub_Unknown<<8))<<16)  | (74))
#define E_CODE_MEDLEY_BIS_TIMEOUT                        (((E_COMM    | (Esub_Timeout<<8))<<16)  | (75))
#define E_CODE_RCReverb7Rx_Bis_C_SEGUE_Quiet_Failure     (((E_COMM    | (Esub_FWInitiatedRetrain<<8))<<16) | (76))
#define E_CODE_BRCM_DISABLE_ANNEX_L                      (((E_COMM    | (Esub_FWInitiatedRetrain<<8))<<16) | (77))
#define E_CODE_SHORTLOOP_CUTPOWER                        (((E_COMM    | (Esub_FWInitiatedRetrain<<8))<<16) | (78))
#define E_CODE_RCMsg1_Bis_CNXT_USPerfFixFlagError        (((E_COMM    | (Esub_FWInitiatedRetrain<<8))<<16) | (79))
#define E_CODE_RQuiet2Tx_Bis_TIME_OUT                    (((E_COMM    | (Esub_Timeout<<8))<<16)| (80))
#define E_CODE_EXCEEDS_MAX16_DS_VN_BREAKPOINTS           (((E_COMM    | (Esub_INIT<<8))<<16)| (81))
#define E_CODE_TREF2_BIS_TIMEOUT                         (((E_COMM    | (Esub_Timeout<<8))<<16)| (82))   //XDSLRTFW-3500
#define E_CODE_IMPROPER_BLACKOUT                         (((E_COMM    | (Esub_FWInitiatedRetrain<<8))<<16) | (83))


#define E_CODE_BITLOAD_EXPLICITRATE_INSUFFICIENT_BITS      (1)
#define E_CODE_BITLOAD_ALLOCFIXED_RATE_FAIL                (2)
#define E_CODE_BITLOAD_VERIFY_PMS_FAIL                     (3)
#define E_CODE_BITLOAD_INVALID_NUM_LATENCY_PATHS           (4)
#define E_CODE_BITLOAD_INVALID_NUM_BEARER_CHANNELS         (5)

#define E_CODE_BITLOAD_INSUFFICIENT_BITS                   (6)
#define E_CODE_BITLOAD_FIXEDRATE_NOT_CONVERGE              (7)
#define E_CODE_BITLOAD_NOVALID_CONFIG                      (8)
#define E_CODE_BITLOAD_LP_TOOLARGE                         (9)
#define E_CODE_BITLOAD_NOVALID_CONFIG_ADAPTIVERATE         (10)
#define E_CODE_BITLOAD_LPMINUS1_NOTSATISFYCONSTR           (11)
#define E_CODE_BITLOAD_LPMINUS1_RATEFAIL                   (12)
#define E_CODE_BITLOAD_NOSUPPORTLIMTEDRATELP0_DUAlLATENCY  (13)
#define E_CODE_BITLOAD_LP1FAIL                             (14)
#define E_CODE_BITLOAD_LP1_INSUFFICIENTCAPACITY            (15)
#define E_CODE_BITLOAD_NOTSUPPORTINPLAT_LP1                (16)
#define E_CODE_BITLOAD_INVALID_INPLAT_LP1                  (17)
#define E_CODE_BITLOAD_LP1_RATETOOHIGH                     (18)

// ReTx bitload exceptions
#define E_CODE_BITLOAD_NOSUPPORT_EXPLICITRATE_URETX        (19)
#define E_CODE_BITLOAD_LP0_INSUFFICIENTCAPACITY            (20)
#define E_CODE_BITLOAD_LP0_BITS_NOT_AVAILABLE              (21)
#define E_CODE_BITLOAD_LP0FAIL                             (22)

#define     DS_RRC_BYTES   3
#define     US_RRC_BYTES   0
#define     DS_RRC_BITS    (DS_RRC_BYTES*8)
#define     US_RRC_BITS    (US_RRC_BYTES*8)


#define DELAY_MAX                   63
#define MAX_XDTU_TABLE_SIZE         4

// valid values for ft_DsReTxCapable
#define CPE_RETX_INCAPABLE          0
#define CPE_RETX_CAPABLE            1
#define DEFAULT_CPE_RETX_CAPABLE    CPE_RETX_INCAPABLE

// valid values for uc_OMSG1_DsReTxEnabled
#define RETX_SELECTED                           0
#define CO_RETX_INCAPABLE                       1
#define CO_RETX_CAPABLE                         2
#define CO_RETX_CAPABLE_BUT_NOT_SELECTED        3

#define RPMS_DTU_FRAMING_TYPE_1                 0
#define RPMS_DTU_FRAMING_TYPE                   RPMS_DTU_FRAMING_TYPE_1

#define RPMS_ASSUMED_Qtx_DELAY                  16

#define PPE_INPUT_MAX                     4160 // Input buffer size at the PPE

#define QRETX_TRANS_TABLE_SIZE      (64*4)
//#define QRETX_TRANS_TABLE_SIZE      (64*3)
#define TS_FUZZ_OFFSET              2

#define SID_MODULO          256
#define TS_MODULO           255

// valid values for uc_DtuStat of ReTX_Params_t
#define GOOD_DTU            0
#define BAD_DTU             1
#define EMPTY_DTU           0xFF

// FIFO1 of LP1 will be populated with DTU info
#define RETX_FIFO1          1
#define RETX_LP1            1

// SID, TS, DTU_STAT
#define DTU_INFO_BYTES_IN_FIFO1       3
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)



/* For the detection of C-COMB symbol */
#define C_COMB_INDEX_CNT_G992_5        26

//#define C_COMB_DETECTION_THRESHOLD      2
#define C_COMB_ZERO_THRESHOLD       32

#define NUM_OF_BINS_FOR_COMB_DETECTION   5
#define THRESHOLD_FOR_QUALIFIED_COMBTONES  0xA00 /* 8.8 format(dB) */

#define C_COMB_DETECTED             1
#define C_ICOMB_DETECTED            2


/* For C-MSG-FMT and C-MSG-PCB */

#define LEN_C_MSGFMT             4

//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (START)
#define LEN_C_MSGPCB             60 /* CO may send blackout bits, Pass/Fail bits and Last_TX_State bits */
                                    //60 = 2(info) + 8(blockout) + 48(VN brkpt, 16*3) + 2(CRC)
                                    //LEN_C_MSGPCB was 14, before integrating virtual noise feature
//XDSLRTFW-438 SMS00847297 Feature_AB_DS_BisPlus_ALL_SupportDsTxRefVirtualNoise (END)


#define LEN_R_MSGFMT_WITHOUT_CRC    2

#define LEN_R_MSGPCB_WITHOUT_CRC    70       /* Increase its length so the corresponding array can contain the messages of blackout bits, Pass/Fail bits and Last_TX_State bits. */
                     /* Note that the Pass/Fail and Last_TX_State bits are only valid in diagnostics mode */

#define C_MSGFMT_CRC_NUM_OF_BITS    16
#define C_MSGFMT_CRC_NUM_OF_SYMBOLS    3*C_MSGFMT_CRC_NUM_OF_BITS
#define C_MSGFMT_CRC_NUM_OF_SYMBOLS_DIAG  8*C_MSGFMT_CRC_NUM_OF_BITS

#define MAX_DS_POWER_CUTBACK               40

/* For C-QUIET4 */

#define FIRST_CHANIDX_CREV1DET          4    /* tone 59 */
#define LAST_CHANIDX_CREV1DET           9   /* tone 107 */
#define THRESHOLD_CREV1DET              2
#define MIN_LEN_C_QUIET4            314
#define MAX_LEN_C_QUIET4            1242

/* For R-MSG-FMT */

/* For R-MSG-PCB */

#define HOOK_STATUS_UNKNOWN      0
#define ON_HOOK               1
#define OFF_HOOK           2
#define NOT_CAPABLE_TO_DETECT 3

#define C_PILOT_CHOICE     64

/* For R-MSGx-LD */

#define R_MSG_LD_SCLR      (0)
#define R_MSG_LD_HLIN      (1)
#define R_MSG_LD_HLOG      (2)
#define R_MSG_LD_QLN    (3)
#define R_MSG_LD_SNR    (4)
#define R_MSG_LD_DONE      (5)

/* for R-MSG1 */

#define R_REVERB_BIS             1

#define BC0_TO_LATENCYPATH_DS       0     /* indicated BC0 goes to latency path 0 */
#define BC1_TO_LATENCYPATH_DS       0xF      /* BC1 is not assigned to any path */
#define BC2_TO_LATENCYPATH_DS       0xF      /* BC2 is not assigned to any path */
#define BC3_TO_LATENCYPATH_DS       0xF      /* BC3 is not assigned to any path */

#define MAX_EXTGIus                 0     /* maximum extension of the gi range supported by the far end xmitter */

/* For R-MEDLEY */
#define NUM_R_MEDLEY_BYTES    (2*TX_NUM_TONES/8)
#define NUM_R_C_MEDLEY_BYTES     (1024/8)


/* For R_PARAMS */
#define LEN_R_PARAMS_PMD (13 + 3 + 2*(RX_NUM_TONES-1) + 2*(RX_NUM_TONES-1))   /* 13 is for attenuation, etc. */
                                                         /* 3 is for reserved byte. */
                                                         /* 2*(RX_NUM_TONES-1) is for bits and gains table.*/
                                                      /* 2*(RX_NUM_TONES-1) is for tone reordering table.*/

#define LEN_R_PARAMS_PMS      (28)
#define LEN_R_PARAMS_CRC      (2)
#define LEN_R_PARAMS_MESSAGE_BYTES  (LEN_R_PARAMS_PMD + LEN_R_PARAMS_PMS + LEN_R_PARAMS_CRC)
#define LEN_R_PARAMS_BITS       (LEN_R_PARAMS_MESSAGE_BYTES*8)
#define MAX_PADDING_BYTES       (5) // worst case

/* For R_C_PARAMS */
#define LEN_C_PARAMS_PMD_HEADER (13 + 1)

#define LEN_C_PARAMS_PMD (LEN_C_PARAMS_PMD_HEADER + 2 + 2*(TX_NUM_TONES-1) + 2*(TX_NUM_TONES-1))

#define LEN_C_PARAMS_PMS      (28)
#define LEN_C_PARAMS_CRC      (2)
#define LEN_C_PARAMS_MESSAGE_BYTES  (LEN_C_PARAMS_PMD + LEN_C_PARAMS_PMS + LEN_C_PARAMS_CRC)

/* For OLR and PM */
/* olr and pm reconfiguration symbol counts */
#define OLR_US_ReconfigPMDSymbolCount     4
#define OLRPM_DS_ReconfigPMDSymbolCount      1
/* pm power cutback */
#define MAX_FFT_GAIN_ADD            30 /* in steps of 6dB */

#ifndef ADSL_62
#define FFT_SCALEBACK_GAIN_0DB_MASK    0xD5
#define FFT_SCALEBACK_GAIN_6DB_MASK    0xD4
#define FFT_SCALEBACK_GAIN_12DB_MASK   0xD0
#define FFT_SCALEBACK_GAIN_18DB_MASK   0xC0
#define FFT_SCALEBACK_GAIN_24DB_MASK   0x80
#define FFT_SCALEBACK_GAIN_30DB_MASK   0x00
#else
#define FFT_SCALEBACK_GAIN_0DB_MASK    (0x254)
#define FFT_SCALEBACK_GAIN_6DB_MASK    (0x154)
#define FFT_SCALEBACK_GAIN_12DB_MASK   (0x54)
#define FFT_SCALEBACK_GAIN_18DB_MASK   (0x14)
#define FFT_SCALEBACK_GAIN_24DB_MASK   (0x4)
#define FFT_SCALEBACK_GAIN_30DB_MASK   (0x0)
#endif
/* olr and pm states */
#define STATE_NOT_DEFINED               0
#define L0_STEADY_STATE             1
#define OLR_LOAD_TABLES             2
#define OLR_SEND_SYNC_INDICATOR        3
#define OLR_RECV_SYNC_INDICATOR        4
#define OLR_RECONFIGURE             5
#define OLR_BKGND_PROC_STATE        6
#define L2_LOAD_TABLES              7
#define L2_RECV_SYNC_INDICATOR         8
#define L2_RECONFIGURE              9
#define L2_READ_TABLES              10
#define PM_BKGND_PROC_STATE            11
#define L2_STEADY_STATE             12
#define L3_REQUEST                  13
#define L3_STEADY_STATE             14
#define OLR_READ_TABLES             17
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start End)
#define L2_SETUP_REVSEQ_DETECTOR    18

/* olr and pm events */
#define LOAD_BAT                 0x0001
#define LOAD_GAIN                0x0002
#define LOAD_TRB                 0x0004
#define RECONFIG_BiGi               0x0008
#define RECONFIG_Lp                 0x0010
#define RECONFIG_Bpn             0x0020
#define RECONFIG_PCB             0x0040
#define READ_BAT                 0x0080
#define READ_GAIN                0x0100
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifdef HW_SNR_FDQ
#define READ_FDQ1                                       0x0200
#define READ_FDQ2                                       0x0400
#define CAL_FDQ_COEF                                    0x0800
#endif
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
/* reverb segue detector constants */
#define NUM_REVERB_SEGUE_BIN_CHECKS    NUM_REVERB_SEGUE_BINS                    //XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
#define NUM_REVERB_SEGUE_BIN_MATCHES   14
/* States specific to L2 */
#define PM_L0_STATE                 0
#define PM_L2_STATE                 1
#define PM_L2_EXIT_SEQ_REVERB_DETECTED 2
#define PM_L2_EXIT_SEQ_SEGUE_DETECTED  3
#define PM_L2_EXIT_POSTPROCESS         4

/* macro specific for OLR/PM trail info*/
#define OLR_BACKUP_CONFIG                 1
#define PM_RESTOREL0_BACKUP_CONFIG        2
#define PM_L0TOL2_BACKUP_CONFIG           3
#define PM_L2LPT_BACKUP_CONFIG            4

#define MAX_OLR_TYPE                      4
#define MAX_OLR_RESULTS             4
#define MAX_OLRPM_ERROR_TYPE        100

// Max values allowed by standard
#define MAX_TPS_TC_TYPE       3
#define MAX_LATENCY_PATHS     4
#define MAX_BEARER_CHANNEL      4

// Max values supported in this implementation
#define NUM_DS_BEARER_CHANNELS_SUPPORTED     (2)
#define NUM_US_BEARER_CHANNELS_SUPPORTED     (2)
#define NUM_US_LATENCY_PATHS              (2)
#define NUM_DS_LATENCY_PATHS              (2)

// Default values for this implementation
#define DEFAULT_NUM_DS_BEARER_CHANNELS       (1)
#define DEFAULT_NUM_US_BEARER_CHANNELS       (1)
#define DEFAULT_NUM_US_LATENCY_PATHS         (1)
#define DEFAULT_NUM_DS_LATENCY_PATHS         (1)

#define NOMPSD_US    0                 /* this value is relative to -38dBm/Hz */
#define MAXNOMPSD_US 0                 /* this value is relative to -38dBm/Hz */
#define MAXNOMATP_US 0                 /* this value is relative to 12.5dBm */
#define NOMPSD_DS    0                 /* this value is relative to -40dBm/Hz */
#define MAXNOMPSD_DS 0                 /* this value is relative to -40dBm/Hz */
#define MAXNOMATP_DS 0                 /* this value is relative to 19.9dBm */

//Absolute values used for relative values
#define DEFAULT_NOMPSD_US  -38               /* absolute default US NOMPSD (dBm/Hz) */
#define DEFAULT_NOMPSD_DS  -40               /* absolute default DS NOMPSD (dBm/Hz) */

#define DEFAULT_MAXNOMATP_US_133 133            /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */
#define DEFAULT_MAXNOMATP_US_125 125            /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */
#define DEFAULT_MAXNOMATP_US_134 134            /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */

#define DEFAULT_MAXNOMATP_DS_199 199            /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */
#define DEFAULT_MAXNOMATP_DS_204 204            /* absolute default DS MAXNOMATP*10 (0.1 dB step-size) */

#define SIGNAL_ABOVE_NYQUIST_FREQ   0x1E  /* type of transmit signal images above the Nyquist frequency */
                                 /* bits 6 to 3 indicate te N value and bits 2 and 1 indicate the */
                                    /* definition of the xmit signal images above the nyquist freq. */
                                    /* (b6b5b4b3) = n, with 1<=n<=15 indicates that N=2^n. */
                                    /* (b6b5b4b3) = n, with n=0 indicates that N is not a power of 2 */
                                    /* (b2b1 = 01): complex conjugate of the base-band signal */
                                    /* (b2b1 = 10): zero-filled */
                                    /* (b2b1 = 00): other (none of the above) */
                                    /* (b2b1 = 11): reserved */

//G992.3 AnnexL PSD mask
#define PSD_DS_NON_OVERLAPPED           (0x1)
#define PSD_DS_OVERLAPPED               (0x2)
#define PSD_US_WIDE_SPECTRUM            (0x1)
#define PSD_US_NARROW_SPECTRUM          (0x2)

#define PSD_MASK_ANXL_US   (PSD_US_WIDE_SPECTRUM | PSD_US_NARROW_SPECTRUM)       // Bit1, Bit 2 indicates G992.3 AnnexL: Mask 1 and Mask 2 supported
#define PSD_MASK_ANXL_DS   (PSD_DS_NON_OVERLAPPED)       // Bit1 indicates G992.3 DS non-overlapped spectrum Annex_L support

//G992.3 and G992.5 AnnexM PSD mask
#define PSD_US_EU32                 (0x1)
#define PSD_US_EU36                 (0x2)
#define PSD_US_EU40                 (0x4)
#define PSD_US_EU44                 (0x8)
#define PSD_US_EU48                 (0x10)
#define PSD_US_EU52                 (0x20)
#define PSD_US_EU56                 (0x1)
#define PSD_US_EU60                 (0x2)
#define PSD_US_EU64                 (0x4)

#define PSD_MASK_ANXM_US1  (PSD_US_EU32 | PSD_US_EU36 | PSD_US_EU40 | PSD_US_EU44 | PSD_US_EU48 | PSD_US_EU52)
#define PSD_MASK_ANXM_US2  (PSD_US_EU56 | PSD_US_EU60 | PSD_US_EU64)

#define PSD_MASK_ANXJ_US1  (PSD_US_EU32 | PSD_US_EU36 | PSD_US_EU40 | PSD_US_EU44 | PSD_US_EU48 | PSD_US_EU52)
#define PSD_MASK_ANXJ_US2  (PSD_US_EU56 | PSD_US_EU60 | PSD_US_EU64)

#define MIN_MSGOVERHEAD_DATARATE_DS 4        /* data rate = 4*1000bits/sec */
#define MIN_MSGOVERHEAD_DATARATE_US 4        /* data rate = 4*1000bits/sec */

#define NOT_SUPPORT                 (0)      /* set to be 0 meaning that we don't support for now */
#define MIN_NET_DATARATE_COMMON_DS     (4)      /* = data rate/4000bps = 16Kbps/4000bps */
#define MAX_NET_DATARATE_COMMON_DS     (4000)   /* = data rate/4000bps = 16Mbps/4000bps */

#define MIN_RES_NET_DATARATE_COMMON_DS (4)      /* = data rate/4000bps = 16Kbps/4000bps */
#define MAX_LATENCY_COMMON_DS       (63)  /* The specail value defined in our code for the maximu delay, which means no limit boundary(in ms) */
#define BER_COMMON_DS               (0x2) /* 0x0 corresponds to a BER of 10^(-3) */
                                    /* 0x1 corresponds to a BER of 10^(-5) */
                                    /* 0x2 corresponds to a BER of 10^(-7) */
                                    /* 0x3 reserved */
#define MIN_INP_COMMON_DS               (0x00)  /* 0x00 special value meaning no impulse noise protection bound */
                                                /* 0x01 means 1/2 frame min INP bound*/
                                                /* 0x10 means 1 frame min INP bound  */
                                                /* 0x11 means 2 frame min INP bound  */
#define IMA_FLAG_COMMON_DS              (0x0)   /* 0x0 disable IMA */
                                                /* 0x1 enable IMA  */

#define MAX_NET_DATARATE_DS_G992_5     (4000)   /* = data rate/8000bps = 32Mbps/8000bps */

#define MIN_RES_NET_DATARATE_DS_G992_5 (4)      /* = data rate/8000bps = 32Kbps/8000bps */
#define MAX_LATENCY_DS_G992_5       (63)  /* The specail value defined in our code for the maximu delay, which means no limit boundary(in ms) */
#define BER_DS_G992_5               (0x2) /* 0x0 corresponds to a BER of 10^(-3) */
                                    /* 0x1 corresponds to a BER of 10^(-5) */
                                    /* 0x2 corresponds to a BER of 10^(-7) */
                                    /* 0x3 reserved */
#define MIN_INP_DS_G992_5               (0x00)  /* 0x00 special value meaning no impulse noise protection bound */
                                                /* 0x01 means 1/2 frame min INP bound*/
                                                /* 0x10 means 1 frame min INP bound  */
                                                /* 0x11 means 2 frame min INP bound  */
#define IMA_FLAG_DS_G992_5              (0x0)   /* 0x0 disable IMA */
                                                /* 0x1 enable IMA  */


#define MIN_NET_DATARATE_STM_BC0_DS    NOT_SUPPORT
#define MAX_NET_DATARATE_STM_BC0_DS    NOT_SUPPORT
#define MIN_RES_NET_DATARATE_STM_BC0_DS   NOT_SUPPORT
#define MAX_LATENCY_STM_BC0_DS         NOT_SUPPORT
#define BER_STM_BC0_DS              NOT_SUPPORT
#define MIN_INP_STM_BC0_DS              NOT_SUPPORT

#define MIN_NET_DATARATE_STM_BC1_DS    NOT_SUPPORT
#define MAX_NET_DATARATE_STM_BC1_DS    NOT_SUPPORT
#define MIN_RES_NET_DATARATE_STM_BC1_DS   NOT_SUPPORT
#define MAX_LATENCY_STM_BC1_DS         NOT_SUPPORT
#define BER_STM_BC1_DS              NOT_SUPPORT
#define MIN_INP_STM_BC1_DS              NOT_SUPPORT

#define MIN_NET_DATARATE_ATM_BC0_DS    MIN_NET_DATARATE_COMMON_DS
#define MAX_NET_DATARATE_ATM_BC0_DS    MAX_NET_DATARATE_COMMON_DS
#define MIN_RES_NET_DATARATE_ATM_BC0_DS   MIN_RES_NET_DATARATE_COMMON_DS
#define MAX_LATENCY_ATM_BC0_DS         MAX_LATENCY_COMMON_DS
#define BER_ATM_BC0_DS              BER_COMMON_DS
#define MIN_INP_ATM_BC0_DS              MIN_INP_COMMON_DS
#define IMA_FLAG_ATM_BC0_DS             IMA_FLAG_COMMON_DS

#define MIN_NET_DATARATE_ATM_BC1_DS    MIN_NET_DATARATE_COMMON_DS
#define MAX_NET_DATARATE_ATM_BC1_DS    MAX_NET_DATARATE_COMMON_DS
#define MIN_RES_NET_DATARATE_ATM_BC1_DS   MIN_RES_NET_DATARATE_COMMON_DS
#define MAX_LATENCY_ATM_BC1_DS         MAX_LATENCY_COMMON_DS
#define BER_ATM_BC1_DS              BER_COMMON_DS
#define MIN_INP_ATM_BC1_DS              MIN_INP_COMMON_DS
#define IMA_FLAG_ATM_BC1_DS             IMA_FLAG_COMMON_DS

#define MAX_NET_DATARATE_ATM_BC0_DS_G992_5      MAX_NET_DATARATE_DS_G992_5
#define MIN_RES_NET_DATARATE_ATM_BC0_DS_G992_5  MIN_RES_NET_DATARATE_DS_G992_5
#define MAX_LATENCY_ATM_BC0_DS_G992_5        MAX_LATENCY_DS_G992_5
#define BER_ATM_BC0_DS_G992_5             BER_DS_G992_5
#define MIN_INP_ATM_BC0_DS_G992_5               MIN_INP_DS_G992_5
#define IMA_FLAG_ATM_BC0_DS_G992_5              IMA_FLAG_DS_G992_5

#define MAX_NET_DATARATE_ATM_BC1_DS_G992_5      MAX_NET_DATARATE_DS_G992_5
#define MIN_RES_NET_DATARATE_ATM_BC1_DS_G992_5  MIN_RES_NET_DATARATE_DS_G992_5
#define MAX_LATENCY_ATM_BC1_DS_G992_5        MAX_LATENCY_DS_G992_5
#define BER_ATM_BC1_DS_G992_5             BER_DS_G992_5
#define MIN_INP_ATM_BC1_DS_G992_5               MIN_INP_DS_G992_5
#define IMA_FLAG_ATM_BC1_DS_G992_5              IMA_FLAG_DS_G992_5

/************************************PTM CHANGES******************************************/
#ifdef DANUBE_PTM_SUPPORT
#define MIN_NET_DATARATE_PTM_BC0_DS    MIN_NET_DATARATE_COMMON_DS
#define MAX_NET_DATARATE_PTM_BC0_DS    MAX_NET_DATARATE_COMMON_DS
#define MIN_RES_NET_DATARATE_PTM_BC0_DS   MIN_RES_NET_DATARATE_COMMON_DS
#define MAX_LATENCY_PTM_BC0_DS         MAX_LATENCY_COMMON_DS
#define BER_PTM_BC0_DS              BER_COMMON_DS
#define MIN_INP_PTM_BC0_DS              MIN_INP_COMMON_DS


#define MIN_NET_DATARATE_PTM_BC1_DS    MIN_NET_DATARATE_COMMON_DS
#define MAX_NET_DATARATE_PTM_BC1_DS    MAX_NET_DATARATE_COMMON_DS
#define MIN_RES_NET_DATARATE_PTM_BC1_DS   MIN_RES_NET_DATARATE_COMMON_DS
#define MAX_LATENCY_PTM_BC1_DS         MAX_LATENCY_COMMON_DS
#define BER_PTM_BC1_DS              BER_COMMON_DS
#define MIN_INP_PTM_BC1_DS              MIN_INP_COMMON_DS

#define MAX_NET_DATARATE_PTM_BC0_DS_G992_5      MAX_NET_DATARATE_DS_G992_5
#define MIN_RES_NET_DATARATE_PTM_BC0_DS_G992_5  MIN_RES_NET_DATARATE_DS_G992_5
#define MAX_LATENCY_PTM_BC0_DS_G992_5        MAX_LATENCY_DS_G992_5
#define BER_PTM_BC0_DS_G992_5             BER_DS_G992_5
#define MIN_INP_PTM_BC0_DS_G992_5               MIN_INP_DS_G992_5
#define IMA_FLAG_PTM_BC0_DS_G992_5              IMA_FLAG_DS_G992_5

#define MAX_NET_DATARATE_PTM_BC1_DS_G992_5      MAX_NET_DATARATE_DS_G992_5
#define MIN_RES_NET_DATARATE_PTM_BC1_DS_G992_5  MIN_RES_NET_DATARATE_DS_G992_5
#define MAX_LATENCY_PTM_BC1_DS_G992_5        MAX_LATENCY_DS_G992_5
#define BER_PTM_BC1_DS_G992_5             BER_DS_G992_5
#define MIN_INP_PTM_BC1_DS_G992_5               MIN_INP_DS_G992_5
#define IMA_FLAG_PTM_BC1_DS_G992_5              IMA_FLAG_DS_G992_5
#else //if defined DANUBE_PTM_SUPPORT
/**************************************PTM CHANGES**************************************/
#define MIN_NET_DATARATE_PTM_BC0_DS    NOT_SUPPORT
#define MAX_NET_DATARATE_PTM_BC0_DS    NOT_SUPPORT
#define MIN_RES_NET_DATARATE_PTM_BC0_DS   NOT_SUPPORT
#define MAX_LATENCY_PTM_BC0_DS         NOT_SUPPORT
#define BER_PTM_BC0_DS              NOT_SUPPORT
#define MIN_INP_PTM_BC0_DS              NOT_SUPPORT


#define MIN_NET_DATARATE_PTM_BC1_DS    NOT_SUPPORT
#define MAX_NET_DATARATE_PTM_BC1_DS    NOT_SUPPORT
#define MIN_RES_NET_DATARATE_PTM_BC1_DS   NOT_SUPPORT
#define MAX_LATENCY_PTM_BC1_DS         NOT_SUPPORT
#define BER_PTM_BC1_DS              NOT_SUPPORT
#define MIN_INP_PTM_BC1_DS              NOT_SUPPORT

/*****************************************PTM CHANGES*****************************************/
#endif//if defined DANUBE_PTM_SUPPORT
/***********************************PTM CHANGES******************************************/
#define MIN_NET_DATARATE_COMMON_US     (4)      /* = data rate/4000bps = 16Kbps/4000bps */
#define MAX_NET_DATARATE_COMMON_US     (960) /* = data rate/4000bps = 3840Kbps/4000bps = 64*15 bits/symbol */
#define MIN_RES_NET_DATARATE_COMMON_US (4)      /* = data rate/4000bps = 16Kbps/4000bps */
#define MAX_LATENCY_COMMON_US       (1024)   /* The specail value defined in our code for the maximu delay, which means no limit boundary(in ms) */
#define BER_COMMON_US               (0x2) /* 0x0 corresponds to a BER of 10^(-3) */
                                    /* 0x1 corresponds to a BER of 10^(-5) */
                                    /* 0x2 corresponds to a BER of 10^(-7) */
                                    /* 0x3 reserved */
#define MIN_INP_COMMON_US               (0x00)  /* 0x00 special value meaning no impulse noise protection bound */
                                                /* 0x01 means 1/2 frame min INP bound*/
                                                /* 0x10 means 1 frame min INP bound  */
                                                /* 0x11 means 2 frame min INP bound  */
#define IMA_FLAG_COMMON_US              (0x0)   /* 0x0 disable IMA */
                                                /* 0x1 enable IMA  */

#define MIN_NET_DATARATE_STM_BC0_US    NOT_SUPPORT
#define MAX_NET_DATARATE_STM_BC0_US    NOT_SUPPORT
#define MIN_RES_NET_DATARATE_STM_BC0_US NOT_SUPPORT
#define MAX_LATENCY_STM_BC0_US         NOT_SUPPORT
#define BER_STM_BC0_US              NOT_SUPPORT
#define MIN_INP_STM_BC0_US              NOT_SUPPORT

#define MIN_NET_DATARATE_STM_BC1_US    NOT_SUPPORT
#define MAX_NET_DATARATE_STM_BC1_US    NOT_SUPPORT
#define MIN_RES_NET_DATARATE_STM_BC1_US NOT_SUPPORT
#define MAX_LATENCY_STM_BC1_US         NOT_SUPPORT
#define BER_STM_BC1_US              NOT_SUPPORT
#define MIN_INP_STM_BC1_US              NOT_SUPPORT

#define MIN_NET_DATARATE_ATM_BC0_US    MIN_NET_DATARATE_COMMON_US
#define MAX_NET_DATARATE_ATM_BC0_US    MAX_NET_DATARATE_COMMON_US
#define MIN_RES_NET_DATARATE_ATM_BC0_US MIN_RES_NET_DATARATE_COMMON_US
#define MAX_LATENCY_ATM_BC0_US         MAX_LATENCY_COMMON_US
#define BER_ATM_BC0_US              BER_COMMON_US
#define MIN_INP_ATM_BC0_US              MIN_INP_COMMON_US
#define IMA_FLAG_ATM_BC0_US             IMA_FLAG_COMMON_US

#define MIN_NET_DATARATE_ATM_BC1_US    MIN_NET_DATARATE_COMMON_US
#define MAX_NET_DATARATE_ATM_BC1_US    MAX_NET_DATARATE_COMMON_US
#define MIN_RES_NET_DATARATE_ATM_BC1_US MIN_RES_NET_DATARATE_COMMON_US
#define MAX_LATENCY_ATM_BC1_US         MAX_LATENCY_COMMON_US
#define BER_ATM_BC1_US              BER_COMMON_US
#define MIN_INP_ATM_BC1_US              MIN_INP_COMMON_US
#define IMA_FLAG_ATM_BC1_US             IMA_FLAG_COMMON_US

/********************************************PTM CHANGES**************************************/
#ifdef DANUBE_PTM_SUPPORT
#define MIN_NET_DATARATE_PTM_BC0_US    MIN_NET_DATARATE_COMMON_US
#define MAX_NET_DATARATE_PTM_BC0_US    MAX_NET_DATARATE_COMMON_US
#define MIN_RES_NET_DATARATE_PTM_BC0_US MIN_RES_NET_DATARATE_COMMON_US
#define MAX_LATENCY_PTM_BC0_US         MAX_LATENCY_COMMON_US
#define BER_PTM_BC0_US              BER_COMMON_US
#define MIN_INP_PTM_BC0_US              MIN_INP_COMMON_US


#define MIN_NET_DATARATE_PTM_BC1_US    MIN_NET_DATARATE_COMMON_US
#define MAX_NET_DATARATE_PTM_BC1_US    MAX_NET_DATARATE_COMMON_US
#define MIN_RES_NET_DATARATE_PTM_BC1_US MIN_RES_NET_DATARATE_COMMON_US
#define MAX_LATENCY_PTM_BC1_US         MAX_LATENCY_COMMON_US
#define BER_PTM_BC1_US              BER_COMMON_US
#define MIN_INP_PTM_BC1_US              MIN_INP_COMMON_US
#else
/********************************************PTM CHANGES*******************************************/
#define MIN_NET_DATARATE_PTM_BC0_US    NOT_SUPPORT
#define MAX_NET_DATARATE_PTM_BC0_US    NOT_SUPPORT
#define MIN_RES_NET_DATARATE_PTM_BC0_US NOT_SUPPORT
#define MAX_LATENCY_PTM_BC0_US         NOT_SUPPORT
#define BER_PTM_BC0_US              NOT_SUPPORT
#define MIN_INP_PTM_BC0_US              NOT_SUPPORT


#define MIN_NET_DATARATE_PTM_BC1_US    NOT_SUPPORT
#define MAX_NET_DATARATE_PTM_BC1_US    NOT_SUPPORT
#define MIN_RES_NET_DATARATE_PTM_BC1_US NOT_SUPPORT
#define MAX_LATENCY_PTM_BC1_US         NOT_SUPPORT
#define BER_PTM_BC1_US              NOT_SUPPORT
#define MIN_INP_PTM_BC1_US              NOT_SUPPORT

/*****************************************PTM CHANGES**************************************/
#endif//if defined DANUBE_PTM_SUPPORT
/*********************************PTM CHANGES*************************************/

#define MAX_DATARATE_LP0_DATAPATH_DS   MAX_NET_DATARATE_COMMON_DS
#define MAX_DATARATE_LP1_DATAPATH_DS   MAX_NET_DATARATE_COMMON_DS

#define MAX_DATARATE_LP0_DATAPATH_DS_G992_5  MAX_NET_DATARATE_DS_G992_5
#define MAX_DATARATE_LP1_DATAPATH_DS_G992_5  MAX_NET_DATARATE_DS_G992_5

#define MAX_DATARATE_LP0_DATAPATH_US   MAX_NET_DATARATE_COMMON_US
#define MAX_DATARATE_LP1_DATAPATH_US   MAX_NET_DATARATE_COMMON_US

#define MAX_R_LP0_DS       8  // = number of RS redundancy octets per codeword/2 = 16/2 (G.HS standard)
#define MAX_R_LP1_DS       8  // = number of RS redundancy octets per codeword/2 = 16/2 (G.HS standard)

#define MAX_D_LP0_DS       6    //= Log2(interleaving depth) Log2(64)
#define MAX_D_LP1_DS       0    //= Log2(interleaving depth) Log2(1)

#define MAX_R_LP0_US       8    // = number of RS redundancy octets per codeword/2 = 16/2 (G.HS standard)
#define MAX_R_LP1_US       8    // = number of RS redundancy octets per codeword/2 = 16/2 (G.HS standard)

#define MAX_D_LP0_US       3   //= Log2(interleaving depth) power(2, 3) = 8
#define MAX_D_LP1_US       0   //= Log2(interleaving depth) power(2, 3) = 1

#define MAX_ONEOVERS_LP0_DS     16   // S0min = 1/MAX_ONEOVERS_LP0_DS
#define MAX_D0_SUPPORT_MASK      0x3FFF  //support optional D0 value: 96, 128, ..., 480, 511
#define MAX_D0_SUPPORT_MASK_30  0x1F  //support all optional D0 value: 96, 128, ..., 224

#define ONE_OVER_S_HALF         2
#define ONE_OVER_S_ONETHIRD      3

#define MIN_PERP  15 // minimum PERp 15 ms
#define MAX_PERP  20 // max PERp 20 ms

// Max number of DS tssi values we can decode from CL.
// Currently the same for all modes.
#define MAX_NUM_DS_TSSI_VALUES      (40)

// Number of US tssi values we send in our initial CLR.  If we need to send a second modified CLR we may send
// more US tssi values than this
#define NUM_US_TSSI_VALUES_INITIAL_CLR  (8)
// Max number of US tssi values we can decode from CL or transmit in CLR.
#define MAX_NUM_US_TSSI_VALUES  (32)

// This special value of log_tssi is defined in the g.992.3/.5 spec as meaning that the log_tssi value for this breakpoint
// should be obtained by interpolating between the two neighboring breakpoints.
#define INTERP_LOG_TSSI_CODE 126
// This special value of log_tssi is defined in the g.992.3/.5 spec as meaning that no power is transmitted on this tone, i.e.
// tssi=0 and log_tssi= -infinity.
#define NO_XMIT_TSSI_CODE  127

#define DISABLED_LP          0xF

// Currentlty, we do pre-processing before entering showtime that
// ensures us that max AZ runs never exceed 3 in showtime. However,
// an US SRA could chaneg a configuration to increase the max AZ run
// count. Hence, until we port pre-processing code for US SRA we shall
// use a max AZ Run of 6. Can be changed to 3 after the port
#define MAX_AZ_RUNS              (15)

// Currently our bitloading does not ensure us that configurations selected will
// never exceed a max ZA Run of 16. Hence, until ensure this in bitloading we shall
// use a max ZA Run of 18. Can be changed to 16 after we ensure this in bitloading
#define MAX_ZA_RUNS              (18)

#define SIMPLE_REQ_CNT           (0)
#define EXTENDED_REQ_CNT         (1)
#define UTC_RESP_CNT          (2)
#define PERFORM_CNT              (3)
#define TIMEOUT_CNT              (4)

#define DEFAULT_SRA_SETTLING_TIME   (2)      //This is in seconds
//SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (START_END)
#define DEFAULT_SRA_DELTA_LP_CHANGE 0x0100   // This has to be in dBs 8.8 format
// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (start end)
#define SIZE_EDR_BUFF      (2)

#define XDSLRTFW1842_ADSL2P_ANXB_POWER_BOOST 0x1

#endif /* _CONST_BIS_H */
