/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*^^^
 *----------------------------------------------------------------------------------
 *
 *  Aware DMT Technology. Proprietary and Confidential.
 *
 *  40 Middlesex Turnpike, Bedford, MA 01730-1413
 *  Phone (781) 276 - 4000
 * Fax   (781) 276 - 4001
 *
 *  Name: diagparam_bis.h
 *
 * Description: This a header file to be included for applying diagnostics mode
 *
 *----------------------------------------------------------------------------------
 *^^^
 */
#ifndef _DIAGPARAM_BIS_H
#define _DIAGPARAM_BIS_H

// Diag mode definitions
// Length for accumulating Quiet for computing QLN during training and diagnostcs mode
#define R_C_QUIET1_QLN_LEN       (256)
#define LOG2_R_C_QUIET1_QLN_LEN     (8)
#define R_C_QUIET1_QLN_LEN_DIAG     (4096)
#define LOG2_R_C_QUIET1_QLN_LEN_DIAG (12)
// Length for accumulating Reverb for computing Hlin/Hlog during training and diagnostcs mode

#define R_C_REVERB3_LD_ACCUM_LEN_CHANEST        (4096)
#define LOG2_R_C_REVERB3_LD_ACCUM_LEN_CHANEST      (12)
#define R_C_REVERB3_LD_ACCUM_LEN_HLIN           (512)
#define LOG2_R_C_REVERB3_LD_ACCUM_LEN_HLIN         (9)

//out of range values for test parameters
#define OUT_OF_RANGE_QUIETLINE_PSD  (255)
#define OUT_OF_RANGE_LOOPATTENU     (1023)
#define OUT_OF_RANGE_SIGNALATTENU   (1023)
#define OUT_OF_RANGE_HLOG        (1023)
#define OUT_OF_RANGE_HLIN        (-32768)
#define OUT_OF_RANGE_ACTATP         (-512)
#define OUT_OF_RANGE_SNR         (255)
#define OUT_OF_RANGE_SNRM        (-512)
//XDSLRTFW-543:BugFix_BisPlus_DS_ALL_IntlvDelay (start_end)
#define OUT_OF_RANGE_ACTPSD         (-900)


// Required target margin for Loop Diag mode
#define LOOPDIAG_SNRM            (6)   // 6dB

//RANGE off Representable values in Q8.8
#define MAX_ALLOWED_SATN   (int16)0x6633     /* 102.2 in Q8.8 */
#define MAX_ALLOWED_LATN   (int16)0x6633     /* 102.2 in Q8.8 */
#define MIN_ALLOWED_ACTATP (int16)0xCCE7     /* -51.1 in Q8.8 */
#define MAX_ALLOWED_ACTATP (int16)0x3333     /* 51.2 in Q8.8 */

//Fix_LATN_MAX_VALUE (Start)
#define OUT_OF_RANGE_ATTEN_DMT_T1413_FORMAT1   (127)  //63.5*2, i.e. 63.5dB in 0.5dB granularity
#define OUT_OF_RANGE_ATTEN_DMT_T1413_FORMAT2   (635)  //63.5*10, i.e. 63.5dB in 0.1dB granularity
//Fix_LATN_MAX_VALUE (End)


//#define DEBUG_TESTPARM

//*******************
//**** CONSTANTS ****
//*******************
#define  POWER_TO_DBM      (-895)      /* -6.9897 = 10log10(2*RN*(.001)) in Q9.7 */
#define  POWER_TO_DBM_PER_HERTZ  (3758)   /* 29.3576 = 10log10(2*RN*(4.3125)) in Q9.7 */
#define TEN_LOG_DELTA_F (9305)         /* 36.35 = 10*log10(4312.5) in Q8.8 */

#define C_20LOG10_2 (1541)             /* 20log10(2) in Q8.8 */
#define C_10LOG10_2 (771)              /* 10log10(2) in Q8.8 */

//#define LOG2LINMIN (-43156)       /* -168.5768 in Q8.8 */
#define LOG2LINMAX   (4620)         /* floor(18.05*256) Q8.8 */
#define MAX_HLIN_VALUE (0x7fff)  /* (in Q8.8) */

#define ATTNDR_SNRGAP            (2496) /* 9.75dB in Q8.8 */


//AFE Specific
/* Used during Rx-filter calibration to ensure calibration filter in representable range */
#ifdef AMAZON_AFE /* Infineon Amazon-A AFE IC */
   #ifndef DANUBE
      #define CALIBRATE_RX_FILTER_CONSTANT_DB (0x2C40) /*Q9.7*/
   #else
   // #define CALIBRATE_RX_FILTER_CONSTANT_DB (0x2E7C)  bis
      #define CALIBRATE_RX_FILTER_CONSTANT_DB (0x30D4) //plus
   #endif
#else /* Else for #ifdef AMAZON_AFE */
//#ifdef ISDN  /* Annex B */
#define CALIBRATE_RX_FILTER_CONSTANT_DB (120<<7) /*Q9.7*/ //Note: 0x3C00 used while calibrating QLN in both ADSL AnxA & AnxB Modes
//#else
//#define CALIBRATE_RX_FILTER_CONSTANT_DB (11250) /*Q9.7*/
//#endif
#endif   /* End of #ifdef/#else AMAZON_AFE */

/* Reference level used for FDQ 27*10log10(2)in Q8.8 for DEC_QPSK_GAIN=0x2000 (Q3.13) */
#define FDQ_REF_LEVEL_DB   (20807)

#ifdef TARGET_HW

//#ifdef AMAZON_AFE || VR9_AFE
#ifdef ISDN /* Annex B */
//bis compensation filter
#define RX_FILTERCOMP_LAST_CHAN_BIS 255
// XDSLRTFW-758 PERF_DS_ALL_ALL_AnnexB_QLN_Calibration (Start_End)
#define RX_FILTERCOMP_FIRST_CHAN_BIS 1
//plus compensation filter
#define RX_FILTERCOMP_LAST_CHAN_PLUS 511
// XDSLRTFW-758 PERF_DS_ALL_ALL_AnnexB_QLN_Calibration (Start_End)
#define RX_FILTERCOMP_FIRST_CHAN_PLUS 1 //First usable Rxfilter tone
#else    /* Annex A */
//bis compensation filter
#define RX_FILTERCOMP_LAST_CHAN_BIS 255
#define RX_FILTERCOMP_FIRST_CHAN_BIS 1
//plus compensation filter
#define RX_FILTERCOMP_LAST_CHAN_PLUS 511
#define RX_FILTERCOMP_FIRST_CHAN_PLUS 1 //First usable Rxfilter tone
#endif   /* End of #ifdef/#else ISDN*/

#else //TARGET_HW

//bis compensation filter
#define RX_FILTERCOMP_LAST_CHAN_BIS 255
#define RX_FILTERCOMP_FIRST_CHAN_BIS 1 //RX_FIRST_CHANNEL1_TSS
//#define MAX_RX_FILTERCOMPVALUE_CHAN_BIS 255 // channel with maximum Rx Compensation Filter Value
#define RX_FILTERCOMP_LAST_CHAN_PLUS 511
#define RX_FILTERCOMP_FIRST_CHAN_PLUS 1 //First usable Rxfilter tone

#endif

//Currently only BIS Rx compensation filters are used in the code which may begin to roll-off as you get closer to tone 255.
//For  Plus we currently use the first part of this same compensation filter (before the roll off begins).
//Set this breakpoint value to determine until which tone the BIS compensation filter is used for PLUS.
//The compensation filter used for PLUS remains flat at that value for tones higher than this BreakPoint tone.
//#define BIS_BREAKPOINT_TONE_FOR_PLUS 127

#ifndef DIAG_AFE_RX_CALIBRATION
//#define DIAG_AFE_RX_CALIBRATION               // uncomment for AFE receiver calibration only
#endif




// Diag mode prototypes
void ComputeHlog(uint8 *puca_hlin, uint8 *puca_msg_ld, uint8 *puca_scale, int16 s_first_channel, int16 s_last_channel);
int16 RxFilterCompensate(int16 s_in, int16 s_pga, int16 s_dBmCompValue, int16 s_chan);
int16 RxInvFiltCoef(int16 s_chan);
void ComputeHlin(void);
void logtolin(int16 *s_value, int16 *s_exp_out, FlagT ft_getexpflag);
void LoopAttenu_BIS(int16 *psa_Hlin_mantissa, int16 s_Hlin_exp, int16 s_first_channel, int16 s_last_channel, int16 s_ToneStepSize);
void QuietLineNoisePSD();
void CalcAvgNoisePSD(uint8  *gpuca_RMSG8_LD, int16 s_OutofRangeValue);
uint32 CalcATTNDR(int16 *psa_SnrBuf, int16 s_DesiredMargin, int16 s_CodingGain);
int16 CalcACTATP(int16 s_nomatp, int16 s_refvalue);
void BgCalcDiagModeData(void);

#endif // _DIAGPARAM_BIS_H
