/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _GDATA_BIS_H
#define _GDATA_BIS_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1313 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  gdata_bis.h
;
;  Header file for global variable declarations for bis
;
*****************************************************************************/
// ******************************************************************
// gdata_bis.h
//
// History
//
// 22/07/2010 Nihar : Reducing Tx power by 3 dB (in DELT mode)
//               when measured PGA in C-COMB1 is above 21 dB
//               Reduction of TX power by 3dB for loops up to 3kft when DELT is used
//               Grep for IOP_DS_BisPlus_CNXT_ReduceTxPwrDELT
//
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 05/10/2011 Kannan/Vinjam : Relocated "gt_ADSL_TcMode_Reprt" structure (pointed by CMV DSL 14) from "Bis" to "Bulk Memory" data overlay section
// Grep for XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs
//
//14/03/2012 Kannan: 08/04/2009 Bhadra: Added code for uinversal ReTx C-Msg1 related changes
//                   Increased "guca_R_C_Msgs1_bis size".by 10 bytes
//                     Grep for SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
//
//14/03/2012 Kannan: 08/04/2009 Bhadra: Added code for uinversal ReTx R-Msg1 related changes
//                   Increased guca_RMsgs1Tab_bis   by 1 byte
//                     Grep for SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
//15/03/2012 Kannan: 16/04/2009 Bhadra: Added code for bitload related changes in Universal Retransmission (G.INP)
//                   Added required variables for bitload.
//                     Grep for SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad to see changes.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 04/07/2012 Ram: Merged "ReTx" Bitswap code from ARX ADSL code base.
//                 Grep for "XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx"
////16/07/2012 Anantha: removed unused variables  for implementation of LCD and NCD defect
// ******************************************************************
#include <stdio.h>
#include "common.h"
#include "rt_state.h"
#include "ifft_fix.h"
#include "typedef.h"
#include "typedef_bis.h"
#include "aoc.h"
#include "eoc.h"
#include "ib.h"
#include "const_bis.h"
#include "ovhd_bis.h"
#include "spectral_shape_bis.h"

#define OPENING_FLAG       (0x7E)

/* bis showtime variables */
extern int16 gs_TxPMDFrameCnt, gs_RxPMDFrameCnt;

/* TX */
#ifndef HERCULES_ADSL_CPE
extern int16 gs_maxAZRunCnt, gsa_num_preproc_frames[NUM_DATA_PATHS];
extern int16 gs_AZRunCnt, gs_dbgFciAaiMaxMipsTx;
#endif
extern int16 gs_dbgTCAMaxMipsTx;
// For faster Tx Data Pump processing -- AZ Run Count Mechanism
extern int16 gsa_TxMuxFrameSize[NUM_DATA_PATHS][2];
#ifndef HERCULES_ADSL_CPE
extern int16 gsa_TxMuxFrameCount[NUM_DATA_PATHS];
extern int16 gsa_ItSizeRegValue[MAX_AZ_RUNS];
extern uint16 gusa_ACfgRegValue[MAX_AZ_RUNS], gusa_ZtLineRegValue[MAX_AZ_RUNS];
#endif
extern uint16 gusa_PreconfigACfgTx[NUM_DATA_PATHS];
// For faster Tx Data Pump processing -- Tx Ovhd Msg Processing
#ifndef HERCULES_ADSL_CPE
extern uint16 gus_ZtLineRegMask;
#endif
extern uint16 gus_TxIbInfoL, gus_TxIbInfoH;
extern uint8 guc_tx_ovhd_byte;

/* RX */
extern int16 gs_ZARunTimes, gs_dbgTCAEndMips, gs_dbgTCAMaxMips, gs_dbgFciMaxMips, gs_dbgAaiMaxMips;
// For faster Rx Data Pump processing -- ZA Run Count Mechanism
extern int16 gsa_NBytes_In_RateBuffer[NUM_DATA_PATHS], gsa_RxMuxFrameCount[NUM_DATA_PATHS], gsa_RxMuxFrameSize[NUM_DATA_PATHS][2];
extern uint16 gus_IrSizeRegValue, gus_ZrLineRegMask, gus_ACfgRegMask;
extern uint16 gusa_PreconfigIRSize[NUM_DATA_PATHS], gusa_PreconfigACfg[NUM_DATA_PATHS];
extern FlagT gft_fdqTCDone;
// For faster Rx Data Pump processing -- Rx Ovhd Msg Processing
extern uint16 gusa_FramingByteBuffer[MAX_ZA_RUNS*3];
extern uint16 *gpusa_FramingByteBufferWPtr;

extern int16 gsa_DSOvhdRate[NUM_DATA_PATHS];
extern int16 gsa_USOvhdRate[NUM_DATA_PATHS];

// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting( Start)
extern ReportErasure_t gt_ErasureDecoding_Reprt;
// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting( End)

//XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs (Start)
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
//extern Report_Hsk_TCMode_t gt_ADSL_TcMode_Reprt;
//XDSLRTFW-340 BugFix_DS_DMT_ALL_SelectedTcModeAfterG.Hs (End)


// HDLC ovhd msg variables
extern int16 gsa_COReq_OvhdMsgSegIndx[3]; //CO requested segmented ovhd msg index
extern int16 gsa_RTXmit_OvhdMsgSegIndx[3]; //RT xmitted segmented ovhd msg index
extern int16 gs_OvhdMsgFirstTone;      //Last tone for each ovhd msg segment
extern int16 gs_MaxTonePerOvhdMsg;     //Maximum # of tones that could be held in one ovhd msg
extern FlagT gfta_FirstOvhdMsgSeg[3];     //Flag indicate whether we are forming the first ovhd msg segment

/* bis training variables */
extern FlagT gft_BIS_TX_transition;

extern uint8 guca_RCMsgFMTTab[LEN_C_MSGFMT];
extern uint8 guca_RCMsgPCBTab[LEN_C_MSGPCB];

extern uint8 guca_RMsgFMTTab[LEN_R_MSGFMT_WITHOUT_CRC];
extern uint8 guca_RMsgPCBTab[LEN_R_MSGPCB_WITHOUT_CRC];

extern TxToneFlags   gp_BlackoutBits_US;

extern CMsgFmt_Bis_t gt_RCMsgFmt_bis;
extern CMsgPcb_Bis_t gt_RCMsgPcb_bis;
extern int16 gs_Num_MsgBytes;

extern RMsgFmt_Bis_t gt_RMsgFmt_bis;
extern uint8 guc_RT_FMT_R_REVERB1;
extern uint8 guc_RT_FMT_C_REVERB4;
extern uint8 guc_RT_FMT_C_TREF1_DURATION;
extern uint8 guc_RT_FMT_C_PILOT;

extern RMsgPcb_Bis_t gt_RMsgPcb_bis;
extern int16 gs_PCB_DS_Delta_bis;

extern int16 gs_COMB1_REFERENCE_POWER;
extern int16 gs_PGA_required_saved;
extern int16 gs_COMB2_REFERENCE_POWER;

extern int16 *gsa_Comb2SignalBuf;
extern int16 gs_ChosenPilot_CD;
extern int16 gs_ChosenPilot_preSNR;
extern int16 gs_PllScaling_bis_CD;
extern int16 gs_PllScaling_bis_preSNR;


extern int16 gs_NumCombSubcarriersInspected;
extern int16 gs_NumCombSubcarriersRequired;
extern int16 gs_ChanDiscDetCnt;
extern int16 gs_R_C_COMB1_AC_LEN_BIS;
extern int16 gs_LOG_R_C_COMB1_AC_LEN_BIS;
extern int16 gsa_Inspected_COMB_Subcarriers[NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2PLUS];
extern int16 gsa_CombToneDetCnt[NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2];

extern int16 gsa_C_COMB_index[C_COMB_INDEX_CNT_G992_5];
extern int16 gsa_tref1_candidates[20];
extern int16  gs_C_COMB_FIRSTCHAN_IDX;
extern int16  gs_C_COMB_LASTCHAN_IDX;


extern int16 gsa_COMB_ICOMB_DetectionBins[NUM_OF_BINS_FOR_COMB_DETECTION];
extern int16 gsa_COMB_ICOMB_DetectionBins_BTLL[NUM_OF_BINS_FOR_COMB_DETECTION];
extern uint8 guc_NUM_OF_BINS_FOR_COMB_DETECTION;
extern uint8 guc_NUM_OF_BINS_FOR_COMB_DETECTION_BTLL;
extern int16 gs_THRESHOLD_FOR_QUALIFIED_COMBTONES;
extern int16 gs_hskPowerThresh4000m;

extern int16 gs_COMB_counter, gs_ICOMB_counter;

extern int16 gus_TxGainCutBackFactor_Bis;

extern int16 gs_NLEchoThresh_bis;
extern int16 gs_NLEchoDiffThresh_bis;
extern int16 gs_NLEchoDiffThresh_rsh_bis;

extern int16 gs_R_C_TREF1_RX_LEN_BIS;
extern int16 gs_R_C_REVERB1_RX_LEN_BIS;;

extern FlagT gft_goto_RReverb3_Flag;
extern int16 gs_RCReverb4_rx_len_bis;
extern int16 gs_RxCrcSubstateCnt;

extern FlagT gft_DS_Windowing;

/* ======================================================================== */
/*  Received R_C_MSGS1 and R_C_MSGS2 information */
/* ======================================================================== */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod Start
#ifdef UNV_RETX_MSGS
extern uint8 guca_R_C_Msgs1_bis[R_C_MSG1_RETX_NUM_BYTES_BIS];
#else
extern uint8 guca_R_C_Msgs1_bis[R_C_MSG1_NUM_BYTES_BIS];
#endif
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

extern uint8 guca_R_C_Msgs2_bis[R_C_MSG2_NUM_BYTES_BIS];

extern uint8 guca_PreAmbleField_bis[(R_MSG1_PRFX_LEN_BIS>>3)];
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod start
#ifdef UNV_RETX_MSGS
extern uint8 guca_RMsgs1Tab_bis[R_MSG1_RETX_NUM_BYTES_BIS];
#else
extern uint8 guca_RMsgs1Tab_bis[R_MSG1_NUM_BYTES_BIS];
#endif
//SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
extern uint8 guca_RMsgs2Tab_bis[R_MSG2_NUM_BYTES_PLUS];

extern uint16 gusa_14Order_PN1024Tab[64];

extern RMsgs1_Bis_t gt_RMsgs1_bis;

extern uint8 guc_R_C_MEDLEY_LENGTH_DIV_512;
extern uint8 guc_R_C_MEDLEY_LENGTH_DIV_512_DEBUG;

extern CMsgs1_Bis_t gt_RCMsgs1_bis;

extern int16 gs_RCReverb3Len_Min;

/* For R-MEDLEY */
extern uint32 gul_MedleyState;  // gul_RxMedleyState;
extern uint8 guca_MedleyBuffer[NUM_R_MEDLEY_BYTES];  // guca_RxMedleyBuffer[NUM_R_C_MEDLEY_BYTES], guca_RxMedleyBuffer_sav[NUM_R_C_MEDLEY_BYTES];

extern uint32 gul_RxMedleyState;
extern uint8 guca_RxMedleyBuffer[NUM_R_C_MEDLEY_BYTES], guca_RxMedleyBuffer_sav[NUM_R_C_MEDLEY_BYTES];

//extern int16 gs_ClippingIdx;
//extern int16 gsa_BisMedleyClippedFrames[23];

extern uint16 gusa_Tones_RMsg2[NSC_C_PARAMS];

/* For R_PARAMS  */
extern int16 gs_NSC_RParams;
extern uint8 guc_FormRParamsState;
extern uint8 guca_Tones_RParams[TX_NUM_TONES-6];
extern int16 gs_BytePosition;
extern uint8 gus_BitPosition;
extern int16 gs_R_Params_Frame_Len;
extern uint8 *guca_R_PARAMS_bis;
extern uint8 guca_R_PARAMS_bis_sav[12];
extern uint8 guc_US_lowest_latency_LP;

/* For Bitload */
extern   PMSBitload_t gt_PMSParams;

extern int16 gs_CheckBytes;

extern int16 gs_MinDSOverheadRate; // MIn DS overhead, computed in bitload_bis
extern int16 gs_CodingGainForATTNDR;   // The coding gain that gives max ATTNDR during initial bitloading.

extern int16 gs_max_CWSize;// Max CW Size limit to be used becasue of max interleaver limit

extern int16 gs_supportedDvalues[21]; // supported D values

extern int32 gl_ATTNDRds_Initial;
extern int32 gl_ATTNDRds_Estimate_Initial;// Estimate of Total Data Rate based on Medley SNR, coding gain for actual max rate.
extern int32 gl_ATTNDRds_Estimate_Updated;// Estimate of Total Data Rate based on Showtime SNR, coding gain for actual max rate.

/* Received R_C_PARAMS information */
extern uint8 guca_R_C_PARAMS_bis[LEN_C_PARAMS_MESSAGE_BYTES+1];

extern uint8 guc_CrcCalcState;
extern int32 gul_RxDescrambleState;
extern int16 gs_C_PCB_Frame_Len;
extern int16 gs_C_Params_Frame_Len;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//FEATURE_BisPlus_ALL_CPARAMS_INP_FLAG_Modifications (Start_End)
extern int16 gs_C_Params_Frame_Complte_Len;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

extern FlagT gft_DecodeCParamsOK;

/* For OLR and PM */
extern TxOLRVars_t      gt_TxOLRVars;
extern RxOLRPMVars_t gt_RxOLRPMVars;
extern int16         gs_TxSyncToneType;

extern FlagT gft_debug_AbortOLR;  // Downstream aborted bitswaps
extern FlagT  gft_extrafinegainallocated; // flag to allocate extra fine gain as soon as we can to take care of
// forceeven1 changes

extern int16 gs_HLogReportDelta;
extern int16 gs_finegainadjust_bis;

/* New BIS stuff */

/* ===================================================*/
/* global variable declarations for Tx overhead bytes */
/* ===================================================*/
extern int16 gsa_tx_SEQp[];
extern MessageOvhdFifo_t gt_TxHDLCMsgFifo;
extern uint8 *guca_TxHDLCMsgBuffer;
extern uint8 guca_tx_clear_eoc_buff[];

/* Global variables to be used in the HDLC ovhd msg transmitting*/
extern FlagT gft_Start_Transmit_HDLC;

/* ===================================================*/
/* global variable declarations for Rx overhead bytes */
/* ===================================================*/
extern HDLCMsgStruct_t gt_RxHDLCMsg;
extern int16 gsa_rx_SEQp[];
extern MessageOvhdFifo_t gt_RxHDLCMsgFifo;
extern uint8 guc_HDLC_RxState;
extern uint8 *guca_RxHDLCMsgBuffer;

// test parameter

// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
extern uint16 gus_US_Hlogf_m[TX_NUM_TONES];
extern uint8 guca_US_Quiet_Line_Noise[TX_NUM_TONES];
extern uint8 guca_US_ShowtimeSNR[TX_NUM_TONES];
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)

extern MeasurementPeriod_t gt_US_MeasurementPeriod;

// comment out temporarily because we haven't had the code ready yet
//extern uint16 gus_DS_Hlogf_measurement_period;
//extern uint16 gus_DS_snr_measurement_period;

extern int16 gs_nearend_ActualAggregateXmtPwr;

/* Needed only for debug check */
/*extern int16 gus_rx_reserved_byte;*/

extern int32 gl_self_test_result;
extern uint16 gus_snr_measurement_period;
extern OvhdRegStruct_t gt_TxOvhdRegister;
extern OvhdRegStruct_t gt_RxOvhdRegister;

extern TxIb_AnamolyStruct_t gt_tx_Anomaly;
extern RxIb_AnamolyStruct_t gt_rx_Anomaly;

extern FlagT gft_TxBpnReconfigAllowed[];
extern FlagT gft_RxBpnReconfigAllowed[];

extern FlagT gft_SkipCparams;

extern int16 gsa_RReverbTones[TX_FFT_LENGTH];

extern uint16 gusa_DS_Tssi_Value[RX_NUM_TONES];
extern uint16 gusa_US_Tssi_Value[TX_NUM_TONES];

/* For TCM support */
/* In BIS we can enable TCM independently for US and DS */
extern FlagT gft_TcmFlag_bis_US;
extern FlagT gft_TcmFlag_bis_DS;

extern int16 gs_RxMinBitsPerTone_BIS_TCM;

/* Diagnostics mode */
extern uint8 guc_CO_PassFail;
extern uint8 guc_CO_Last_TX_State;
extern uint8 guc_RT_PassFail;
extern uint8 guc_RT_Last_TX_State;

extern FlagT gft_G992_5_Medley14thOrderPRBS;

// Flags here for GHS to Init codeswap transition purpose
extern uint8 gft_enterTraining;       // Flag indicate that we have got valid BIS mode and we are ready to codeswap new pages

// Actual aggregate transmit power
extern uint8 guc_ACTATP_LSB;
extern uint8 guc_ACTATP_MSB;

// Loop Attenuation
extern uint8 guc_LoopAtten_LSB;
extern uint8 guc_LoopAtten_MSB;

// Signal Attenuation
extern uint8 guc_SigAtten_LSB;
extern uint8 guc_SigAtten_MSB;

// global variables used for BIS ovhd update test paramter
extern FlagT gft_UpdateTestPar;
extern uint16 gus_10sec_Timer;
extern int16 gs_RxSNRM_ovhd;
extern int16* gpsa_RxSnrBuf_ovhd;

extern FlagT gft_farEndSISupport;

extern int16 gs_BisToneOrderIntlvDepth;

extern int16 gs_tssiMaskCeil;
/* Should include indexes 0 and gs_RxNumTones(512) and should be non-decreasing */
extern int16 gsa_DsMaskCeilLogTssiBrkptIndx[4];
/* Positive value is relative to NOMPSD */
extern int16 gsa_DsMaskCeilLogTssiBrkptVal[4];  /* log tssi (0, 63.5)dB in Q7.9 format */

extern FlagT gft_EnableSmallerS;  //Enable Smaller S at G992.5x mode, for now it means enable S=1/4
extern FlagT gft_DisableExtendedFrame;  //Internal flag to indicate whether or not to Disable the new info of extended frame parameters
extern FlagT gft_GHS_S0min_Negotiated; //Flag indicate whether or not both CLR and CL contains the extended frame parameter in GHS

extern int16 gs_RxEstimatedMinMargin;

extern uint16* gpusa_CLR_USTssiIndex;
extern uint8* gpuca_CLR_USTssiValue;
extern uint8* gpfta_CLR_USTssiSi;

extern uint16* gpusa_CL_USTssiIndex;
extern uint8* gpuca_CL_USTssiValue;
extern uint8* gpfta_CL_USTssiSi;

#ifndef BIS_CODESWAP
extern uint16 gusa_CLR_USTssiIndex[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)];
extern uint8 guca_CLR_USTssiValue[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)];
extern uint8 gfta_CLR_USTssiSi[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)/8];

extern uint16 gusa_CL_USTssiIndex[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)];
extern uint8 guca_CL_USTssiValue[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)];
extern uint8 gfta_CL_USTssiSi[MAX_NUM_US_TSSI_VALUES*(NUM_G992_3_ANNEX_SUPPORTED+NUM_G992_5_ANNEX_SUPPORTED)/8];
#endif

// Number of DS Tssi breakpoints sent in CL msg
extern int16 gsa_num_DS_Tssi_brkpt[2];
// Number of DS Tssi breakpoints kept from CL msg
extern int16 gsa_num_DS_Tssi_brkpt_kept[2];

// Number of US Tssi breakpoints sent in CL msg
extern int16 gsa_num_US_Tssi_brkpt[2];
// Number of US Tssi breakpoints kept from CL msg
extern int16 gsa_num_US_Tssi_brkpt_kept[2];
// Number of US Tssi breakpoints being sent in CLR msg
extern int16 gsa_num_USTssi_Xmitted[2];

extern uint16 gusa_CL_RcvdCnt[6];

extern int16 gs_total_extrabitsNeeded; //extra bits needed for showtime AZRun preprocessing

extern uint8 guc_PM_L3_InternalState;  //Global variable for PM L3 State Machine
extern uint8 guc_PM_L3_Response;    //Global variable for PM L3 State Machine

//saved rates of L0 state. Will be used after L2 exist and back to L0.
extern int32 gla_save_DSDataRate[2];
extern int16 gsa_save_DSOvhdRate[2];
//saved ACTATPds of L0 state, the L2 ACTATP will be updated by gs_DS_ACTATP_L0 - PCBdiff_of_L2_L0
extern int16 gs_DS_ACTATP_L0;

extern int16 gs_tssi_DeepNotchthreshold;
extern int16 gs_tssi_ShallowNotchthreshold;
extern int16 gs_tssi_threshold;
extern FlagT gft_NotchPresent;
extern int16 gs_PcbDsDeltaForNotch;
extern int16 gs_avg_first_channel, gs_avg_last_channel, gs_avg_num_channels;
extern FlagT gft_StrongNoisePresent;
extern FlagT gft_dbgDisableTimeout;

// IOP_DS_BisPlus_CNXT_ReduceTxPwrDELT (Start)
#ifndef ISDN   // Only for Anx-A
extern int8 gc_reduce_txpwr_for_CNXT_delt;
extern int8 gc_CCOMB1_thrd_for_CNXT_delt;
#endif // ifndef ISDN
// IOP_DS_BisPlus_CNXT_ReduceTxPwrDELT (End)

#endif   /* _GDATA_BIS_H */
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): memory allocation for p_QLN struct
//extern uint8 guca_RxBat_Before_BS[RX_NUM_TONES];
//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (Start)

extern RxToneFlags p_PARRTONEset;

// XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
//bit allocation saved before Bitswap
extern uint8 guca_RxBat_Before_BS[RX_NUM_TONES];
// XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)

extern int16   gs_TCM_ovhd_Lp0;
extern int16   gs_bits_Lp0;
extern int16   gs_TCM_ovhd_Lp0_ReTx;
extern int16   gs_bits_Lp0_ReTx;
extern int16   gs_ncloaded_Lp0_ReTx;
extern uint16  gus_ncloaded_Lp1_ReTx;
extern int16   gs_ncloaded_Lp0;
extern uint16  gus_ncloaded_ReTx;
extern int16   gs_TCM_ovhd_Lp1_ReTx;
extern int16   gs_Tcm_Oh_LP1;
extern int16   gs_TotalBitsSupported_ReTx;
extern int16   gs_RxExtraBits_ReTx;
extern uint16  gus_Lp1Available_ReTx1;
extern uint16  gus_Lp1Available_ReTx2;
extern int16   gs_RxAvFineGain_ReTx;
extern int16   gs_MaxToneForFast_ReTx_ST;   /* Number of tones whose bits are allocated in ReTx Showtime */
extern uint16  gus_S;
//FEATURE_DS_BisPlus_ALL_ReTx_Modified_HEC_Error_Count Begin
extern uint16   gus_A;
//FEATURE_DS_BisPlus_ALL_ReTx_Modified_HEC_Error_Count End
extern FlagT   gft_change_lp0;
extern FlagT   gft_Bitswap_UreTX;
//SMS01435874:FEATURE_ALL_BisPlus_ALL_Univ_Retx_BitLoad (End)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
