/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   gdata_bis_diag.c
*
*  This file contains global variable declarations for
*   bis diagnostics mode
*
*-------------------------------------------------------------------------
*/
#ifndef _GDATA_BIS_DIAG
#define _GDATA_BIS_DIAG

#include <stdio.h>
#include "common.h"
#include "rt_state.h"
#include "rt_tones.h"
#include "pga_set.h"
#include "ifft_fix.h"
#include "aoc.h"
#include "typedef.h"
#include "typedef_bis.h"
#include "bert.h"
#include "compiler.h"
#include "eoc.h"
#include "ib.h"
#include "const.h"
#include "const_bis.h"
#include "ovhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "data_alloc.h"
#include "spectral_shape_bis.h"


/* Diagnostics mode */
extern uint8 guca_RMSG1_LD[14];
extern uint8 *gpuca_RMSG2_LD;
extern uint8 *gpuca_RMSG6_LD;
extern uint8 *gpuca_RMSG8_LD;
extern uint8 *gpuca_RMSGx_LD;

extern uint8 guc_Reverb_Counter;
extern uint8 guc_R_C_Ack;
extern uint8 guc_msg_ld_idx_us; /* Indicate which R-MSGx-LD is being transmitted from RT */
extern FlagT gft_RCAckLDRcvFlag;
extern uint8 guc_RMsgLDType;


extern uint8 *gpuca_R_C_MSG1_LD;
extern uint8 *gpuca_R_C_MSG2_LD;
extern uint8 *gpuca_R_C_MSG3_LD;
extern uint8 *gpuca_R_C_MSG4_LD;
extern uint8 *gpuca_R_C_MSG5_LD;
extern uint8 guc_msg_ld_idx_ds; /* Indicate which C-MSGx-LD is being received at RT */
extern uint16 guc_msg_seq_num;  /* Indicate the sequence number of received C-MSGx-LD message */

/* global variables for short initialization */
extern FlagT gft_CComb2_Detected;

// For DIAGNOSTICS_MODE_PARAMS
extern int16 *gpsa_RxHlin;          // Pointer to channel transfer function in linear
extern uint16 gus_Hlin_scale;       // scale for gsa_RxHlin
extern int16 gsa_RxHlogDS[RX_NUM_TONES>>1]; // DS channel transfer function in log domain
extern FlagT gft_DiagAfeRxCalibration; // Flag used to indicate that Rx calibration is being done
extern int16 gs_DiagRxCalibrateConstant;  //Holds constant value used to calibrate Rx AFE filter
extern LoopDiagParam_t gt_DS_LDParam;
extern LoopDiagParam_t gt_US_LDParam;

/* CPE Modem front-end Rx path specific data  (platform dependent) */
//#ifndef DIAG_AFE_RX_CALIBRATION
//extern int16 gsa_Rxfilter_comp_dB[256];
//#endif


#endif // _GDATA_BIS_DIAG
