/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _OLR_Bpn_CHECK_H
#define _OLR_Bpn_CHECK_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             olr_Lp_check.h
 * DESCRIPTION:      Header file for functions that implement the
 *                   OLR Bpn check.
 *
 **********************************************************************/

#include "typedef.h"

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
FlagT isValidFramingConfiguration(Config_t* t_config, uint8 *puca_BCnToLPp, DerivedFrameProp_t* t_DerivedFrameProperties,
                              int16* sa_deltaLp, int16* sa_deltaBpn, int16* ps_retCode);
FlagT isBpnReconfigValid(int16* sa_deltaBpn, int8 *puca_BCnToLPp, FlagT *pta_BpnReconfigAllowed, Config_t *pt_Config, FlagT isDownstream, int16* ps_retCode);
void CheckForBpnReconfig(int16 s_CodewordSize, int16 s_Lp, int16 s_Rp, int16 s_Dp, FlagT* ft_BpnReconfigAllowed);
FlagT VerifyAndUpdateTxQAMParameters(uint8* uca_BAT, int16* sa_Lp);
void VerifyAndUpdateRxQAMParameters(void);
void VerifyAndUpdateRxFramerParameters(void);

#endif /* _OLR_Bpn_CHECK_H */
