/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _OVHD_H
#define _OVHD_H

/****************************************************************************
;       Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;       Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;       File Name: ovhd_bis.h
;
;
*****************************************************************************/
// ******************************************************************
//  ovhd_bis.h
//
// History
//
// 29/01/2009 Sriram Shastry : Added the constant to indicate the Test Parameter ID
//                                      Grep for SMS00847294:Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 10/08/2011 Vinjam: Added a new flag to detect "LOM" (Loss Of Margin) to "TxIb_AnamolyStruct_t" structure.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
//  19/09/2011 Sriram Shastry : Disable Power Management L2,L3 mode, Seamless rate adaptation ( US & DS direction) as a part of R43. delivery
//                                       This is done as per project management requirement. They are only check box feature for R4.3 release. SRA & PM L2 mode
//                                       features are functionally not verified.
//
//              Grep for :   IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
// ******************************************************************


#include "typedef.h"
#include "const_bis.h"

// We limit Sum{Lp} >= 16 as the feasible Lp configuation in L2 mode. This is to guarantee enough number
// of loaded tones (>10) in L2 mode so that we can avoid possible false detection of L2 Exit symbol.
// Note: This limit is specifically set for Socrates firmware, not a general one in BIS spec.
#define MIN_SUPPORTED_SUMLP_IN_L2_MODE  16
#define MIN_PM_REQ_PCB_VALUE            0
#define MAX_PM_REQ_PCB_VALUE            40
// Cutting back too much from L0 power level could result in PLL noise that reduces US SNR margin.
#define MAX_L0_TO_L2_CUTBACK                    (12)

// Due to memory constraints these are currently set at some arbitrary values.
#define MAX_TX_ME_HDLC_MSG_SIZE 32
#define MAX_RX_ME_HDLC_MSG_SIZE 256

#define MAX_RX_HDLC_MSG_SIZE    (1030 - MAX_RX_ME_HDLC_MSG_SIZE)
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
#define MAX_TX_HDLC_MSG_SIZE        1000
#define MAX_TX_HDLC_BUFFER_SIZE  1000
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)

#define TX_CEOC_SPACING                 (15)    // Spacing between Tx Clear EOC messages (DMT)

// size in bytes
#define CLEAR_EOC_DATA_SIZE             10

#define OVHD_HIGH_PRIORITY              (0)
#define OVHD_NORMAL_PRIORITY    (1)
#define OVHD_LOW_PRIORITY               (2)
#define MAX_OVHD_PRIORITY               (3)

#define MIN_OVHD_MESSAGE_LEN  (4)
#define MAX_OVHD_MESSAGE_LEN  (1024)

/**************************/
/* BIS INDICATOR BITS     */
/**************************/
#define LOS_IB                                  (0x7F)
#define SEF_IB                                  (0xBF)
#define LPR_IB                                  (0xDF)
#define LCD_BC0_IB                              (0x7F)
#define LCD_BC1_IB                              (0xBF)


/****************************/
/* OVHD MESSAGE DESIGNATORS */
/****************************/

/* Highest priority message */
#define RECONFIG_CMD_DESIG                                      0x01

/* Normal priority message */
#define EOC_CMD_DESIG                                           0x41
#define TIME_CMD_DESIG                                          0x42
#define INVENTORY_CMD_DESIG                                     0x43
#define CNTL_PAR_RD_CMD_DESIG                           0x04
#define MGMT_CNTR_RD_CMD_DESIG                          0x05
#define POWER_MGMT_CMD_DESIG                            0x07
#define CLEAR_EOC_CMD_DESIG                                     0x08
#define NSF_FACILITY_CMD_DESIG                          0x3F

/* Low priority message */
#define PMD_TEST_PAR_RD_CMD_DESIG                       0x81
#define NSF_FACILITY_LOW_CMD_DESIG                      0xBF

/* Segment ACK Designator*/
#define SEGMENT_ACK_PRIOR0                  0xF0
#define SEGMENT_ACK_PRIOR1                  0xF1
#define SEGMENT_ACK_PRIOR2                  0xF2

/**************************/
/* EOC COMMAND TYPES */
/**************************/

#define PERFORM_SELF_TEST                               0x01
#define UPDT_TEST_PARAMETER                             0x02
#define START_TX_CORR_CRC                               0x03
#define END_TX_CORR_CRC                                 0x04
#define START_RX_CORR_CRC                               0x05
#define END_RX_CORR_CRC                                 0x06
#define EOC_ACK                                                 0x80
#define SELF_TEST_ACK                                   0x01
/****************/
/* REASON CODES */
/****************/

#define BUSY                                                    0x01
#define INVALID_PAR                                             0x02
#define NOT_ENABLED                                             0x03
#define NOT_SUPPORTED                                   0x04
#define INSUFF_MARGIN                                   0x01
#define STATE_NOT_DESIRED                               0x03
#define INFEASIBLE_PARAMETER                    0x04

/**************************/
/*  SEGMENT ACK MSG TYPE*/
/**************************/
#define SEGMENT_ACK_TYPE                0x01

/**************************/
/* RECONFIG COMMAND TYPES */
/**************************/
#define BITSWAP_REQ                                             0x01
#define DRR_REQ                                                 0x02
#define SRA_REQ                                                 0x03

#define PLUS_BITSWAP_REQ                0x04
#define PLUS_DRR_REQ                                    0x05
#define PLUS_SRA_REQ                                    0x06

#define DEFER_BITSWAP                                   0x81
#define DRR_REJECT                                              0x82
#define SRA_REJECT                                              0x83

/**********************/
/* TIME COMMAND TYPES */
/**********************/
#define SET_TIME                                                0x01
#define TIME_READ                                               0x02

#define TIME_READ_ACK                                   0x82
#define TIME_ACK                                                0x80

/**************************/
/* INVENTORY COMMAND TYPES*/
/**************************/
#define IDENT_READ                                              0x01
#define AUX_IDENT_READ                                  0x02
#define SELF_TEST_RES_READ                              0x03
#define PMD_CAP_READ                                    0x04
#define PMS_TC_CAP_READ                                 0x05
#define TPS_TC_CAP_READ                                 0x06

#define IDENT_READ_ACK                                  0x81
#define AUX_IDENT_READ_ACK                              0x82
#define SELF_TEST_RES_READ_ACK                  0x83
#define PMD_CAP_READ_ACK                                0x84
#define PMS_TC_CAP_READ_ACK                             0x85
#define TPS_TC_CAP_READ_ACK                             0x86

/****************************************/
/* CONTROL PARAMETER READ COMMAND TYPES */
/****************************************/
#define PMD_CNTRL_PAR_READ                              0x01
#define PMS_TC_PAR_READ                                 0x02
#define TPS_TC_PAR_READ                                 0x03

#define PMD_CNTRL_PAR_READ_ACK                  0x81
#define PMS_TC_PAR_READ_ACK                             0x82
#define TPS_TC_PAR_READ_ACK                             0x83

/*****************************************/
/* MANAGEMENT COUNTER READ COMMAND TYPES */
/*****************************************/
#define MGMT_CNTR_READ                                  0x01

#define MGMT_CNTR_READ_ACK                              0x81

/*****************************************/
/* POWER MANAGEMENT COMMAND TYPES                */
/*****************************************/
#define STATE_TRANS_REQ                                 0x01
#define L2_REQ                                                  0x02
#define L2_TRIM_REQ                                             0x03

#define STATE_TRANS_GRANT                               0x80
#define STATE_TRANS_REJECT                              0x81
#define L2_GRANT                                                0x82
#define L2_REJECT                                               0x83
#define L2_TRIM_GRANT                                   0x84
#define L2_TRIM_REJECT                                  0x85

#define PLUS_L2_GRANT                   0x86

/* PM L3 state machine internal states */
#define WAITING_FOR_L3_REQUEST                          1
#define WAITING_FOR_QUEUE_IN_HDLC_TX_QUEUE      2
#define WAITING_FOR_L3_RESPONSE             3

/* Possible outcomes to CPE-initiated L3 request */
#define PM_L3_GRANT_RECEIVED                            1
#define PM_L3_REJECT_RECEIVED                           2
#define PM_L3_RESPONSE_TIMEOUT                          3
// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (START_End)
#define PM_L3_RESPONSE_DISABLED                         4

/***************************/
/* CLEAR EOC COMMAND TYPES */
/***************************/

#define CLEAR_EOC_MSG                                   0x01
#define CLEAR_EOC_ACK                                   0x80
#define CLEAR_EOC_NACK                                  0x81
#define CLEAR_EOC_NOT_SUPPORT           0x04

/****************************************/
/* NON STANDARD FACILITY COMMAND TYPES  */
/****************************************/
#define NSF                                                             0x01
#define NSF_ACK                                                 0x80
#define NSF_NEG_ACK                                             0x81


/****************************************/
/* TEST PARAMETER READ COMMAND TYPES    */
/****************************************/

#define SINGLE_READ                                             0x01
#define MULT_READ                                               0x02
#define NEXT_MULT_READ                                  0x03
#define PLUS_MULT_READ                  0x04
#define BIS_BLOCK_READ                                  0x04    /* unfortunately, standard doesnt specify unique message types between bis/plus modes */
#define PLUS_BLOCK_READ                                 0x05

#define SINGLE_READ_ACK                                 0x81
#define MULT_READ_ACK                                   0x82
#define PMD_TEST_PAR_READ_NACK                  0x80
#define BLOCK_READ_ACK                                  0x84

/****************************************/
/* TEST PARAMETER READ ID VALUES                */
/****************************************/
#define CHANNEL_TRANSFER_FUNCTION               0x01
#define QUIET_LINE_NOISE_PSD                    0x03
#define SNR                                                             0x04
#define MEASUREMENT_PERIOD                              0x05
#define LINE_ATTENUATION                                0x21
#define SIGNAL_ATTENUATION                              0x22
#define SIGNAL_TO_NOISE_MARGIN                  0x23
#define ATTAIN_NET_DATA_RATE                    0x24
#define NE_ACTUAL_TRANSMIT_POWER                0x25
#define FE_ACTUAL_TRANSMIT_POWER                0x26
// Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting (Start_End)
#define FE_ACTUAL_INP_ACT                           0x27

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
#define RETX_INP_ACT_SHINE                      0x41
#define RETX_INP_ACT_REIN                       0x42
#define RETX_ETR                    0x43
#define RETX_DELAY_ACT                          0x44
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

/****************************************/
/* REGISTER LENGTHS                         */
/****************************************/

#define TIME_REG_LENGTH                                 0x08
#define SELF_TEST_REG_LENGTH                    0x04
/****************************************/

/*********************************/
/* POWER MANAGEMENT STATES               */
/*********************************/

#define L0_STATE                                                0x0
#define L2_STATE                                                0x1
#define L3_STATE                                                0x3

/*********************************/


typedef struct {
    uint8       message_priority;        /*  HDLC message priority */
    uint8       cntrl_field;             /*  HDLC message control field */
    uint16  gus_FCS;                     /*  HDLC message FCS */
} HDLCMsgStruct_t;

typedef struct {
    uint8       uc_self_test_reg[SELF_TEST_REG_LENGTH]; /* Self test result register */
} OvhdRegStruct_t;

// this structure is the definition of Tx HDLC queue item
typedef struct {
    uint8       uc_message_type;
    uint8       uc_message_designator;
    uint8       uc_defer_reason_code;
    uint8   uc_Source;
    uint8   uc_Segmented;
    FlagT   ft_InvertedSyncSymbol_expected;           // TRUE if expecting an inverted Sync Symbol for this priority
    uint8   uc_TestParameterId;
    uint16   us_param_rd_carrier_index;
    uint16   us_param_rd_start_carrier_index;
    uint16   us_param_rd_stop_carrier_index;
} TxOvhdMsgInfoStruct_t;

// this structure is used to pass message info to TxHdlcSendRequest()
// Currently, it looks the same as TxOvhdMsgInfoStruct_t, but it might be diff later.
typedef struct {
    uint8       uc_message_type;
    uint8       uc_message_designator;
    uint8       uc_defer_reason_code;
    uint8   uc_Source;
    uint8   uc_Segmented;
    FlagT   ft_InvertedSyncSymbol_expected;            // TRUE if expecting an inverted Sync Symbol for this priority
    uint8   uc_TestParameterId;
    uint16   us_param_rd_carrier_index;
    uint16   us_param_rd_start_carrier_index;
    uint16   us_param_rd_stop_carrier_index;
} TxOvhdMsgInfoRequest_t;

// this structure is used as a general indication of when to send a new message in the queue during the special case
// of waiting for Inverted Sync Symbol for a response(L2 grant) and waiting for Segmented ACK for a segmented message.
typedef struct {
    FlagT   ft_InvertedSyncSymbol_expected;           // TRUE if expecting an inverted Sync Symbol for this priority
    FlagT   ft_SegmentedMsgProgress;
}HDLCInfo_t;

extern HDLCInfo_t gt_HDLCInfo;
extern TxOvhdMsgInfoRequest_t gt_OlrPm_TxOvhdMsgInfoInput;      // this one is used to pass message
// info between OLR decision/PM to TC task

// these are valid values for uc_Source of TxOvhdMsgInfoStruct_t and TxOvhdMsgInfoRequest_t.
#define RESPONSE_SOURCE          0
#define AUTO_CMD_SOURCE          1
#define ME_CMD_SOURCE            2
#define MAX_SOURCE_TYPE          3

// queue size:
// o for response, 1;
// o for commands, 2 for autonomous, 1 for ME.
// o the allocated size per source could be different for diff priorities.
//   e.g., priority 0 will not available for ME_CMD_SOURCE.

#define MAX_HDLC_AUTO_CMD        2
#define MAX_HDLC_ME_CMD          1
#define MAX_HDLC_RESPONSE        1
#define HDLC_QUEUE_LENGTH        (MAX_HDLC_AUTO_CMD + MAX_HDLC_ME_CMD + MAX_HDLC_RESPONSE)

// return values from TxHdlcSendRequest()
#define HDLC_QUEUE_ADDED         1
#define HDLC_QUEUE_FULL          2
#define HDLC_QUEUE_BUSY          3
#define HDLC_QUEUE_BUSY_SEGMENT  4

typedef struct {
    uint8 uc_ReadIndex;                                                         // points to to-be-sent message
    uint8 uc_WriteIndex;                                                        // points to next available queue item.
    uint8 uc_Semaphore;                                                         // to prevent FG/BG queue access conflicts
    FlagT ft_ack_expected;                                                      // TRUE if expecting a response for this priority
    uint8 uc_ExpectedDesignator;
    uint8 uc_ExpectedMsgType;
    uint8 uc_ExpectedTestParamId;
    uint8 uc_Source;                                // source type
    uint16 us_ovhd_timer;
    uint8 uca_MaxMsgTypeCount[MAX_SOURCE_TYPE];         // Max messages per source for this priority
    uint8 uca_MsgTypeCount[MAX_SOURCE_TYPE];            // keep track of submitted messages per source

    uint16 s_TimedOutMsgCount;
    uint16 s_TotalCmdSent;
    uint16 s_TotalRespRecv;
    uint16 s_TotalCmdRecv;
    uint16 s_TotalRespSent;

} TxHdlcControl_t;

extern TxHdlcControl_t gta_TxHdlcControlInfo[MAX_OVHD_PRIORITY];     // per priority

typedef struct {
    uint8       uc_ncd_anom[NUM_DS_BEARER_CHANNELS_SUPPORTED];            /* No cell delineation anomaly */
    uint8       uc_ocd_anom[NUM_DS_BEARER_CHANNELS_SUPPORTED];            /* Out of cell delineation anomaly */
    int16       s_cd_flag[NUM_DS_BEARER_CHANNELS_SUPPORTED];                      /* Cell delineation flag */
    int16       s_ocd_cnt[NUM_DS_BEARER_CHANNELS_SUPPORTED];                      /* Count of consecutice OCD anomalies */
    uint8       uc_lcd_def[NUM_DS_BEARER_CHANNELS_SUPPORTED];             /* LCD defect flag */
    uint8   uc_los_def;                                                           /* LOS Defect flag */
    uint8   uc_sef_def;                                                           /* SEF Defect flag */
    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start_End)
    uint8   uc_lom_def;                                                           /* LOM Defect flag */

} TxIb_AnamolyStruct_t;

extern uint32 gula_NE_ocd_cnt;                                  // total near end ocd anomaly count
extern uint32 gula_NE_lcd_cnt;                                  // total near end lcd defect count
extern uint32 gula_NE_ncd_cnt;                                  // total near end ncd anomaly count
extern uint32 gula_FE_ocd_cnt;                                  // total far end ocd anomaly count
extern uint32 gula_FE_lcd_cnt;                                  // total far end lcd defect count
extern uint32 gula_FE_ncd_cnt;                                  // total far end ncd anomaly count

typedef struct {
    uint8       uc_ntr;                                                           /* DS NTR octet */
    uint32      ul_ffec_cnt[NUM_DATA_PATHS];              /* Far end FEC error count */
    uint32      ul_fcrc_cnt[NUM_DATA_PATHS];              /* Far end CRC error count */
    uint32  ul_ffec_err_sec;                                      /* Far end FEC errored seconds count */
    uint32      ul_ferr_sec;                                              /* Far end errored seconds count */
    uint32      ul_fsev_err_sec;                                          /* Far end severely errored seconds count */
    uint32  ul_flos_err_sec;                                      /* Far end LOS errored seconds count */
    uint32      ul_funavail_err_sec;                              /* Far end unavailable errored seconds count */
    uint8   uc_flos_def;                                                  /* Far end LOS Defect flag */
    uint8   uc_fsef_def;                                                  /* Far end SEF Defect flag */
    uint8       uc_flpr_def;                                              /* Far end Lpr flag */
    uint8       uc_fncd_anom[NUM_DS_BEARER_CHANNELS_SUPPORTED];           /* No cell delineation anomaly */
    uint8       uc_focd_anom[NUM_DS_BEARER_CHANNELS_SUPPORTED];           /* Out of cell delineation anomaly */
    int16       s_fcd_flag[NUM_DS_BEARER_CHANNELS_SUPPORTED];                     /* Cell delineation flag */
    int16       s_focd_cnt[NUM_DS_BEARER_CHANNELS_SUPPORTED];                     /* Count of consecutice OCD anomalies */
    uint8       uc_flcd_def[NUM_US_BEARER_CHANNELS_SUPPORTED];            /* Far end LCD defect */
    uint32      ul_fhec_err_cnt[NUM_US_BEARER_CHANNELS_SUPPORTED];        /* Far end HEC error count */
    uint32      ul_ftot_hec_cell_cnt[NUM_US_BEARER_CHANNELS_SUPPORTED]; /* Far end total hec cell count */
    uint32      ul_ftot_cell_cnt[NUM_US_BEARER_CHANNELS_SUPPORTED];       /* Far end total cell count */
    uint32  ul_fber_idle_cell_cnt[NUM_US_BEARER_CHANNELS_SUPPORTED]; /* Far end total bits errors in ATM Idle cells payload*/
} RxIb_AnamolyStruct_t;
#endif
