/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _RT_STATE_BIS_H
#define _RT_STATE_BIS_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1432 USA
 * TELEPHONE:        (781) 276-4000
 * FAX:              (781) 276-4001
 * WEB:              http://www.aware.com
 *
 * FILE:             rt_state_bis.h
 * DESCRIPTION:      Constants for the G.dmt.bis state machine.
 *
// 14/03/2012 Kannan: 08/04/2009 Bhadra: Added code for uinversal ReTx C-Msg1 related changes
//                   Added variables required for DFE<->PPE and cntrs.
//                     Grep for SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
//
//
// 14/03/2012 Kannan: 08/04/2009 Bhadra: Added code for uinversal ReTx R-Msg1 related changes
//                     Grep for SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod to see changes.
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
 **********************************************************************/

/* First G.dmt.bis entry in DoState[] */
#define BIS_STATES_START         (300)


/*******************************************************************/
/* Definition of G.dmt.bis states                                  */
/*******************************************************************/

/* =============================================================== */
/* G.dmt.bis TX states                                             */
/* =============================================================== */

/* CPE TX Channel Discovery States */

#define R_QUIET1_TX_BIS          (BIS_STATES_START +   0)
#define R_COMB1_TX_BIS           (BIS_STATES_START +   1)
#define R_QUIET2_TX_BIS          (BIS_STATES_START +   2)
#define R_COMB2_TX_BIS           (BIS_STATES_START +   3)
#define R_ICOMB1_TX_BIS          (BIS_STATES_START +   4)
#define R_LINEPROBE_TX_BIS       (BIS_STATES_START +   5)
#define R_QUIET3_TX_BIS          (BIS_STATES_START +   6)
#define R_COMB3_TX_BIS           (BIS_STATES_START +   7)
#define R_ICOMB2_TX_BIS          (BIS_STATES_START +   8)
#define R_MSG_FMT_TX_BIS         (BIS_STATES_START +   9)
#define R_MSG_PCB_TX_BIS         (BIS_STATES_START +  10)

/* CPE TX Transceiver Training States */

#define R_REVERB1_TX_BIS         (BIS_STATES_START +  11)
#define R_QUIET4_TX_BIS          (BIS_STATES_START +  12)
#define R_REVERB2_TX_BIS         (BIS_STATES_START +  13)
#define R_QUIET5_TX_BIS          (BIS_STATES_START +  14)
#define R_REVERB3_TX_BIS         (BIS_STATES_START +  15)
#define R_ECT_TX_BIS          (BIS_STATES_START +  16)
#define R_REVERB4_TX_BIS         (BIS_STATES_START +  17)
#define R_SEGUE1_TX_BIS          (BIS_STATES_START +  18)

/* CPE TX Channel Analysis States */

#define R_REVERB5_TX_BIS         (BIS_STATES_START +  19)
#define R_SEGUE2_TX_BIS          (BIS_STATES_START +  20)
#define R_MSG1_TX_BIS            (BIS_STATES_START +  21)
#define R_MEDLEY_TX_BIS          (BIS_STATES_START +  22)
#define R_EXCHMARKER_TX_BIS         (BIS_STATES_START +  23)

/* CPE TX Exchange States */

#define R_MSG2_TX_BIS            (BIS_STATES_START +  24)
#define R_REVERB6_TX_BIS         (BIS_STATES_START +  25)
#define R_SEGUE3_TX_BIS          (BIS_STATES_START +  26)
#define R_PARAMS_TX_BIS          (BIS_STATES_START +  27)
#define R_REVERB7_TX_BIS         (BIS_STATES_START +  28)
#define R_SEGUE4_TX_BIS          (BIS_STATES_START +  29)

/* States for diagnostics mode only */
#define R_SEGUE_LD_TX_BIS           (BIS_STATES_START +  70)
#define R_MSG_LD_TX_BIS             (BIS_STATES_START +  71)
#define R_QUIET1_LD_TX_BIS          (BIS_STATES_START +  72)
#define R_QUIET2_LD_TX_BIS          (BIS_STATES_START +  73)
#define R_ACK_NACK_LD_TX_BIS        (BIS_STATES_START +  74)
#define R_QUIET3_LD_TX_BIS          (BIS_STATES_START +  75)
#define R_QUIET_L3_TX_BIS           (BIS_STATES_START +  76)

/* States for short initialization only */
#define R_QUIET2_SI_TX_BIS          (BIS_STATES_START +  78)
/* =============================================================== */
/* G.dmt.bis RX states                                             */
/* =============================================================== */

/* CPE RX Channel Discovery States */

#define R_C_QUIET1_RX_BIS        (BIS_STATES_START +  30)
#define R_C_COMB1_RX_BIS         (BIS_STATES_START +  31)
#define R_C_QUIET2_RX_BIS        (BIS_STATES_START +  32)
#define R_C_COMB2_RX_BIS         (BIS_STATES_START +  33)
#define R_C_ICOMB1_RX_BIS        (BIS_STATES_START +  34)
#define R_C_LINEPROBE_RX_BIS     (BIS_STATES_START +  35)
#define R_C_QUIET3_RX_BIS        (BIS_STATES_START +  36)
#define R_C_COMB3_RX_BIS         (BIS_STATES_START +  37)
#define R_C_ICOMB2_RX_BIS        (BIS_STATES_START +  38)
#define R_C_MSG_FMT_RX_BIS       (BIS_STATES_START +  39)
#define R_C_MSG_PCB_RX_BIS       (BIS_STATES_START +  40)
#define R_C_QUIET4_RX_BIS        (BIS_STATES_START +  41)

/* CPE RX Transceiver Training States */

#define R_C_REVERB1_RX_BIS       (BIS_STATES_START +  42)
#define R_C_TREF_1_RX_BIS        (BIS_STATES_START +  43)
#define R_C_REVERB2_RX_BIS       (BIS_STATES_START +  44)
#define R_C_ECT_RX_BIS           (BIS_STATES_START +  45)
#define R_C_REVERB3_RX_BIS       (BIS_STATES_START +  46)
#define R_C_TREF2_RX_BIS         (BIS_STATES_START +  47)
#define R_C_QUIET5_RX_BIS        (BIS_STATES_START +  48)
#define R_C_REVERB4_RX_BIS       (BIS_STATES_START +  49)
#define R_C_SEGUE1_RX_BIS        (BIS_STATES_START +  50)

/* CPE RX Channel Analysis States */

#define R_C_MSG1_RX_BIS          (BIS_STATES_START +  51)
#define R_C_REVERB5_RX_BIS       (BIS_STATES_START +  52)
#define R_C_SEGUE2_RX_BIS        (BIS_STATES_START +  53)
#define R_C_MEDLEY_RX_BIS        (BIS_STATES_START +  54)
#define R_C_EXCHMARKER_RX_BIS    (BIS_STATES_START +  55)

/* CPE RX Exchange States */

#define R_C_MSG2_RX_BIS          (BIS_STATES_START +  56)
#define R_C_REVERB6_RX_BIS       (BIS_STATES_START +  57)
#define R_C_SEGUE3_RX_BIS        (BIS_STATES_START +  58)
#define R_C_PARAMS_RX_BIS        (BIS_STATES_START +  59)
#define R_C_REVERB7_RX_BIS       (BIS_STATES_START +  60)
#define R_C_SEGUE4_RX_BIS        (BIS_STATES_START +  61)

/* States for diagnostics mode only */
#define R_C_TREF1_LD_RX_BIS         (BIS_STATES_START +  80)
#define R_C_TREF2_LD_RX_BIS         (BIS_STATES_START +  81)
#define R_C_SEGUE_LD_RX_BIS         (BIS_STATES_START +  82)
#define R_C_MSG_LD_RX_BIS           (BIS_STATES_START +  83)
#define R_C_TREF3_LD_RX_BIS         (BIS_STATES_START +  84)
#define R_C_QUIET_L3_RX_BIS         (BIS_STATES_START +  85)

/* =============================================================== */
/* G.dmt.bis TX state lengths                                      */
/* =============================================================== */

/* CPE State Lengths for short initialization */
#define LEN_RT1                              (5*(128+256))

/* CPE TX Channel Discovery State Lengths */

#define R_QUIET1_MAX_TX_LEN_BIS                 (4396)
#define R_QUIET1_MAX_TX_LEN_BIS_DIAG            (8708)

#define R_COMB1_TX_LEN_BIS                   (128)
#define R_QUIET2_NORMAL_MAX_TX_LEN_BIS          (714 + R_C_COMB2_NORMAL_RX_LEN_BIS)
#define R_QUIET2_TX_LEN_BIS_DIAG             (4522)

#define R_QUIET2_FAST_RECOVERY_MAX_TX_LEN_BIS      (714 + R_C_COMB2_FAST_RECOVERY_RX_LEN_BIS)
#define R_COMB2_TX_LEN_BIS                   (256)
#define R_ICOMB1_TX_LEN_BIS                     (10)
#define R_LINEPROBE_TX_LEN_BIS                  (512)


#define R_COMB3_TX_LEN_BIS                   (64)
#define R_ICOMB2_TX_LEN_BIS                     (10)
#define R_MSG_FMT_TX_LEN_BIS                 (96)
#define R_MSG_FMT_TX_LEN_BIS_DIAG               (256)

#define R_MSG_PCB_NO_BLACKOUT_BITS_TX_LEN_BIS      (144)
#define R_MSG_PCB_WITH_BLACKOUT_BITS_TX_LEN_BIS    (912)

/* CPE TX Transceiver Training State Lengths */

#define R_REVERB1_TX_LEN1_BIS                (272)
#define R_REVERB1_TX_LEN2_BIS                (592)
#define R_QUIET4_TX_LEN_BIS_DIAG             (15872)

#define R_REVERB2_MAX_TX_LEN_BIS             (15888)
#define R_REVERB2_MAX_TX_LEN_BIS_SI             (1088)
#define R_REVERB2_TX_LEN_BIS_DIAG               (15856)

#define R_QUIET5_MAX_TX_LEN_BIS                 (16384)
#define R_QUIET5_TX_LEN_BIS_SI                  (1024)
#define R_QUIET5_TX_LEN_BIS_DIAG             (16464)

#define R_REVERB3_TX_LEN_BIS                 (64)
#define R_ECT_TX_LEN_BIS                     (512)
#define R_SEGUE_TX_LEN_BIS                   (10)
#define  R_REVERB5_MAX_TX_LEN_BIS                  (196+224)   /* 224 = LEN_C_MSG1 */
#define  R_REVERB5_TX_LEN_BIS_DIAG                 (1564)

#define  R_EXCHMARKER_TX_LEN_BIS                (64)
#define  R_REVERB6_TX_BIS_MIN_LEN               (80)
#define  R_REVERB6_TX_BIS_TIMEOUT               (2000)
#define MIN_R_REVERB5_TX_BIS_CONT_LEN           (0)
#define  R_REVERB7_TX_BIS_TIMEOUT               (2048)

#define R_C_TREF2_WT_LEN_BIS                 (16+64)
#define R_MSGS1_TX_LEN_BIS                   ((4+4+2)*8) /* prefix + msg + crc */
#define R_MEDLEY_TX_LEN_BIS                     (512)


#define R_SEGUE_LD_TX_LEN_BIS                (64)
#define  R_MSG1_LD_TX_LEN_BIS                            (1152)
#define  R_MSGx_LD_TX_LEN_BIS                            (16640)  /*  (258+2)*8*8  */
#define  R_CRC_LEN_LD                                    (128)  /*  2*8*8       */
#define R_QUIET1_LD_TX_LEN_BIS                     (256)
#define R_ACK_MESSAGE_LD                           (0x55)
#define R_ACK_NACK_LD_TX_LEN_BIS                (64)
#define R_QUIET3_LD_TX_LEN_BIS                     (256)

/* =============================================================== */
/* G.dmt.bis RX state lengths                                      */
/* =============================================================== */

/* CPE RX Channel Discovery State Lengths */

#define R_C_QUIET1_MIN_RX_LEN_BIS               (512)
#define R_C_QUIET1_MAX_RX_LEN_BIS               (4204)

#define R_C_QUIET1_MIN_RX_LEN_BIS_DIAG          (6360)
#define R_C_QUIET1_MAX_RX_LEN_BIS_DIAG          (8516)

#define R_C_COMB1_RX_LEN_BIS                 (128)
#define R_C_QUIET2_RX_LEN_BIS                (256)
#define R_C_COMB2_SHORT_RX_LEN_BIS              (1024)
#define R_C_COMB2_NORMAL_RX_LEN_BIS             (3872)
#define R_C_COMB2_FAST_RECOVERY_RX_LEN_BIS         (1024)
#define R_C_ICOMB1_RX_LEN_BIS                (10)
#define R_C_LINEPROBE_RX_LEN_BIS             (512)
#define R_C_QUIET3_MAX_RX_LEN_BIS               (906)
#define R_C_COMB3_RX_LEN_BIS                 (64)
#define R_C_ICOMB2_RX_LEN_BIS                (10)
#define R_C_MSG_FMT_RX_LEN_BIS                  (96)
#define R_C_MSG_FMT_RX_LEN_BIS_DIAG             (256)

#define R_C_MSG_PCB_RX_LEN1_BIS                 (96)   /* without blackout bits  */
#define R_C_MSG_PCB_RX_LEN2_BIS                 (192)  /* with blackout bits     */

#define R_C_QUIET4_MAX_RX_LEN_BIS               (1242)

/* CPE RX Transceiver Training State Lengths */

#define R_C_REVERB1_RX_LEN_BIS_DIAG             (16384)
#define R_C_TREF1_RX_LEN_BIS_DIAG               (15872)
#define R_C_REVERB2_RX_LEN_BIS                  (64)
#define R_C_ECT_RX_LEN_BIS                   (512)
#define R_C_REVERB3_MAX_RX_LEN_BIS              (15936)
#define R_C_REVERB3_RX_LEN_BIS_DIAG             (15872)

#define R_C_TREF2_RX_LEN_BIS                 (576)
#define R_C_EXCHMARKER_RX_LEN_BIS               (64)

/* For bis diagnostics mode only */
#define C_ACK_MESSAGE_LD                     (0x55)
#define R_C_CRC_LEN_LD                       (128)  /* 2*8*8  */
#define R_C_TREF2_LD_RX_LEN_BIS                       (256)
#define R_C_SEGUE_LD_RX_LEN_BIS                       (64)
#define R_C_TREF3_LD_RX_LEN_BIS                       (256)


/*******************************************************************/
/* End of definition of G.dmt.bis states                           */
/*******************************************************************/

/* ============================= */
/*    Constants for RX states    */
/* ============================= */

#define BIS_TIME_OUT_LENGTH                     (1000)

#define NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2          (6)
#define NUM_COMB_SUBCARRIERS_INSPECTED_ADSL2PLUS         (22)
#define NUM_COMB_SUBCARRIERS_REQUIRED           (3)


// Number of consecutive C-QUIET, C-COMB, C-ICOMB or C-REVERB symbols to be detected
// before making a transition
#define R_C_TRANSITION_CNT_BIS                  (3)
#define R_C_COMB_QUIET_TRANSITIONS_CNT_BIS            (5)

// Constants used in R_C_COMB2_RX_BIS state
#define R_C_COMB2_AC_LEN_BIS                 (64)
#define LOG2_R_C_COMB2_AC_LEN_BIS               (6)

// Number of C-ICOMB symbols that have be received in order to declare that CO
// wants to do lineprobe.
#define R_C_ICOMB1_THRESHOLD                 (5)

#define R_C_QUIET4_AC_LEN_BIS                (64)
#define LOG2_R_C_QUIET4_AC_LEN_BIS              (6)
#define R_C_REVERB_SCALE_BIS                 (5)  /* 7 dB */
#define RX_FIRST_PWR_CHN_BIS                 (33)
#define RX_LAST_PWR_CHN_BIS                     (96)

#define R_C_REVERB1_WT_LEN_BIS                  (16)

#define R_C_TREF1_WT_LEN_BIS                 (16)

#ifdef RUN_ASIM
// Reduce time length of reverb3 state by 7500 frames for simulation

#define R_C_REVERB3_BIS_ACCUM_LEN_CHANEST       (256)
#define LOG2_R_C_REVERB3_BIS_ACCUM_LEN_CHANEST     (8)
#define R_C_REVERB3_BIS_ACCUM_LEN_HLIN          (256)
#define LOG2_R_C_REVERB3_BIS_ACCUM_LEN_HLIN        (8)

#else
// In RC-Reverb3, two separate accumulations are performed. The first is used
// to calculate the actual channel impulse response for frame
// alignment and TDQ.  The second uses a reference AFE setting and is used to
// calculate the calibrated HLin (and therefore HLog, LATN, etc.)
#define R_C_REVERB3_BIS_ACCUM_LEN_CHANEST       (4096)
#define LOG2_R_C_REVERB3_BIS_ACCUM_LEN_CHANEST     (12)
#define R_C_REVERB3_BIS_ACCUM_LEN_HLIN          (512)
#define LOG2_R_C_REVERB3_BIS_ACCUM_LEN_HLIN        (9)
#endif

#define R_C_MSG1_PRFX_LEN_BIS                (4*8)
#define DS_WINDOWING_BYTES                   (RX_NUM_TONES >> 5)
#define R_C_MSG1_NUM_BYTES_BIS                  (24 + DS_WINDOWING_BYTES)
#define R_C_MSG1_NUM_BITS_BIS                (R_C_MSG1_NUM_BYTES_BIS*8)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod Start
#ifdef UNV_RETX_MSGS
#define R_C_MSG1_UNIV_RETX_TPS_TC_NUM_BYTES        (11)  // 0 if Universal ReTx is disabled
#define R_C_MSG1_UNIV_RETX_PMS_TC_NUM_BYTES        (3)   // 4 if Universal ReTx is disabled.
#define R_C_MSG1_UNIV_RETX_PMS_TPS_TC_EXTRA_BYTES  (11+3-4) //Considering 4 bytes of PMS-TC added
                                                            // in normal cases.
//XDSLRTFW-2457 (Start_End)
#define R_C_MSG1_RETX_NUM_BYTES_BIS          (36 + DS_WINDOWING_BYTES) //Increase to 36 to support ReTx TPS-TC and PMS-TC octets
//FEATURE_DS_BisPlus_ALL_ReTxCMSG1_New Start
#define R_C_MSG1_UNIV_RETX_TPS_CI_LEFTR_BYTES      (2)
// FEATURE_DS_BisPlus_ALL_ReTxCMSG1_New End
#endif
//SMS01436310 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
#define R_C_MSG2_NUM_BYTES_BIS                  (TX_NUM_TONES>>3)
#define R_C_CRC1_LEN_BIS                     (2*8)
#define  R_C_REVERB5_MAX_RX_LEN_BIS             (218+96)
#define  R_C_REVERB5_RX_LEN_BIS_DIAG               (1574)
#define  MEDLEY_LEN_BIS_DIAG                    (32256)  /* US and DS have the same length */
#define  R_C_REVERB7_RX_MAX_LEN_BIS             (2048+10)               /* During this state, we need to detect 10 C-SEGUE4 frames. */

#define  NSC_C_PARAMS                                (4)

/* ============================= */
/*    Constants for TX states    */
/* ============================= */

#define R_MSG1_PRFX_LEN_BIS                        (4*8)
#define R_MSG1_NUM_BYTES_BIS                    (4)
#define R_MSG1_NUM_BITS_BIS                        (R_MSG1_NUM_BYTES_BIS*8)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
//SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod Begin
#ifdef UNV_RETX_MSGS
#define R_MSG1_RETX_NUM_BYTES_BIS               (5)
#define R_MSG1_RETX_NUM_BITS_BIS                (R_MSG1_RETX_NUM_BYTES_BIS*8)
#endif
//SMS01436414 :FEATURE_ALL_BisPlus_ALL_Univ_Retx_MSGS_mod End
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
#define R_MSG2_NUM_BYTES_PLUS                   (64)
#define R_MSG2_NUM_BYTES_BIS                    (32)

#define R_MSG2_NUM_BITS_BIS                        (R_MSG2_NUM_BYTES_BIS*8)
#define R_CRC_TX_BIS_LEN                        (R_MSGS1_TX_LEN_BIS - R_MSG1_PRFX_LEN_BIS - R_MSG1_NUM_BITS_BIS)

#endif      /* _RT_STATE_BIS_H */
