/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _RX_OVRHD_H
#define _RX_OVRHD_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             rx_ovrhd_bis.h
 * DESCRIPTION:      Header file containing functions for producing the
 *                   synchronization byte for the transmitter.
 *
 **********************************************************************/

#include "typedef.h"

#define R_PILOT_TONE    16


#define MONITOR                         (0)
#define ADD_TO_FIFO                     (1)

/* This functiopn is just for debug  */
/* extern int16 GetReservedByte(void); */

extern BkgdFunction RxHDLCProcessor;
extern void GetHDLCByte(MessageOvhdFifo_t *Fifo);

extern void Rx_ovhd_msg_handler(void);
extern void Rx_prior0_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void Rx_prior1_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void Rx_prior2_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);

extern void Abandon_DS_OLRPM(void);
extern void RxIbProcessor_bis(void);
extern void Perform_Self_test(void);

extern void rx_reconfig_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void rx_eoc_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void rx_time_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void rx_inventory_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void rx_cntrl_par_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void rx_mgmt_par_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void rx_power_mgmt_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void rx_clear_eoc_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void rx_nsf_facility_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);
extern void rx_test_param_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput);

extern FlagT ExtractBinsInfo(uint8 * puca_msg_buffer, int16 s_Nf, FlagT ft_isPlus, int16* sa_deltaLp, int16* ps_retCode, uint8* uca_TxBat, int16* sa_TxFineGains);
extern void Rx_OLR_Decision(void);
extern FlagT CalcNewBATGains(int16 s_Lp_delta, int16 s_DesiredMargin, int16 *ps_RetCode);
//XDSLRTFW-1727
uint8 ChangeL2BitGains(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 s_DesiredDeltaSumLp,
                                    int16 *psa_SNRBuffer, int16 s_MinToneMargin,
                                    RxToneFlags p_ActiveTones, RxToneFlags p_ModifiedTones,
                                    int16 *ps_ActualDeltaSumLp, FlagT ft_StopAtMarginThreshold,
                                    FlagT ft_NotforceEven1Bit, FlagT ft_AddfineGainplusdeltaLp);


int16 GetL2Lp(uint8 *puca_buffer, int32 idx,int16 *ps_LpMaxCpy,int16 *ps_LpMinCpy, int16 *ps_sum_deltaLp);

extern void ProcessRSErrorCnt_BIS(int16 s_LatencyPath, uint16 us_fec_count, uint16 us_dec_stat);
extern void ProcessFramingBytes(void);

#endif /* _RX_OVRHD_H */

