/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _SHOW_INIT_OLR_H
#define _SHOW_INIT_OLR_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             showinit_olr.h
 * DESCRIPTION:      Header file for functions that implement
 *                   OLR and PM
 *
 **********************************************************************/

#include "typedef.h"

/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
void OLR_TxInit(void);
void OLRPM_RxInit(int16);
BkgdFunction OLR_BgBackupTxConfig;
BkgdFunction OLR_BgBackupRxConfig;
BkgdFunction PM_BgRxL0ToL2Config;
BkgdFunction OLRPM_BgRestoreRxL0Config;

void OLRPM_RxPreProcessing(void);
void OLRPM_RxPostProcessing(uint8 uc_OLRPM);
void Calc_CRCIncrement(void);

void do_l2_processing(void);
void compute_fftscaleback_fdqcoef(int16 s_FFTGaindB, int16 s_FdqGain,
                        int16 *ps_scaleback, int16 *ps_fdqMultiplier,
                        int16 *psa_fdq_coef, int8 *puca_fdq_exp,
                        int16 s_firsttone, int16 s_numtones, FlagT ft_loadScaleback);
void compute_fftscaleback(int16 s_FFTGaindB, int16 s_FdqGain,
                        int16 *ps_scaleback, int16 *ps_fdqMultiplier,
                        int16 *psa_fdq_coef, int8 *puca_fdq_exp,
                        int16 s_firsttone, int16 s_numtones, FlagT ft_loadScaleback);
void compute_fdqcoef(int16 s_FFTGaindB, int16 s_FdqGain,
                        int16 *ps_scaleback, int16 *ps_fdqMultiplier,
                        int16 *psa_fdq_coef, int8 *puca_fdq_exp,
                        int16 s_firsttone, int16 s_numtones, FlagT ft_loadScaleback);
#endif /* _SHOW_INIT_OLR_H */
