/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _SPECTRAL_SHAPE_BIS_H
#define _SPECTRAL_SHAPE_BIS_H
/*^^^
 *----------------------------------------------------------------------------------
 *
 *  Aware DMT Technology. Proprietary and Confidential.
 *
 *  40 Middlesex Turnpike, Bedford, MA 01730-1413
 *  Phone (781) 276 - 4000
 * Fax   (781) 276 - 4001
 *
 *  Name: spectral_shape_bis.h
 *
 * Description: This a header file to be included for applying Tssi
 *
 *----------------------------------------------------------------------------------
 *^^^
 */
// ******************************************************************
// spectral_shape_bis.h
//
// History
//
// 19/08/2010 AdeelJ/Palaksh/Bhadra: Fix for ADSL2+ low US rates against Intracom CNXT DSLAM.
//               Defined new TSSi US set with flat spectrum starting at tone 2 and
//               higher power in image band for US.
//               This TSSi set will be used in profiles with high target margin.
//               Grep for SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement
//
// 15/04/2014 ChiWen/Hanyu: Fine tuned US performance against CNXT DSLAMs based on ADSLRTFW-1480 and ADSLRTFW-1591 with the following changes
//  (1) Added special flat US TSSI;
//  (2) Set tone 32 to zero(gusa_US_Tssi_Value[32] = 0);
//  (3) Enabled special flat US TSSI in C-REVERB1/R-REVERB1 (might have influence over the final PGA training);
//  (4) Enabled special flat US TSSI in C-REVERB2;
//  (5) Renamed gft_USPerf_Midloop_Gspn to gft_USPerf_Gspn for all CNXT CO's;
//  (6) Above changes are applied to all CNXT CO/DSLAMs regardless of CO FW versions and controlled by CMV bit4 (MASK 0x0010) of info 103 27
//      that is ENABLED (bit4=1) by default. This is especially recommended at CenturyLink/USA. So far no side effect has been observed.
//  Grep for XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement
//
//  07/02/18: Stefan: XDSLRTFW-2417: INFINEON not used anymore in VR9 ADSL code
//            Re-enable required code under #ifdef INFINEON
//            - KPN specific ADSL Annex-B (oISDN) Tx-spectrum
//            - Nlp = 1
//            grep for: XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
// *****************************************************************************
#include "const_bis.h"
#include "ghs.h"

/* =====================================================*/
/* These hold US tssi info to be encoded in the CLR      */
/* message based on preferred mode                 */
/* =====================================================*/
/* G992.3 A/L */
extern int16 gsa_US_NOMPSD_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMPSD_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMATP_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED];
extern uint8 guca_US_TssiIndex_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT gfta_US_SprtSet_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3];
extern uint8 guca_US_TssiValue_G9923A[NUM_G992_3A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];

/* G992.3 B */
extern int16 gsa_US_NOMPSD_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMPSD_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMATP_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED];
extern uint8 guca_US_TssiIndex_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT gfta_US_SprtSet_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3];
extern uint8 guca_US_TssiValue_G9923B[NUM_G992_3B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];

/* G992.3/5 M */
extern int16 gsa_US_NOMPSD_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMPSD_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMATP_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED];
extern uint8 guca_US_TssiIndex_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern uint8 guca_US_TssiValue_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT  gfta_US_SprtSet_AnnexM[NUM_ANNEX_M_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3];

/* G992.5 A */
extern int16 gsa_US_NOMPSD_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMPSD_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMATP_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED];
extern uint8 guca_US_TssiIndex_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT gfta_US_SprtSet_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3];
extern uint8 guca_US_TssiValue_G9925A[NUM_G992_5A_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];

/* G992.5 B */
extern int16 gsa_US_NOMPSD_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMPSD_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMATP_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED];
extern uint8 guca_US_TssiIndex_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT gfta_US_SprtSet_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3];
extern uint8 guca_US_TssiValue_G9925B[NUM_G992_5B_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];

/* G992.3/5 I */
extern int16 gsa_US_NOMPSD_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMPSD_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMATP_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED];
extern uint8 guca_US_TssiIndex_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern uint8 guca_US_TssiValue_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT  gfta_US_SprtSet_AnnexI[NUM_ANNEX_I_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3];

// XDSLRTFW-2417 #define INFINEON not used anymore in VR9 ADSL code
/* G992.3/5 J */
extern int16 gsa_US_NOMPSD_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMPSD_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED];
extern int16 gsa_US_MAXNOMATP_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED];
extern uint8 guca_US_TssiIndex_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern uint8 guca_US_TssiValue_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT  gfta_US_SprtSet_AnnexJ[NUM_ANNEX_J_PSDMASK_SUPPORTED][NUM_US_TSSI_VALUES_INITIAL_CLR>>3];
extern uint8 guca_US_TssiIndex_G9923B_KPN[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern uint8 guca_US_TssiValue_G9923B_KPN[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT  gfta_US_SprtSet_G9923B_KPN[NUM_US_TSSI_VALUES_INITIAL_CLR>>3];

// XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (START)
// Special tssi defined to not exceed US power limit when boosting US power for XDSLRTFW-772
extern uint8 guca_US_TssiIndex_G9925B_XDSLRTFW1842[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern uint8 guca_US_TssiValue_G9925B_XDSLRTFW1842[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT  gfta_US_SprtSet_G9925B_XDSLRTFW1842[NUM_US_TSSI_VALUES_INITIAL_CLR>>3];
// XDSLRTFW-1867_ADSL2P_AnxB_DONT_Exceed_13.3dBm_Us_Power (END)

// Special US tssi for GSPN Annex L
extern uint8 guca_US_TssiIndex_G9923L_M1_GSPN[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern uint8 guca_US_TssiIndex_G9923L_M2_GSPN[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern uint8 guca_US_TssiValue_G9923L_GSPN[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT  gfta_US_SprtSet_G9923L_GSPN[NUM_US_TSSI_VALUES_INITIAL_CLR>>3];

//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (START)
// Special US tssi for GSPN Plus
extern uint8 guca_US_TssiIndex_G9925A_GSI_Intracom[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern uint8 guca_US_TssiValue_G9925A_GSI_Intracom[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern FlagT gfta_US_SprtSet_G9925A_GSI_Intracom[NUM_US_TSSI_VALUES_INITIAL_CLR >> 3];
//SMS00910375 IOP_US_BISPlus_CNXT_USRateImprovement (END)

//XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (START)
extern uint8 guca_US_TssiIndex_G9925A_GSI_E67[NUM_US_TSSI_VALUES_INITIAL_CLR];
extern uint8 guca_US_TssiValue_G9925A_GSI_E67[NUM_US_TSSI_VALUES_INITIAL_CLR];
//XDSLRTFW-1584 XDSLRTFW-1585 IOP_US_BISPlus_CNXT_USRateImprovement (END)

/* =====================================================*/
/* These hold DS tssi info decoded from the CL message   */
/* =====================================================*/
/* G992.3 */
extern uint16 gusa_DS_TssiIndex_G9923[NUM_G992_3_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES];      // Subcarrier index
extern uint8 guca_DS_TssiValue_G9923[NUM_G992_3_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES];    // Log tssi value
extern uint8  gfta_DS_SprtSet_G9923[NUM_G992_3_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES>>3];     // Indication bit (1: in SUPPORTset; 0: not in SUPPORTset)

/* G992.5 */
extern uint16 gusa_DS_TssiIndex_G9925[NUM_G992_5_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES];      // Subcarrier index
extern uint8 guca_DS_TssiValue_G9925[NUM_G992_5_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES];    // Log tssi value
extern uint8  gfta_DS_SprtSet_G9925[NUM_G992_5_ANNEX_SUPPORTED][MAX_NUM_DS_TSSI_VALUES>>3];     // Indication bit (1: in SUPPORTset; 0: not in SUPPORTset)

#endif //_SPECTRAL_SHAPE_BIS_H
