/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _TX_OVRHD_BIS_H
#define _TX_OVRHD_BIS_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             tx_ovrhd_bis.h
 * DESCRIPTION:      Header file containing functions for producing the
 *                   synchronization byte for the transmitter.
 *
 **********************************************************************/

#include "typedef.h"
#include "ghs.h"

/* Indicator bits, Error handlers */
extern void Update_Anamoly_bis(FlagT ft_FarEndOrNearEnd);
extern void WriteIndicatorBits_bis(void);
extern void TransmitHDLCByte(MessageOvhdFifo_t *Fifo);
extern void TxHDLCProcessor(void);

extern int16 FillBinsInfo(uint8 *puca_msg_buffer, FlagT isBisOrPlus, uint8 uc_priority, uint8 uc_message_type);

extern int16 Fill_C_MSG_PCB_PMD_Info(uint8 *puca_msg_buffer,int16 idx);

extern int16 Fill_C_PARAMS_Info(uint8 *puca_msg_buffer, int16 idx, uint8 info);

extern int16 Fill_MS_MSG_PMS_TC_Info(uint8 *puca_msg_buffer, int16 idx);
extern int16 AddTpsTcInfo(int16 s_bc, Adsl2AllInfo_t *pt_Info, uint8 *puc_M, int16 idx);

/* Form messages of priority 1*/
extern uint8 Form_time_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
extern uint8 Form_Inventory_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
extern uint8 Form_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
extern uint8 Form_Control_val_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
extern uint8 Form_mgmt_counter_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
extern uint8 Form_Clear_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
extern uint8 Form_Power_Mgmt_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);

/* Form messages of priority 2*/
extern uint8 Form_nsf_facility_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, uint8 uc_message_type);
extern uint8 Form_test_param_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);

/* Tx overhead handlers */
extern uint8 Tx_prior0_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
extern uint8 Tx_prior1_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);
extern uint8 Tx_prior2_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo);

// TxHdlcProcessing
void CheckHdlcTimeOut(void);

// interface function to submit a message to Tx HDLC queue
int32 TxHdlcSendRequest(int32 l_PriorityIndex, TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput);

#ifdef HDLC_QUEUE_LOGGING
// interface function to reset response-expected control info
void ClearExpectedResponse(int32 l_PriorityIndex);
#endif

// interface function to retrieve the next message to be sent.
uint8 TxHdlcNextSendMessage(int32 l_PriorityIndex, TxOvhdMsgInfoStruct_t *pt_NextTxOvhdMsgInfo);

#ifdef HDLC_POLL_TEST
extern void Poll_prior1_test_messages();
extern void Poll_prior2_test_messages();
extern FlagT gft_PollHDLC1, gft_PollHDLC2;
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
// Counters to keep track of Eoc Polling
extern uint8 guc_PollPrior1Messages;
extern uint8 guc_PollPrior2Messages;
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)

#endif

extern BkgdFunction ME_HDLC_TxProcessor;

extern void ProcessCorruptCRC_BIS(int16 s_latencyPath);
extern void TxIbProcessor_bis(void);
extern void ProcessTxHDLCByte(void);

extern void PM_L3_State_Machine(void);

#endif /* _TX_OVRHD_BIS_H */

