/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

#ifndef _TYPEDEF_BIS_H
#define _TYPEDEF_BIS_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: typedef_bis.h
;
;  This file contains type definitions used by different files.
;
*****************************************************************************/
#include <stdio.h>
#include "config.h"
#include "const.h"
#include "const_bis.h"


/* Structure used for C_MSG_FMT */
typedef struct {
   uint16   us_FMT_R_REVERB1;                /* Set to 1 indicates that the ATU-C requests an extended duration of the R-REVERB1 state. Set to 0 indicates not. */
   uint16   us_FMT_C_MSG1;                   /* Set to 1 indicates that the ATU-C shall  apply windowing  with window samples included in the C-MSG1 message. Set to 0 indicates it shall not. */
   uint16   us_FMT_C_REVERB4;                /* Set to 1 indicates that the ATU-C requests an extended duration of the C-REVERB4 state. Set to 0 indicates it does not. */
   uint16   us_FMT_R_QUIET4;                 /* The (0 to 31) value mapped in these bits indicates the duration of the R-QUIET4 state. The msb shall be mapped on the higher message bit index. */
    uint16  us_FMT_C_MSG_PCB;                            /* Set to 1 indicates that the C-MSG-PCB message shall include the C-BLACKOUT bits. Set to 0 indicates that it shall not  */
    uint8   uc_MedleyPRBSds;                 /* indicates whether to use dmt medley sequence or 14th order prbs sequence in plus mode */
} CMsgFmt_Bis_t;

/* Structure used for C_MSG_PCB */
typedef struct {
   uint16   us_C_MIN_PCB_DS;                 /* ATU-C Minimum Downstream Power Cutback (6 bit value) */
   uint16   us_C_MIN_PCB_US;                 /* ATU-C Minimum Upstream Power Cutback (6 bit value) */
   uint16   us_HOOK_STATUS;                     /* Hook Status (2 bit value) */
} CMsgPcb_Bis_t;

/* Structure used for R_MSG_FMT */
typedef struct {
   uint16   us_FMT_R_REVERB1;                /* Set to 1 indicates that the ATU-R requests an extended duration of the R-REVERB1 state. Set to 0 indicates it does not. */
// uint16   us_FMT_R_MSG1;                   /* Set to 1 indicates that the ATU-R shall transmit the R-MSG1 message. Set to 0 indicates it shall not. */
   uint16   us_FMT_C_REVERB4;                /* Set to 1 indicates that the ATU-R requests an extended duration of the C-REVERB4 state. Set to 0 indicates it does not. */
   uint16   us_FMT_C_TREF1;                     /* The value mapped in these bits indicates the minimum duration of the C-TREF1 state. The msb shall be mapped on the higher message bit index. */
   uint16   us_FMT_R_MSG_PCB;                /* Set to 1 indicates that the R-MSG-PCB message shall include the R-BLACKOUT bits. Set to 0 indicates it does not. */
   uint16   us_FMT_C_TREF2;                     /* Indicates that the ATU-R requests the ATU-C to transmit C-TREF symbols (if set to 1) or C-QUIET symbols (if set to 0) during R-ECT. */
   uint16   us_FMT_C_PILOT;                     /* Set to 1 indicates that the ATU-R requests the ATU-C to transmit a fixed 4-QAM constellation point on the C-TREF pilot tone. Set to 0 indicates it does not. */
    uint8   uc_MedleyPRBSus;                 /* 0= use dmt medley sequence, 1=use 14th order medley sequence */
} RMsgFmt_Bis_t;

/* Structure used for R_MSG_PCB */
typedef struct {
   uint16   us_R_MIN_PCB_DS;                 /* ATU-R Minimum Downstream Power Cutback */
   uint16   us_R_MIN_PCB_US;                 /* ATU-R Minimum Upstream Power Cutback */
   uint16   us_HOOK_STATUS;                     /* Hook Status */
   uint16   us_C_PILOT;                      /* Subcarrier index of downstream pilot tone */
// We don't use blackout bits now.
// uint16   us_R_BLACKOUT[16];                  /* Blackout indication per subcarrier */
//                                     /* 1 bit is needed per subcarrier. So 16 words are used */
} RMsgPcb_Bis_t;

/* Structure used for C_MSGS1 */
typedef struct {
    uint16  us_TARSNRMds;                    /* target noise margin */
   uint16   us_MINSNRMds;                    /* minimum noise margin */
   uint16   us_MAXSNRMds;                    /* maximum noise margin */
   uint16   us_RA_MODEds;                    /* rate adaptation mode */
   uint16   us_PM_Mode;                      /* power management mode. Bit0: indicates whether L3 state is allowed (1) or not allowed (0) */
                                       /* Bit1: indicates whether L2 state is allowed (1) or not allowed (0) */
   uint16   us_RA_USNRMds;                   /* rate adaptation upshift noise margin */
   uint16   us_RA_UTIMEds;                   /* rate adaptation upshift time interval */
   uint16   us_RA_DSNRMds;                   /* rate adaptation downshift noise margin */
   uint16   us_RA_DTIMEds;                   /* rate adaptation downshift time interval */
   uint16   us_MaxBitsPerTone;                  /* max number of bits per sub carrier, >=8 and <= 15 */
   uint16   us_EXTGIds;                      /* max extension of gi range supported, >=0 and <= (MAXPSDds - NOMPSDds) */
   uint8 uc_CA_MEDLEYus;                     /* minimum length of the R_MEDLEY state */
   int16 sa_DSWindow[RX_NUM_TONES>>6];       /* holds the ds windowing coefs when DS windowing is enabled by CO */
} CMsgs1_Bis_t;

/* Structure used for R_MSGS1 */
typedef struct {
    uint16  us_MaxBitsPerTone;                  /* max number of bits per sub carrier, >=8 and <= 15 */
   uint16   us_EXTGIus;                      /* max extension of gi range supported, >=0 and <= (MAXPSDds - NOMPSDds) */
   uint8 uc_CA_MEDLEYds;                     /* minimum length of the C_MEDLEY state */
} RMsgs1_Bis_t;


// Structure used for Handshake info for Bitloading
typedef struct {

   int16 s_MinMSGDSOverheadRate;

   int16 s_NumDSLatencyPaths;
   int16 sa_DS_MaxCheckbytesLP[NUM_DS_LATENCY_PATHS];
   int16 sa_DS_MaxIntlvDepthLP[NUM_DS_LATENCY_PATHS];
   int16 sa_DS_MaxDataRateLP[NUM_DS_LATENCY_PATHS];

   int16 sa_DS_BCActive[NUM_DS_BEARER_CHANNELS_SUPPORTED];
   int16 sa_DS_MinNetDataRateBC[NUM_DS_BEARER_CHANNELS_SUPPORTED];
   int16 sa_DS_MaxNetDataRateBC[NUM_DS_BEARER_CHANNELS_SUPPORTED];
   int16 sa_DS_ReservedNetDataRateBC[NUM_DS_BEARER_CHANNELS_SUPPORTED];
   int16 sa_DS_MaxLatencyBC[NUM_DS_BEARER_CHANNELS_SUPPORTED];
   int16 sa_DS_BerBC[NUM_DS_BEARER_CHANNELS_SUPPORTED];
   int16 sa_DS_MinINPBC[NUM_DS_BEARER_CHANNELS_SUPPORTED];
   int16   s_DS_SupportedDValuesLP0;
   int16 s_OneOverSminADSL2;
   int16 sa_DS_TransferModeBC[NUM_DS_BEARER_CHANNELS_SUPPORTED];

} HandshakeBis_t;


// Structure used for saving the result of the bitloading
typedef struct {
   int16 s_Lp[NUM_DATA_PATHS];
   int16 s_Mp[NUM_DATA_PATHS];
   int16 s_Tp[NUM_DATA_PATHS];
   int16 s_Rp[NUM_DATA_PATHS];
   int16 s_Dp[NUM_DATA_PATHS];
   int16 s_MSGlp;
   int16 s_IBITSlp;
   int16 s_MSGc;
   int16 sa_Bpn[NUM_DATA_PATHS][NUM_DS_BEARER_CHANNELS_SUPPORTED];
} PMSBitload_t;

#endif /* _TYPEDEF_BIS_H */

