/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  L3StateMachine.c
*
*
****************************************************************************/

/*-------------------------------------------------------------------------*/
//
// File load_codeswap.c
//
// History :
//
//  19/09/2011 Sriram Shastry : Disable Power Management L2,L3 mode, Seamless rate adaptation ( US & DS direction) as a part of R43. delivery
//             This is done as per project management requirement. They are only check box feature for R4.3 release. SRA & PM L2 mode
//             features are functionally not verified.
//
//    Grep for :   IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode
//
// 07/03/2013 Vinjam: On receiving "Ack" for "PM L3" request set "Socrates CMV STAT 18 0" to "3" (i.e. PM L3)
//                    In the CMV re-map this is mapped to HERC STAT 0 1
//                    Grep for XDSLRTFW-750 Fix_DS_BisPlus_All_PML3EnableByDefault
/*-------------------------------------------------------------------------*/
#include <string.h>
#include "typedef.h"
#include "gdata_bis.h"
#include "gdata.h"
#include "cmv.h"
#include "const_bis.h"
#include "ovhd_bis.h"
#include "tx_ovrhd_bis.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : PM_L3_State_Machine(void)
 *
 *  Description:  This subroutine implements the PM L3 state machine
 *
 *  Prototype:
 *      void  PM_L3_State_Machine(void)
 *
 *  Input Arguments:
 *    None
 *
 *  Output Arguments:
 *    1. Updates (a)STATArray[STAT_PowerMode] (b)STATArray[STAT_PMStatus] (c)STATArray[STAT_PMError]
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *      1. guc_PM_L3_InternalState
 *    2. guc_PM_L3_Response
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void PM_L3_State_Machine(void)
{

    TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoRequest;    // will contain the info about the message to be generated

   switch(guc_PM_L3_InternalState) {

   case WAITING_FOR_L3_REQUEST:

      //if((PMstate == L0) AND (CNTL[1]&CNTL_Request_L3))
      //   Change the guc_PM_L3_InternalState;
      //   Clear the "CNTL_Request_L3" bit in CNTL[1] Array
      // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (Start)
      if(TESTArray[TEST_Control3]&(TEST_DisableL3Mode))
      {

           guc_PM_L3_InternalState = WAITING_FOR_L3_REQUEST;
           guc_PM_L3_Response = PM_L3_RESPONSE_DISABLED;
           STATArray[STAT_ME_PMREQ_STATUS] |= STAT_OLRPM_ABORTED;
           STATArray[STAT_ME_PMREQ_ERROR] = REQ_ACTION_DISABLED;
      }

      else if(CNTLArray[CNTL_PM_Control]&CNTL_Request_L3)
      // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (End)
      {
         CNTLArray[CNTL_PM_Control] ^= CNTL_Request_L3;  //Clear the bit
         if ((gt_RxOLRPMVars.uc_rxOLRPMState == L0_STEADY_STATE) ||
            (gt_RxOLRPMVars.uc_rxOLRPMState == L2_STEADY_STATE))
         {
            // Change the rxOLRPMState here so we don't consider other OLR/PM until
            // this L3 request is resolved
            gt_RxOLRPMVars.uc_rxOLRPMState = L3_REQUEST;
            STATArray[STAT_ME_PMREQ_STATUS] = STAT_PM_L3_REQ;
            STATArray[STAT_ME_PMREQ_ERROR] = 0;
            guc_PM_L3_InternalState = WAITING_FOR_QUEUE_IN_HDLC_TX_QUEUE;
         }
         else
         {
            STATArray[STAT_ME_PMREQ_STATUS] |= STAT_OLRPM_ABORTED;
            STATArray[STAT_ME_PMREQ_ERROR] = REQ_NOT_IN_L0_STATE; // Actually, not in L0 or L2 state.
         }
      }
      break;

   case WAITING_FOR_QUEUE_IN_HDLC_TX_QUEUE:

      //Fill up the structure members of "TxOvhdMsgInfoRequest_t"
      t_TxOvhdMsgInfoRequest.uc_message_type = STATE_TRANS_REQ;
      t_TxOvhdMsgInfoRequest.uc_message_designator = POWER_MGMT_CMD_DESIG;
      t_TxOvhdMsgInfoRequest.uc_Source = AUTO_CMD_SOURCE;
      t_TxOvhdMsgInfoRequest.uc_Segmented = FALSE;
      t_TxOvhdMsgInfoRequest.uc_TestParameterId = L3_STATE;

      //Push Simple PM L3 request in HDLC Tx Queue. If this fails, remain in this
      // state and try again next time.
      if (TxHdlcSendRequest(OVHD_NORMAL_PRIORITY, t_TxOvhdMsgInfoRequest) == HDLC_QUEUE_ADDED)
      {
         guc_PM_L3_InternalState = WAITING_FOR_L3_RESPONSE;
         guc_PM_L3_Response = 0;    //Reset the variable
      }
      break;


   case WAITING_FOR_L3_RESPONSE:
      if(guc_PM_L3_Response > 0) //Either response recived or time out occured
      {
         guc_PM_L3_InternalState = WAITING_FOR_L3_REQUEST;

         if(guc_PM_L3_Response == PM_L3_GRANT_RECEIVED)
         {
            // We set CMV to indicate to ME that L3 request/grant is complete, then
            // just wait for ME to reset us.
            gt_RxOLRPMVars.uc_rxOLRPMState = L3_STEADY_STATE;
            gft_EnterL3afterNextReboot = STAT_PM_L3;
            STATArray[STAT_ME_PMREQ_STATUS] |= (STAT_OLRPM_COMPLETE | STAT_OLRPM_RESPONSE);
            //XDSLRTFW-750 Fix_DS_BisPlus_All_PML3EnableByDefault (Start_End)
            STATArray[STAT_PowerMode] = (int16) STAT_PM_L3;
         }

         if(guc_PM_L3_Response == PM_L3_REJECT_RECEIVED)
         {
            gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
            STATArray[STAT_ME_PMREQ_STATUS] |= (STAT_OLRPM_ABORTED | STAT_OLRPM_RESPONSE);
         }

         if(guc_PM_L3_Response == PM_L3_RESPONSE_TIMEOUT)
         {
            gt_RxOLRPMVars.uc_rxOLRPMState = L0_STEADY_STATE;
            STATArray[STAT_ME_PMREQ_STATUS] |= STAT_OLRPM_ABORTED;
            STATArray[STAT_ME_PMREQ_ERROR] = REQ_L3_RESPONSE_TIMEOUT;
         }
      }
      break;
   }

}
//#endif


