/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware BIS Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             txhdlcprocessor.c
 * DESCRIPTION:      HDLC message processor functions.
 *
 **********************************************************************/
#include <string.h>
#include "typedef.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "ovhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "gdata.h"
#include "cmv.h"
#include "hs_misc.h"
#include "hndshk_Data.h"
#include "rx_ovrhd_bis.h"
#include "trail.h"
#include "showinit_olr.h"
#ifdef DEBUG_STREAMING
#include "DebugBuffer.h"
#endif

// function pointer array to all HDLC Tx ovhd msg handler functions
uint8 (*Tx_ovhd_msg_handler[])(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo) =
                                                                    {&Tx_prior0_ovhd_msg_handler,
                                                   &Tx_prior1_ovhd_msg_handler,
                                                   &Tx_prior2_ovhd_msg_handler};
// this is Tx HDLC queue
extern TxOvhdMsgInfoStruct_t gta_TxOvhdMessage[][HDLC_QUEUE_LENGTH];

#ifdef HDLC_QUEUE_LOGGING
extern FILE *gfp_hdlc_out;
void QueueStatLog(uint8 *puc_QueuStat, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo, int32 l_PriorityIndex)
{
   printf("P%d - %s designator = 0x%x, msg_type = 0x%x, source = %d, ,msg_cnt %d, %d, %d\n",
            l_PriorityIndex, puc_QueuStat, pt_TxOvhdMsgInfo->uc_message_designator,
            pt_TxOvhdMsgInfo->uc_message_type, pt_TxOvhdMsgInfo->uc_Source,
            gta_TxHdlcControlInfo[l_PriorityIndex].uca_MsgTypeCount[0],
            gta_TxHdlcControlInfo[l_PriorityIndex].uca_MsgTypeCount[1],
            gta_TxHdlcControlInfo[l_PriorityIndex].uca_MsgTypeCount[2]);
   fprintf(gfp_hdlc_out, "P%d - %s designator = 0x%x, msg_type = 0x%x, source = %d, ,msg_cnt %d, %d, %d\n",
            l_PriorityIndex, puc_QueuStat, pt_TxOvhdMsgInfo->uc_message_designator,
            pt_TxOvhdMsgInfo->uc_message_type, pt_TxOvhdMsgInfo->uc_Source,
            gta_TxHdlcControlInfo[l_PriorityIndex].uca_MsgTypeCount[0],
            gta_TxHdlcControlInfo[l_PriorityIndex].uca_MsgTypeCount[1],
            gta_TxHdlcControlInfo[l_PriorityIndex].uca_MsgTypeCount[2]);
}
#endif

FlagT gft_CorruptFCS = FALSE;
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : TxHDLCProcessor(void)
 *
 *  Description:  This subroutine computes the HDLC byte to be transmitted and
 *          stores in  fifo
 *
 *  Prototype:
 *      void  TxHDLCProcessor(void)
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *       gt_TxHDLCMsgFifo
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
#define OVHD_TIMEOUT_DELTA 6  // superframes, 100 ms
DATA_MAP_BIS
uint8 guca_ovhd_msg_timeout[MAX_OVHD_PRIORITY] = {24, 47, 59};
uint16 gusa_ovhd_msg_timeout[MAX_OVHD_PRIORITY] = {0, 0, 0};
int16 gs_RxOvhdMsg_length = 200;  //an average recieve HDLC msg length

// The following global variables are primarily for debug purpose
int16 gs_TxOvhdMsg_length = 0;                // Last ovhd tx msg length
uint8* gpuc_TxOvhdMsg_StartAddr = 0x0;        // Last ovhd tx msg starting address in Tx Msg FIFO
uint16 gus_Tx_HDLCMsgIndex = 0;               // Total ovhd tx msg counter
DATA_MAP_END;

#ifdef HDLC_LEAVE_TRAIL
extern FILE *fp_HDLCdata;
#endif

#ifdef HDLC_POLL_TEST
DATA_MAP_BIS
void (*Poll_test_message[])() = {&Poll_prior1_test_messages, &Poll_prior2_test_messages};
DATA_MAP_END;
#endif

void TxHDLCProcessor(void)
{
   uint8 uc_new_or_old_bit;
   uint8 uc_tx_hdlc_byte;
   int32 l_PriorityIndex;
    TxOvhdMsgInfoStruct_t t_TxOvhdMsgInfo;    // will contain the info about the message to be generated
    TxHdlcControl_t *pt_TxHdlcControlInfo = NULL;

   /* Initialise it to invalid number */
   uint8 uc_comm_or_resp_bit = 2;

   uint8 uca_tx_hdlc_msg_buffer[MAX_TX_HDLC_BUFFER_SIZE - 6];
   uint16 us_tx_hdlc_msg_length = 0;

   int i;

#ifdef HDLC_LEAVE_TRAIL
   static int16 s_HDLCIndex = 0;

   if (!fp_HDLCdata)
      fp_HDLCdata = fopen ("HDLC_Data.txt", "w");
   else
   {
      fclose(fp_HDLCdata);
      fp_HDLCdata = fopen("HDLC_Data.txt", "a");
   }
#endif

   PM_L3_State_Machine();

   gt_TxHDLCMsg.gus_FCS = 0xFFFF;

   /* Form the message and fill the FIFO only if last message has been transmitted */
   // Only one ovhd message can be sent at any time. We currently can't handle the complicated scenario when the
   // higher priority messeges comes in before the lower priority message completes its transmission yet.

   if(gt_TxHDLCMsgFifo.IndexOfOldest == gt_TxHDLCMsgFifo.NextAvailable)
   {
#ifdef HDLC_POLL_TEST
        // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
        if (gft_PollHDLC1 || gft_PollHDLC2)
        {
            for (l_PriorityIndex = 1; l_PriorityIndex < MAX_OVHD_PRIORITY; l_PriorityIndex++)
            {
                (*Poll_test_message[l_PriorityIndex-1])();
            }
        }
        // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)
#endif

      /**********************/
      /* Set gft_Start_Transmit_HDLC FALSE so that Zephyr shouldn't start transmitting
         HDLC byte until the new HDLC msg is fully formed. Otherwise Zephyr could be starve and send 0x7E flag.
         Make this very early is just for safe reason. */
      /**********************/
      gft_Start_Transmit_HDLC = FALSE;

      /**********************/
      /* Check for timeouts */
      /**********************/
      CheckHdlcTimeOut();

      /***********************/
      /* Form OVHD MESSAGES */
      /***********************/
      // Only one ovhd message can be sent, the higher ovhd msg send first. We currently can't handle
      // complicated higher priority messeges coming when lower priority message is still transmitting yet.
      for (l_PriorityIndex = 0; l_PriorityIndex < MAX_OVHD_PRIORITY; l_PriorityIndex++)
      {
            // check any message needs to be sent
         if(TxHdlcNextSendMessage(l_PriorityIndex, &t_TxOvhdMsgInfo) == TRUE)
         {

            /*************/
            /* IMPORTANT */
            /*************/
            /* As per spec, an ATU-R should not initiate an OLR if it has transmitted */
            /* an L2 grant and is waiting for a sync indicator */

            /* As the gt_RxOLRPMVars.uc_rxOLRPMState = OLR_RECV_SYNC_INDICATOR */
            /* the case when the ATU-R is expecting a sync indicator from the other end */
            /* for a L0 to L2 transsition : state being L2_RECV_SYNC_INDICATOR is */
            /* automatically ruled out */

            // Initialize HDLC msg buffer each time when we try to form a new message
            memset(uca_tx_hdlc_msg_buffer, 0, MAX_TX_HDLC_BUFFER_SIZE-6);

#ifdef HDLC_LEAVE_TRAIL
            s_HDLCIndex++;
            fprintf(fp_HDLCdata, "\nHDLC_Sent_Msg #%d\n", s_HDLCIndex);
            fprintf(fp_HDLCdata, "Priority:      0x%02x\n", l_PriorityIndex);
#endif
            /* Form the message to be transmitted */
            if (t_TxOvhdMsgInfo.uc_Source == ME_CMD_SOURCE)
            {
               uc_comm_or_resp_bit = (guca_Tx_ME_HDLCMsgBuffer[1] & 0x80) >> 7; // command  or response
               if (uc_comm_or_resp_bit !=0) // ME can issue only a command
               {
                  STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_INVALID_MSG;
//                uc_comm_or_resp_bit  = 2; // no need to send out this message
               }
               else
               {
                  us_tx_hdlc_msg_length = gt_ME_HDLC_Params.s_ME_HdlcTxMsgLength;
                  memcpy(&uca_tx_hdlc_msg_buffer[0], guca_Tx_ME_HDLCMsgBuffer, us_tx_hdlc_msg_length);
               }
               //clear gt_RxClearEocBuf_CMV.s_RxClearEocBuf_Disable after a Tx ME-HDLC
               //message is copied from the ME-HDLC buffer in preparation for transmission.
               gt_RxClearEocBuf_CMV.s_RxClearEocBuf_Disable = FALSE;
            }
            else
            {
               uc_comm_or_resp_bit = (*Tx_ovhd_msg_handler[l_PriorityIndex])(&uca_tx_hdlc_msg_buffer[0], &us_tx_hdlc_msg_length, &t_TxOvhdMsgInfo);
            }
            // from now on, this pointer points to the priority that has a pending message to be sent
            pt_TxHdlcControlInfo = &gta_TxHdlcControlInfo[l_PriorityIndex];

            DebugTrail(5, DEBUG_LOG_OVHDMESSAGES, 0xCCCC, (int16)(gl_RxSymbolCount&0xFFFF), (int16)((gl_RxSymbolCount>>16)&0xFFFF), (int16)((uc_comm_or_resp_bit<<8)|(l_PriorityIndex&0xFF)), (int16)uca_tx_hdlc_msg_buffer[0]);

            // Guarantee that we always transmit the higher priority message first
            break;
         }
      }


      /********************************/
      /* TRANSMIT MESSAGE           */
      /********************************/
      if(uc_comm_or_resp_bit < 2)
      {

         /* Toggle the LSB for every new message sent */
         uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
         uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

         /* Fill in the message command/response field */
         if ((gt_TxHDLCMsg.cntrl_field = uc_comm_or_resp_bit << 1) == 0)
         {
            // Sending a command, so expect a response.
            pt_TxHdlcControlInfo->ft_ack_expected = TRUE;
            pt_TxHdlcControlInfo->uc_Source = t_TxOvhdMsgInfo.uc_Source;
         }

         /* Fill the message priority based on the command designator */
         if (uca_tx_hdlc_msg_buffer[0] == RECONFIG_CMD_DESIG)
         {
            l_PriorityIndex = OVHD_HIGH_PRIORITY;
         }
         else if ( (uca_tx_hdlc_msg_buffer[0] == PMD_TEST_PAR_RD_CMD_DESIG)
            || (uca_tx_hdlc_msg_buffer[0] == NSF_FACILITY_LOW_CMD_DESIG) )
         {
            l_PriorityIndex = OVHD_LOW_PRIORITY;
         }
         else
         {
            // commands EOC_CMD_DESIG, TIME_CMD_DESIG, INVENTORY_CMD_DESIG, CNTL_PAR_RD_CMD_DESIG, MGMT_CNTR_RD_CMD_DESIG
            // POWER_MGMT_CMD_DESIG, CLEAR_EOC_CMD_DESIG,NSF_FACILITY_CMD_DESIG have normal priority
            l_PriorityIndex = OVHD_NORMAL_PRIORITY;
         }

         gt_TxHDLCMsg.message_priority = (uint8) l_PriorityIndex;

         /* considering possible ovhd msg segmentation*/
         if (gsa_RTXmit_OvhdMsgSegIndx[l_PriorityIndex] >= 0)
         {
            gt_TxHDLCMsg.cntrl_field |= (gsa_RTXmit_OvhdMsgSegIndx[l_PriorityIndex])<<3;

            if (gfta_FirstOvhdMsgSeg[l_PriorityIndex])
            {
               // first segmented message
               gt_TxHDLCMsg.cntrl_field |= (1<<7);
               gfta_FirstOvhdMsgSeg[l_PriorityIndex] = FALSE;
            }

            // we expect Segment ACK or Inverted Sync symbol
            gt_HDLCInfo.ft_SegmentedMsgProgress = TRUE;
            if (gsa_RTXmit_OvhdMsgSegIndx[l_PriorityIndex] == 0)
            {
               // last segmented message
               gt_TxHDLCMsg.cntrl_field |= (1<<7);

               //reset the ovhd segment info for the new msg
               gsa_RTXmit_OvhdMsgSegIndx[l_PriorityIndex] = -1;
               gsa_COReq_OvhdMsgSegIndx[l_PriorityIndex] = -1;
               gt_HDLCInfo.ft_SegmentedMsgProgress = FALSE;
               //for L2, the t_TxOvhdMsgInfo.ft_InvertedSyncSymbol_expected checked later on
               //will set this flag to be TRUE.
               pt_TxHdlcControlInfo->ft_ack_expected = FALSE;

            }
         }
         else
         {
            /* Fill in the new or old message bit field */
            gt_TxHDLCMsg.cntrl_field |= uc_new_or_old_bit;
         }
         // For debug usage, we need to know where the new Tx ovhd msg starts in the fifo
#ifdef HDLC_LEAVE_TRAIL
         gpuc_TxOvhdMsg_StartAddr = guca_TxHDLCMsgBuffer + (uint32)gt_TxHDLCMsgFifo.NextAvailable;


         // protect HDLC Tx msg counter from overflow
         if (gus_Tx_HDLCMsgIndex == 0xFFFF)
            gus_Tx_HDLCMsgIndex = 0;
         else
            gus_Tx_HDLCMsgIndex++;
#endif

         gs_TxOvhdMsg_length = 4; //including OPENING_FLAG, priority, ctrl_field, Closing_FLAG

         /* Add the message to gt_TxHDLCMsgFifo */
         AddMessageToOvhdFifo(&gt_TxHDLCMsgFifo, OPENING_FLAG);

         AddMessageToOvhdFifo(&gt_TxHDLCMsgFifo, (uint8) l_PriorityIndex);
         gt_TxHDLCMsg.gus_FCS = CalcCRC_Byte( (uint8) l_PriorityIndex, gt_TxHDLCMsg.gus_FCS, FCS_GEN_POLY );

         AddMessageToOvhdFifo(&gt_TxHDLCMsgFifo, gt_TxHDLCMsg.cntrl_field);
         gt_TxHDLCMsg.gus_FCS = CalcCRC_Byte( gt_TxHDLCMsg.cntrl_field, gt_TxHDLCMsg.gus_FCS, FCS_GEN_POLY );

         /* Compute the FCS */
         for (i=0; i< us_tx_hdlc_msg_length; i++)
         {
            /* Compute FCS before adding the escape octets */
            gt_TxHDLCMsg.gus_FCS = CalcCRC_Byte( uca_tx_hdlc_msg_buffer[i], gt_TxHDLCMsg.gus_FCS, FCS_GEN_POLY );

         }

         if (gft_CorruptFCS == FALSE)
            gt_TxHDLCMsg.gus_FCS = ~gt_TxHDLCMsg.gus_FCS;   /*  take 1's compliment */

         /* Add the FCS computed to the message buffer */
         uca_tx_hdlc_msg_buffer[us_tx_hdlc_msg_length] = (uint8)(gt_TxHDLCMsg.gus_FCS & 0xFF);/* FCS low octet */
         uca_tx_hdlc_msg_buffer[us_tx_hdlc_msg_length + 1] = (uint8)(gt_TxHDLCMsg.gus_FCS >> 8); /* FCS high octet */

         /* Add the transparency octets before transmitting */
         for (i=0; i< us_tx_hdlc_msg_length + 2; i++)
         {
            uc_tx_hdlc_byte = uca_tx_hdlc_msg_buffer[i];

            /* Octet transparency */
            switch (uc_tx_hdlc_byte)
            {

               case FLAG:
               case 0x7D:

                  /* A 0x7E or a 0x7D in the message is coded as 0x7D and 0x5E */
                  AddMessageToOvhdFifo(&gt_TxHDLCMsgFifo, 0x7D);
                  gs_TxOvhdMsg_length++;
                  uc_tx_hdlc_byte = uc_tx_hdlc_byte ^ 0x20;
                  break;

               default:
                  break;

            }   /*  switch */

            AddMessageToOvhdFifo(&gt_TxHDLCMsgFifo, uc_tx_hdlc_byte);
            gs_TxOvhdMsg_length++;
         }

         AddMessageToOvhdFifo(&gt_TxHDLCMsgFifo, OPENING_FLAG);

#ifdef DEBUG_STREAMING
         // In case the new message will not fit in the rest of the EOC debug buffer, we will write it to the beginning
         if((gus_DSH_TX_EOC_idx+us_tx_hdlc_msg_length+2)>DSH_EOC_BUFFER_LENGTH)
         {
            gus_DSH_TX_EOC_idx=0;
         }
         memcpy(&guca_DSH_TX_EOC_msg_buffer[gus_DSH_TX_EOC_idx+2],&uca_tx_hdlc_msg_buffer[0],us_tx_hdlc_msg_length+2);
         guca_DSH_TX_EOC_msg_buffer[gus_DSH_TX_EOC_idx+0] = (uint8)l_PriorityIndex;
         guca_DSH_TX_EOC_msg_buffer[gus_DSH_TX_EOC_idx+1] = uc_comm_or_resp_bit;
         DSH_SendStream(DSH_OCH_TX_MESSAGES,us_tx_hdlc_msg_length+2,&guca_DSH_TX_EOC_msg_buffer[gus_DSH_TX_EOC_idx]);
         // Avoid overwriting previous message by shifting the gus_DSH_RX_EOC_idx behind this message
         gus_DSH_TX_EOC_idx+=us_tx_hdlc_msg_length+2;
#endif

         // Only until now, can we start transmiting the HDLC byte to avoid possible
         // ovhd msg fifo starving problem

         // Note: the order of updating the two variables below is important, i.e, gft_Start_Transmit_HDLC
         // needs to be updated after the gus_transmit_ovhd_msg_length updation.
         // The reason is that the timing critical task TransmitHDLCByte also has the opportunity of
         // updating gft_Start_Transmit_HDLC and gus_transmit_ovhd_msg_length. In this background task,
         // the complier could allocate more than one DSP cycle to update these two variables. If the
         // timing critical task TransmitHDLCByte(...) interrupts this background task when it tries to set
         // gft_Start_Transmit_HDLC to be TRUE first and hasn't been able to update gus_transmit_ovhd_msg_length yet
         //, TransmitHDLCByte() will reset gft_Start_Transmit_HDLC to be FALSE since gus_transmit_ovhd_msg_length
         // is still zero.
         gft_Start_Transmit_HDLC = TRUE;


         ////////////////////////////////////////////////////////////////////////
         // Determine whether we expect a response (ack) from the CO to our message
         ////////////////////////////////////////////////////////////////////////
         /*
         If we're sending a command, rather than a response, then an acknowledge is always expected.
         However we also use the acknowledge/timeout mechanism when we are expecting an inverted sync frame "ack"
         from the CO.  We check below for these special cases which expect an inverted sync frame ack : L2 grant (0x82),
         L2 trim grant (0x84), ADSL2+ L2 grant (0x86).  DS OLRs also expect an inverted sync frame response but are handled
         elsewhere.  Note that we do not expect a response to an L3 grant (0x80).
         */

         if((t_TxOvhdMsgInfo.uc_Source != RESPONSE_SOURCE) || t_TxOvhdMsgInfo.ft_InvertedSyncSymbol_expected||gt_HDLCInfo.ft_SegmentedMsgProgress)
         {
            pt_TxHdlcControlInfo->ft_ack_expected = TRUE;
            pt_TxHdlcControlInfo->uc_ExpectedDesignator = uca_tx_hdlc_msg_buffer[0];
            pt_TxHdlcControlInfo->uc_ExpectedMsgType = uca_tx_hdlc_msg_buffer[1];
                // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
                // Set the expected test param id for test param messages sent
                if (pt_TxHdlcControlInfo->uc_ExpectedDesignator == PMD_TEST_PAR_RD_CMD_DESIG)
                {
                    pt_TxHdlcControlInfo->uc_ExpectedTestParamId = uca_tx_hdlc_msg_buffer[2];
                }
                // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)

            /////////////////////////////////////////////////////////////////////////////////////////////////
            // Initilaize timer and set the timeout length for this message
            /////////////////////////////////////////////////////////////////////////////////////////////////
            // Standard specifies "Timeouts are based starting from the last octet of a
            // request message sent to last octet of a response message received"
            /////////////////////////////////////////////////////////////////////////////////////////////////
            // Hence to the original standard specified timeout length we add the time
            // required to send out this message (plus some extra time)
            // Note: Acounting for just the length of this message is not completely accurate
            // since we can have more than one messages being transmitted @ the same time hence we give some delta
            // Standard specifies MSGc HDLC ovhd bytes be transmitted in PERp. Max{PERp} == 20 ms.
            //    MSGc Bytes in 20 ms ==> gs_TxOvhdMsg_length bytes in (gs_TxOvhdMsg_length * 20) / MSGc ms
            //    ie. (gs_TxOvhdMsg_length * 20) / (17 * MSGc) superframes
            /////////////////////////////////////////////////////////////////////////////////////////////////

            // Initailize timer to 0
            pt_TxHdlcControlInfo->us_ovhd_timer = 0;

            // setup timeout value

            gusa_ovhd_msg_timeout[l_PriorityIndex] = (uint16)(gs_TxOvhdMsg_length * (1+6/gt_tx_config.s_MSGc) * 8)/ gsa_USOvhdRate[0]
               + (uint16)(gs_RxOvhdMsg_length * (1+6/gt_rx_config.s_MSGc) * 8)/ gsa_DSOvhdRate[0];

            // Add some extra time to the timeout specified by standard for given priority message
            gusa_ovhd_msg_timeout[l_PriorityIndex] += (OVHD_TIMEOUT_DELTA + (int16)guca_ovhd_msg_timeout[l_PriorityIndex]);
         }

#ifdef HDLC_LEAVE_TRAIL
         // CRC bytes
         fprintf(fp_HDLCdata, "CRC Bytes:     0x%02x 0x%02x\n", uca_tx_hdlc_msg_buffer[us_tx_hdlc_msg_length], uca_tx_hdlc_msg_buffer[us_tx_hdlc_msg_length+1]);

         fprintf(fp_HDLCdata, "%2x  ", l_PriorityIndex);
         fprintf(fp_HDLCdata, "%2x  ", gt_TxHDLCMsg.cntrl_field);

         for (i = 0; i < us_tx_hdlc_msg_length + 2; i++)
         {
            fprintf(fp_HDLCdata, "%2x  ", uca_tx_hdlc_msg_buffer[i]);
         }
         fprintf(fp_HDLCdata, "\n");

         if (fp_HDLCdata)
            fclose (fp_HDLCdata);
#endif

         if (t_TxOvhdMsgInfo.uc_Source == ME_CMD_SOURCE)
            STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_MSG_SENT;
      }


   }
}



// During message segmentation, other responses or commands in the queue will be delayed.
// this will make our segmentation handling a lot simpler and easier.
//
// While waiting for a response, we will not send another command (by the spec) or a response
// that might be segmented.
//
// PM/grant response will be treated as segmented response, and that will help to solve the
// timer corruption problem.
//
// Before putting a command or response in the queue, the code should be able to identify
// these as segmented or not. Hlog, SRA, PM are the only supported segmentations at this point.
FlagT TxHdlcNextSendMessage(int32 l_PriorityIndex, TxOvhdMsgInfoStruct_t *pt_NextTxOvhdMsgInfo)
{
    int32 l_ReadIndex, l_NextReadIndex;
    TxHdlcControl_t *pt_TxHdlcControlInfo;
    TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo = NULL;

    pt_TxHdlcControlInfo = &gta_TxHdlcControlInfo[l_PriorityIndex];

    l_ReadIndex = pt_TxHdlcControlInfo->uc_ReadIndex;
    l_NextReadIndex = l_ReadIndex;

    // queue is not empty if ReadIndex and WriteIndex are different.
    while (l_ReadIndex != pt_TxHdlcControlInfo->uc_WriteIndex)
    {
        pt_TxOvhdMsgInfo = &gta_TxOvhdMessage[l_PriorityIndex][l_NextReadIndex];

        // advance l_ReadIndex ahead of time
        if (l_ReadIndex == HDLC_QUEUE_LENGTH - 1)
        {
            l_ReadIndex = 0;
        }
        else
        {
            l_ReadIndex++;
        }

      if ((gt_HDLCInfo.ft_InvertedSyncSymbol_expected == FALSE) && (gt_HDLCInfo.ft_SegmentedMsgProgress == FALSE))
      {
         // a).If not waiting for an ACK of this priority, we can send any command or response of this priority.
         // b).If waiting for an ACK of this priority to a simple command, don't send another command of this priority,
         //    but OK to send a response of this priority.
         if ((pt_TxHdlcControlInfo->ft_ack_expected == FALSE) || (pt_TxOvhdMsgInfo->uc_Source == RESPONSE_SOURCE))
            break;  //ok to send it
      }
      else
      {
         // c).If segmented message is in progress, don't send anything of any priority other than the segmented msg
         // d).Don't send anything of any priority if waiting for an inverted sync ACK.
         if (gt_HDLCInfo.ft_SegmentedMsgProgress
            && (pt_TxHdlcControlInfo->uc_ExpectedDesignator == pt_TxOvhdMsgInfo->uc_message_designator)
            &&(pt_TxHdlcControlInfo->uc_ExpectedMsgType == pt_TxOvhdMsgInfo->uc_message_type))
               break; //ok to send it
      }

      l_NextReadIndex = l_ReadIndex;
    }

    // is there a valid pending message to be sent?
    if (l_NextReadIndex != pt_TxHdlcControlInfo->uc_WriteIndex)
    {
        // copy it the "to-be-sent" entry
        *pt_NextTxOvhdMsgInfo = *pt_TxOvhdMsgInfo;

        // shift/push all queue entries from (original ReadIndex to l_NextReadIndex - 1) to
        // (original ReadIndex + 1 to l_NextReadIndex) to
        while (l_NextReadIndex != pt_TxHdlcControlInfo->uc_ReadIndex)
        {
            if (l_NextReadIndex == 0)
            {
                l_ReadIndex = HDLC_QUEUE_LENGTH - 1;
            }
            else
            {
                l_ReadIndex = l_NextReadIndex - 1;
            }
            gta_TxOvhdMessage[l_PriorityIndex][l_NextReadIndex] = gta_TxOvhdMessage[l_PriorityIndex][l_ReadIndex];
            l_NextReadIndex = l_ReadIndex;
        }

        // update ReadIndex. No acceess control/semaphore needed because this field
        // is only updated by the BG code (in fact, by this function exclusively).
        if (l_NextReadIndex++ == HDLC_QUEUE_LENGTH - 1)
        {
            pt_TxHdlcControlInfo->uc_ReadIndex = 0;
        }
        else
        {
            pt_TxHdlcControlInfo->uc_ReadIndex = (uint8)l_NextReadIndex;
        }

      //save the inverted Sync symbol expected flag of current message. Use them in
      //the logic at the beginning of this function to decide when to send a new message in the queue
      gt_HDLCInfo.ft_InvertedSyncSymbol_expected = pt_NextTxOvhdMsgInfo->ft_InvertedSyncSymbol_expected;

        // the MsgTypeCount is accessible to both FG and BG, lock while updating
        pt_TxHdlcControlInfo->uc_Semaphore = TRUE;
        pt_TxHdlcControlInfo->uca_MsgTypeCount[pt_NextTxOvhdMsgInfo->uc_Source]--;
        pt_TxHdlcControlInfo->uc_Semaphore = FALSE;

#ifdef HDLC_QUEUE_LOGGING
        QueueStatLog("QUEUE_SENT", pt_NextTxOvhdMsgInfo, l_PriorityIndex);
#endif

#ifdef HDLC_STAT
        if (pt_NextTxOvhdMsgInfo->uc_Source == RESPONSE_SOURCE)
        {
            pt_TxHdlcControlInfo->s_TotalRespSent++;
        }
        else
        {
            //must be CMD
            pt_TxHdlcControlInfo->s_TotalCmdSent++;
        }
#endif
        return(TRUE);
    }


    return(FALSE);
}
