/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware BIS Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             TxHDLC_Queue.c
 * DESCRIPTION:      Functions that implement the showtime non-time critical tasks for g.dmt.bis.
 *
 **********************************************************************/
#include "typedef.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "ovhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "gdata.h"
#include "cmv.h"
#include "plam.h"
#include "rx_plam.h"
#include "tx_plam.h"
#include "snr.h"
#include <string.h>
#include "tx_ops_bis.h"
#include "rx_ovrhd_bis.h"
#include "bitload_const.h"

// this is Tx HDLC queue
extern TxOvhdMsgInfoStruct_t gta_TxOvhdMessage[][HDLC_QUEUE_LENGTH];

#ifdef HDLC_QUEUE_LOGGING
extern FILE *gfp_hdlc_out;
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : TxHdlcSendRequest(int32 l_PriorityIndex, TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput)
 *
 *  Description:  This subroutine sends TX HDLC msgs into Queue
 *
 *  Prototype:
 *      void  TxHdlcSendRequest(int32 l_PriorityIndex, TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput)
 *
 *  Input Arguments:
 *      l_PriorityIndex : the ovhd msg priority index
 *    t_TxOvhdMsgInfoInput: contains info about the message being added to queue
 *
 *  Output Arguments:
 *
 *  Return:
 *      None
 *
 *
 *  Notes: if the message type exceeds its max allowed count, return FALSE
 *       if not, insert the request to location pointed by WriteIndex, also update the control structure.
 *------------------------------------------------------------------------
 *^^^
 */
int32 TxHdlcSendRequest(int32 l_PriorityIndex, TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput)
{
    TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo;
    TxHdlcControl_t *pt_TxHdlcControlInfo;
    int32 l_Source;
    int32 l_ReturnCode = HDLC_QUEUE_FULL;


    pt_TxHdlcControlInfo = &gta_TxHdlcControlInfo[l_PriorityIndex];
    l_Source = t_TxOvhdMsgInfoInput.uc_Source;
    // this check is to make that foreground will not corrupt the queue item when
    // this same is called by BG code and being interrupted. It's rare but potential.
    // what's needed protections? uc_WriteIndex and uca_MsgTypeCount
    if (pt_TxHdlcControlInfo->uc_Semaphore == FALSE)
    {
        pt_TxHdlcControlInfo->uc_Semaphore = TRUE;

        if (pt_TxHdlcControlInfo->uca_MsgTypeCount[l_Source] < pt_TxHdlcControlInfo->uca_MaxMsgTypeCount[l_Source])
        {
         // points to available queue item
            pt_TxOvhdMsgInfo = &gta_TxOvhdMessage[l_PriorityIndex][pt_TxHdlcControlInfo->uc_WriteIndex];

            // update queue control
            if (pt_TxHdlcControlInfo->uc_WriteIndex == HDLC_QUEUE_LENGTH - 1)
            {
                pt_TxHdlcControlInfo->uc_WriteIndex = 0;
            }
            else
            {
                pt_TxHdlcControlInfo->uc_WriteIndex++;
            }
            pt_TxHdlcControlInfo->uca_MsgTypeCount[l_Source]++;
            pt_TxHdlcControlInfo->uc_Semaphore = FALSE;

         // copy input message info into queue item
            pt_TxOvhdMsgInfo->uc_message_type = t_TxOvhdMsgInfoInput.uc_message_type;
            pt_TxOvhdMsgInfo->uc_defer_reason_code = t_TxOvhdMsgInfoInput.uc_defer_reason_code;
            pt_TxOvhdMsgInfo->uc_message_designator = t_TxOvhdMsgInfoInput.uc_message_designator;
            pt_TxOvhdMsgInfo->uc_Source = (uint8)l_Source;
            pt_TxOvhdMsgInfo->uc_Segmented = t_TxOvhdMsgInfoInput.uc_Segmented;
         pt_TxOvhdMsgInfo->ft_InvertedSyncSymbol_expected = t_TxOvhdMsgInfoInput.ft_InvertedSyncSymbol_expected;
            pt_TxOvhdMsgInfo->uc_TestParameterId = t_TxOvhdMsgInfoInput.uc_TestParameterId;
         pt_TxOvhdMsgInfo->us_param_rd_carrier_index = t_TxOvhdMsgInfoInput.us_param_rd_carrier_index;
         pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index = t_TxOvhdMsgInfoInput.us_param_rd_start_carrier_index;
         pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index = t_TxOvhdMsgInfoInput.us_param_rd_stop_carrier_index;

#ifdef HDLC_QUEUE_LOGGING
#if 0
         QueuStatLog("QUEUE_ADDED", pt_TxOvhdMsgInfo, l_PriorityIndex);
         printf("P%d - QUEUE_ADDED designator = 0x%x, msg_type = 0x%x, source = %d,msg_cnt %d, %d, %d\n",
            l_PriorityIndex, t_TxOvhdMsgInfoInput.uc_message_designator,
            t_TxOvhdMsgInfoInput.uc_message_type,
            t_TxOvhdMsgInfoInput.uc_Source,
            pt_TxHdlcControlInfo->uca_MsgTypeCount[0],
            pt_TxHdlcControlInfo->uca_MsgTypeCount[1],
            pt_TxHdlcControlInfo->uca_MsgTypeCount[2]);
         fprintf(gfp_hdlc_out, "P%d - QUEUE_ADDED designator = 0x%x, msg_type = 0x%x, source = %d,msg_cnt %d, %d, %d\n",
            l_PriorityIndex, t_TxOvhdMsgInfoInput.uc_message_designator,
            t_TxOvhdMsgInfoInput.uc_message_type,
            t_TxOvhdMsgInfoInput.uc_Source,
            pt_TxHdlcControlInfo->uca_MsgTypeCount[0],
            pt_TxHdlcControlInfo->uca_MsgTypeCount[1],
            pt_TxHdlcControlInfo->uca_MsgTypeCount[2]);
#endif
#endif
         l_ReturnCode = HDLC_QUEUE_ADDED;
        }
      else
      {
#ifdef HDLC_QUEUE_LOGGING
#if 0
         QueuStatLog("QUEUE_FULL",(TxOvhdMsgInfoStruct_t *) &t_TxOvhdMsgInfoInput, l_PriorityIndex);
         printf("P%d - QUEUE_FULL designator = 0x%x, msg_type = 0x%x, source = %d,msg_cnt %d, %d, %d\n",
            l_PriorityIndex, t_TxOvhdMsgInfoInput.uc_message_designator,
            t_TxOvhdMsgInfoInput.uc_message_type,
            t_TxOvhdMsgInfoInput.uc_Source,
            pt_TxHdlcControlInfo->uca_MsgTypeCount[0],
            pt_TxHdlcControlInfo->uca_MsgTypeCount[1],
            pt_TxHdlcControlInfo->uca_MsgTypeCount[2]);

         fprintf(gfp_hdlc_out, "P%d - QUEUE_FULL designator = 0x%x, msg_type = 0x%x, source = %d,msg_cnt %d, %d, %d\n",
            l_PriorityIndex, t_TxOvhdMsgInfoInput.uc_message_designator,
            t_TxOvhdMsgInfoInput.uc_message_type,
            t_TxOvhdMsgInfoInput.uc_Source,
            pt_TxHdlcControlInfo->uca_MsgTypeCount[0],
            pt_TxHdlcControlInfo->uca_MsgTypeCount[1],
            pt_TxHdlcControlInfo->uca_MsgTypeCount[2]);
#endif
#endif
         l_ReturnCode = HDLC_QUEUE_FULL;
      }
        pt_TxHdlcControlInfo->uc_Semaphore = FALSE;
      return(l_ReturnCode);

    }
    else
    {
#ifdef HDLC_QUEUE_LOGGING
#if 0
      QueuStatLog("QUEUE_BUSY",(TxOvhdMsgInfoStruct_t *) &t_TxOvhdMsgInfoInput, l_PriorityIndex);
#else
      printf("P%d - QUEUE_BUSY designator = 0x%x, msg_type = 0x%x, source = %d\n",
            l_PriorityIndex, t_TxOvhdMsgInfoInput.uc_message_designator,
            t_TxOvhdMsgInfoInput.uc_message_type,
            t_TxOvhdMsgInfoInput.uc_Source);

      fprintf(gfp_hdlc_out, "P%d - QUEUE_BUSY designator = 0x%x, msg_type = 0x%x, source = %d\n",
            l_PriorityIndex, t_TxOvhdMsgInfoInput.uc_message_designator,
            t_TxOvhdMsgInfoInput.uc_message_type,
            t_TxOvhdMsgInfoInput.uc_Source);
#endif
#endif

        return(HDLC_QUEUE_BUSY);
    }
}


