/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2008 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             UpdateFailure_bis.c
 * DESCRIPTION:      Functions that implement Tx PLAM
 *
 **********************************************************************/

// *********************************************************************************************************
// UpdateFailure_bis.c
//
// History
//
// 09/08/2011 Vinjam: Added code to trigger "OOS (Out of synchronization ( valid for PTM only))" defect.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 10/08/2011 Vinjam: Added code to declare "LOM" defect after 2.5 seconds.
//                    Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
// 04/07/2012 Anantha: Added code for declaring LCD, NCD fsilure after 2.5s and
//                termination of the same in 10s.
//          grep pattern XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
//
// 11/10/2013 Prashant: Modified the code for declaring LOM failure and triggering ReInit on LOM.
//                      LOM failure is declared after continious presence of LOM defect for 20 Sec.
//                      ReInit triggered after Programmable LOM_ReInit_Threshold i.e. DSL 30 1 (In Sec).
//                      LOM failure is cleared after 10 Sec. of absence of defect.
//                      (Refered MessageSpec VRX_FWMCAT_Rev2.3Internal.PDF)
//          Grep for XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit
//
//
// *********************************************************************************************************


#include "common.h"
#include "gdata.h"
#include "ib.h"
#include "cmv.h"
#include "plam.h"
#include "tx_plam.h"
#include "tx_plam_bis.h"
#include "const_bis.h"
#include "gdata_bis.h"
#include "data_alloc.h"

#ifdef DO_PLAM

// Imported the function UpdateFailure_bis() from tx_plam_bis.c
// Kannan, 01/06/2006

//===========================================================================
// [G.997.1] 7.2.4.1.1 Near-end HEC violation count (HEC-P)
//The near-end HEC_violation_count performance parameter is a count of the
// number of occurrences of a near-end HEC anomaly in the ATM Data Path.
// This has been defined in tx_plam_bis.c
// Kannan, 01/06/2006
//uint32 gula_hec_error_cnt[MAX_ATM_SIZE] = {0,0,0,0};
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//

//===========================================================================

DATA_MAP_BIS
FailureCount_t gt_NCD_BC0_neFailureCount;
FailureCount_t gt_NCD_BC1_neFailureCount;
FailureCount_t gt_LCD_BC0_neFailureCount;
FailureCount_t gt_LCD_BC1_neFailureCount;

DATA_MAP_END


/*****************************************************************************
;  Subroutine Name: void UpdateFailure_bis(void)
;
;; Prototype:
;     void UpdateFailure_bis(void)
;
;  Input Arguments:
;       none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
*******************************************************************************/

void UpdateFailure_bis(void)
{
   FlagT ft_generate_error = FALSE;
   /************************/
   /* Near end LOS failure */
   /************************/
   UpdateFailureInfo(gt_tx_Anomaly.uc_los_def , &gt_LOSneFailureCount, &gs_NearEndFailure,
               PLAM_LOS_FailureBit);

    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
   /************************/
   /* Near end LOM failure */
   /************************/
    gt_tx_Anomaly.uc_lom_def = TERMINATED;
    if ((gt_NearEndParam.s_SnrMargin < 0) ||
        (((gs_RxMinRequestedSTMargin << 8) < gs_RxDesiredMargin) && (gt_NearEndParam.s_SnrMargin < (gs_RxMinRequestedSTMargin << 1))))
            // Retrain if margin is too low (note: gs_RxMinRequestedSTMargin: Q16.0; gs_RxDesiredMargin: Q8.8; gt_NearEndParam.s_SnrMargin: Q15.1)
    {
       gt_tx_Anomaly.uc_lom_def = PRESENT;
    }

    UpdateFailureCounts(gt_tx_Anomaly.uc_lom_def, &gt_LOMneFailureCount);
    // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (StartEnd)
   if (gt_LOMneFailureCount.s_present == NUM_SFRAMES_20SEC)
      /* Update the PLAM CMV for LOM failure */
      gs_NearEndFailure |= PLAM_LOM_FailureBit;
    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)

    // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (Start)
   if(gt_ReInit_Threshold.s_LOM_ReInit_Threshold == 0)
       gt_ReInit_Threshold.s_LOM_ReInit_Threshold = 60;

   if (gt_LOMneFailureCount.s_present >= (NUM_SFRAMES_1SEC * gt_ReInit_Threshold.s_LOM_ReInit_Threshold))
      gft_TriggerLOMReInit = TRUE;
   else
        gft_TriggerLOMReInit = FALSE;
    // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (End)

   /************************/
   /* Near end LOF failure */
   /************************/

   UpdateFailureCounts(gt_tx_Anomaly.uc_sef_def, &gt_LOFneFailureCount);

   /* If no LOS defect/failure check for LOF failure */
   if (((gt_tx_Anomaly.uc_los_def != PRESENT) && ((gs_NearEndFailure & PLAM_LOS_FailureBit) == 0)))
   {
      if (gt_LOFneFailureCount.s_present == NUM_SFRAMES_2P5SEC)
         /* Update te PLAM CMV for LOF failure */
         gs_NearEndFailure |= PLAM_LOF_FailureBit;
   }


    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (Start)
    if (guca_DS_TransferMode_bis[0] == ATM)
    { //ATM Mode selected

      /***************/
      /* NCD Failure */
      /***************/
      UpdateFailureInfo(gt_tx_Anomaly.uc_ncd_anom[0], &gt_NCD_BC0_neFailureCount, &gs_NearEndFailure,
                  PLAM_NCD_BC0_FailureBit);
      // XDSLRTFW-1481 (Start_End)
      if (gs_NearEndFailure & PLAM_NCD_BC0_FailureBit)
      {
         gt_HercADSL_PLAMMap_g997_DataPathFailureStatus.s_LCD_NCD_Failure |= PLAM5_DATAPATH_NCD_NE_BC0;
      }


      UpdateFailureInfo(gt_tx_Anomaly.uc_ncd_anom[1], &gt_NCD_BC1_neFailureCount, &gs_NearEndFailure,
                  PLAM_NCD_BC1_FailureBit);
        // XDSLRTFW-1481 (Start_End)
      if (gs_NearEndFailure & PLAM_NCD_BC1_FailureBit)
      {
         gt_HercADSL_PLAMMap_g997_DataPathFailureStatus.s_LCD_NCD_Failure |= PLAM5_DATAPATH_NCD_NE_BC1;
      }

      /***************/
      /* LCD Failure */
      /***************/
      UpdateFailureInfo(gt_tx_Anomaly.uc_lcd_def[0], &gt_LCD_BC0_neFailureCount, &gs_NearEndFailure,
               PLAM_LCD_BC0_FailureBit);
      // XDSLRTFW-1481 (Start_End)
      if (gs_NearEndFailure & PLAM_LCD_BC0_FailureBit)
      {
         gt_HercADSL_PLAMMap_g997_DataPathFailureStatus.s_LCD_NCD_Failure |= PLAM5_DATAPATH_LCD_NE_BC0;
      }

      UpdateFailureInfo(gt_tx_Anomaly.uc_lcd_def[1], &gt_LCD_BC1_neFailureCount, &gs_NearEndFailure,
               PLAM_LCD_BC1_FailureBit);
      // XDSLRTFW-1481 (Start_End)
      if (gs_NearEndFailure & PLAM_LCD_BC0_FailureBit)
      {
         gt_HercADSL_PLAMMap_g997_DataPathFailureStatus.s_LCD_NCD_Failure |= PLAM5_DATAPATH_LCD_NE_BC1;
      }

    }
    else
    { //PTM mode selected
        //ReUsed "gt_LCD_BC0_neFailureCount" for "OOS defect" purpose
      UpdateFailureInfo(gt_tx_Anomaly.s_cd_flag[0], &gt_LCD_BC0_neFailureCount, &gs_NearEndFailure,
               PLAM_OOS_FailureBit);
      // XDSLRTFW-1481 (Start_End)
      if(gs_NearEndFailure & PLAM_OOS_FailureBit)
        {
            gt_HercADSL_PLAMMap_g997_DataPathFailureStatus.s_OOS_Failure |= PLAM5_DATAPATH_OOS_NE_BC0;
        }

    }
    //XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers (End)



   /*******   10 second counts for reseting the failures **********/


   /* Clear the failure counts to prevent overflow */
   InitializeFailureCountPresent(&gt_LOFneFailureCount, NUM_SFRAMES_2P5SEC);

   /* Terminate the failure bit if no defect for 10 seconds */
   TerminateFailureBit(&gt_LOFneFailureCount, &gs_NearEndFailure, PLAM_LOF_FailureBit, NUM_SFRAMES_10SEC);

   // XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (Start)
   /* Terminate the failure bit if no defect for 10 seconds */
   TerminateFailureBit(&gt_LOMneFailureCount, &gs_NearEndFailure, PLAM_LOM_FailureBit, NUM_SFRAMES_10SEC);
   //XDSLRTFW-1205 ENH_DS_ALL_ALL_LOMx_ReInit (End)


   /************ Check for line availability *************/
   if((gs_contiguous_bad_sec_cnt == 10)  && (gft_line_unavailable == FALSE))
   {
      /* If 10 consecutive seconds bad */
      /* Increment the total unavailable seconds count */
      gs_unavail_err_sec_cnt += gs_contiguous_bad_sec_cnt;
      gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt += gs_contiguous_bad_sec_cnt; // XDSLRTFW-1562

      /* Set flag for line unavailability */
      gft_line_unavailable = 1;

      /* Reset the counter to prevent overflow */
      gs_contiguous_bad_sec_cnt = 0;

   }
   else
   {
      if((gft_line_unavailable == TRUE)
         /* Check if line can be declared back available */
         &&(gs_contiguous_good_sec_cnt == 10))
      {
            /* If contiguous 10 good seconds, line is available */
            gft_line_unavailable = FALSE;

            /* The 10 good seconds are excluded from the unavailable line seconds */
            gs_unavail_err_sec_cnt -= gs_contiguous_good_sec_cnt;
            gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt -= gs_contiguous_good_sec_cnt; // XDSLRTFW-1562

            /* Reset the counter to prevent overflow */
            gs_contiguous_good_sec_cnt = 0;
      }

   }

}


#endif /* DO_PLAM */
