/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  rx_ib_ini_bis.c
*
*  Functions to initialize the ovhd functions
*
****************************************************************************/

// ****************************************************************************
// rx_ib_ini_bis.c
//
// History
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// ****************************************************************************

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "ovhd_bis.h"
#include "fifo.h"
#include "DSLEngin.h"

/*****************************************************************************
;  Subroutine Name: RxInitIb_bis(...)
;
;  This subroutine initializes the variables and structures required for
;   processing indicator bits and updating error counters
;
;  Prototype:
;     void RxInitIb_bis()
;
;  Input Arguments: none
;
;  Output Arguments:none
;
*******************************************************************************/

void RxInitIb_bis(void)
{
   int16 i;
   for ( i= 0; i< NUM_DATA_PATHS; i++)
   {
      gt_rx_Anomaly.ul_ffec_cnt[i] = 0;   /* Far end FEC error count */
      gt_rx_Anomaly.ul_fcrc_cnt[i] = 0;   /* Far end CRC error count */
   }

   for ( i= 0; i< NUM_US_BEARER_CHANNELS_SUPPORTED; i++)
   {
      gt_rx_Anomaly.ul_fhec_err_cnt[i] = 0;     /* Far end HEC error count */
      gt_rx_Anomaly.ul_ftot_hec_cell_cnt[i] = 0;   /* Far end total hec cell count */
      gt_rx_Anomaly.ul_ftot_cell_cnt[i] = 0;    /* Far end total cell count */

      gt_rx_Anomaly.uc_flcd_def[i] = TERMINATED;   /* Far end LCD Defect flag */

   }

   gt_rx_Anomaly.uc_ntr = 0;

   gt_rx_Anomaly.uc_flos_def = TERMINATED;  /* Far end LOS Defect flag */
   gt_rx_Anomaly.uc_fsef_def = TERMINATED;  /* Far end SEF Defect flag */
   gt_rx_Anomaly.uc_flpr_def = TERMINATED;  /* Far end LPR Defect flag */

   gt_rx_Anomaly.ul_ffec_err_sec = 0;     /* Far end FEC errored seconds count */
   gt_rx_Anomaly.ul_ferr_sec = 0;         /* Far end errored seconds count */
   gt_rx_Anomaly.ul_fsev_err_sec = 0;     /* Far end severely errored seconds count */
    gt_rx_Anomaly.ul_flos_err_sec = 0;    /* Far end LOS errored seconds count */
   gt_rx_Anomaly.ul_funavail_err_sec = 0;    /* Far end unavailable errored second count */

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      //gul_RETX_EFTR_min = (gt_ReTxConfigInfo.us_ndr)*1000; //bits/sec
      gul_RETX_EFTR_min = (gt_ReTxConfigInfo.us_ndr); //1kbits/sec
      gul_prev_EFTR = gul_RETX_EFTR_min;
      if(gt_ReTxConfigInfo.us_leftr_thresh != 0)
      {
         //LEFTR_THRESH = 0.01*gt_ReTxConfigInfo.us_leftr_thresh
         //considering gt_ReTxConfigInfo.us_ndr in kbps
         //ul_thresh = gt_ReTxConfigInfo.us_leftr_thresh
         //                *gt_ReTxConfigInfo.us_ndr*10;

         // us_etr is used in place of ndr and in 1kbps steps.
         // FEATURE_DS_BisPlus_ALL_ReTx_leftr_thresh Start
         // us_ndr in place of us_etr.
         gul_leftr_thresh = gt_ReTxConfigInfo.us_ndr;
         gul_leftr_thresh *= gt_ReTxConfigInfo.us_leftr_thresh;
         gul_leftr_thresh = gul_leftr_thresh /100;
         if(gul_leftr_thresh < (gt_ReTxConfigInfo.us_etr >> 1))
            gul_leftr_thresh = gt_ReTxConfigInfo.us_etr >> 1;

      }
      else  gul_leftr_thresh = (gt_ReTxConfigInfo.us_etr * 998)/1000;
      //FEATURE_DS_BisPlus_ALL_ReTx_leftr_thresh End

   }
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
}
