/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  rx_olr_decision.c
*
*
****************************************************************************/
// ******************************************************************
// rx_olr_decision.c
//
// History
//
// 06/08/10 Nihar: Added code to delay DS BitSwap
//       for all DSLAMs in DMT mode. Grep for the following
//       (i) IOP_DS_DMT_ALL_EnableDsBitSwap
//
// 26/07/10  Bhadra/Palaksha Murthy  Added fix against CNXT Cos.Link drops are
//           observed with some old CNXT DSLAMS in ADSL2/+ mode,if all tones are
//           loaded with 1bit(at some long loop fixed rate cases.
//          Solution is to force atleast to have one 2 bit tone.And also In these cases
//          disable the bitswap requests.
//          Grep for "IOP_ALL_BISPLus_CNXT_1bitConstellation" to check the changes.
//
// 12/08/2010 AdeelJ/Sriram/Bhadra: To use the existing SRA code for 1 step SRA based on CMV
//           INFO 103 20 bit mask 0x0001.The SRA step size is increased
//           to maximum if this cmv is set.
//             In this file we conditionally bypass framing check for one step SRA.
//             Grep for SMS01221899 Feature_DS_All_All_EnableOneStepSRA
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: IOP fix for SRA Upshift and Downshift not achieving the Target Margin.
//               Removed min margin Check so that SRA process Makes modem reach target margin.
//               Grep for SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix
//
// 17/08/2010 AdeelJ/Palaksha/bhadra: Modification of SRA Algorithm to make SRA Step more accurate and inclusion of
//               overshoot check for SRA DnShift.
//               removed external reference to Upshift Process as the variable is now declared in gdata.h
//               changed variable types of Upshift and DnShift process to global flag.
//               Grep for SMS00954738:Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep
//
// 17/08/2010 Kannan/Bhadra: IOP fix for Downstream Upshift SRA failure
//                    against  ISAM 7302 NALT-C  & Geminax.
//               Grep for SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA
//
// 18/08/2010 Shakil/Sriram/Bhadra :No DS BS and Streaming DS CRC errors when CPE Side DSL NEXT Noise raised to -40dBm/Hz
//               (ADSL2/ADSL2+).The changes are ported from AR7/UR8 CPE in BIS/2+ for bitswap interop.
//               Deleted the code changes with respect to gft_ctlm_bitswap_workaround set to 1.
//               Grep for SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR
//
// 18/08/2010 Shakil/Palaksha/Bhadra: Fix for "DS Bitswap against Conexant E67 based DSLAMs rejected".
//             Tests showed that bitwaps that involve 10 tones are time out by the Conexant E67 DSLAM.
//             In order to have a system that works fine in a field environment it is not acceptable
//             that DS bitswaps are rejected.So the number of tones involved in per Bitswap request
//             has to be limited to maximum of 4(all CNXT DSLAM's except  D57).
//          Grep for SMS01218543 IOP_AB_BisPlus_GSI_RestrictBitswapTonesTo4
//
// 18/08/2010 Shakil/Bhadra: Fix for Link drop in greece Bitswap test:
//             Restrict  the number of tones/request in bitswap to max of 2 tones/request
//             (ie.,gs_REDUCE_LP_DELTA_BITSWAP==1) against any non D57 (Against D57 it is 20)
//             CNXT DSLAMs instead of 4 as stated above "IOP_AB_BisPlus_GSI_RestrictBitswapTonesTo4"
//             Grep for SMS01225862 for the change
//
// 23/09/2011 Kannan: info 103 27 0x100  (if Bit d8 is enabled bypass 'gs_REDUCE_LP_DELTA_BITSWAP = 1'
//                for CNXT COs. i.e we use gs_REDUCE_LP_DELTA_BITSWAP = 20 (default) to do the bitswap faster
//                if CNXT CO supports Lp reduction of more than 1bit at a time in single bitswap request
//                Grep for XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
//
// 27/09/2011 Kannan: info 103 27 0x100  (if Bit d8 is enabled bypass 'gs_REDUCE_LP_DELTA_BITSWAP = 1'
//                for CNXT COs. i.e we use gs_REDUCE_LP_DELTA_BITSWAP = 20 (default) to do the bitswap faster
//                if CNXT CO supports Lp reduction of more than 1bit at a time in single bitswap request for
//                      Bis Mode ONLY.
//                      LpReduction Bits for Plus mode is configurable through CMV bits, Max Lp Reduction
//                      bits for Plus mode is 3 bits. Hence use the info 103 27 0x600 (Bit10 & 9) for
//                      Lp reduction configuration.
//                      But info 103 27 (Bit 10 & 9) is initialized with 1bit Lp reduction for Plus mode
//                      i.e info 103 27 0x200
//                Grep for XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI
//
// 16/08/2011 ChihWen/Bhadra  1. Finding a max delta Lp which fulfills the framing limitation during framing calculation.
//                            2. Cap the delta Lp with the max delta Lp before requesting SRA.
//                            3. Enabling chamber IOP bit (OPTN 25 bitmask(0x8000)) for FDQ/SNR adaptation.
//                            4. Enabling dynamic threshold for DEC adaptation.
//                            5. Masking the code of freezing PLL/SNR/FDQ adaptation since
//                               the noise boosting will be up to 27 dB
//                         Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRAInterleaved
//
// 04/07/2012 Ram: Merged "ReTx" Bitswap code from ARX ADSL code base.
//                 Grep for "XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx"
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
// 08/11/2012 Anantha: 1. Fix for noise level change during a given show time SNR measurment cycle
//                2. Adjusting number of bins from which bits are removed to increase SNR margin so that bitswap won't fail change is
//                effective only if min margin goes to negative.
//                3. Removing margin fudge from SNR required for bit loading (used for gain + bitswap) since in gain+ bit swap function
//                doesn't use fudge while calculating margin
//                4. Change is made to mark only tones in which either bits or gain is changed as bitswap tones
//                grep for XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
// 13/02/2013 Anantha: Added fix for sync drop while increasing noise level from 3 dB to 4 dB.
//                Issue was happening due to incosistency in the margin calculated.
//                Also seen ping pong of biswaps creating ugly margin curve which was resulting in
//                port drop during show time.
//                grep for XDSLRTFW-602:Enh_DS_ALL_ALL_BitSwap
//19-02-2013 Anantha: Removed number of bitswap change request restrication for CNXNT chipset with gs_CurrentCoVendorID == 0x10
//             to pass bitswap test with cnxnt stinger E.67.1.78
//             grep for XDSLRTFW-569: BugFix_DS_BisPlus_CNXNT_BitSwapNumToneInc
// 20/02/2013 Anantha:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//                XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
// 20/12/2012 Balabath : XDSLRTFW-1086 / ADSLRTFW-1611:Sync loss in FT BS Test
//    1) If RFI tone format (Noise File) didn't have BW inforamtion then RFI has effect on neighbour tones also.
//      RFI tone should have 0.0 0.0 in BW columns.Please check the jira entry for more details.
//    2) The reasons for link drop are FT reboot conditions (severe error seconds (30s), error seconds 90s)
//    The reasons for not doing the Bitswap (delayed Bitswap request) on the RFI applied tone (for example Tone 280) is
//    2.1)  Cap of min margin to -3dB, and number of bits to be removed from tones is  set to '1' for CNXT
//    2.2)  Search the tones from first loaded channel.
//    2.3)  Because of strong RFI, observed margin degradation of <-3dB on tones around 80. So, bits are swapped from these tones.
// Solution:
//    3) Remove the cap on minmargin tones, and change deltaLp to 4, otherwise RFI tests will fail.
// Other proposal (to be done):
//    4) If deltaLp is 1, try to do more than one Bitswap request per SNR update.
//    Revert back change of "XDSLRTFW-569"
//    Grep for XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap
//
// 06/11/2013 Balabath :XDSLRTFW-1313 XDSLRTFW-1208In TR105E testsuite SRA functional tests were failing.
// The problems are
// 1) Expected Result SRA_reported_margin_downshift_ds >= RA-DSNRM is not meeting
// Description: This is due to the Min message based overhead data rate requirement.
// As per the profile configured, MinDSOverheadRate is 6kbps, after framing params
// Message based Ovhd rate is 6.3 kbps only. This restricts Downshift SRA.
// Solution: Modift framing params calculation to come up with more DSOverheadRate
// for SRA profiles.
// 2) Upshift SRA triggered before reaching RA-USNRM.
// Description: These are because of the fixes added to reach target margin after
// downshift or upshift. But there are multiple bugs with this portion of code.
// 2.a)Upshift SRA triggered before reaching RA-USNRM
// 2.b)Not honouring RA-DTIMEus.
// 2.c)Not honouring RA-DTIMEds etc..
// 2.d) SRA triggers when BER test is undergoing.
// Solutions:Total algorithm needs to be modified. Changes include
// 2.a)Fix for Upshift SRA triggered before reaching RA-USNRM.
// 2.b)Consider parameter RA-DTIMEus.
// 2.c)Consider parameter RA-DTIMEds.
// 2.d)Reaching Target Margin moved under CMV control.
// CMV INFO 103 28 1(bitmask 0x1). By default this is disabled.
// (This will be enabled based on the customer requirement.)
// And if multiple SRAs are required to reach target margin,
// They will be issued within settling time (30s) and the process will be stopped
// after settling time. Otherwise SRA triggers are going to happen when BER process starts.
// 3) Other changes include introduction of new CMV bits.
// 3.a) CMV control for enable/disable framing constraint minoverhead rate conveyed in GHS.
// CMV INFO 103 28 2(bitmask # 0x0002 [CMV_SRA_TO_ENABLE_MINOVERHEAD_GHS_CHECK]).
// By default this is enabled.
// 3.b) CMV control for enable/disable framing constraint Maxdelay conveyed in GHS.
// CMV INFO 103 28 4(bitmask # 0x0004 [CMV_TO_ENABLE_SRA_MAXLATENCY_CHECK]).
// By default this is enabled.
// Note: For CNXT DSLAM this CMV will disabled internally in the code. With
// CNXT DSLAMs, OneOverS is limited to 3. This will have impact on delay constraint and NDR.
// Tests show that voilation of delay constraint works fine with CNXT based DSLAMs.
// To find code changes grep for
// XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges
// Downshift process and Upshift process introduced to reach close to target_margin +- 0.5dB
// There were some problems with FLEXIT2 TR-105 SRA cases
// FLEXIT stops if DnShift+UpShift is triggered during "gft_SRADnShift_process"
// So make sure only DnShifts will be allowed here during Downshift process.
// Grep for XDSLRTFW-1313 XDSLRTFW-1208 : BugFix_DS_BisPlus_All_TR105SRAChanges to see code changes
//
// 16/12/2017 Chih-Wen: XDSLRTFW-3612 XDSLRTFW-3658
//            Intermittent noise variation was seen in TR100A 24HDSL MV test at the moment when the noise was boosted.
//            When the variation happened, bitswap swapped bits to the wrong tones which resulted in lots of CRC and link drop.
//            To cope with this noise variation, delta bit number for bitswap was set to one.
//            Grep for XDSLRTFW_3612_TR100A_MV_24HDSL_NoiseBoostWorkaround XDSLRTFW_3658_TR100A_MV_24HDSL_NoiseBoostWorkaround
//
// *****************************************************************************
#include "typedef.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "rx_ovrhd_bis.h"
#include "gdata.h"
#include "dsp_op.h"
#include "cmv.h"
#include "showinit.h"
#include "dec_gain.h"
#include "const_bis.h"
#include "bitload_support.h"
#include "states.h"
#include "bitload_const.h"
#include "changebat.h"
#include "minmaxmargin.h"
#include "memory.h"
#include "bitload2.h"
#include "changebat.h"
#include "ovhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "stdlib.h"
#include "bitload_bis.h"
#include "memsetbf.h"

#ifdef DEBUG_FGLINSUMSQ
#include "decimalgain.h"
#include "mul.h"
#endif

#ifdef LEAVE_TRAIL
#include "trail.h"
#endif

#ifndef ISDN   // Only for Anx-A
// IOP_DS_DMT_ALL_EnableDsBitSwap
extern void Check_DsBitSwapTimeWindow(void);
#endif // ifndef ISDN

//SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (Start)
//hard coded gs_REDUCE_LP_DELTA_BITSWAP to 20 as in AR7 the maximum tones/ bitswap req = 20
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
int16 gs_REDUCE_LP_DELTA_BITSWAP = 120; //20
//XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
int16 gs_trail_bitswap = 0x7FFF;
//SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (End)
#ifdef DEBUG_FGLINSUMSQ
int16 bi, s_FGainLin;
int32 l_SumFGainLinSq_add, l_temp;
#endif
//SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (Start)
//int16 gft_ctlm_bitswap_workaround;
//SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (End)
/*****************************************************************************
;  Subroutine Name: Rx_OLR_Decision(...)
;
;  This subroutine checks if there is a request to initiate an OLR
;
;  Prototype:
;     void Rx_OLR_Decision(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;*****************************************************************************/
#define RX_OLR_NONE        0
#define RX_OLR_PERFORM     1
#define RX_OLR_ABORT    2
//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
#define     min(a,b) ((a)>(b) ? (b) : (a))
#define max(a,b)           ((a)>(b)?(a):(b))
extern int16 gsa_dsPrevSNRMargnPerBand[];
extern int16 gsa_dsPresentSNRMargnPerBand[];
extern int16 gs_lastLoadedBin;
extern uint32 gsa_RxBitSwap_Decision[16];

//XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)
void Rx_OLR_Decision(void)
{
   int16 s_RxOLRDecisionState;
   int i, j, s_retCode;
   int16 s_ch;
   FlagT ft_Result;
   int16 s_MinMarginBeforeSwap, s_delta_Lp, s_MinMarginAfterSwap,
      s_ActualDeltaSumLp;
   int32 l_sumLpDelta, l_MinMarginCheck;
   int16 s_MinToneMargin;
   int16 s_avgDiff = 0;
   int16 s_MarginDecision;
   int16 s_BitswapAcceptThr;
   gs_IncBitInBinReduced = 0;

   /* Check for a new OLR request */

   if (
#ifndef TARGET_HW
      (TESTArray[TEST_ReconfigControl] & TEST_TestBitswap) ||
#endif
      (TESTArray[TEST_ReconfigControl] & TEST_TestOLR) ||
      !(OPTNArray[OPTN_AlgControl] & OPTN_DSAutoBitSwapDisable))
   {

   /* Clear OLRStatus OLRError CMV */
   STATArray[STAT_OLRError_DS] = 0;
   STATArray[STAT_OLRStatus_DS] = 0;

   /* Check if in L0 State */
   if(gt_RxOLRPMVars.uc_rxOLRPMState != L0_STEADY_STATE)
   {
      //record error code and error status in OLR cmv
      STATArray[STAT_OLRError_DS] |= REQ_NOT_IN_L0_STATE;
      STATArray[STAT_OLRStatus_DS] |= STAT_OLRPM_ABORTED;

      /* Clear the test bits now */
      TESTArray[TEST_ReconfigControl] &= ~(TEST_TestBitswap | TEST_TestOLR);
      return;
   }

   /* All set to initiate a new OLR */

   /* Initialize variables */
   // set Rx OLR Decision State m/c, initial state
   s_RxOLRDecisionState = RX_OLR_NONE;
   // Clear OLR msg transmitted counter
   // we haven't considered retransmitted when time out happens yet
   gt_RxOLRPMVars.s_RequestReXmitCnt = 0;
   // misc
   s_retCode = 0;
   gt_OlrPm_TxOvhdMsgInfoInput.uc_Source = AUTO_CMD_SOURCE;

   // Copy current dB fine gains and associated metrics to a safe place
      memcpy(gsa_TempRxFineGains, gsa_RxFineGains,
             sizeof(int16) * gs_RxNumTones);

   gl_save_SumFGainLinSq =  gl_SumFGainLinSq;
   gl_save_SumGiSqTssiSq = gl_SumGiSqTssiSq;

#ifndef TARGET_HW
   if((TESTArray[TEST_ReconfigControl] & TEST_TestBitswap) != 0)
   {
      /* Clear the test bits now */
      TESTArray[TEST_ReconfigControl] &= ~TEST_TestBitswap;

      // set OLR msg type in cmv
      STATArray[STAT_OLRStatus_DS] = STAT_OLR_BITSWAP;

      uc_rx_sub_bin = (uint8)TESTArray[TEST_BitSwapFromTone];
      uc_rx_add_bin = (uint8)TESTArray[TEST_BitSwapToTone];

      /* Change the BAT Table based on bitswap */
      guca_RxBat[uc_rx_add_bin]++;
      guca_RxBat[uc_rx_sub_bin]--;

      /* Check for validity of bitswap request */
      // CMV based bitswap request needs to specify an add_bin
      // with < RX_MAX_BITS_PER_TONE bits and a sub_bin with > 2 bits
      if(guca_RxBat[uc_rx_add_bin] <= RX_MAX_BITS_PER_TONE && guca_RxBat[uc_rx_sub_bin] >= 2)
      {
         // update rx olr decision state
         s_RxOLRDecisionState = RX_OLR_PERFORM;
         // set OLR msg type in cmv
         gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type = BITSWAP_REQ;

         // Clear the bitfield that indicates the tones changed by the bitswap logic
         memset(guca_RxBitswapTones, 0, (sizeof(uint8)) * ((int16)(gs_RxNumTones>>3)));

         //Mark the tones that have changed
         guca_RxBitswapTones[(int16)uc_rx_add_bin/8] |= (uint8)(1 << ((int16)uc_rx_add_bin%8));
         guca_RxBitswapTones[(int16)uc_rx_sub_bin/8] |= (uint8)(1 << ((int16)uc_rx_sub_bin%8));
      }
      else
      {
         s_RxOLRDecisionState = RX_OLR_ABORT;
         //record error code in OLR cmv
         s_retCode = REQ_INVALID_BiGi;
      }
   }
   /* Check for DRR/SRA request */
   else if((TESTArray[TEST_ReconfigControl] & TEST_TestOLR) != 0)
#else
   /* Check for DRR/SRA request */
   if((TESTArray[TEST_ReconfigControl] & TEST_TestOLR) != 0)
#endif
   {
#ifdef LEAVE_TRAIL
      for (i = 0; i < NUM_DATA_PATHS; i++)
      {
         gs_trail_deltaLp[i] = TESTArray[i+TEST_OLR_Lp0Delta];
         gs_trail_deltaBpn[i] = TESTArray[i+TEST_OLR_BC0Delta];
      }
#endif
      /* Clear the test bits now */
      TESTArray[TEST_ReconfigControl] &= ~TEST_TestOLR;

         if (TESTArray[TEST_OLR_Lp0Delta] || TESTArray[TEST_OLR_Lp1Delta] ||
             TESTArray[TEST_OLR_BC0Delta] || TESTArray[TEST_OLR_BC1Delta])
      {
         //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
         gs_OlrReq = SRA_REQ;
            l_sumLpDelta =
               (int32) (TESTArray[TEST_OLR_Lp0Delta] +
                        TESTArray[TEST_OLR_Lp1Delta]);
         if (l_sumLpDelta <= 0)
            l_MinMarginCheck = NEG_INFINITY_DB;
         else
            l_MinMarginCheck = gs_RxDesiredMargin;

         /* if summation Lp changed ==> SRA */
         if(l_sumLpDelta != 0)
         {
            STATArray[STAT_OLRStatus_DS] |= STAT_OLR_SRA;
            gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type = SRA_REQ;
            if (gt_rx_config.s_Nlp > 1)
            {
               // update rx olr decision state
               s_RxOLRDecisionState = RX_OLR_ABORT;
               s_retCode = RESP_NOT_SUPPORTED;
            }
         }
         else
         {  /* else assume DRR */
            STATArray[STAT_OLRStatus_DS] |= STAT_OLR_DRR;
            gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type = DRR_REQ;
         }

         /* Check if any requested Lp changes are valid */
            if ((s_RxOLRDecisionState != RX_OLR_ABORT) &&
                isLpReconfigValid(TESTArray + TEST_OLR_Lp0Delta, &gt_rx_config,
                                  (int16 *)(void *)&s_retCode,TRUE)
               /* Check if any requested Bpn changes are valid */
                &&
                (isBpnReconfigValid
                  (TESTArray + TEST_OLR_BC0Delta, (int8 *)(void *)guca_rxBCnToLPp,
                     gft_RxBpnReconfigAllowed, &gt_rx_config, TRUE,
                     (int16 *)(void *)&s_retCode))
               /* Check if we have valid framing configuration and meet all constraints */
               /* Turn off ovhd rate and max latency verification for time being to not wreck explicit rate tests */
               /* isValidFramingConfiguration seems to be always retruns true if deltaBC0 is 0*/
               // Bypass framing checks are handled in ComputeFramingConstraints()
               &&(isValidFramingConfiguration(&gt_rx_config, guca_rxBCnToLPp, &gt_DerivedFrameProperties_DS,
                  TESTArray+TEST_OLR_Lp0Delta, TESTArray+TEST_OLR_BC0Delta, (int16 *)(void *)&s_retCode))

               && (CalcNewBATGains((int16)l_sumLpDelta, (int16)l_MinMarginCheck, (int16 *)(void *)&s_retCode)))
            {

            // update rx olr decision state
            s_RxOLRDecisionState = RX_OLR_PERFORM;

            /* Lp/Bpn changes valid -- update firmware variables */
            for(i = 0; i < gt_rx_config.s_Nlp; i++)
            {
               gt_rx_config.s_Lp[i] += TESTArray[i+TEST_OLR_Lp0Delta];
            }
            for (j = 0; j < gt_rx_config.s_Nbc; j++)
            {
               i = guca_rxBCnToLPp[j];

               gt_rx_config.sa_Bpn[i][j] += TESTArray[j+TEST_OLR_BC0Delta];
            }
         }
         else
         {
            // update rx olr decision state
            s_RxOLRDecisionState = RX_OLR_ABORT;

            if (gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type == SRA_REQ)
            {
                  if ((s_retCode & REQ_VIOLATE_MAXLConstraint) ==
                      REQ_VIOLATE_MAXLConstraint)
                  STATArray[STAT_Misc] |= STAT_DSSRA_UPSHIFT_BLOCKED;
               else if ((s_retCode & REQ_VIOLATE_MINLConstraint) == REQ_VIOLATE_MINLConstraint)//s_LpTemp < s_MinLp
                  STATArray[STAT_Misc] |= STAT_DSSRA_DNSHIFT_BLOCKED;
            }
         }
      }
         //SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA (Start)
         //Clear it after the completion of Upshift SRA.
         gft_AllowUpshiftSRA = FALSE;
         //SMS00900615 IOP_DS_BISPLus_ALL_AllowUpshiftSRA (End)

   }/* end of DRR/SRA */
   else if(!(OPTNArray[OPTN_AlgControl] & OPTN_DSAutoBitSwapDisable))
   {
      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
      gs_OlrReq = BITSWAP_REQ;
   /* Total length of the tx overhead message is limited to MAX_TX_HDLC_MSG_SIZE, so currently limit the value of deltaLp
   here, which decides the number of bitswaptones; and themessage length. Limit it to be max MAX_TX_HDLC_MSG_SIZE;
   BIS needs MAX_TX_HDLC_MSG_SIZE/3 max tones; while plus is MAX_TX_HDLC_MSG_SIZE/4 ; Assuming worst case scenario that +/- 1 bit can change 2 tones
   and in the worst scenario 2 more tones due to TCM overhead change, set
   max limit for bis would be MAX_TX_HDLC_MSG_SIZE/(2*6), plus MAX_TX_HDLC_MSG_SIZE/(2*8) */

      //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
      if ((gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_FAST_BITSWAP) == 0)
        gs_REDUCE_LP_DELTA_BITSWAP = 20;
      else
        gs_REDUCE_LP_DELTA_BITSWAP = 120;
      //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)

      if (( gl_SelectedMode & (MODE_G992_5)  ))
         s_delta_Lp = MAX_TX_HDLC_BUFFER_SIZE/16 - 10 ;
      else
         s_delta_Lp = MAX_TX_HDLC_BUFFER_SIZE/12 - 10 ;

      if (s_delta_Lp < gs_REDUCE_LP_DELTA_BITSWAP) gs_REDUCE_LP_DELTA_BITSWAP = s_delta_Lp;

      if (OPTNArray[OPTN_OLRControl_DS] & OPTN_ForceDSAutoBitswap_ADSL2)
      {
         // reduce both trigger and accept thresholds
         gs_BITSWAP_TRIGGER_DELTA = 0;
         gs_Bitswap_Accept_Delta = 0;
      }

         // Fn call Just moved ahead
         //Determine the smallest margin tone from medley set from 1 bit tones to 15 bit tones
         FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat,
                                   gsa_RxFineGains, gsa_RxShowtimeSnrBuf,
                                   p_MEDLEYset_DS,
                                   gs_RxMinBitsPerTone_BIS_TCM,
                                   (int16) guc_MaxAllocBitsPerTone, &s_ch,
                                   &s_MinMarginBeforeSwap);

         gsa_RxBitSwap_Before[guc_log_idx] = (uint32)((s_ch <<16)|s_MinMarginBeforeSwap);
         // Check if a bitswap needs to be carried out
         // Determine the minimum margin on any tone
         // SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (Start)
         if (gl_SelectedMode & (MODE_ADSL2))
         {
            //XDSLRTFW_3612_TR100A_MV_24HDSL_NoiseBoostWorkaround_START
            //XDSLRTFW_3658_TR100A_MV_24HDSL_NoiseBoostWorkaround_START
            //Intermittent noise variation was seen in TR100A 24HDSL MV test at the moment when the noise was boosted.
            //When the variation happened, bitswap swapped bits to the wrong tones which resulted in lots of CRC and link drop.
            //To cope with this noise variation, delta bit number for bitswap is set to one.
            #ifndef ISDN
            if (gft_24HDSLNoise == TRUE)
            {
               gs_REDUCE_LP_DELTA_BITSWAP = 1;
            }
            #endif
            //XDSLRTFW_3658_TR100A_MV_24HDSL_NoiseBoostWorkaround_END
            //XDSLRTFW_3612_TR100A_MV_24HDSL_NoiseBoostWorkaround_END

            if (gs_CurrentCoChipset == CTLM_CO_CHIPSET)
            {
                   //For CTLM restrict the bitswap for bis/plus to max 1 tone/request
               gs_REDUCE_LP_DELTA_BITSWAP = 1;
            }
            //If CO is CNXT but not D57 then restrict the bitswap to maximum 10 tones/request
            else if ((gs_CurrentCoChipset == GSI_CO_CHIPSET) && (gs_CurrentCoVendorID != 0x0b))
            {
               //SMS01218543 IOP_AB_BisPlus_GSI_RestrictBitswapTonesTo4 (START_END)
               //For other CNXT except D57 restrict the bitswap for bis/plus to max 4 tones/request
               // SMS01225862:- restrict the tones/request count, max to 2 for any non D57 CNXT DSLAMs( Start)
               //XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (START)
               //info 103 27 0x100  (if Bit d8 is enabled bypass 'gs_REDUCE_LP_DELTA_BITSWAP = 1'
               //for CNXT COs. i.e we use gs_REDUCE_LP_DELTA_BITSWAP = 20 (default) to do the bitswap faster
               //if CNXT CO supports Lp reduction of more than 1bit at a time in single bitswap request.
               if (gl_SelectedMode & (MODE_G992_3))
               {
                  if ((gt_INFX_CMV.us_OperatorSpBits5 & CMV_TO_BYPASS_Bis_1bit_LpReduction_CNXT) == 0)
                  {
                     gs_REDUCE_LP_DELTA_BITSWAP = 1;  // was 3 before
                  }
               }
               else if (gl_SelectedMode & (MODE_G992_5))
               {
                  int16 s_temp = (gt_INFX_CMV.us_OperatorSpBits5 & CMV_For_2Plus_LpReduction_CNXT) >> 9;
                  if (s_temp >= 2)
                  {
                     gs_REDUCE_LP_DELTA_BITSWAP = s_temp; //LpBit Reduction 2 & 3
                  } else
                  {
                     gs_REDUCE_LP_DELTA_BITSWAP = 1;  // LpBit Reduction 1, use 1bit even though the config is "0" bits
                  }
               }
               else
               {
                  gs_REDUCE_LP_DELTA_BITSWAP = 1;  // was 3 before
               }
               //XDSLRTFW-332 IOP_A_DS_BisPlus_CNXT_BitswapDuetoRFI (END)
               // this value == '1' indicates: subtract maximum 1 bit from one tone and
               // add that bit to another tone, giving 2 tones/request.

               // SMS01225862:-restrict the tones/request count, max to 2 for any non D57 CNXT DSLAMs(End)
               //XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap (start)
               // For strong RFI we may need to do more than 2 bits to be swapped.
               // other wise Reboot indication because of consecutive sev. error seconds
               // In strong RFI (-50dBm/Hz)cases margin falls to around -37dBm/Hz.
               if((s_MinMarginBeforeSwap < 0) &&(guca_RxBat[s_ch]>1))
               {
                  gs_REDUCE_LP_DELTA_BITSWAP = 4;
                  gft_CNXT_RFI_BS = TRUE;
               }
               else
                  gft_CNXT_RFI_BS = FALSE;
               //XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap (end)

            }
         }
         //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (End)

         //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (Start)
         //Deleted the routine for FindToneWithExtremeMargin ( gs_RxMinBitsPerTone_BIS_TCM + 2)
         //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (End)



         //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
         // Logic to check upShift or DownShift of MinToneMargin during BitSwap.
         if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
         {
            if((gs_RxAvMargin >= (gs_RxDesiredMargin))
               &&(s_MinMarginBeforeSwap < gs_RxDesiredMargin)&& (gft_BitSwapUp == 1))
            {
               gft_BitSwapUp = 1;
               gft_BitSwapDown = 0;
               gs_target_margin += gs_delta_step;
               if(gs_target_margin > gs_RxDesiredMargin)
               {
                  gs_target_margin = gs_RxDesiredMargin;
                   gft_BitSwapUp = 0;
               }
            }

            else if((s_MinMarginBeforeSwap <
            gs_RxDesiredMargin - gs_BITSWAP_TRIGGER_DELTA) ||
            (s_MinMarginBeforeSwap < 512))
            {
               gft_BitSwapDown = 1;
               gs_target_margin = (gs_RxDesiredMargin - gs_BITSWAP_TRIGGER_DELTA)
                                    + gs_delta_step;
               // If avrage margin is around 3dB then try with 3dB(768=>0x300)
               if((gs_target_margin > gs_RxAvMargin) && (gs_RxAvMargin > 768) )
                  gs_target_margin = 768;

               gft_BitSwapUp = 0;
            }
         }
         //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)

      // AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation (Start)
#ifndef ISDN   // Only for Anx-A
      if (!gs_ChIdx_1bitTo2bit)
      {
#endif // ifndef ISDN
        // AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation (End)

      // Explore bitswap in case minimum margin is  below the desired margin by bitswap trigger delta or if it is below 2 dB

      //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
      //Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered
      //when minimum margin is below 0 dB. In the case when margin on tones were ever dropped
      //to below -6 dB, gs_BITSWAP_TRIGGER_DELTA is set to gs_RxDesiredMargin, and
      //gs_BITSWAP_TRIGGER is 0x0000. Otherwise, gs_BITSWAP_TRIGGER_DELTA is 0x0300,
      //and gs_BITSWAP_TRIGGER is 0x0200.

      //For ReTx do not change the value of gs_BITSWAP_TRIGGER, keep always 512.
      if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {
         gs_BITSWAP_TRIGGER = 512;
      }
    //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
   //Input of the bit-swap scheme, per-bin margin, is calculated by averaging noise power over downstream band;
   // by dividing band into sub bands of predefined size. The averaging is done sequentially one sub-band after other.
   //In stress test and margin test noise level is increased at once or gradually based on the test specification.
   //If noise power averaging is not completed fully (most of the times the case will occur) some sub-bands have margin
   // which is computed before changing noise level and other sub-bands will have noise power after changing noise level.
   //If number of frames used for averaging is large enough variation in average margin will be very low for all
   // practical purpose we average noise power won't vary more than 0.2dB. If difference between present average margin
   //and previously calculated average margin by more than 0.5dB one can infer that noise in the present run is changed
   //and don't run bit-swap scheme over the per-bin margin. Similarly if difference between minimum per-bin margin calculated
   //over downstream band varies from previous calculated minimum per-bin margin more than 3dB don't run bit-swap scheme over the per-bin margin
   if(!TESTArray[Test_DisableBitSwapImprvmnt])
     {
         int16 s_maxIndex = 0;
         int16 s_count = 0;

         getPerBandAvgMargin(guca_RxBat,
                        gsa_RxFineGains,
                        gsa_RxShowtimeSnrBuf,
                        p_MEDLEYset_DS);

         s_maxIndex = (gs_RxLastChannel - gs_lastLoadedBin)/gs_DD_RxChannelsPerSymbol;

         for(i=0; i < s_maxIndex; i++) {
            if(abs(gsa_dsPrevSNRMargnPerBand[i] - gsa_dsPresentSNRMargnPerBand[i])>0x80) {
               s_avgDiff = 0x100;
               break;
            }
         }

         for(; i < s_maxIndex; i++) {
            if(abs(gsa_dsPrevSNRMargnPerBand[i] - gsa_dsPresentSNRMargnPerBand[i])<0x80) {
               s_avgDiff = 0;
               break;
            }
         }

         for(i=0; i < s_maxIndex; i++) {
            gsa_dsPrevSNRMargnPerBand[i] = gsa_dsPresentSNRMargnPerBand[i];
         }


         if(s_avgDiff < 0x100) {
               s_avgDiff  = (gs_RxAvMargin - gs_RxPrevAvgMargin);
               if(s_avgDiff < 0) {
                  s_avgDiff = -s_avgDiff;
               }
         }
   }
     else
     {
         s_avgDiff = 0;
   }
     s_MarginDecision = gs_RxDesiredMargin - gs_BITSWAP_TRIGGER_DELTA;

     if(gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_ST_Changes)
     {
         gs_BITSWAP_TRIGGER = 0x0080; // or min margin less than 0.5dB
         // Modified "gs_MinTargetSnrMargin" from 3dB to "(gs_RxAvgMargin-0x0080)" dB
         gs_MinTargetSnrMargin = MIN((gs_RxDesiredMargin - 0x0100),(gs_RxAvMargin-0x0080));
         gs_MinTargetSnrMargin = (gs_MinTargetSnrMargin) & 0xFFE0; // floor it to nearest 0.125dB
         if(gt_HercADSL_OPTNMap_MarginControl.s_BitSwapThr > 0x0000)
            gs_MinTargetSnrMargin = gt_HercADSL_OPTNMap_MarginControl.s_BitSwapThr;
         // if Min Margin is less than (gs_RxAvMargin-2.5dB)
         s_MarginDecision = MAX((gs_MinTargetSnrMargin -0x0200),0x0000);
         s_avgDiff = 0;

     }

      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)
      if (((s_MinMarginBeforeSwap < s_MarginDecision) ||
         (s_MinMarginBeforeSwap < gs_BITSWAP_TRIGGER) ||
      //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
         ((OPTNArray[OPTN_OLRControl_DS] & OPTN_EnableAutoSRA) &&
         (gft_AutoSRA_ErrorCondition == FALSE) &&
         (gs_RxAvMargin >= gt_RCMsgs1_bis.us_RA_USNRMds) &&
         (s_MinMarginBeforeSwap < gs_RxDesiredMargin) &&
           //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
           (gt_ReTxConfigInfo.ft_ReTxOn == 0)) ||
          ((gt_ReTxConfigInfo.ft_ReTxOn == 1) &&
           (gs_RxAvMargin >= (gs_RxDesiredMargin)) &&
           (s_MinMarginBeforeSwap < gs_RxDesiredMargin)&&
           (gft_BitSwapUp == 1))) && (s_avgDiff < 0xC0)
           //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)
         )
      {
         gsa_RxBitSwap_Decision[guc_log_idx] = (uint32)((gs_BITSWAP_TRIGGER <<16)|s_MarginDecision);

         // set OLR msg type in cmv
         STATArray[STAT_OLRStatus_DS] = STAT_OLR_BITSWAP;
      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
      if(!TESTArray[Test_DisableBitSwapImprvmnt])
            gft_BitloadOK = FAIL;


         // clear RxBitSwapTones
         memset(guca_RxBitswapTones, 0,
                (sizeof(uint8)) * ((int16) (gs_RxNumTones >> 3)));
      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
      //store BAT before bitswap which will be used to mark tones in which bins bitswaps
      //are done at the end of scheme
      memcpy(guca_RxBat_Before_BS, guca_RxBat,
         sizeof(uint8) * gs_RxNumTones);

         //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
         if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
         {

            gft_Bitswap_UreTX = 1;

            gft_BitloadOK = FAIL;

            gft_BitloadOK = ReTx_PreBitSwapProcessing(gs_target_margin);
            gft_Bitswap_UreTX = 0;
            // cannot converge with high margin stop upShift.
            if ((gft_BitloadOK == FAIL) && (gft_BitSwapUp == 1) )
            {
                gft_BitSwapUp = 0;
            }


            if (gft_BitloadOK == SUCCEED)
            {

                FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat,
                    gsa_RxFineGains, gsa_RxShowtimeSnrBuf,
                    p_MEDLEYset_DS,
                    gs_RxMinBitsPerTone_BIS_TCM,
                    (int16) guc_MaxAllocBitsPerTone, &s_ch,
                    &s_MinMarginAfterSwap);

               if(s_MinMarginAfterSwap > s_MinMarginBeforeSwap)
                  VerifyAndUpdateRxQAMParameters();
               else gft_BitloadOK = FAIL;

            }
            if (gft_BitloadOK == SUCCEED)
            {
               for (i =0;i < gs_RxNumTones;i++)
               {
                  if((guca_RxBat[i] != guca_RxBat_Before_BS[i]) ||
                     (gsa_RxFineGains[i] != gsa_TempRxFineGains[i]))
                        SETTONEFLAG(guca_RxBitswapTones, i);
               }


            // If avg margin after bitload is greater than Desired margin+delta(0.5dB)
            // Try upshift.
               if((gs_RxAvMargin >= (gs_target_margin + (gs_delta_step << 1)))
                  && (gft_BitSwapDown == 1)
                 )
                     gft_BitSwapUp = 1;

               //dbg_Bitswap_cnt++;

            }

         }//if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
         else
         {
         //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)
      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
      //mark tones which having margin between min margin and min margin + delta
            if(!TESTArray[Test_DisableBitSwapImprvmnt])
            {
                  getBinsHavingMargnBtwenMinAndPlusDelta(guca_RxBat,
                                          gsa_RxFineGains,
                                          gsa_RxShowtimeSnrBuf,
                                          p_MEDLEYset_DS,
                                          s_MinMarginBeforeSwap,
                                          gs_Bitswap_Accept_Delta,
                                          gs_RxMinBitsPerTone_BIS_TCM,
                                          (int16) guc_MaxAllocBitsPerTone);
            }
            //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
            //changing min margin threshold after swap to minimum of (average margin - 1dB)
            //and (target margin -1dB)
            if(!TESTArray[Test_DisableBitSwapImprvmnt])
            {
               //XDSLRTFW-602:Enh_DS_ALL_ALL_BitSwap (start_end)
               s_MinToneMargin = min((gs_RxAvMargin-0x180),(gs_RxDesiredMargin-0x100));
            }
            else
            {
               s_MinToneMargin = gs_RxDesiredMargin - 0x0100;
            }
            if(gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_ST_Changes)
            {
               s_MinToneMargin = gs_MinTargetSnrMargin;
            }
            // reduce Lp by a fixed value
            s_delta_Lp = -gs_REDUCE_LP_DELTA_BITSWAP;
            //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (Start)
            // The first flag "ft_StopAtMarginThreshold = TRUE" ensures to break the algorithm as soon as the minimum
            //margin after bit removal equals or better than gs_RxDesiredMargin - 0x0100.The second flag "ft_NotforceEven1Bit = 1"
            //means there would not be forced even number of 1 bit constelletation -> it is done finally after the bits are added.
            //The 3rd flag "ft_AddfineGainplusdeltaLp = 0" means no fine gain changed for the deltaLp change

            // change bat by reducing Lp by s_delta_Lp;
            ft_Result =
                  ChangeLpKeepMaxMargin(guca_RxBat, gsa_RxFineGains, s_delta_Lp,
                                        gsa_RxShowtimeSnrBuf,
                              s_MinToneMargin,
                                        p_MEDLEYset_DS, guca_RxBitswapTones,
                                        &s_ActualDeltaSumLp, TRUE, 1, 0);
            //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (End)

            // Take the ActualDeltaSumLp which were reduced, as the bits to add back, this could be different compared
            // to gs_REDUCE_LP_DELTA_BITSWAP
         //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
         // moving statement which was present above ChangeLpKeepMaxMargin function call
         // to use s_MinToneMargin variable
            s_MinToneMargin = s_MinMarginBeforeSwap + gs_Bitswap_Accept_Delta;
            if(gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_ST_Changes)
            {
               s_MinToneMargin = gs_MinTargetSnrMargin;
            }
            s_delta_Lp = - s_ActualDeltaSumLp;

            //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (Start)
            //To add bits the condition Maximum margin in the spectrum > s_MinToneMargin must satisfy -> otherwise return with error
            //Also the second flag "ft_NotforceEven1Bit=0" this time to ensure even number of 1 bit tones
            //No fine gain changes

            ft_Result =
            ChangeLpKeepMaxMargin(guca_RxBat, gsa_RxFineGains, s_delta_Lp,
                                  gsa_RxShowtimeSnrBuf, s_MinToneMargin,
                                  p_MEDLEYset_DS, guca_RxBitswapTones,
                                  &s_ActualDeltaSumLp, TRUE, 0, 0);
            //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (End)

            //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
            //If bitswap is failed, checking of the tones whose margin were ever below
            //-6 dB will be ignored. Then bitswap will be tried again.
            if ((ft_Result != 0) &&
                (gft_TonesWithStrongNoise == TRUE) &&
                (gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_BITSWAP_EVACUATION))
            {
               MemSetBuffer((int16 *)(void *)guca_TimeVaryNoise_Ind_sav, 0, 0, 64);
               s_delta_Lp -= s_ActualDeltaSumLp;
               ft_Result = ChangeLpKeepMaxMargin(guca_RxBat, gsa_RxFineGains, s_delta_Lp,
                                                 gsa_RxShowtimeSnrBuf, s_MinToneMargin,
                                                 p_MEDLEYset_DS, guca_RxBitswapTones,
                                                 &s_ActualDeltaSumLp, TRUE, 0, 0);
            }
            //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)

            if ((ft_Result !=0) && (gft_FineGainOn))
            {
               // use fine gains to add remainder of the bits
               s_delta_Lp -=s_ActualDeltaSumLp;
            //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
            //removing margin fudge
               for(i = 0; i <= guc_MaxAllocBitsPerTone; i++)
               {
                  if(!TESTArray[Test_DisableBitSwapImprvmnt])
                  {
                        gsa_SNRRequired[i] = gsa_ConstellationSNR[i] + s_MinToneMargin;
                  }
                  else
                  {
                     gsa_SNRRequired[i] = gsa_ConstellationSNR[i] + s_MinToneMargin - OPTNArray[OPTN_MarginDelta];
                  }
               }
               //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (Start)
               //Change fine gains to add the remaining bits-> modify the fine gains here. Must check this function!!!
               ft_Result =
                  ChangeLpKeepMaxMargin(guca_RxBat, gsa_RxFineGains,
                                        s_delta_Lp, gsa_RxShowtimeSnrBuf,
                                        s_MinToneMargin, p_MEDLEYset_DS,
                                        guca_RxBitswapTones,
                                        &s_ActualDeltaSumLp, TRUE, 0, 1);
               //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (End)

            }
         //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
         //Bit-swap scheme mentioned above first reduces bits to increase per-bin margin and then
         //increments bits in bins to componsate decrement. Bit increment and decrement are done independently.
         //It may not possible to swap all the bits which are reduced. This leads to bit-swap failure.
         //To solve the problem reduce number of tones from which bits are reduced
            if ((ft_Result !=0) && (!TESTArray[Test_DisableBitSwapImprvmnt]))
            {
               s_delta_Lp -=s_ActualDeltaSumLp;
            gs_IncBitInBinReduced = 1;

               ft_Result =
                  ChangeLpKeepMaxMargin(guca_RxBat, gsa_RxFineGains,
                                        s_delta_Lp, gsa_RxShowtimeSnrBuf,
                                        s_MinMarginBeforeSwap, p_MEDLEYset_DS,
                                        guca_RxBitswapTones,
                                        &s_ActualDeltaSumLp, TRUE, 0, 0);
            gs_IncBitInBinReduced = 0;
            }
            memset(guca_RxBitswapTones, 0,(sizeof(uint8)) * ((int16) (gs_RxNumTones >> 3)));
            //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)
            if (ft_Result ==0)
            {
               //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
               int16 s_tempVal;
               s_tempVal = 0;
               //Mark the tones, as bits swap tone, in which bits or gain is changed
               for (i =0;i < gs_RxNumTones;i++)
               {
                  if((guca_RxBat[i] != guca_RxBat_Before_BS[i]) ||
                     (gsa_RxFineGains[i] != gsa_TempRxFineGains[i]))
                  {
                        SETTONEFLAG(guca_RxBitswapTones, i);
                        s_tempVal = 1;
                  }
               }
            //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)
               if (gft_FineGainOn)
                     DistributeFineGains(guca_RxBat, gsa_RxFineGains,
                          gsa_RxShowtimeSnrBuf, guca_RxBitswapTones,
                          (int16 *)(void *)&gus_ncloaded, &gl_SumFGainLinSq,
                          &gl_SumGiSqTssiSq);

               // addition of s_Lp_delta was ok
               // detemine margin now
               //SMS00963651 SMS00795020 IOP_AB_BisPlus_CTLM_GSI_ImprovedBitSwap_SNR (Start_End)
               //Modified the Input argument p_MEDLEYset_DS( deleted) instead of guca_RxBitswapTones
               FindToneWithExtremeMargin(SMALLEST_MARGIN, guca_RxBat,
                                         gsa_RxFineGains, gsa_RxShowtimeSnrBuf,
                                         guca_RxBitswapTones,
                                         gs_RxMinBitsPerTone_BIS_TCM,
                                         (int16) guc_MaxAllocBitsPerTone, &s_ch,
                                         &s_MinMarginAfterSwap);
               gsa_RxBitSwap_After[guc_log_idx] = (uint32)((s_ch <<16)|s_MinMarginAfterSwap);
               /* ========================================================================= */
               /* Verify if frame size matches to bit allocation table (DMT/BIS Showtime,OLR,L2)*/
               /* Also computes parameters for Rx QAM/TCM block configuration*/
               /* ========================================================================= */
               VerifyAndUpdateRxQAMParameters();
               //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
               if(!(gft_BitloadOK && s_tempVal) &&
                        (!TESTArray[Test_DisableBitSwapImprvmnt]))
               {
                  gft_BitloadOK = FAIL;
               }

#ifdef BITSWAP_DEBUG
               if (gft_BitloadOK == 0) gft_debug_AbortOLR++;
#endif
            }
            else
            {
               // in case +deltaLp is a failure,we need to read Bat from hardware
               // set min margins before and after swap in such a way that Bat is read from hardware.
               s_MinMarginBeforeSwap = 1 ;
               s_MinMarginAfterSwap = s_MinMarginBeforeSwap - 1;
            }

         //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
         }

         //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)
         s_BitswapAcceptThr = s_MinMarginBeforeSwap + gs_Bitswap_Accept_Delta;
         if(gt_HercADSL_OPTNMap_MarginControl.us_NMS_Ctrl & OPTN_NoiseMarginChange_NM_Ctrl_NMS_ST_Changes)
         {
            s_BitswapAcceptThr = s_MinMarginBeforeSwap;
         }
         // Check if margin is better after Swap, initiate a bitswap
         //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
         //if min margin is negative and bits are changed in at least one tone allow bit swap to continue
         if ((((s_MinMarginAfterSwap >= s_BitswapAcceptThr)
                 ||((s_MinMarginBeforeSwap < 0) &&(gs_RxAvMargin < 2*256) &&
                  (s_MinMarginAfterSwap >=s_MinMarginBeforeSwap + 0x80)&&
                  (!TESTArray[Test_DisableBitSwapImprvmnt]))
               ) &&(gft_BitloadOK == 1)
                  &&(gt_ReTxConfigInfo.ft_ReTxOn == 0)
            )
            ||((gt_ReTxConfigInfo.ft_ReTxOn == 1) &&
                  (gft_BitloadOK == SUCCEED))
            )
            //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)
            {
               gsa_SNR_update_cnt[guc_log_idx] = gus_ShowtimeSNRUpdateCount;
               guc_log_idx = (guc_log_idx+1)&0xf;
               // update rx olr decision state
            s_RxOLRDecisionState = RX_OLR_PERFORM;
            // set OLR msg type in cmv
            gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type = BITSWAP_REQ;
               //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (START)
               //SMS00966303 SMS00954738 Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep (START_END)
               if(!gft_SRAUpShift_process) // restore original threshold parameters after
                                    // bitswap after last SRA Upshift
               { // restore defaults to stop the bitswaps.
                  //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
                  //Set gs_BITSWAP_TRIGGER_DELTA = gs_RxDesiredMargin once marign on tones are
                  //dropped to below -6 dB.
                  if ((gft_TonesWithStrongNoise == TRUE) &&
                      (gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_FAST_BITSWAP))
                  {
                     gs_BITSWAP_TRIGGER_DELTA = gs_RxDesiredMargin;
                     gs_BITSWAP_TRIGGER = 0x0000; // 0dB
                  }
                  else
                  {
                     gs_BITSWAP_TRIGGER_DELTA = 0x0300; // 3dB
                     gs_BITSWAP_TRIGGER = 0x0200; // 2dB
                  }
                  //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
                  gs_Bitswap_Accept_Delta = 0x0100; // 1 dB
               }
               //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (END)
#ifdef BITSWAP_DEBUG
            // log bitswap information
            if ( gs_trail_bitswap < (2*MAX_STATES - 20))
            {
               gsa_StatesTrail[gs_trail_bitswap++] = (int16)0xDDDD;
               gsa_StatesTrail[gs_trail_bitswap++] = (int16)gus_ShowtimeSNRUpdateCount;
               gsa_StatesTrail[gs_trail_bitswap++] = s_MinMarginBeforeSwap ;
               gsa_StatesTrail[gs_trail_bitswap++] = s_MinMarginAfterSwap;
               gsa_StatesTrail[gs_trail_bitswap++] = s_delta_Lp;
            }
            else if (gs_trail_bitswap != 0x7FFF)   //check if bitswap trail enabled
            {
               gs_trail_bitswap = 0;
            }
#endif
         }
         else
         {
            // update rx olr decision state
            s_RxOLRDecisionState = RX_OLR_ABORT;
            gft_BitloadOK=1; // temporarily set it to true here, to kick another bitswap

         }
      }
// AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation (Start)
#ifndef ISDN   // Only for Anx-A
      }
#endif // ifndef ISDN
// AR8_TF:IOP_ALL_BISPLus_CNXT_1bitConstellation (End)
   }// OPTN_DSAutobitswapdisable
   //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start)
   //store present average and min margin for next round of bitswap
    gs_RxPrevAvgMargin = (gs_RxPrevAvgMargin + 3*gs_RxAvMargin)>>2;
   //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(end)
   /* Perform OLR */
   if(s_RxOLRDecisionState == RX_OLR_PERFORM)
   {
#ifdef DEBUG_FGLINSUMSQ
      /*Debug Code to compute sumGi squares and compare with running sum */
      l_temp=0;
      for(i=gs_RxFirstChannel;i<gs_RxNumTones;i++)
      {
         bi = guca_RxBat[i];
         if (bi!=0) // check that tone is loaded
         {

            bi=gsa_RxFineGains[i];
            s_FGainLin = (DecimalGain(bi)+(int16)(1<<3)) >>4;
            MULS16(l_SumFGainLinSq_add, s_FGainLin, s_FGainLin)  ;
            l_temp +=l_SumFGainLinSq_add;
         }

      }

      //adjust the extra value added to account for forceeven1bit
      bi =-640;
      s_FGainLin = (DecimalGain(bi)+(int16)(1<<3)) >>4;
      MULS16(l_SumFGainLinSq_add, s_FGainLin, s_FGainLin)  ;
      l_temp +=l_SumFGainLinSq_add;

      if (l_temp!=gl_SumFGainLinSq) Pause(1111);

#endif


      OLRPM_RxPreProcessing();

      /* calculate combined gain */
            CalcDecodGain(gt_rx_config.psa_BAT, gt_rx_config.psa_FineGains,
                          gsa_RxCombinedGains, 0, gs_RxNumTones, FALSE,
                          guca_RxBitswapTones);

      /* ========================================================================= */
      /* Verify if frame size matches to bit allocation table (DMT/BIS Showtime,OLR,L2)*/
      /* Also computes parameters for Rx QAM/TCM block configuration*/
      /* ========================================================================= */
      VerifyAndUpdateRxQAMParameters();

      // update rx olr decision state machine
      gt_RxOLRPMVars.uc_rxOLRPMState = OLR_LOAD_TABLES;
      gt_RxOLRPMVars.s_rxOLRPMEvent = LOAD_BAT | LOAD_GAIN | LOAD_TRB | RECONFIG_BiGi | RECONFIG_Lp | RECONFIG_Bpn;

      // update OLR msg type for plus mode
      if(( gl_SelectedMode & (MODE_G992_5)  ))
      {
            gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type =
               (uint8) ((uint16) gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type +
                        SRA_REQ);
      }

      // record OLR progress status in OLR cmv
      gt_RxOLRPMVars.s_RequestReXmitCnt++;
         STATArray[STAT_OLRStatus_DS] |=
            (STAT_OLRPM_IN_PROGRESS |
             ((gt_RxOLRPMVars.s_RequestReXmitCnt) << 8));
   }
   /* OLR Aborted -- Restore firmware bi/gi tables */
   else if(s_RxOLRDecisionState == RX_OLR_ABORT)
   {
      OLRPM_RxPreProcessing();

      //////////////////////////////////
      // Switch BAT and Gain Tables
      //////////////////////////////////
#ifdef ADSL_62
        guc_RxQtInactiveTblSeg = guc_RxQtActiveTblSeg;
#endif
      // We may have changed the BAT when evaluating whether the intended OLR violated SNR margin, so we
      // need to reload that table.
      gt_RxOLRPMVars.uc_rxOLRPMState = OLR_READ_TABLES;
      gt_RxOLRPMVars.s_rxOLRPMEvent = READ_BAT;
      gt_OlrPm_TxOvhdMsgInfoInput.uc_message_type = 0;

      // Restore original fine gains and associated fine gain metrics.
         memcpy(gsa_RxFineGains, gsa_TempRxFineGains,
                sizeof(int16) * gs_RxNumTones);

      gl_SumFGainLinSq = gl_save_SumFGainLinSq;
      gl_SumGiSqTssiSq = gl_save_SumGiSqTssiSq;

      // record error status and error code in OLR cmv
      STATArray[STAT_OLRError_DS] |= s_retCode;
      STATArray[STAT_OLRStatus_DS] |= STAT_OLRPM_ABORTED;
   }
   }

}
// IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
/*****************************************************************************
;  Subroutine Name: Check_DsBitSwapTimeWindow(...)
;
;  Function used to introduce the delay between the first bitswap request &
;  the consequitive bitswap requests based on the number of super frame value
;  stored in the "guc_TimeWindow_DS_BitSwaps".
;
;  Prototype:
;     void Check_DsBitSwapTimeWindow(void)
;
;  Input Arguments:  None
;
;  Output Arguments: (i) Changes the counter value in "guc_TimeWindow_DS_BitSwaps"
;                    if it's value is greater than zero.
;                 (ii) Clears DS Auto BitSwap bit in "CMV OPTN 2 0"
;
;  Return:  None
;
*****************************************************************************/
void Check_DsBitSwapTimeWindow(void)
{
    if (guc_TimeWindow_DS_BitSwaps > 0)
    {
        guc_TimeWindow_DS_BitSwaps--;
        if (guc_TimeWindow_DS_BitSwaps == 0)
        {
            OPTNArray[OPTN_AlgControl] &= ~OPTN_DSAutoBitSwapDisable;
        }
    }
}
#endif // ifndef ISDN
// IOP_DS_DMT_ALL_EnableDsBitSwap (End)
#undef RX_OLR_NONE
#undef RX_OLR_PERFORM
#undef RX_OLR_ABORT
