/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  rx_ovhd1_bis.c
*
*
****************************************************************************/
#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "DSLEngin.h"
#include "fifo.h"
#include "cmv.h"
#include "trail.h"

#ifdef HDLC_LEAVE_TRAIL
   FILE *fp_HDLCdata = NULL;
#endif

int32 HDLC_Deframer(uint8 uc_byte);
int16 gs_remove_cnt;                   // Number of bytes read from the Msg Fifo by RxHDLCProcessor.

/*****************************************************************************
*   Subroutine Name: RxHDLCProcessor
*
*   Description:
*
*     This function copies any bytes found in gt_RxHDLCMsgFifo into a local buffer.  It then
*     processes them using a state machine while copying them to a global buffer (guca_rx_hdlc_msg_buffer).
*     The state machine removes escape octets, computes FCS and recognizes the end of a message by its
*     closing flag byte.  When a complete message is received the ovhd message handler is called
*     immediately.  The state machine also recognizes error conditions (message too large,
*     message too small, bad FCS) and discards these messages.
*     If the bytes copied from gt_RxHDLCMsgFifo comprise more than one message, the messages will
*     processed in sequence.  If the bytes include a partial message, it will be processed as well
*     and the output stored in the global buffer.  In a subsequent call to this function the remainder
*     of the message bytes will be copied from the message fifo and processed to form the complete
*     message in the global buffer.
*
*     Note that the message as read from the message fifo does not contain the opening flag, which is stripped
*     off when bytes are copied between the deframer and the fifo.  The message does contain all other bytes,
*     including the control field, the payload, the FCS, and the closing flag.
*
*   Prototype:
*       void RxHDLCProcessor(void)
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*   Global Variables:
*
*
*******************************************************************************/

void RxHDLCProcessor(void)
{

   uint8 uca_rx_ovhd_byte[MAX_RX_HDLC_MSG_SIZE];

   // For convenience, we force word buffer into byte buffer to save ovhd msg
   uint8* gpuca_ovhd_log = (uint8*)(void *)gsa_StatesTrail;
   int32 i;

#ifdef HDLC_LEAVE_TRAIL

   if (!fp_HDLCdata)
      fp_HDLCdata = fopen ("HDLC_Data.txt", "w");
   else
   {
      fclose(fp_HDLCdata);
      fp_HDLCdata = fopen("HDLC_Data.txt", "a");
   }
#endif

   /* If no message in the FIFo, return, no processing needed */
   gs_remove_cnt = 0;
   while(RemoveMessageFromOvhdFifo(&gt_RxHDLCMsgFifo, &uca_rx_ovhd_byte[gs_remove_cnt]))
   {
      gs_remove_cnt++;

      //protect overflowing the array
      if (gs_remove_cnt == MAX_RX_HDLC_MSG_SIZE)
         return;
   }

   for (i = 0; i < gs_remove_cnt; i++)
      HDLC_Deframer(uca_rx_ovhd_byte[i]);

#ifdef HDLC_LEAVE_TRAIL
   if (fp_HDLCdata)
      fclose (fp_HDLCdata);
#endif
}

