/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*       Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*       Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*       rx_ovhd_bis.c
*
*
****************************************************************************/
// **************************************************************************
//  rx_ovhd_bis.h
//
// History
// 04/12/2012 Varun : Modified the code
//   1) To indicate the PM status correctly- Bug Fix
//   2) Changed L3 Enable bit to 15th bit of test 28 0 (Old CMV- OPTN 15)
//   3) Changed the #define to indiate the correct reason for reject of L3 request from CO.
//   Grep for  XDSLRTFW-1236
//
// 17/08/2010 AdeelJ/Palaksha/Bhadra: IOP fix for SRA Upshift and Downshift not achieving the Target Margin.
//      Removed min margin Check so that SRA process Makes modem reach target margin.
//      Grep for SMS00951973:IOP_DS_BISPlus_ALL_SRATargetMarginFix
//
// 17/08/2010 AdeelJ/Palaksha/bhadra: Modification of SRA Algorithm to make SRA Step more accurate and inclusion of
//     overshoot check for SRA DnShift.
//     removed external reference to Upshift Process as the variable is now declared in gdata.h
//     changed variable types of Upshift and DnShift process to global flag.
//     Grep for SMS00954738:Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep
//
//  19/09/2011 Sriram Shastry : Disable Power Management L2,L3 mode, Seamless rate adaptation ( US & DS direction) as a part of R43. delivery
//     This is done as per project management requirement. They are only check box feature for R4.3 release. SRA & PM L2 mode
//     features are functionally not verified.
//
//     Grep for :   IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode
//
// 10/01/2012 Shakil/Bhadra: Random link drops seen in ADSL2p mode in a noisy line of DTAG customer house.CPE dropped the link
//     due to near end LOS generated by excessive Downstream CRCs. According to our reboot criterion it
//     requires more than 1000 downstream CRCs to declare LOS from the CPE side but while we supressed
//     the LOS generation (cw test 29 0 0x4) we did not see the issue and the maximum CRC was less
//     than 300. Since we expected more than 1000 CRCs when the LOS was supressed the root cause was in
//     the LOS based on CRC block of the code where we did not increase gsa_good_count_ variable atall which
//     trigerred LOS if CRC is increased by more than 40 in 20 seconds interval. The reason that gsa_good_count
//     did not increased is, it resides in a function called ProcessFramingBytes() which was excluded in the VR9
//     compilation process(executes only ifndef HERCULES_ADSL_CPE). Asa fix this variable was moved to the
//     correct place to be compiled and incremented correctly.
//     Code Grep: XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC
//
// 06/05/2011 Sriram Shastry : Disable L2 mode request from CO. It was seen in DTAG Lab that CPE is unable to handle L2 trim and
//    link was dropping after l2 trim request from CO. So L2 mode is switched off
//    Grep for : XDSLRTFW-298 IOP_DS_BisPlus_ALL_PM_L2mode
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//    ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//    Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 14/12/2012 Mahesh: Added L2 entry - Amd 4 changes.
//    Grep for XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4
//
// 07/01/2013 Ram: Fix added for JIRA 575. Attach "FEC uncorrectable CW count" to CMV
//    Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
// 20/02/2013 Mahesh:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//
// 20/02/2013 Anantha:  Removed Ananta's bitswap enhancement changes for L2 & SRA
//    XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap
//
// 26/2/2013 Vinjam: Store the received far-end ActINP in "gt_HercADSL_USRateCMV.s_ActInpErasure[]".
//    grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 27/2/2013 Vinjam: Added code to get "RETX_INP_ACT_SHINE" & "RETX_INP_ACT_REIN" from the received EOC messages.
//    Grep for XDSLRTFW-738 Task_DS_BisPlus_All_ReportInpReinShineInReTx.
//
// 07/03/2013 Vinjam: After sending "Grant" to CO initiated "PM L3" request set "Socrates CMV STAT 18 0" to "3" (i.e. PM L3)
//    In the CMV re-map this is mapped to HERC STAT 0 1
//    Grep for XDSLRTFW-750 Fix_DS_BisPlus_All_PML3EnableByDefault
//
// 22/03/2013 Ram: Gated 'L2 Amd-4 changes' with a flag to disable them running for other cases
//    Grep for XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4
//
// 30/08/2013 Prashant: Fix for CPE not honouring MaxLp sent from Co.
//  1. If the DSLAM configured "L2_Max" in "L2 Request" < "rate(L0)/2" Then fallback to Old L2 implementation.
//  2. Gi shaping is not needed for loops < 2000m [from Dietmar], so fallback to old L2 implementation with max
//     possible Lp.
//  3. Check to make sure that the new Lp is always less than L2_Max.
//  Grep for XDSLRTFW-1169 BugFix_All_DS_BisPlus_L2_HonourMaxLP
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//  Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 09/09/2014 ChihWen: Avoid MIPs peaking in L2 entry and exit by moving calculation of FDQ coefficients to background tasks.
//  Grep for XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit
//
// 24/11/2017 Sriram Shastry:VRX518 US CRCs and FECs in Tests of 1TR112 ADSL2+ Anx J.
//   Disable OOB handling if US Bitswap is ongoing .DEC update logic gets into conflict with OLR as both algorithms
//   copy gsa_TxCombinedGains to the inactive gain table / active table.
//   Grep for XDSLRTFW-3479
// *****************************************************************************************************************************
#include <string.h>
#include "typedef.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "gdata.h"
#include "dsp_op.h"
#include "enc_gain.h"
#include "tone_ord.h"
#include "dec_gain.h"
#include "showinit.h"
#include "cmv.h"
#include "const_bis.h"
#include "bitload_support.h"
#include "states.h"
#include "bitload_const.h"
#include "changebat.h"
#include "ovhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "trail.h"
#include "tx_plam.h"
#include "nmp_plfm.h"
#include "rxceoc_com.h"
#include "minmaxmargin.h"
#include "dsp_op2.h"
#ifdef DEBUG_STREAMING
#include "DebugBuffer.h"
#endif
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
#include "ComputeRMSFineGain.h"
// XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

#ifdef TARGET_HW
#include "mei_iof.h"
#endif

#ifdef HDLC_LEAVE_TRAIL
extern FILE *fp_HDLCdata;
#endif
//XDSLRTFW-1727
uint16 gs_DeltaMinMaxLp;
int16 gs_ErrCode = 0;


uint16 gus_hdlc_msg_len; // the global variable to save the current HDLC msg length
uint32 gul_last_RxIbinfo =0xFFFFFFFF;
//uint32 gul_NumL2ReqRcvd = 0;

//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifdef HW_SNR_FDQ
#define MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION      (370)
extern int16 gsa_pilot_FDQ_coef[2];
extern uint8 guc_pilot_FDQ_exp;
extern void reconfig_fft_fdq_for_l2pcb(void);
extern void reconfig_next_fdq_for_l2pcb(void);
#endif
//XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
//XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

// function pointer arrays to all HDLC Rx ovhd msg handler functions
void   (*Rx_prior_ovhd_msg_handler[MAX_OVHD_PRIORITY])(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput) =
{&Rx_prior0_ovhd_msg_handler,
&Rx_prior1_ovhd_msg_handler,
&Rx_prior2_ovhd_msg_handler};

extern void Update_OLRPMCnt(OLRPMCntInfo_t* pt_OLRPMCnt, int16 s_OLRPMType, int16 s_countType);
extern void QueueInterruptRequest(int16 s_InterruptCode);
extern int16 gs_PilotToneIdx;

//XDSLRTFW-1727
int8 gc_dbgMaxL0ToL2PCB = MAX_L0_TO_L2_CUTBACK; //XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2

#define OPTN_NEW_PCB_DISABLE 0x1000

void CalcL2LpPcb(int16 *ps_ActualDeltaLp,int16 *ps_Pcb,int16 L0Lp,int16 MinPcb,int16 L0Pcb)
{
   //note that actualDeltaLp is negative
   int16 L2LpMax = L0Lp + *ps_ActualDeltaLp;
   // TODO: assume 3% overhead for Lp to get sumBi

   #define TCM_OVHD_PERCENTAGE         (97)
   int16 OfSetBi   = L0Lp - (L2LpMax * TCM_OVHD_PERCENTAGE / 100);
   //Calculate the Power difference for Lp reduction assuming 3dB reduction for every bit
   int16 OfsetPcb =    (((OfSetBi * 3)<<8) + (gus_ncloaded>>1))/gus_ncloaded;

   //Check the difference between the current PCB vs the L2 requested min pcb
   gs_DeltaPcb = MinPcb - L0Pcb;
   if (gs_DeltaPcb < 0)
     gs_DeltaPcb = 0;

   *ps_Pcb = OfsetPcb + (gs_DeltaPcb<<8);
   *ps_ActualDeltaLp = ((*ps_Pcb * gus_ncloaded)/3)>>8;
}
//XDSLRTFW-1727
void getValidPCB(int16 s_minPCB, int16 s_maxPCB, int16 s_currPCB, int16 *ps_relativePCB, int16 *ps_ErrCode)
{
   int16 s_PCB_Compare;
   //get the valid PCB wrt previous PCB or wrt L0 PCB.. limit the total cutback to 12 dB
   if (OPTNArray[OPTN_Power_Management] & OPTN_NEW_PCB_DISABLE)
   {
      s_PCB_Compare = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols;
   }
   else
      s_PCB_Compare = s_currPCB;

   // Note that if successful we do not modify the ErrCode value, and if input
   // ErrCode is already non-zero we return immediately.
   // If some error has already occurred, don't bother here.
   if (*ps_ErrCode != 0)
      return;

   // If min and max PCBs are invalid
   if ((s_minPCB > s_maxPCB) ||
   (s_maxPCB < s_currPCB) ||
   (s_minPCB < MIN_PM_REQ_PCB_VALUE) ||
   (s_maxPCB > MAX_PM_REQ_PCB_VALUE))
   //||(s_minPCB == s_currPCB))   // Same cut back value is sent as before then reject it.
   {
      // record the error code
      *ps_ErrCode = REQ_INVALID_PCB|RESP_INVALID_PARAMETERS;
      return;
   }

   if ((gs_CurrentCoChipset==BDCM_CO_CHIPSET || gs_CurrentCoChipset==IFTN_CO_CHIPSET) &&
   ((s_minPCB - s_PCB_Compare/*gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols*/) > gc_dbgMaxL0ToL2PCB))
   //XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
   {
      // Cutting back too much from L0 power level could result in PLL noise that reduces US SNR margin.
      *ps_ErrCode = REQ_INVALID_PCB|RESP_INFEASIBLE_PARAMETERS;
      return;
   }

   *ps_relativePCB = s_minPCB - s_currPCB;

   if (*ps_relativePCB < 0)
      *ps_relativePCB = 0;

   if ((OPTNArray[OPTN_Power_Management] & OPTN_NEW_PCB_DISABLE)==0)
   {
      if(*ps_relativePCB == 0)
      {
         *ps_relativePCB = s_maxPCB - s_currPCB;
         if (*ps_relativePCB > gc_dbgMaxL0ToL2PCB)
            *ps_relativePCB = gc_dbgMaxL0ToL2PCB -1;
      }
   }
}

#ifdef HDLC_QUEUE_LOGGING
extern FILE *gfp_hdlc_out;

/*^^^
 *------------------------------------------------------------------------
 *
 * Name : ClearExpectedResponse(int32 l_PriorityIndex)
 *
 * Description:  This subroutine clearing the expected response specifically
 *
 * Prototype:
 *      void   ClearExpectedResponse(int32 l_PriorityIndex)
 *
 * Input Arguments:
 *      l_PriorityIndex : the ovhd msg priority index
 *
 * Output Arguments:
 *
 * Return:
 *      None
 *
 *
 * Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void ClearExpectedResponse(int32 l_PriorityIndex)
{
   printf("P%d - Removed expected ACK: designator = 0x%x, msg_type = 0x%x\n",
   l_PriorityIndex, gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedDesignator,
   gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedMsgType);

   fprintf(gfp_hdlc_out, "P%d - Removed expected ACK: designator = 0x%x, msg_type = 0x%x\n",
   l_PriorityIndex, gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedDesignator,
   gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedMsgType);
}

#endif

/*****************************************************************************
*   Subroutine Name: rx_segment_ack_handler
*
*   Description:
*            This subroutine processes the received overhead message
*
*   Prototype:
*         void rx_segment_ack_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_segment_ack_handler(uint8 uc_message_priority, uint8* puca_msg_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
      //double check whether the message type is right
   if (puca_msg_buffer[3] == SEGMENT_ACK_TYPE)
   {
   //save what is the segmented msg index CO requested
   gsa_COReq_OvhdMsgSegIndx[uc_message_priority] = puca_msg_buffer[4];

   //Check the validity of gs_COReq_OvhdMsgSegIndx
   if (gsa_COReq_OvhdMsgSegIndx[uc_message_priority] == gsa_RTXmit_OvhdMsgSegIndx[uc_message_priority])
   {
   // we got the correct ACK
   //overwrite the message designator, message type from ACK
   #ifdef HDLC_QUEUE_LOGGING
   ClearExpectedResponse(uc_message_priority);
   #endif
   //clear ACK expect flag
   gta_TxHdlcControlInfo[uc_message_priority].ft_ack_expected = FALSE;

   // request sending of next segment
   t_TxOvhdMsgInfoInput->uc_message_designator = puca_msg_buffer[5];
   t_TxOvhdMsgInfoInput->uc_message_type = puca_msg_buffer[6];

   if (uc_message_priority == 0)
   {
      // must be SRA commands
      t_TxOvhdMsgInfoInput->uc_Source = AUTO_CMD_SOURCE;
   }
   else
   {
      // probably either Hlog or PM
      t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;
      if (t_TxOvhdMsgInfoInput->uc_message_designator == POWER_MGMT_CMD_DESIG)
      {
         t_TxOvhdMsgInfoInput->ft_InvertedSyncSymbol_expected = TRUE;
      }
   }

      TxHdlcSendRequest(uc_message_priority, *t_TxOvhdMsgInfoInput);
   }
      //else
      //{
      // Options to deal with invalid ACK
      // 1. Ignor, continue waiting for ACK until timeout
      // 2. Reset everything, abort current xmit session, start from very beginning and
      // ready for the next new ovhd msg
      //
      // Option 1 seems more flexible
      //}
   }
}

/*****************************************************************************
*   Subroutine Name: Rx_ovhd_msg_handler
*
*   Description:
*            This subroutine processes the received overhead message*

  *     Prototype:
  *        void Rx_ovhd_msg_handler(void)
  *
  *     Input Arguments: Message Buffer
  *
  *     Output Arguments: none
  *
  *     Return: none
******************************************************************************/

void Rx_ovhd_msg_handler(void)
{
   uint8 uc_new_or_old_bit;
   TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput;
   TxHdlcControl_t *pt_TxHdlcControlInfo;
   uint8 uc_comm_or_resp_bit = 2; /* Initialise with an invalid entry */

   // save the current msg length
   gus_hdlc_msg_len = gus_rx_msg_index;

   // If we got valid overhead message, we will process it based on its content
   if (guca_rx_hdlc_msg_buffer[0] < MAX_OVHD_PRIORITY)
   {
      gt_RxHDLCMsg.message_priority =    guca_rx_hdlc_msg_buffer[0] & 0x3;
      pt_TxHdlcControlInfo = &gta_TxHdlcControlInfo[gt_RxHDLCMsg.message_priority];

      /* Extract the new or old alternating message bit field */
      uc_new_or_old_bit = (guca_rx_hdlc_msg_buffer[1] & 0x1);

      // This new/old command check that is based on cntrl_filed is not complete.
      // It doesn't consider the scenario when we could missed one command but get the next command,
      // and we will intentionaly skip this coming command since its cntrl field is same as the last
      // command we correctly get because of toggle.
      // We temporarily comment out this line to work around this problem for the time being because
      // it is reported to cause problem in Infenion CO.
      /* Return if an old repeated message */
      //            if((gt_RxHDLCMsg.cntrl_field & 0x1) == uc_new_or_old_bit)
      //                  return;

      /* Update the control field */
      gt_RxHDLCMsg.cntrl_field = guca_rx_hdlc_msg_buffer[1];

      //clear the ovhd info input structure
      memset((void*)&t_TxOvhdMsgInfoInput, 0, sizeof(TxOvhdMsgInfoRequest_t));
      t_TxOvhdMsgInfoInput.uc_message_designator = guca_rx_hdlc_msg_buffer[2];
      // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
      t_TxOvhdMsgInfoInput.uc_message_type = guca_rx_hdlc_msg_buffer[3];
      // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)

      /* Check if the received message is a command or a response */
      uc_comm_or_resp_bit = (guca_rx_hdlc_msg_buffer[1] >> 1) & 0x1;

      if (uc_comm_or_resp_bit) //if response
      {
         if (guca_rx_hdlc_msg_buffer[2] == pt_TxHdlcControlInfo->uc_ExpectedDesignator)
         {
            pt_TxHdlcControlInfo->s_TotalRespRecv++;
            pt_TxHdlcControlInfo->ft_ack_expected = FALSE;

            if (pt_TxHdlcControlInfo->uc_Source == ME_CMD_SOURCE)
            {
               // set the stat cmv.
               STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_RESP_RCVD;

               // store the received response message length.
               if ((gus_hdlc_msg_len - 4) < MAX_RX_ME_HDLC_MSG_SIZE)
                  gt_ME_HDLC_Params.s_ME_HdlcRxMsgLength = gus_hdlc_msg_len - 4;
               else
               {
                  gt_ME_HDLC_Params.s_ME_HdlcRxMsgLength = MAX_RX_ME_HDLC_MSG_SIZE;

                  // set the stat cmv indicating that the received message length
                  // is longer than the ME Hdlc Rx buffer length
                  STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_RX_BUF_OVERFLOW;
               }
               // copy the received buffer to rx ME HDLC buffer
               // 1st two bytes are address field and control field and the last two bytes are the FCS bytes
               // so skip the 1st two and the last two bytes
               memcpy(guca_Rx_ME_HDLCMsgBuffer, &guca_rx_hdlc_msg_buffer[2], gt_ME_HDLC_Params.s_ME_HdlcRxMsgLength);
            }
         }
      }
      else
      {
         pt_TxHdlcControlInfo->s_TotalCmdRecv++;
      }

      #ifdef HDLC_LEAVE_TRAIL
      // Priority byte
      fprintf(fp_HDLCdata, "Priority:       0x%02x\n", guca_rx_hdlc_msg_buffer[0]);

      //Control field byte
      fprintf(fp_HDLCdata, "Control Field: 0x%02x    ", guca_rx_hdlc_msg_buffer[1]);
      if (!uc_comm_or_resp_bit)
         fprintf(fp_HDLCdata, "(Command)\n");
      else
         fprintf(fp_HDLCdata, "(Response)\n");

      //Designator byte
      fprintf(fp_HDLCdata, "Designator:    0x%02x    ", guca_rx_hdlc_msg_buffer[2]);
      #endif

      DebugTrail(5, DEBUG_LOG_OVHDMESSAGES, 0xDDDD, (int16)(gl_RxSymbolCount&0xFFFF), (int16)((gl_RxSymbolCount>>16)&0xFFFF), (int16)guca_rx_hdlc_msg_buffer[0], (int16)guca_rx_hdlc_msg_buffer[2]);

      if ((guca_rx_hdlc_msg_buffer[2] != (SEGMENT_ACK_PRIOR0|gt_RxHDLCMsg.message_priority))
      && (gsa_RTXmit_OvhdMsgSegIndx[gt_RxHDLCMsg.message_priority]>= 1))
      {
         return; //don't process any msg other than segment ACK if we are expecting it
      }
      // segment ack recieved, process it
      else if (guca_rx_hdlc_msg_buffer[2] == (SEGMENT_ACK_PRIOR0|gt_RxHDLCMsg.message_priority))
      {
         rx_segment_ack_handler(gt_RxHDLCMsg.message_priority, guca_rx_hdlc_msg_buffer, &t_TxOvhdMsgInfoInput);
      }
      // Process overhead message based on its priority category
      else
      {
         (*Rx_prior_ovhd_msg_handler[gt_RxHDLCMsg.message_priority])(guca_rx_hdlc_msg_buffer,&t_TxOvhdMsgInfoInput);
#ifdef HDLC_LEAVE_TRAIL
         // CRC bytes
         fprintf(fp_HDLCdata, "CRC Bytes:    0x%02x 0x%02x\n", guca_rx_hdlc_msg_buffer[gus_hdlc_msg_len-2], guca_rx_hdlc_msg_buffer[gus_hdlc_msg_len-1]);
#endif
      }
   }
}

/*****************************************************************************
*   Subroutine Name: Rx_prior0_ovhd_msg_handler
*
*   Description:
*            This subroutine processes the received overhead message*

  *     Prototype:
  *        void Rx_prior0_ovhd_msg_handler(uint8* puca_msg_buffer, &t_TxOvhdMsgInfoInput)
  *
  *     Input Arguments: Message Buffer
  *
  *     Output Arguments: none
  *
  *     Return: none
******************************************************************************/

void Rx_prior0_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
#ifdef HDLC_LEAVE_TRAIL
   fprintf(fp_HDLCdata, "(OLR msg)\n");
#endif

   if (puca_msg_buffer[2] == RECONFIG_CMD_DESIG)
   {
      rx_reconfig_cmd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
   }
}

/*****************************************************************************
*   Subroutine Name: Rx_prior1_ovhd_msg_handler
*
*   Description:
*            This subroutine processes the received overhead message
*
*   Prototype:
*         void Rx_prior0_ovhd_msg_handler(uint8* puca_msg_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void Rx_prior1_ovhd_msg_handler(uint8* puca_msg_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
void (*fp_Temp)(uint8 *, TxOvhdMsgInfoRequest_t*);

   fp_Temp = NULL;

   if(puca_msg_buffer[2] == EOC_CMD_DESIG)
   {
   #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(EOC msg)\n");
   #endif
      fp_Temp = &rx_eoc_msg_handler;
   }
   else if(puca_msg_buffer[2] == TIME_CMD_DESIG)
   {
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(Time msg)\n");
      #endif
      fp_Temp = &rx_time_cmd_handler;
   }
   else if(puca_msg_buffer[2] == INVENTORY_CMD_DESIG)
   {
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(Inventory msg)\n");
      #endif
      fp_Temp = &rx_inventory_cmd_handler;
   }
   else if(puca_msg_buffer[2] ==    CNTL_PAR_RD_CMD_DESIG)
   {
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(Control Parameter msg)\n");
      #endif

      //rx_cntrl_par_rd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
      fp_Temp = &rx_cntrl_par_rd_handler;
   }
   else if(puca_msg_buffer[2] ==    MGMT_CNTR_RD_CMD_DESIG)
   {
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(Management Parameter msg)\n");
      #endif
      fp_Temp = &rx_mgmt_par_rd_handler;
   }
   else if(puca_msg_buffer[2] == POWER_MGMT_CMD_DESIG)
   {
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(Power Management msg)\n");
      #endif
      fp_Temp = &rx_power_mgmt_rd_handler;
   }
   else if(puca_msg_buffer[2] == CLEAR_EOC_CMD_DESIG)
   {
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(Clear EOC msg)\n");
      #endif
      fp_Temp = &rx_clear_eoc_handler;
   }
   else if(puca_msg_buffer[2] == NSF_FACILITY_CMD_DESIG)
   {
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(NSF msg)\n");
      #endif
      fp_Temp = &rx_nsf_facility_cmd_handler;
   }

   if (fp_Temp != NULL)
   {
      (*fp_Temp)(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
   }
}


/*****************************************************************************
*   Subroutine Name: Rx_prior2_ovhd_msg_handler
*
*   Description:
*            This subroutine processes the received overhead message
*
*   Prototype:
*         void Rx_prior2_ovhd_msg_handler(uint8* puca_msg_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void Rx_prior2_ovhd_msg_handler(uint8* puca_msg_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   if ( puca_msg_buffer[2] == PMD_TEST_PAR_RD_CMD_DESIG)
   {
   #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(PMD Test Parameter msg)\n");
   #endif
      rx_test_param_rd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
   }
   else if( puca_msg_buffer[2] == NSF_FACILITY_LOW_CMD_DESIG)
   {
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "(NSF low priority msg)\n");
      #endif
      rx_nsf_facility_cmd_handler(&puca_msg_buffer[3], t_TxOvhdMsgInfoInput);
   }
}

/*****************************************************************************
*   Subroutine Name: rx_time_cmd_handler
*
*   Description:
*            This subroutine processes the received overhead message
*
*   Prototype:
*         void rx_time_cmd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_time_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8* puca_time[3] = {&(gt_Saved_CO_Timer.uc_hour), &(gt_Saved_CO_Timer.uc_minute), &(gt_Saved_CO_Timer.uc_second)};
   uint8 uc_msg_type, uca_digit[2];
   int32 i, j;
   int32 l_Action;      // 1 - send message; 0 - do nothing

   uc_msg_type = puca_buffer[0];

   l_Action = 1;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   if (uc_msg_type == SET_TIME)
   {
      /* These commands only received by RT */
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Set Time)\n", uc_msg_type);
      fprintf(fp_HDLCdata, "Time Set Value:");

      for (i=0; i < TIME_REG_LENGTH; i++)
         fprintf(fp_HDLCdata, "0x%02x ", puca_buffer[i + 1]);
#endif
      //Indicate that we should sync our time with CO's
      gft_COSetTimer = TRUE;

      i = 1;
      for (j = 0; j < 3; j++)
      {
         uca_digit[1] = puca_buffer[i++];
         uca_digit[0] = puca_buffer[i++];

         //transform ASCII character to digit according to ISO/IEC 646
         *(puca_time[j]) = (uca_digit[1] - 48)*10+(uca_digit[0]-48);

         //next byte is (:) character
         i++;
      }

#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "\n");
#endif

      t_TxOvhdMsgInfoInput->uc_message_type = TIME_ACK;
   }
   else if (uc_msg_type == TIME_READ)
   {
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Read Time)\n", uc_msg_type);
#endif
      t_TxOvhdMsgInfoInput->uc_message_type = TIME_READ_ACK;
   }
   else
      l_Action = 0;

   if (l_Action)
   {
      TxHdlcSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
   }
}

/*****************************************************************************
*   Subroutine Name: rx_reconfig_cmd_handler(uint8* puca_buffer)
*
*   Description:
*            This subroutine processes the received OLR message
*
*   Prototype:
*      void rx_reconfig_cmd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
******************************************************************************/
void sendUSOLRResponse(uint8 uc_msg_type, uint8 uc_defer_reason_code,uint8 uc_internal_error_code, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_temp;

   // record error status and error code in OLR cmv
   STATArray[STAT_OLRError_US] = uc_internal_error_code|uc_defer_reason_code;
   STATArray[STAT_OLRStatus_US] |= STAT_OLRPM_ABORTED|STAT_OLRPM_RESPONSE;

   t_TxOvhdMsgInfoInput->uc_defer_reason_code = uc_defer_reason_code;

   uc_temp = (uc_msg_type & 0x4)?(uc_msg_type-3):uc_msg_type;

   t_TxOvhdMsgInfoInput->uc_message_type = uc_temp | 0x80;

   Update_OLRPMCnt(&gt_USOLRPMCnt, (uint16)(uc_msg_type), UTC_RESP_CNT);

   TxHdlcSendRequest(0 /* priority */, *t_TxOvhdMsgInfoInput);

}

void rx_reconfig_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type, uc_temp;
   FlagT ft_isPlus = FALSE;
   int16 s_temp, s_retCode, s_Nf;
   uint8 uca_TxBat[TX_NUM_TONES];
   int16 sa_TxFineGains[TX_NUM_TONES];
   FlagT ft_BiGi_changed, ft_Lp_changed, ft_Bpn_changed;
   int16 sa_deltaLp[NUM_DATA_PATHS]={0,0};                     /* Initialize to zero */
   int16 sa_deltaBpn[NUM_BEARER_CHANNELS] = {0, 0};      /* Initialize to zero */
   int32 i, j;

   // clear Respone Retransmit Count
   gt_TxOLRVars.s_ResponseReXmitCnt = 0;

   uc_msg_type = *puca_buffer++;

   ft_isPlus = FALSE;
   s_retCode = 0;
   s_Nf = 0;
   ft_BiGi_changed = FALSE;
   ft_Lp_changed = FALSE;
   ft_Bpn_changed = FALSE;

   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {
      case PLUS_BITSWAP_REQ:
      case BITSWAP_REQ:
      case PLUS_DRR_REQ:
      case DRR_REQ:
      case PLUS_SRA_REQ:
      case SRA_REQ:

      Update_OLRPMCnt(&gt_USOLRPMCnt, uc_msg_type, SIMPLE_REQ_CNT);

#ifdef HDLC_LEAVE_TRAIL
      if (uc_msg_type == DRR_REQ)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (DRR Request)\n", uc_msg_type);
      else if (uc_msg_type == SRA_REQ)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (SRA Request)\n", uc_msg_type);
      else   /* BITSWAP_REQ || PLUS_BITSWAP_REQ */
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Bitswap Request)\n", uc_msg_type);
#endif
      // Once receive request, set OLR Status CMV and clear OLR Error CMV
      // uc_msg_type: Bitswap/DRR/SRA/Plus_Bitswap request
      STATArray[STAT_OLRStatus_US] = (uc_msg_type<<4);
      STATArray[STAT_OLRError_US] = 0;

      /* Check if in L0 State */
      if (gt_TxOLRVars.uc_txOLRState != L0_STEADY_STATE)
      {
         sendUSOLRResponse(uc_msg_type, RESP_BUSY, REQ_NOT_IN_L0_STATE, t_TxOvhdMsgInfoInput);
         break;
      }

      if (((uc_msg_type == BITSWAP_REQ) || (uc_msg_type == PLUS_BITSWAP_REQ)) && (OPTNArray[OPTN_AlgControl] & OPTN_USBitSwapDisable))
      {
         sendUSOLRResponse(uc_msg_type, RESP_NOT_SUPPORTED, REQ_ACTION_DISABLED, t_TxOvhdMsgInfoInput);
         break;
      }
      // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (Start)
      if (((uc_msg_type == SRA_REQ) || (uc_msg_type == PLUS_SRA_REQ)) && (OPTNArray[OPTN_OLRControl_DS] & OPTN_DisableUSSRA) )
      {
         sendUSOLRResponse(uc_msg_type, RESP_NOT_ENABLED, REQ_ACTION_DISABLED, t_TxOvhdMsgInfoInput);
         break;
      }
      // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (End)

      /* Extract Nf, Lp, Bpn info from US OLR request message */
      if (uc_msg_type & 0x4)
         ft_isPlus = TRUE;

         uc_temp = (uc_msg_type & 0x4)?(uc_msg_type-3):uc_msg_type;

      if (uc_temp > 1)   //DRR/SRA/PLUS_DRR/PLUS_SRA
      {
         /* Extract the new Lp parameter */
         for(i = 0; i < gt_tx_config.s_Nlp; i++)
         {
            /* Lp high octet */
            s_temp = (int16)(*puca_buffer++ << 8);

            /* Lp low octet */
            s_temp |= (int16)(*puca_buffer++);

            sa_deltaLp[i] = s_temp - gt_tx_config.s_Lp[i];
         }
         /* Extract the new Bpn values */
         for (j = 0; j < gt_tx_config.s_Nbc; j++)
         {
            i = guca_txBCnToLPp[j];
            s_temp = (int16)(*puca_buffer++);
            sa_deltaBpn[j] = s_temp - gt_tx_config.sa_Bpn[i][j];
         }


#ifdef LEAVE_TRAIL
         for (i = 0; i < NUM_DATA_PATHS; i++)
         {
            gs_trail_deltaLp[i] = sa_deltaLp[i];
            gs_trail_deltaBpn[i] = sa_deltaBpn[i];
         }
#endif
      }

      if (ft_isPlus)
      {
         /* s_Nf high octet */
         s_Nf = (int16)(*puca_buffer++ << 8);
         /* s_Nf low octet */
         s_Nf |= (int16)(*puca_buffer++);      /* Number of subcarriers */
      }
      else
      {
         s_Nf = *puca_buffer++; /* Number of subcarriers */
      }



      /* Check if any requested Lp/Bpn changes are valid -- if so extract bi gi info from US olr request message */
      if(isLpReconfigValid(sa_deltaLp, &gt_tx_config, &s_retCode,FALSE)    // XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode (Start_End)
      /* Check if any requested Bpn changes are valid */
      &&(isBpnReconfigValid(sa_deltaBpn, (int8 *)(void *)guca_txBCnToLPp, gft_TxBpnReconfigAllowed, &gt_tx_config, FALSE, &s_retCode))
      /* Check if we have valid framing configuration and meet all constraints */
      /* Turn off ovhd rate and max latency verification for time being to not wreck explicit rate tests */
      &&(      TRUE || /* Turn off all framing configuration checks to enable verification of co side ME check */
      isValidFramingConfiguration(&gt_tx_config, guca_txBCnToLPp, &gt_DerivedFrameProperties_US,
      sa_deltaLp, sa_deltaBpn, &s_retCode))
      /* Check if any bins chganged */
      &&(!ExtractBinsInfo(puca_buffer, s_Nf, ft_isPlus, sa_deltaLp, &s_retCode, uca_TxBat, sa_TxFineGains)))
      {

         // we got valid OLR parameters
         STATArray[STAT_OLRStatus_US] |= STAT_OLRPM_IN_PROGRESS;

         /* Lp changes requested and valid */
         if(sa_deltaLp[0] || sa_deltaLp[1])
         {
            gt_tx_config.s_Lp[0] += sa_deltaLp[0];
            gt_tx_config.s_Lp[1] += sa_deltaLp[1];
            ft_Lp_changed = TRUE;
         }


         /* Bpn changes requested and valid */
         if(sa_deltaBpn[0] || sa_deltaBpn[1])
         {
            for (j = 0; j < gt_tx_config.s_Nbc; j++)
            {
               i = guca_txBCnToLPp[j];

               gt_tx_config.sa_Bpn[i][j] += sa_deltaBpn[j];
            }
            ft_Bpn_changed = TRUE;
         }


         if (s_Nf)
         {
            /* Set the new BAT table and FineGain table to the global arrays*/
            memcpy(guca_TxBat, uca_TxBat, TX_NUM_TONES);
            memcpy(gsa_TxFineGains, sa_TxFineGains, TX_NUM_TONES*sizeof(int16));
            // XDSLRTFW-3479(Start)
         /*Example
         |-----|--------|---------------|-----------------------------|-----------------------------|---------------|--------------|-----------------------|-----------------------------|---------------------------------------|
         |Test |TxSymCnt|TxSymCnt       |TxSymCnt                     |TxSymCnt_                    |TxSymCnt-OLRMsg|NumTxSymCntfor|NumTxSymCntfrom        |NumofTxSymCnt                |Problem                                |
         |case |OLR_MSG |TxOutBandSignal|EnableOutBandSignalInsertion |DisableOutBandSignalInsertion|GainTabe       |OLRMsgToOLRHW |OLRMsgToTxOutBandSignal|Conflict_OLR_DEC             |description                            |
         |     |Updated |Updated        |Updated                      |Updated                      |Updated        |Update        |Update                 |HWUpdate                     |                                       |
         ------|--------|---------------|-----------------------------|-----------------------------|---------------|--------------|-----------------------|-----------------------------|----------------------------------------
         |Bad  |612036  |612067         |612069                       |612072                       |612102         |66            |31                     |TxSymTxOOBInsrt:enable = -33 |DEC update logic gets into conflict    |
         |     |        |               |                             |                             |               |              |                       |TxSymTxOOBInsrt:Disable= -30 |(DEC HW updated ahead of OLR HW update)|
         |     |        |               |                             |                             |               |              |                       |                             |with OLR as both algorithms copy       |
         |     |        |               |                             |                             |               |              |                       |                             |gsa_TxCombinedGains to the inactive    |
         |     |        |               |                             |                             |               |              |                       |                             |gain table / active table              |
         |-----|--------|---------------|-----------------------------|-----------------------------|---------------|--------------|-----------------------|-----------------------------|---------------------------------------|
         |Test |TxSymCnt|TxSymCnt       |TxSymCnt                     |TxSymCnt_                    |TxSymCnt-OLRMsg|NumTxSymCntfor|NumTxSymCntfrom        |NumofTxSymCnt                |Problem                                |
         |case |OLR_MSG |TxOutBandSignal|EnableOutBandSignalInsertion |DisableOutBandSignalInsertion|GainTabe       |OLRMsgToOLRHW |OLRMsgToTxOutBandSignal|Conflict_OLR_DEC             |Solution                               |
         |     |Updated |Updated        |Updated                      |Updated                      |Updated        |Update        |Update                 |HWUpdate                     |                                       |
         |-----|--------|---------------|-----------------------------|-----------------------------|---------------|--------------|-----------------------|-----------------------------|---------------------------------------|
         |Good |612036  |Block DECTxOOB |Block DECTxOOB               |Block DECTxOOB               |612102         |66            |Block DECTxOOB         |No conflict- DECTxOOB signal |Block DEC update logic if US OLR is on |
         |     |        |signal update  |signal update                |signal update                |               |              |signal update          |is blocked                   |going                                  |
         |     |        |(NA)           |(NA)                         |(NA)                         |               |              |(NA)                   |                             |                                       |
         ------|--------|---------------|-----------------------------|-----------------------------|---------------|--------------|-----------------------|-----------------------------|---------------------------------------|*/

            gft_BlockOOBSignal_BecauseOf_OngoingUSOLR = TRUE;   // Set for   OLR message
            // XDSLRTFW-3479(End)

            CalcEncodGain(guca_TxBat, gsa_TxFineGains, gsa_TxCombinedGains);
            ft_BiGi_changed = TRUE;
         }
      }

      /* One of these flags will be set only if we have a valid US OLR request*/
      if (ft_BiGi_changed || ft_Lp_changed || ft_Bpn_changed )
      {
         gt_TxOLRVars.uc_txOLRState = OLR_SEND_SYNC_INDICATOR;
         Update_OLRPMCnt(&gt_USOLRPMCnt, uc_msg_type, PERFORM_CNT);
      }
      /* else US OLR request has invalid parameters -- send appropriate response */
      else
      {
         sendUSOLRResponse(uc_msg_type, RESP_INVALID_PARAMETERS, (uint8)s_retCode, t_TxOvhdMsgInfoInput);
      }

      gt_TxOLRVars.s_ResponseReXmitCnt++;
      STATArray[STAT_OLRStatus_US] |= (gt_TxOLRVars.s_ResponseReXmitCnt<<8);
      break;

      case DEFER_BITSWAP:
      case DRR_REJECT:
      case SRA_REJECT:

      Update_OLRPMCnt(&gt_DSOLRPMCnt, (int16) (uc_msg_type & 0x3), (int16) UTC_RESP_CNT);

#ifdef HDLC_LEAVE_TRAIL
      if (uc_msg_type == DEFER_BITSWAP)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Defer Bitswap)\n", uc_msg_type);
      else if (uc_msg_type == DRR_REJECT)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (DRR Reject)\n", uc_msg_type);
      else if (uc_msg_type == SRA_REJECT)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (SRA Reject)\n", uc_msg_type);

#endif
      // record error status and error code in OLR cmv
      // According to HDLC msg format, the second byte following reject msg type will
      // be the error code
      STATArray[STAT_OLRError_DS] = *puca_buffer++;
      STATArray[STAT_OLRStatus_DS] &= ~STAT_OLRPM_IN_PROGRESS;
      STATArray[STAT_OLRStatus_DS] |= STAT_OLRPM_ABORTED|STAT_OLRPM_RESPONSE;

      #ifdef HDLC_QUEUE_LOGGING
         ClearExpectedResponse(0);
      #endif
      /* If a defer OLR message received, don't wait for sync indicator anymore */

      /* Currently, we simply restore the original configuration */
      /* An alternative would be to resend the message */
      Abandon_DS_OLRPM();

      break;

      default:
      break;
   }

}


/*****************************************************************************
*   Subroutine Name: rx_eoc_msg_handler(uint8* puca_buffer)
*
*   Description:
*            This subroutine processes the received EOC overhead message
*
*   Prototype:
*        void rx_eoc_msg_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/

void rx_eoc_msg_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   int32 l_Action;          // 0 - no action; 1 - send EOC_ACK; 2 - delete expected msg

   uc_msg_type = puca_buffer[0];
   l_Action = 1;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {

      case PERFORM_SELF_TEST:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Perform Self Test)\n", uc_msg_type);
#endif
      Perform_Self_test();

      t_TxOvhdMsgInfoInput->uc_message_type = SELF_TEST_ACK;

      // later should check for return code
      TxHdlcSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
      l_Action = 0;

      break;

      case UPDT_TEST_PARAMETER:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Update Test Parameter)\n", uc_msg_type);
#endif
      //turn on the Update Test Paramter flag
      gft_UpdateTestPar = TRUE;

      break;

      case START_TX_CORR_CRC:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Start Tx Corrupt CRC)\n", uc_msg_type);
#endif
      // The reason we put BIS_CODESWAP here is that we will get this message from CO in HDLC ovhd
      // msg testing in Cocomo test. In Cocomo, we don't really want to send out corrupt US CRC
      // to mess our overnight test result. However, in real Socrates firmware, we want to have
      // this function work correctly as it should be.
#ifdef BIS_CODESWAP
      gft_send_crc_corrupt_bits_flag = TRUE;
#endif

      break;

      case END_TX_CORR_CRC:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (End Tx Corrupt CRC)\n", uc_msg_type);
#endif
      // see comment for START_TX_CORR_CRC above
#ifdef BIS_CODESWAP
      gft_send_crc_corrupt_bits_flag   = FALSE;
#endif

      break;

      case START_RX_CORR_CRC:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Start Rx Corrupt CRC)\n", uc_msg_type);
#endif
      //gft_receive_crc_corrupt_bits_flag = TRUE;
      break;

      case END_RX_CORR_CRC:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (End Rx Corrupt CRC)\n", uc_msg_type);
#endif
      //gft_receive_crc_corrupt_bits_flag = FALSE;

      break;

#ifdef ENABLE_ALL_HDLC_OVHD
      case EOC_ACK:
      l_Action = 2;
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (EOC Ack)\n", uc_msg_type);
#endif
      // more stuff here
      // there might be a need for an element that records the expected message_type
      // similarly to uc_ExpectedDesignator.

      break;
#endif //#ifdef ENABLE_ALL_HDLC_OVHD
      default:
      l_Action = 0;
      break;
   }

   if (l_Action == 1)
   {
      t_TxOvhdMsgInfoInput->uc_message_type = EOC_ACK;

      // later should check for return code
      TxHdlcSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
   }
#ifdef HDLC_QUEUE_LOGGING
   else if (l_Action == 2)
   {
      ClearExpectedResponse(1);
   }
#endif
}

/*****************************************************************************
*   Subroutine Name: rx_inventory_cmd_handler(uint8* puca_buffer)
*
*   Description:
*            This subroutine processes the received Inventory message
*
*   Prototype:
*        void rx_inventory_cmd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/


void rx_inventory_cmd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   int32 l_Action;      // 0 - do nothing; 1 - request HDLC send; 2 - delete acked cmd


   uc_msg_type = puca_buffer[0];

   l_Action = 1;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {
#ifdef HDLC_LEAVE_TRAIL
      case IDENT_READ:
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Identification Read)\n", uc_msg_type);

      t_TxOvhdMsgInfoInput->uc_message_type = IDENT_READ_ACK;
      break;

      case AUX_IDENT_READ:
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Auxiliary Identification Read)\n", uc_msg_type);

      t_TxOvhdMsgInfoInput->uc_message_type = AUX_IDENT_READ_ACK;
      break;

      case SELF_TEST_RES_READ:
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Self Test Result Read)\n", uc_msg_type);

      t_TxOvhdMsgInfoInput->uc_message_type = SELF_TEST_RES_READ_ACK;
      break;

      case PMD_CAP_READ:
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (PMD Capability Read)\n", uc_msg_type);

      t_TxOvhdMsgInfoInput->uc_message_type = PMD_CAP_READ_ACK;
      break;

      case PMS_TC_CAP_READ:
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (PMS-TC Capability Read)\n", uc_msg_type);

      t_TxOvhdMsgInfoInput->uc_message_type = PMS_TC_CAP_READ_ACK;
      break;

      case TPS_TC_CAP_READ:
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (TPS-TC Capability Read)\n", uc_msg_type);

      t_TxOvhdMsgInfoInput->uc_message_type = TPS_TC_CAP_READ_ACK;
      break;

#else //below are for socrates
      case IDENT_READ:
      case AUX_IDENT_READ:
      case SELF_TEST_RES_READ:
      case PMD_CAP_READ:
      case PMS_TC_CAP_READ:
      case TPS_TC_CAP_READ:
      t_TxOvhdMsgInfoInput->uc_message_type = uc_msg_type | 0x80;
      break;
#endif //HDLC_LEAVE_TRAIL

#ifdef HDLC_POLL_TEST


      case IDENT_READ_ACK:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Identification Read Ack)\n", uc_msg_type);
#endif

      l_Action = 2;
      {
         int i;
         /* Get 8 octets of vendor id */
         for(i = 0; i< VENDOR_ID_LENGTH; i++)
            guca_fe_SystemVendorID[i] = puca_buffer[i + 1];

         /* Get 16 octets of version number */
         for(i = 0; i< VERSION_NUM_LENGTH; i++)
            guca_fe_SystemVersionNum[i] = puca_buffer[VENDOR_ID_LENGTH + 1 + i];


         /* Get 32 octets of serial number */
         for(i = 0; i< SERIAL_NUM_LENGTH; i++)
            guca_fe_SystemSerialNum[i] = puca_buffer[VENDOR_ID_LENGTH+VERSION_NUM_LENGTH + 1 + i];

      }
      break;

      case AUX_IDENT_READ_ACK:
   #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Auxiliary Identification Read Ack)\n", uc_msg_type);
   #endif
      l_Action = 2;
      {
         int i;
         for (i=0; i < VENDOR_ID_LENGTH; i++)
            guca_fe_SystemVendorID[i] = puca_buffer[i + 1];
      }
      break;
   #endif // HDLC_POLL_TEST

   #ifdef ENABLE_ALL_HDLC_OVHD
      case PMD_CAP_READ_ACK:
      case PMS_TC_CAP_READ_ACK:
      case TPS_TC_CAP_READ_ACK:
   #ifdef HDLC_LEAVE_TRAIL
      if (uc_msg_type == PMD_CAP_READ_ACK)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (PMD Capability Read Ack)\n", uc_msg_type);
      else if (uc_msg_type == PMS_TC_CAP_READ_ACK)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (PMS-TC Capability Read Ack)\n", uc_msg_type);
      else if (uc_msg_type == TPS_TC_CAP_READ_ACK)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (TPS-TC Capability Read Ack)\n", uc_msg_type);
   #endif

      l_Action = 2;

      break;
   #endif //#ifdef ENABLE_ALL_HDLC_OVHD

      default:
      l_Action = 0;
      break;
   }

   if (l_Action == 1)
   {
      TxHdlcSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
   }
#ifdef HDLC_QUEUE_LOGGING
   else if (l_Action == 2)
   {
      ClearExpectedResponse(1);
   }
#endif

}

/*****************************************************************************
*   Subroutine Name: rx_cntrl_par_rd_handler(uint8* puca_buffer)
*
*   Description:
*            This subroutine processes the received control parameter read command
*
*   Prototype:
*        void rx_cntrl_par_rd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/


void rx_cntrl_par_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   int32 l_Action;

   uc_msg_type = puca_buffer[0];
   l_Action = 1;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {
#ifdef HDLC_LEAVE_TRAIL
      case PMD_CNTRL_PAR_READ:
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (PMD Control Parameter Read)\n", uc_msg_type);

      t_TxOvhdMsgInfoInput->uc_message_type = PMD_CNTRL_PAR_READ_ACK;
      break;

      case PMS_TC_PAR_READ:
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (PMS-TC Control Parameter Read)\n", uc_msg_type);

      t_TxOvhdMsgInfoInput->uc_message_type = PMS_TC_PAR_READ_ACK;
      break;

      case TPS_TC_PAR_READ:
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (TPS-TC Control Parameter Read)\n", uc_msg_type);

      t_TxOvhdMsgInfoInput->uc_message_type = TPS_TC_PAR_READ_ACK;
      break;

#else
      case PMD_CNTRL_PAR_READ:
      case PMS_TC_PAR_READ:
      case TPS_TC_PAR_READ:
      t_TxOvhdMsgInfoInput->uc_message_type = uc_msg_type|0x80;
      break;
#endif ////HDLC_LEAVE_TRAIL

#ifdef ENABLE_ALL_HDLC_OVHD
      case PMD_CNTRL_PAR_READ_ACK:
      case PMS_TC_PAR_READ_ACK:
      case TPS_TC_PAR_READ_ACK:
      l_Action = 0;
#ifdef HDLC_LEAVE_TRAIL
      if (uc_msg_type == PMD_CNTRL_PAR_READ_ACK)
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (PMD Control Parameter Read)\n", uc_msg_type);
      else if (uc_msg_type == PMS_TC_PAR_READ_ACK)
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (PMS-TC Control Parameter Read)\n", uc_msg_type);
      else if (uc_msg_type == TPS_TC_PAR_READ_ACK)
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (TPS-TC Control Parameter Read)\n", uc_msg_type);
#endif
#ifdef HDLC_QUEUE_LOGGING
      ClearExpectedResponse(1);
#endif
      break;

#endif //#ifdef ENABLE_ALL_HDLC_OVHD
      default:
      l_Action = 0;
      break;

   }

   if (l_Action == 1)
   {
      TxHdlcSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
   }
#ifdef HDLC_QUEUE_LOGGING
   else if (l_Action == 2)
   {
      ClearExpectedResponse(1);
   }
#endif


}



/*****************************************************************************
*   Subroutine Name: rx_mgmt_par_rd_handler(uint8* puca_buffer)
*
*   Description:
*            This subroutine processes the received management counter read command
*
*   Prototype:
*        void rx_mgmt_par_rd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/

int16 GetCounterBytes(int16 index, uint32* counter, uint8* puca_buffer)
{
   int32 k, n;

   // reset counter before we set new value
   (*counter) = 0;

   for(k = index, n = 3; k <= (index+3); k++, n--)
   (*counter)|= (uint32)(puca_buffer[k] << (8*n));/* Far end FEC error count */

   return((int16)k);
}


void rx_mgmt_par_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   // assume passed in ptr pointing to offset0 of ohc msg buffer
   // then msg buff octet0=ctrlfield, octet1=addrfield, octet2=msgdesig, octet3=msgtype
   // note1: msg buff octets after offset 3 contain fcs for MGMT_CNTR_READ
   // note2: msg buff octets after offset 3 contain mgmtctrs  & fcs for MGMT_CNTR_READ_ACK
   uint8 uc_msg_type = puca_buffer[0]; // idx_of_msg_type_octet = 3 if passed in ptr points to offset0

   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {
      case MGMT_CNTR_READ:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Management Counter Read)\n", uc_msg_type);
#endif
      t_TxOvhdMsgInfoInput->uc_message_type = MGMT_CNTR_READ_ACK;
      t_TxOvhdMsgInfoInput->uc_message_designator = MGMT_CNTR_RD_CMD_DESIG;
      TxHdlcSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
      break;

      // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
      case MGMT_CNTR_READ_ACK:
      // Update the g997 FE error counters based on the received management counter values
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Management Counter Read Ack)\n", uc_msg_type);
#endif
#ifdef HDLC_QUEUE_LOGGING
      ClearExpectedResponse(1);
#endif
      int16 i;
      int16 idx = 1; // idx of first octet of mgmtctrs (start_idx_of_mgmt_ctr_octets = 1 + idx_of_msg_type_octet)

      // FE FEC
      for (i = 0; i < gt_tx_config.s_Nlp; i++)
      {
         idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_ffec_cnt[i]),puca_buffer);
      }

      // FE CRC (aka CV)
      for (i = 0; i < gt_tx_config.s_Nlp; i++)
      {
         idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_fcrc_cnt[i]), puca_buffer);
      }

      // FE FECS (FEC Seconds)
      idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_ffec_err_sec), puca_buffer);

      // FE ES (Errored Seconds)
      idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_ferr_sec), puca_buffer);

      // FE SES (Severely Errored Seconds)
      idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_fsev_err_sec), puca_buffer);

      // FE LOSS (LOS Seconds)
      idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_flos_err_sec), puca_buffer);

      // FE UAS (Unavailable Seconds)
      idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_funavail_err_sec), puca_buffer);

      /* TPS TC Parameter info */
      for (i = 0; i < gt_tx_config.s_Nbc; i++)
      {
         // Check if Bpn = 0 for this bearer channel
         // If so, don't expect any octets for this bearer channel
         if((gt_tx_config.sa_Bpn[LP0_DATA_PATH][i] + gt_tx_config.sa_Bpn[LP1_DATA_PATH][i]) == 0)
         {
            continue;
         }

         // FE HEC - HEC anomalies counter
         idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_fhec_err_cnt[i]), puca_buffer);

         // FE CD - Total HEC cell count
         idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_ftot_hec_cell_cnt[i]), puca_buffer);

         // FE CU - Total cell count
         idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_ftot_cell_cnt[i]), puca_buffer);

         // FE IBE - Total bit error in ATM idle cell
         idx = GetCounterBytes(idx, &(gt_rx_Anomaly.ul_fber_idle_cell_cnt[i]), puca_buffer);
      }
    break;
   }
   // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)
}

/*****************************************************************************
*   Subroutine Name: rx_power_mgmt_rd_handler(uint8* puca_buffer)
*
*   Description:
*            This subroutine processes the received power management command
*
*   Prototype:
*      void rx_power_mgmt_rd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
******************************************************************************/
int16 gs_L2ExcessMargin = 0;

//XDSLRTFW-1727
void rx_power_mgmt_rd_handler(uint8* puca_buffer, TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput )
{


   uint8 uc_msg_type;
   int16 s_sum_deltaLp;
   /* Initialize to zero */
   int16 s_ErrCode, s_RelativePCB, s_temp, sa_Lp_delta[NUM_DATA_PATHS]={0},sa_Bpn_delta[NUM_BEARER_CHANNELS]={0};
   int16 s_PcbErrCode=0,s_BATErrCode=0;
   uint8 uc_proposed_link_state = 0;
   int32 l_Action, idx=0;
   int   l_ExcessMargin;
   int16 s_LpMaxCpy,s_LpMinCpy;
   FlagT ft_LpReconfigValid=FALSE;
   FlagT ft_CalcNewBATGains=FALSE;
   /* Clear PMStatus STAT CMV */
   STATArray[STAT_PMError] = 0;
   STATArray[STAT_PMStatus] = 0;
   s_ErrCode = 0;

   /* Extract the received message type */
   uc_msg_type = puca_buffer[idx++];
   l_Action = 0;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   switch(uc_msg_type)
   {
      case STATE_TRANS_REQ:
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:  0x%02x    (State Transition Request)\n", uc_msg_type);
      #endif
      /* Extract the proposed link state*/
      uc_proposed_link_state = puca_buffer[idx++];

      switch(uc_proposed_link_state)
      {
         case L0_STATE:
         case L2_STATE:

#ifdef HDLC_LEAVE_TRAIL
         if (uc_proposed_link_state == L0_STATE)
            fprintf(fp_HDLCdata , "Proposed Link: 0x%02x  (L0_State)\n", uc_proposed_link_state);
         else if (uc_proposed_link_state == L2_STATE)
            fprintf(fp_HDLCdata, "Proposed Link: 0x%02x  (L2_State)\n", uc_proposed_link_state);
#endif
         /* RT rejects the request if any state other than L3 is proposed */
         l_Action = 1;
         t_TxOvhdMsgInfoInput->uc_message_type = STATE_TRANS_REJECT;
         t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_INVALID_PARAMETERS;

         // record the error code and status in PM cmv
         STATArray[STAT_PMStatus] = STAT_OLRPM_ABORTED|STAT_PM_CO_REQ|STAT_PM_SIMPLE_REQ|STAT_OLRPM_RESPONSE;
         STATArray[STAT_PMError] = RESP_INVALID_PARAMETERS;

         break;

         case L3_STATE:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Proposed Link: 0x%02x   (L3_State)\n", uc_proposed_link_state);
#endif
         l_Action = 1;
         STATArray[STAT_PMStatus] = STAT_PM_L3_REQ|STAT_PM_CO_REQ|STAT_OLRPM_RESPONSE;
         /* Check if in L0 State */

         if ((gt_RxOLRPMVars.uc_rxOLRPMState != L0_STEADY_STATE)
#ifdef BIS_CODESWAP
         // only when we finish swap SHOWBG2 page, can we start the following tasks
         ||(gft_RestoreShowtimeBGState != 2)
#endif
         )
         {
            t_TxOvhdMsgInfoInput->uc_message_type = STATE_TRANS_REJECT;
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_BUSY;

            //XDSLRTFW-1236(START_END)
            // record the error code and status in PM cmv
            STATArray[STAT_PMStatus] = (STATArray[STAT_PMStatus]&(~STAT_OLRPM_CLR_2BITS))|(STAT_OLRPM_ABORTED);
            STATArray[STAT_PMError] = RESP_BUSY;
         }
         // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (Start)
         else if (TESTArray[TEST_Control3]&(TEST_DisableL3Mode))
         {
            t_TxOvhdMsgInfoInput->uc_message_type = STATE_TRANS_REJECT;
            //XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable(Start)
            //t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_INVALID_PARAMETERS;
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_NOT_ENABLED;// not desired

            //XDSLRTFW-1236(START_END)
            // record the error code and status in PM cmv... Not Supported
            STATArray[STAT_PMStatus] = (STATArray[STAT_PMStatus]&(~STAT_OLRPM_CLR_2BITS))|(STAT_OLRPM_ABORTED);
            STATArray[STAT_PMError] = RESP_STATE_NOT_DESIRED; //not enabled;
            //XDSLRTFW-1214 IOP_DS_Plus_IKNS_ST_Stable(End)
         }
         // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (End)
         else
         {
            gft_EnterL3afterNextReboot = STAT_PM_L3;
            t_TxOvhdMsgInfoInput->uc_message_type = STATE_TRANS_GRANT;
            //XDSLRTFW-1236(START_END)
            STATArray[STAT_PMStatus] = (STATArray[STAT_PMStatus]&(~STAT_OLRPM_CLR_2BITS))|(STAT_OLRPM_COMPLETE);
            STATArray[STAT_PMError] = 0;
            STATArray[STAT_Misc] |= STAT_CO_L3_REQ_GRANTED;
            //XDSLRTFW-750 Fix_DS_BisPlus_All_PML3EnableByDefault (Start_End)
            STATArray[STAT_PowerMode] = (int16) STAT_PM_L3;
         }
         break;
      }
      break;

      /* Only received by RT */
      case L2_REQ:
#if 0
      if( TESTArray[TEST_ReconfigControl] & TEST_TestL2Timeout )
      {
         // Test feature to check for CO time out
         break;
      }
#endif
      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
      if (OPTNArray[OPTN_Power_Management] & OPTN_L2_Amd4_Enable)
      {
         gft_Amd4_L2_Entry = 1;
         gft_pwr_limit = 0;
      }

      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

      STATArray[STAT_PMStatus] = 0;
      STATArray[STAT_PMError] = 0;
      // PM_IN_PROGRESS, ATU_C initiate, L2 req, received req
      STATArray[STAT_PMStatus] = STAT_PM_CO_REQ|STAT_PM_L2_REQ;
      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
      gs_OlrReq = L2_REQ;

      /* Check if in L0 State */
      if (gt_RxOLRPMVars.uc_rxOLRPMState != L0_STEADY_STATE ||
      (gft_ShowtimeSnrUpdateFlag == FALSE) || (gt_rx_config.s_Nlp > 1)
#ifdef BIS_CODESWAP
      // only when we finish swap SHOWBG2 page, can we start the following tasks
      ||(gft_RestoreShowtimeBGState != 2)
#endif
      )
      {
         // record the error code and status in PM cmv
         if (gt_rx_config.s_Nlp > 1)
         {
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_INFEASIBLE_PARAMETERS;
            STATArray[STAT_PMError] = RESP_INFEASIBLE_PARAMETERS;
         }
         else
         {
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_BUSY;
            STATArray[STAT_PMError] = REQ_NOT_IN_L0_STATE|RESP_BUSY;
         }
         //XDSLRTFW-1236(START_END)
         STATArray[STAT_PMStatus] =(STATArray[STAT_PMStatus]&(~STAT_OLRPM_CLR_2BITS)) |(STAT_OLRPM_ABORTED)|STAT_OLRPM_RESPONSE;
         l_Action = 1;
         t_TxOvhdMsgInfoInput->uc_message_type = L2_REJECT;
      break;
      }

      // Read the L2 request.
      // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (Start)
      if (OPTNArray[OPTN_OLRControl_DS] & OPTN_DisableL2Mode)
      {
         t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_INVALID_PARAMETERS;
         STATArray[STAT_PMError] = RESP_INVALID_PARAMETERS;
         //XDSLRTFW-1236(START_END)
         STATArray[STAT_PMStatus] = (STATArray[STAT_PMStatus]&(~STAT_OLRPM_CLR_2BITS)) |
         (STAT_OLRPM_ABORTED) | STAT_OLRPM_RESPONSE;
         l_Action = 1;
         t_TxOvhdMsgInfoInput->uc_message_type = L2_REJECT;
      break;
      }
      // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (End)

      // Copy current dB fine gains to a safe place
      memcpy(gsa_TempRxFineGains, gsa_RxFineGains, sizeof(int16) * gs_RxNumTones);
      memcpy(guca_RxBat_Before_BS, guca_RxBat, sizeof(uint8) * gs_RxNumTones);
      gl_save_SumFGainLinSq =  gl_SumFGainLinSq;
      gl_save_SumGiSqTssiSq = gl_SumGiSqTssiSq;
      gsa_save_DSOvhdRate[0] = gsa_DSOvhdRate[0];
      gsa_save_DSOvhdRate[1] = gsa_DSOvhdRate[1];
      gla_save_DSDataRate[0] = gla_DSDataRate[0];
      gla_save_DSDataRate[1] = gla_DSDataRate[1];

      /* Extract the max/min PCS ds values */
      gt_RxOLRPMVars.uc_min_PCB_val = puca_buffer[idx++];
      gt_RxOLRPMVars.uc_max_PCB_val = puca_buffer[idx++];


      // Check if the PCBs are valid and get a valid relative PCB
      getValidPCB((int16)gt_RxOLRPMVars.uc_min_PCB_val, (int16)gt_RxOLRPMVars.uc_max_PCB_val, gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols, &s_RelativePCB, &s_ErrCode);


      if( GetL2Lp (puca_buffer, idx, &s_LpMaxCpy, &s_LpMinCpy, &s_sum_deltaLp) )
      {
         goto Exit_For_Lp_Exception;
      }

      OLRPM_RxPreProcessing();
      s_temp = gs_RxDesiredMargin+(s_RelativePCB << 8);


      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
      if (gft_Amd4_L2_Entry)
      {
         gft_pwr_limit = 0;
         //ATPR_L2 = (L2_MaxPCB - L0_PCB)<< 8;
         gs_ATPR_L2 = ( (int16) gt_RxOLRPMVars.uc_max_PCB_val - gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols)<< 8;
         //As in L2 MinPCB has to be met. So remaining reduction can be through Gi Scale
         gs_Offset_L2rmsFG_power = ((int16) gt_RxOLRPMVars.uc_min_PCB_val << 8)- gs_ATPR_L2;
      }


      if (gft_Amd4_L2_Entry)
      {
         //Calc approx L2 Lp & PCB from the max Lp & min PCB value
         CalcL2LpPcb(&s_sum_deltaLp,&s_temp,gt_rx_config.s_Lp[0], gt_RxOLRPMVars.uc_min_PCB_val,gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols);

         if ((gt_rx_config.s_Lp[0]- s_sum_deltaLp) < s_LpMinCpy)
         {
            s_sum_deltaLp = gt_rx_config.s_Lp[0] - s_LpMinCpy - 5;
            s_temp -=128;
         }
         if ((gt_rx_config.s_Lp[0] - s_sum_deltaLp) > s_LpMaxCpy)
         {
            s_sum_deltaLp = gt_rx_config.s_Lp[0] - s_LpMaxCpy + 5;
            s_temp -=128;
         }
      }

      gs_DeltaMinMaxLp = s_LpMaxCpy - s_LpMinCpy;
      if(gs_DeltaMinMaxLp > 32)
         gs_DeltaMinMaxLp = 32;


      sa_Lp_delta[0] = -s_sum_deltaLp;
      sa_Lp_delta[1] = 0;

      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
      if(s_ErrCode == 0)
         ft_LpReconfigValid = isLpReconfigValid(sa_Lp_delta, &gt_rx_config, &s_ErrCode,TRUE);

      if(s_ErrCode == 0)
         ft_CalcNewBATGains = CalcNewBATGains((int16)s_sum_deltaLp, (s_temp), &s_ErrCode);


      gs_ErrCode = s_ErrCode;
      // Check that all parameters are valid and that new BAT would meet SNR margin.
      // XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode (Start_End)
#if 0
      if ((s_ErrCode == 0)    // If already non-zero we've failed an earlier check.
      && isLpReconfigValid(sa_Lp_delta, &gt_rx_config, &s_ErrCode,TRUE)
      &&    CalcNewBATGains((int16)s_sum_deltaLp, s_temp, &s_ErrCode))
#else
      if ((s_ErrCode == 0) && (ft_LpReconfigValid) && (ft_CalcNewBATGains))
#endif
      {
         int32 i;
         // begin PM process
         STATArray[STAT_PMStatus] |= STAT_OLRPM_IN_PROGRESS;

         /* Lp changes requested and valid */
         if(s_sum_deltaLp)
         {
            //for(i = 0; i < gt_rx_config.s_Nlp; i++)
            //gt_rx_config.s_Lp[i] += sa_Lp_delta[i];
            //ADSLRTFW-1582 FEATURE_DS_BisPlus_ALL_GainScaleInL2Mode_Amd4G9923 (Start)

            // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
            if((gft_Amd4_L2_Entry))
            {
               gt_rx_config.s_Lp[0] += (gs_L2ActualDeltaSumLp);
            }
            else
            {
               //Bug fix: sa_Lp_delta[0] is a positive number, so Lp should be substracted by sa_Lp_delta[0].
               //gt_rx_config.s_Lp[0] += sa_Lp_delta[0];
               gt_rx_config.s_Lp[0] -= sa_Lp_delta[0];
            }
            // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

            // XDSLRTFW-1169 BugFix_All_DS_BisPlus_L2_HonourMaxLP [Start]
            //Check to make sure that the new Lp is always less than L2_Max

            if(gt_rx_config.s_Lp[0] > s_LpMaxCpy)
            {
               s_ErrCode |= REQ_INVALID_Lp|RESP_INVALID_PARAMETERS;
               goto Exit_For_Lp_Exception;
            }
            // XDSLRTFW-1169 BugFix_All_DS_BisPlus_L2_HonourMaxLP [End]
            //ADSLRTFW-1582 FEATURE_DS_BisPlus_ALL_GainScaleInL2Mode_Amd4G9923 (End)

            // Recalculate combined gains for the tones having b[i] or g[i] modified.
            //combinedgains is now   unsigned for L2 to support bigger range
            memcpy(gusa_RxL2CombinGains, gsa_RxCombinedGains,sizeof(uint16)*512);

            CalcDecodGain(gt_rx_config.psa_BAT, gt_rx_config.psa_FineGains, (int16 *)(void *)gusa_RxL2CombinGains, 0, gs_RxNumTones, FALSE, guca_RxBitswapTones);
            /* ========================================================================= */
            /* Verify if frame size matches to bit allocation table (DMT/BIS Showtime,OLR,L2)*/
            /* Also computes parameters for Rx QAM/TCM block configuration*/
            /* ========================================================================= */
            VerifyAndUpdateRxQAMParameters();
#if 0

            if(gft_Amd4_L2_Entry)
               VerifyL2Gains();
#endif
         }

         for (i =0;i < gs_RxNumTones;i++)
         {
            if ((guca_RxBat[i] != guca_RxBat_Before_BS[i]) ||
            (gsa_RxFineGains[i] != gsa_TempRxFineGains[i]))
            SETTONEFLAG(guca_RxBitswapTones, i);
         }


         gt_RxOLRPMVars.uc_rxOLRPMState = L2_LOAD_TABLES;
         gt_RxOLRPMVars.s_rxOLRPMEvent = LOAD_BAT | LOAD_GAIN | LOAD_TRB | RECONFIG_BiGi | RECONFIG_Lp | RECONFIG_PCB;

         /* Set the L2 PCB value that will be used */
         if(gs_RxEstimatedMinMargin > gs_RxDesiredMargin)
         {
            l_ExcessMargin = (gs_RxEstimatedMinMargin - gs_RxDesiredMargin) >> 8;
            gs_L2ExcessMargin = ((l_ExcessMargin>>2) > 3) ? 3: l_ExcessMargin;
            s_RelativePCB = (gs_L2ExcessMargin);      /* Increase the relative L2 PCB as much as margins allow us */
         }
         else
         {
            s_RelativePCB = 0;
         }
         gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols + s_RelativePCB;



         // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
#if 0
         if(gft_Amd4_L2_Entry)
         {
            gMaheshTemp[20]++; //= 0x3a3a;
            // gs_pcbDsL2SymBefAtprCheck_dbg = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols;
            l_RMSGI_L2_Lin = (int32) ComputeRMSFineGain(gt_rx_config.psa_BAT,gt_rx_config.psa_FineGains,
            gs_RxNumTones, gs_CurrentCoChipset, 0, 0);
            s_RMSGI_L2_Log = 2*(ConvertToDB(l_RMSGI_L2_Lin) - ConvertToDB(8192));
            //This code changes may be revisited
            //s_RMSGI_DeltaL0L2_Log = gt_TxPMDControl.us_RMSGI_DS - s_RMSGI_L2_Log;
            //s_RMSGI_DeltaL0L2_Log = (s_RMSGI_DeltaL0L2_Log + 0x80) >> 8; //Rounding
            //We shall consider only L2 RMSGi for ATPR compliance
            s_RMSGI_L2_Log = (s_RMSGI_L2_Log + 0x80) >> 8; //Rounding
            //s_PCB_L2_with_gi_power = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols - s_RMSGI_L2_Log;
            s_PCB_L2_with_gi_power = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols - s_RMSGI_L2_Log;
            s_xs_power_cut = s_PCB_L2_with_gi_power - ((int16) gt_RxOLRPMVars.uc_max_PCB_val);

#if 1
            //whether the L2 entry related power reduction with PCB and gi is still in the limits of MaxPCB, i.e.
            //AddPCB_L2Entry-offset-10*log10(sum((gi(L0)/gi(L2))^2)/NC) <= MaxPCB - PCB(L0) with NC = number of carrier in L2 with gi>0
            // Check for ATPR check
            if(s_PCB_L2_with_gi_power > (int16) gt_RxOLRPMVars.uc_max_PCB_val)
            {
               if(s_xs_power_cut > (int16) gt_RxOLRPMVars.uc_max_PCB_val)
               {
                  gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols = (int16) gt_RxOLRPMVars.uc_min_PCB_val;
               }
               else
               {
                  gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols = ((int16) gt_RxOLRPMVars.uc_max_PCB_val) - s_xs_power_cut;
               }
            }
#endif

#if 0
            //Debug
            gs_pcbDsL2SymAfterAtprCheck_dbg = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols;
            gs_RMSGI_L2_Log_dbg = s_RMSGI_L2_Log;
            gs_xs_power_cut_dbg = s_xs_power_cut;
#endif
         }
#endif
         // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

            if (gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols > (int16)gt_RxOLRPMVars.uc_max_PCB_val)
               gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols = (int16)gt_RxOLRPMVars.uc_max_PCB_val;
            // Cutting back too much from L0 power level could result in PLL noise that reduces US SNR margin.
            if (gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols > gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols + MAX_L0_TO_L2_CUTBACK)
               gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols + MAX_L0_TO_L2_CUTBACK;

            /* Set the L2 to L0 exit symbol PCB value to the same as L2 PCB value and use L2 fine gains */
            /* For now -- if better performance required by L2 Exit Sequence Detector the below can be changed */
            gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols= gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols;
            // gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols;
            gt_RxOLRPMVars.t_L2PowerCutBack.ft_isL2Gain = 1;

            //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
            //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifdef HW_SNR_FDQ
            gt_RxOLRPMVars.s_rxOLRPMEvent |= (READ_FDQ1 | READ_FDQ2 | CAL_FDQ_COEF);
#endif
            //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
            //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
      }

      Exit_For_Lp_Exception:
      /* Send L2 defer request */
      if (s_ErrCode)
      {
         // We may have changed the BAT when evaluating whether the L2 request violated SNR margin, so we
         // need to reload that table.
         gt_RxOLRPMVars.uc_rxOLRPMState = OLR_READ_TABLES;
         gt_RxOLRPMVars.s_rxOLRPMEvent = READ_BAT;

         l_Action = 1;
         t_TxOvhdMsgInfoInput->uc_message_type = L2_REJECT;

         // For L2 mode request, it is possible that the requested Lp change is valid according to BIS spec,
         // but not feasible in Socrates firmware implementation. For example, we limit sum{Lp} >16 to obtain
         // enough DS loaded tones so that we can avoid false dection of L2 Exit symbol.
         if ((s_ErrCode & RESP_INFEASIBLE_PARAMETERS) == RESP_INFEASIBLE_PARAMETERS)
         {
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_INFEASIBLE_PARAMETERS;
            STATArray[STAT_PMError] |= s_ErrCode;
         }
         else
         {
            t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_INVALID_PARAMETERS;
            // record the error code and status in PM cmv
            STATArray[STAT_PMError] |= (s_ErrCode | RESP_INVALID_PARAMETERS);
         }
         //XDSLRTFW-1236(START_END)
         STATArray[STAT_PMStatus]=(STATArray[STAT_PMStatus]&(~STAT_OLRPM_CLR_2BITS))|(STAT_OLRPM_ABORTED)|STAT_OLRPM_RESPONSE;
      }


      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
      gft_Amd4_L2_Entry = 0;
      gft_pwr_limit =0;
      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

      // XDSLRTFW-1169 BugFix_All_DS_BisPlus_L2_HonourMaxLP [Start_End]
      OPTNArray[OPTN_Power_Management] &= ~OPTN_L2_DataRate_Towards_Max;

      break;

      case L2_TRIM_REQ:
#if 0
      if( TESTArray[TEST_ReconfigControl] & TEST_TestL2TrimTimeout )
      {
         // Test feature to check for CO time out
         break;
      }
#endif
      // gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols;
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:  0x%02x    (L2 Trim Request)\n", uc_msg_type);
      fprintf(fp_HDLCdata, "Proposed PCBds:0x%02x\n", puca_buffer[idx]);
#endif
      //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
      gs_OlrReq = L2_REQ;
      STATArray[STAT_PMStatus] = STAT_PM_L2_TRIM_REQ|STAT_PM_CO_REQ;

      /* Check if in L2 State */
      if((gt_RxOLRPMVars.uc_rxOLRPMState != L2_STEADY_STATE) || (gt_RxOLRPMVars.s_rxOLRPMEvent != 0))
      {
         // record the error code and status in PM cmv
         STATArray[STAT_PMError] = REQ_NOT_IN_L2_STATE|RESP_BUSY;
         //XDSLRTFW-1236(START_END)
         STATArray[STAT_PMStatus] =(STATArray[STAT_PMStatus]&(~STAT_OLRPM_CLR_2BITS))|(STAT_OLRPM_ABORTED)|STAT_OLRPM_RESPONSE;
         l_Action = 1;
         t_TxOvhdMsgInfoInput->uc_message_type = L2_TRIM_REJECT;
         t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_BUSY;
      break;
      }

      /* Extract the proposed PCBds value */
      s_temp = puca_buffer[idx++];

      // Check if the PCBs are valid and get a valid relative PCB
      getValidPCB(s_temp, s_temp, gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols, &s_RelativePCB, &s_PcbErrCode);

      s_temp = gs_RxDesiredMargin+((s_RelativePCB + gs_L2ExcessMargin)<<8);
      s_ErrCode = SUCCEED;
      // Check that the current BAT (i.e. with deltaLp=0) will still meet SNR margin after the cutback.
      if ((OPTNArray[OPTN_Power_Management] & OPTN_L2_Amd4_Enable) == 0)
         s_ErrCode= CalcNewBATGains(0, s_temp, &s_BATErrCode);



      if ((s_PcbErrCode == 0) && (s_BATErrCode == 0) && (s_ErrCode== SUCCEED))
      {
         OLRPM_RxPreProcessing();

         // Trim request is valid.   Proceed with reconfiguration.

         /* Set the L2toL0Exit PCB value that will be sent out to the CO, postpone setting s_pcbDsL2Symbols until we recieved inverted sync symbol*/
         //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
         //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifndef HW_SNR_FDQ
         gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols += s_RelativePCB;
#endif
         //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
         //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

         //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
         //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
#ifdef HW_SNR_FDQ
         //At this point, FDQ coefficients of all tones are set to the values for L0 state (avoid MIPs peaking in L2 exit),
         //so the re-calculation for FDQ coefficients of all tones need to fall back to the value in L2 state before L2 trim.
         gt_RxOLRPMVars.t_L2PowerCutBack.s_L2FFTGaindB = 0;
         gt_RxOLRPMVars.t_L2PowerCutBack.s_additionalFdqGaindB = 0;
         gt_RxOLRPMVars.t_L2PowerCutBack.s_L2FdqGaindB = 0;

         reconfig_fft_fdq_for_l2pcb();
         if (gs_RxLastChannel > MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION)
            reconfig_next_fdq_for_l2pcb();

         //Start the re-calculation of FDQ coefficients of all tones in L2 trim.
         gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols += s_RelativePCB;
         gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols;

         //Over-write FDQ coefficients of pilot tone before re-calculation for FDQ coefficients of all tones in L2 trim
         gsa_pre_FDQ_coef[gs_PilotToneIdx*2] = gsa_pilot_FDQ_coef[0];
         gsa_pre_FDQ_coef[gs_PilotToneIdx*2+1] = gsa_pilot_FDQ_coef[1];
         guca_pre_FDQ_exp[gs_PilotToneIdx] = guc_pilot_FDQ_exp;

         //Move re-calculation for FDQ coefficients of all tones from TC tasks to here to avoid MIPs peaking
         reconfig_fft_fdq_for_l2pcb();
         if (gs_RxLastChannel > MAX_NUM_CHNLS_FOR_FDQ_COMPUTATION)
         reconfig_next_fdq_for_l2pcb();
#endif
         //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
         //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)

         gt_RxOLRPMVars.s_rxOLRPMEvent = RECONFIG_PCB;

         t_TxOvhdMsgInfoInput->uc_message_type = L2_TRIM_GRANT;
         t_TxOvhdMsgInfoInput->ft_InvertedSyncSymbol_expected = TRUE;

         STATArray[STAT_PMStatus] |=STAT_OLRPM_IN_PROGRESS|STAT_OLRPM_RESPONSE;
      }
      else
      {
         gt_RxOLRPMVars.s_rxOLRPMEvent = READ_BAT | READ_GAIN;

         // Reject L2 TRIM request.
         // record the error code and status in PM cmv
         STATArray[STAT_PMError] = s_BATErrCode | s_PcbErrCode;
         //XDSLRTFW-1236(START_END)
         STATArray[STAT_PMStatus] =(STATArray[STAT_PMStatus]&(~STAT_OLRPM_CLR_2BITS))|(STAT_OLRPM_ABORTED)|STAT_OLRPM_RESPONSE;
         t_TxOvhdMsgInfoInput->uc_message_type = L2_TRIM_REJECT;
         t_TxOvhdMsgInfoInput->uc_defer_reason_code = RESP_INVALID_PARAMETERS;
      }
      l_Action = 1;
      break;

      case STATE_TRANS_GRANT:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:  0x%02x    (State Transition Grant)\n", uc_msg_type);
#endif
      l_Action = 2;
      guc_PM_L3_Response = PM_L3_GRANT_RECEIVED;       //honored only if(guc_PM_L3_InternalState == WAITING_FOR_L3_RESPONSE)
      break;

      case STATE_TRANS_REJECT:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:  0x%02x    (State Transition Reject)\n", uc_msg_type);
#endif
      l_Action = 2;
      // record error code in PM cmv.
      STATArray[STAT_ME_PMREQ_ERROR] = puca_buffer[idx++];
      guc_PM_L3_Response = PM_L3_REJECT_RECEIVED; //honored only if(guc_PM_L3_InternalState == WAITING_FOR_L3_RESPONSE)
      break;

      default:
      break;
   } //switch(uc_msg_type

   if (l_Action == 1)
   {
      TxHdlcSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
   }
#ifdef HDLC_QUEUE_LOGGING
   else if (l_Action == 2)
   {
      ClearExpectedResponse(1);
   }
#endif

   // L3 processing
   if(l_Action == 2)
   {
      PM_L3_State_Machine();
   }
   //End of rx_pwr_mgmt_handler
}

/*****************************************************************************
*   Subroutine Name: rx_clear_eoc_handler(uint8* puca_buffer)
*
*   Description:
*            This subroutine processes the received management counter read command
*
*   Prototype:
*        void rx_clear_eoc_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_clear_eoc_handler(uint8* puca_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
#ifdef HDLC_LEAVE_TRAIL
   int16 i;
#endif

   uc_msg_type = puca_buffer[0];

   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   if(uc_msg_type == CLEAR_EOC_MSG)
   {
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Clear EOC msg)\n", uc_msg_type);
      fprintf(fp_HDLCdata, "Msg Content:    ");

      /* Extract the Clear EOC data */
      for (i = 0; i < CLEAR_EOC_DATA_SIZE; i++)
      {
         fprintf(fp_HDLCdata, "0x%02x ", puca_buffer[i + 1]);
      }

      fprintf(fp_HDLCdata, "\n");
#endif

      t_TxOvhdMsgInfoInput->uc_message_type = CLEAR_EOC_ACK;

      if (((STATArray[STAT_Misc] & STAT_AllCodeSwapsDone) == STAT_AllCodeSwapsDone)
      && (!(gt_RxClearEocBuf_CMV.s_RxClearEocBuf_Disable)))
      // Copy payload bytes. Strip off 4-byte header and 2-byte FCS.
         CopyBufferToRxClearEOC(puca_buffer+1, gus_rx_msg_index-6);

#ifdef TARGET_HW
      QueueInterruptRequest(OMB_CLEAREOC_INTERRUPT_CODE);
#endif

      TxHdlcSendRequest(1 /* priority */, *t_TxOvhdMsgInfoInput);
   }
   else if ((uc_msg_type == CLEAR_EOC_ACK) || (uc_msg_type == CLEAR_EOC_NACK))
   {
#ifdef ENABLE_ALL_HDLC_OVHD

#ifdef HDLC_LEAVE_TRAIL
      if (uc_msg_type == CLEAR_EOC_ACK)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Clear EOC Ack)\n", uc_msg_type);
      else if (uc_msg_type == CLEAR_EOC_NACK)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Clear EOC NAck)\n", uc_msg_type);
#endif
#ifdef HDLC_QUEUE_LOGGING
      ClearExpectedResponse(1);
#endif
#endif
   }
}


/*****************************************************************************
*   Subroutine Name: rx_nsf_facility_cmd_handler(uint8* puca_buffer)
*
*   Description:
*            This subroutine processes the received nsf command
*
*   Prototype:
*        void rx_nsf_facility_cmd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/

void rx_nsf_facility_cmd_handler(uint8* puca_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;

#ifdef HDLC_LEAVE_TRAIL
   uint8 i;
#endif

   uc_msg_type = puca_buffer[0];
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;

   if(uc_msg_type == NSF)
   {
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (NSF msg)\n", uc_msg_type);
#endif
      if(gt_RxHDLCMsg.message_priority    != 0)
      {
         t_TxOvhdMsgInfoInput->uc_message_type = NSF_ACK;
         TxHdlcSendRequest(gt_RxHDLCMsg.message_priority, *t_TxOvhdMsgInfoInput);
      }


#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "NSF content:    ");
      for (i = 0; i < gus_hdlc_msg_len-6; i++)
         fprintf(fp_HDLCdata, "0x%02x ", puca_buffer[1+i]);

      fprintf(fp_HDLCdata, "\n");
#endif
   }
#ifdef ENABLE_ALL_HDLC_OVHD
   else if ((uc_msg_type == NSF_ACK) || (uc_msg_type == NSF_NEG_ACK))
   {
#ifdef HDLC_LEAVE_TRAIL
      if (uc_msg_type == NSF_ACK)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (NSF ACK msg)\n", uc_msg_type);
      else if (uc_msg_type == NSF_NEG_ACK)
         fprintf(fp_HDLCdata, "Message Type:    0x%02x    (NSF NACK msg)\n", uc_msg_type);
#endif

#ifdef HDLC_QUEUE_LOGGING
      if (gt_RxHDLCMsg.message_priority  != 0)
      {
         ClearExpectedResponse(gt_RxHDLCMsg.message_priority);
#endif
      }
   }
#endif //#ifdef ENABLE_ALL_HDLC_OVHD
}
extern uint8 guc_param_rd_carrier_index;

/*****************************************************************************
*   Subroutine Name: rx_test_param_rd_handler(uint8* puca_buffer)
*
*   Description:
*      This subroutine processes the received test parameter read command
*
*   Prototype:
*      void rx_test_param_rd_handler(uint8* puca_buffer)
*
*   Input Arguments: Message Buffer
*
*   Output Arguments: none
*
*   Return: none
*****************************************************************************/
void rx_test_param_rd_handler(uint8* puca_buffer,TxOvhdMsgInfoRequest_t* t_TxOvhdMsgInfoInput)
{
   uint8 uc_msg_type;
   int32 l_Action, k=0;
   uint16 us_fe_measurement_period, us_fe_subcarrier_param;
   int16 i;
   uc_msg_type = puca_buffer[0];
   t_TxOvhdMsgInfoInput->uc_TestParameterId = gta_TxHdlcControlInfo[OVHD_LOW_PRIORITY].uc_ExpectedTestParamId;

   l_Action = 0;
   t_TxOvhdMsgInfoInput->uc_Source = RESPONSE_SOURCE;
   switch(uc_msg_type)
   {
      case SINGLE_READ:
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Single Read msg)\n", uc_msg_type);
      #endif
      l_Action = 1;

      /* Get the test paramter ID */
      t_TxOvhdMsgInfoInput->uc_TestParameterId = puca_buffer[1];

      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Test_ParamID:    0x%02x    ", t_TxOvhdMsgInfoInput->uc_TestParameterId);
      switch (t_TxOvhdMsgInfoInput->uc_TestParameterId)
      {
         case CHANNEL_TRANSFER_FUNCTION:
         fprintf(fp_HDLCdata, "(Channel Transfer Function Hlog(f))\n");
         break;

         case QUIET_LINE_NOISE_PSD:
         fprintf(fp_HDLCdata, "(Quiet Line Noise PSD QLN(f))\n");
         break;

         case SNR:
         fprintf(fp_HDLCdata, "(SNR)\n");
         break;

         case LINE_ATTENUATION:
         fprintf(fp_HDLCdata, "(Line Attenuation LATN)\n");
         break;

         case SIGNAL_ATTENUATION:
         fprintf(fp_HDLCdata, "(Signal Attenuation SATN)\n");
         break;

         case SIGNAL_TO_NOISE_MARGIN:
         fprintf(fp_HDLCdata, "(SNR Margin)\n");
         break;

         case ATTAIN_NET_DATA_RATE:
         fprintf(fp_HDLCdata, "(Attainable Net Data Rate ATTNDR)\n");
         break;

         case NE_ACTUAL_TRANSMIT_POWER:
         fprintf(fp_HDLCdata, "(Near-end ACTATP)\n");
         break;

         case FE_ACTUAL_TRANSMIT_POWER:
         fprintf(fp_HDLCdata, "(Far-end ACTATP)\n");
         break;

         default:
         break;
      }
      #endif

      #ifndef TARGET_HW
      // For software sims, reply NACK to HLOGds request in Plus since CocomoCO doesn't support
      // segmented messaging.
      if ((( gl_SelectedMode & (MODE_G992_5) )) && (t_TxOvhdMsgInfoInput->uc_TestParameterId == CHANNEL_TRANSFER_FUNCTION))
      {
         t_TxOvhdMsgInfoInput->uc_message_type = PMD_TEST_PAR_READ_NACK;
      break;
      }
      #endif

      t_TxOvhdMsgInfoInput->uc_message_type = SINGLE_READ_ACK;
      break;

      // Unfortunately, standard doesnt specify unique message types between
      // bis/plus modes. PLUS_MULT_READ and BIS_BLOCK_READ both have a value 4
      case MULT_READ:
      case PLUS_MULT_READ:
      case PLUS_BLOCK_READ:
      #ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Multiple Read msg)\n", uc_msg_type);
      fprintf(fp_HDLCdata, "Specified Tone:0x%02x\n", puca_buffer[1]);
      #endif
      l_Action = 1;

      /* If sub carrier index goes out of range, send a NACK */
      t_TxOvhdMsgInfoInput->uc_message_type = PMD_TEST_PAR_READ_NACK;

      /* Multiple Read */
      if (uc_msg_type == MULT_READ ||(uc_msg_type == PLUS_MULT_READ && (gl_SelectedMode & (MODE_G992_5))))
      {
         /* Get the sub carrier index */
         if (uc_msg_type == PLUS_MULT_READ)
            t_TxOvhdMsgInfoInput->us_param_rd_carrier_index = (puca_buffer[1]<<8)  | puca_buffer[2];
         else
            t_TxOvhdMsgInfoInput->us_param_rd_carrier_index = puca_buffer[1];

         /* Verify the sub carrier index */
         if (t_TxOvhdMsgInfoInput->us_param_rd_carrier_index < gs_RxNumTones)
         {
            // keep track of the index for NEXT_MULT_READ usage.
            guc_param_rd_carrier_index = (uint8)t_TxOvhdMsgInfoInput->us_param_rd_carrier_index;
            t_TxOvhdMsgInfoInput->uc_message_type = MULT_READ_ACK;
         }
      }
      /* Block Read */
      else
      {
         /* Get the sub carrier index */
         if (uc_msg_type == PLUS_BLOCK_READ)
         {
            t_TxOvhdMsgInfoInput->us_param_rd_start_carrier_index = (puca_buffer[1]<<8)    | puca_buffer[2];
            t_TxOvhdMsgInfoInput->us_param_rd_stop_carrier_index = (puca_buffer[3]<<8) | puca_buffer[4];
         }
         else
         {
            t_TxOvhdMsgInfoInput->us_param_rd_start_carrier_index = puca_buffer[1];
            t_TxOvhdMsgInfoInput->us_param_rd_stop_carrier_index = puca_buffer[2];
         }

         /* Verify the # of tones <= 160(gs_MaxTonePerOvhdMsg). Protect against block read responses that are too large. */
         /* For Block read, the total length is: (Hlog) 2+2*(stopTone - startTone+1)
         (QLN) +2+(stopTone - startTone+1)
         (SNR) +2+(stopTone - startTone+1)
         */

         /* Verify the sub carrier index */
         if (t_TxOvhdMsgInfoInput->us_param_rd_start_carrier_index <= t_TxOvhdMsgInfoInput->us_param_rd_stop_carrier_index &&
         t_TxOvhdMsgInfoInput->us_param_rd_stop_carrier_index < gs_RxNumTones &&
         ((t_TxOvhdMsgInfoInput->us_param_rd_stop_carrier_index - t_TxOvhdMsgInfoInput->us_param_rd_start_carrier_index) <= gs_MaxTonePerOvhdMsg))
         {
            t_TxOvhdMsgInfoInput->uc_message_type = BLOCK_READ_ACK;
         }
      }

      break;

      case NEXT_MULT_READ:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Next Multiple Read msg)\n", uc_msg_type);
#endif
      l_Action = 1;

      /* Increment the saved sub carrier index to transmit info about this */
      /* sub carrier in the next mult read */
      t_TxOvhdMsgInfoInput->us_param_rd_carrier_index = ++guc_param_rd_carrier_index;


      if(t_TxOvhdMsgInfoInput->us_param_rd_carrier_index < gs_RxNumTones)
      {
         t_TxOvhdMsgInfoInput->uc_message_type = MULT_READ_ACK;
      }
      else
      {
         /* If sub carrier index goes out of range, send a NACK */
         t_TxOvhdMsgInfoInput->uc_message_type = PMD_TEST_PAR_READ_NACK;
      }

      break;

      case SINGLE_READ_ACK:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Single Read Ack )\n", uc_msg_type);
#endif
      l_Action = 2;
      /* Save test parameter read response from far-end */
      switch(t_TxOvhdMsgInfoInput->uc_TestParameterId)
      {
         case CHANNEL_TRANSFER_FUNCTION:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Channel Transfer Func )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         us_fe_measurement_period = ((uint16)puca_buffer[1] << 8) | (uint16)puca_buffer[2];
         gt_US_MeasurementPeriod.us_Hlogf_measurement_period = us_fe_measurement_period; // HLOGMTds

         for (i = 0; i < gs_TxNumTones; i++)
         {
            // Compensated HLOG represented as m(i)
            // HLOG messaged across as m(i) which is a 10-bit unsigned integer
            // where HLOG(i) = 6-(m(i)/10)
            us_fe_subcarrier_param = ((uint16)puca_buffer[3 + (2 * i)] << 8);
            us_fe_subcarrier_param |= ((uint16)puca_buffer[3 + (2 * i) + 1]);
            us_fe_subcarrier_param &= 0x3FF; // m(i) is unsigned integer of 10 bits size

            gus_US_Hlogf_m[i] = us_fe_subcarrier_param;
         }
         break;

         case QUIET_LINE_NOISE_PSD:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Quiet Line Noise PSD )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         // QLN represented as per Hercules API CMV spec
         // QLN messaged across using n(i) unsigned integer of 8 bits size
         // where QLN(i) = -23-(n(i)/2)
         us_fe_measurement_period = ((uint16)puca_buffer[1] << 8) | (uint16)puca_buffer[2];
         gt_US_MeasurementPeriod.us_QLN_measurement_period = us_fe_measurement_period; // QLNMTds
         for (i = 0; i < gs_TxNumTones; i++)
         {
            guca_US_Quiet_Line_Noise[i] = puca_buffer[3 + i]; // n(i) is unsigned integer of 8 bits
         }
         break;

         case SNR:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (SNR )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         // SNR messaged across using snr(i) unsigned integer of 8 bits size
         // where SNR(i) = -32+(snr(i)/2)
         // The received SNR values are packed 2 tones per offset of the DS SNR array
         us_fe_measurement_period = ((uint16)puca_buffer[1] << 8) | (uint16)puca_buffer[2];
         gt_US_MeasurementPeriod.us_snr_measurement_period = us_fe_measurement_period; // SNRMTds
         for (i = 0; i < gs_TxNumTones; i++)
         {
            guca_US_ShowtimeSNR[i] = puca_buffer[3 + i]; // snr(i) is unsigned integer of 8 bits
         }
         break;

         case LINE_ATTENUATION:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Line Attenuation LATN)\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         gt_FarEndParam.us_LoopAttenuation = ((uint16)puca_buffer[1] << 8) | (uint16)puca_buffer[2];
         break;

         case SIGNAL_ATTENUATION:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Signal Attenuation SATN)\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         gt_FarEndParam.us_SignalAttenuation = ((uint16)puca_buffer[1] << 8) | (uint16)puca_buffer[2];
         break;

         case SIGNAL_TO_NOISE_MARGIN:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (SNR Margin )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         gt_FarEndParam.s_SnrMargin = ((int16)puca_buffer[1] << 8) | (int16)puca_buffer[2];
         break;

         case ATTAIN_NET_DATA_RATE:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Attainable Net Date Rate ATTNDR)\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         gt_FarEndParam.ul_AttainableDataRate = (((uint16)puca_buffer[1] << 24) | ((uint16)puca_buffer[2] << 16)| ((uint16)puca_buffer[3] << 8) | (uint16)puca_buffer[4]);
         break;

         case NE_ACTUAL_TRANSMIT_POWER:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Near-end ACTATP)\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         gs_nearend_ActualAggregateXmtPwr = ((int16)puca_buffer[1] << 8) | ((int16)puca_buffer[2] & 0xFF);
         break;

         case FE_ACTUAL_TRANSMIT_POWER:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Far-end ACTATP)\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         gt_FarEndParam.s_ActualAggregateXmtPwr = ((int16)puca_buffer[1] << 8) | ((int16)puca_buffer[2] & 0xFF);
         break;

         //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
         case FE_ACTUAL_INP_ACT:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Far-end ActINP)\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         gt_FarEndParam.us_ActualINP = ((int16)puca_buffer[1]);   //Assumption: Bearer Channel-0 INP is mapped to lower octet
         gt_HercADSL_USRateCMV.s_ActInpErasure[0] = ((int16)puca_buffer[1]); //Assumption: Bearer Channel-0 INP is mapped to LSB octet
         gt_HercADSL_USRateCMV.s_ActInpErasure[1] = ((int16)puca_buffer[2]); //Assumption: Bearer Channel-1 INP is mapped to MSB octet
         break;
         //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)

         //XDSLRTFW-738 Task_DS_BisPlus_All_ReportInpReinShineInReTx (Start)
         case RETX_INP_ACT_SHINE:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Far-end ReTx ActINP SHINE)\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         gt_ReTXStats.us_FE_InpActShine = ((((uint16)puca_buffer[1] << 8) | (uint16)puca_buffer[2]));
         break;

         case RETX_INP_ACT_REIN:
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Far-end ReTx ActINP REIN)\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
         gt_ReTXStats.us_FE_InpActRine = ((uint16)puca_buffer[1]);
         break;
         //XDSLRTFW-738 Task_DS_BisPlus_All_ReportInpReinShineInReTx (End)

      }
      break;

      case MULT_READ_ACK:
      l_Action = 2;
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Multiple Read Ack)\n", uc_msg_type);
      fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Channel Transfer Func )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
      // Compensated HLOG represented as m(i)
      // HLOG messaged across using m(i) unsigned integer of 10 bits size
      // where HLOG(i) = 6-(m(i)/10)
      us_fe_measurement_period = ((uint16)puca_buffer[1] << 8) | (uint16)puca_buffer[2];
      gt_US_MeasurementPeriod.us_Hlogf_measurement_period = us_fe_measurement_period; // HLOGMTds
      us_fe_subcarrier_param = ((uint16)puca_buffer[3] << 8);
      us_fe_subcarrier_param |= ((uint16)puca_buffer[4]);
      us_fe_subcarrier_param &= 0x3FF; // m(i) is unsigned integer of 10 bits size
      gus_US_Hlogf_m[t_TxOvhdMsgInfoInput->us_param_rd_carrier_index] = us_fe_subcarrier_param;

#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Quiet Line Noise PSD )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
      // QLN represented as per Hercules API CMV spec
      // QLN messaged across using n(i) unsigned integer of 8 bits size
      // where QLN(i) = -23-(n(i)/2)
      us_fe_measurement_period = ((uint16)puca_buffer[5] << 8) | (uint16)puca_buffer[6];
      gt_US_MeasurementPeriod.us_QLN_measurement_period = us_fe_measurement_period; // QLNMTds
      guca_US_Quiet_Line_Noise[t_TxOvhdMsgInfoInput->us_param_rd_carrier_index] = puca_buffer[7];

#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (SNR )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
      // SNR messaged across using snr(i) unsigned integer of 8 bits size
      // where SNR(i) = -32+(snr(i)/2)
      us_fe_measurement_period = ((uint16)puca_buffer[8] << 8) | (uint16)puca_buffer[9];
      gt_US_MeasurementPeriod.us_snr_measurement_period = us_fe_measurement_period; // SNRMTds
      guca_US_ShowtimeSNR[t_TxOvhdMsgInfoInput->us_param_rd_carrier_index] = puca_buffer[10];
      break;

      case BLOCK_READ_ACK:
      l_Action = 2;
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (Block Read Ack)\n", uc_msg_type);
      fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Channel Transfer Func )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
      // Compensated HLOG represented as m(i)
      // HLOG messaged across using m(i) unsigned integer of 10 bits size
      // where HLOG(i) = 6-(m(i)/10)
      us_fe_measurement_period = ((uint16)puca_buffer[1] << 8) | (uint16)puca_buffer[2];
      gt_US_MeasurementPeriod.us_Hlogf_measurement_period = us_fe_measurement_period; // HLOGMTds
      for (i = t_TxOvhdMsgInfoInput->us_param_rd_start_carrier_index; i < t_TxOvhdMsgInfoInput->us_param_rd_stop_carrier_index; i++)
      {
         us_fe_subcarrier_param = ((uint16)puca_buffer[3 + (2 * i)] << 8);
         us_fe_subcarrier_param |= ((uint16)puca_buffer[3 + (2 * i) + 1]);
         us_fe_subcarrier_param &= 0x3FF; // m(i) is unsigned integer of 10 bits size

         gus_US_Hlogf_m[i] = us_fe_subcarrier_param;
      }

#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (Quiet Line Noise PSD )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
      // QLN represented as per Hercules API CMV spec
      // QLN messaged across using n(i) unsigned integer of 8 bits size
      // where QLN(i) = -23-(n(i)/2)
      us_fe_measurement_period = ((uint16)puca_buffer[5] << 8) | (uint16)puca_buffer[6];
      gt_US_MeasurementPeriod.us_QLN_measurement_period = us_fe_measurement_period; // QLNMTds
      for (i = t_TxOvhdMsgInfoInput->us_param_rd_start_carrier_index; i < t_TxOvhdMsgInfoInput->us_param_rd_stop_carrier_index; i++)
      {
         guca_US_Quiet_Line_Noise[i] = puca_buffer[3 + i]; // n(i) is unsigned integer of 8 bits
      }

#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Test Parameter:   0x%02x  (SNR )\n", t_TxOvhdMsgInfoInput->uc_TestParameterId);
#endif
      // SNR messaged across using snr(i) unsigned integer of 8 bits size
      // where SNR(i) = -32+(snr(i)/2)
      us_fe_measurement_period = ((uint16)puca_buffer[8] << 8) | (uint16)puca_buffer[9];
      gt_US_MeasurementPeriod.us_snr_measurement_period = us_fe_measurement_period; // SNRMTds
      for (i = t_TxOvhdMsgInfoInput->us_param_rd_start_carrier_index; i < t_TxOvhdMsgInfoInput->us_param_rd_stop_carrier_index; i++)
      {
         guca_US_ShowtimeSNR[i] = puca_buffer[3 + i]; // snr(i) is unsigned integer of 8 bits
      }
      break;

      case PMD_TEST_PAR_READ_NACK:
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "Message Type:    0x%02x    (PMD Teat Parameter Read Ack)\n", uc_msg_type);
#endif
      l_Action = 2;
      break;
   }

   if (l_Action == 1)
   {
   TxHdlcSendRequest(2 /* priority */, *t_TxOvhdMsgInfoInput);
   }
   #ifdef HDLC_QUEUE_LOGGING
   else if (l_Action == 2)
   {
   ClearExpectedResponse(2);
   }
   #endif
}

/*****************************************************************************
;      Subroutine Name: FlagT ExtractBinsInfo(uint8* puca_buffer, int16 s_Nf, FlagT ft_isPlus, int16* sa_deltaLp, int16* ps_retCode, uint8* uca_TxBat, int16* sa_TxFineGains)
;
;      This subroutine extracts the bitswap bins information from the OLR messafde
; received
;
;      Prototype:
;            FlagT ExtractBinsInfo(uint8* puca_buffer, int16 s_Nf, FlagT ft_isPlus, int16* sa_deltaLp, int16* ps_retCode, uint8* uca_TxBat, int16* sa_TxFineGains)
;
;      Input Arguments:
;
;      Output Arguments:
;
;      Return:
;
;******************************************************************************/
FlagT ExtractBinsInfo(uint8* puca_buffer, int16 s_Nf, FlagT ft_isPlus, int16* sa_deltaLp, int16* ps_retCode, uint8* uca_TxBat, int16* sa_TxFineGains)
{
   int32 i,k;
   int16 s_carrier_index;
   uint16 us_TxFineGain;
   uint8 uc_TxBat;
   int16 sa_Lp[NUM_DATA_PATHS]={0};

   if (!s_Nf)
      return (FALSE);


   // We don't want to change the global BAT table and FineGain Table in checking process. Therefore,
   // we set the local BAT table and FineGain table with the original global array values
   memcpy(uca_TxBat, guca_TxBat, TX_NUM_TONES);
   memcpy(sa_TxFineGains, gsa_TxFineGains, TX_NUM_TONES*sizeof(int16));

   /* Extract the bins information */
   for (i = 0, k = 0; k < s_Nf; i = i+3, k++)
   {
      if (ft_isPlus)
      {
         s_carrier_index = (puca_buffer[i++]<<8);
         s_carrier_index |= puca_buffer[i];
      }
      else
         s_carrier_index = puca_buffer[i];

      us_TxFineGain = (uint16)((puca_buffer[i+1] <<8)| (puca_buffer[i+2] & 0xF0));
      uc_TxBat = (puca_buffer[i+2] & 0xF);
      /* Check the parameters and reject the bitswap if not valid. Tone index, */
      /* TX fine gain, and TX bits have to be less than respective maxima. Note that */
      /* the check is done in an unsigned arithmetic so this check rejects bitswap */
      /* if any of the variables are negative. */
      if (((uint16)s_carrier_index > gs_TxLastChannel) || (us_TxFineGain > 0x2AB0) || (uc_TxBat > TX_MAX_BITS_PER_TONE))
      {
         *ps_retCode = REQ_INVALID_BiGi;
         return (TRUE);
      }
      sa_TxFineGains[s_carrier_index] = (int16)us_TxFineGain;
      uca_TxBat[s_carrier_index] =   uc_TxBat;
   }


   // calculate the new proposed Lp value
   for (i = 0; i < gt_tx_config.s_Nlp; i++)
      sa_Lp[i] = gt_tx_config.s_Lp[i] + sa_deltaLp[i];

   /* ========================================================================= */
   /* Verify if frame size matches to bit allocation table (DMT/BIS Showtime,OLR,L2)*/
   /* Also computes parameters for Tx QAM/TCM block configuration*/
   /* ========================================================================= */
   if (!VerifyAndUpdateTxQAMParameters(uca_TxBat, sa_Lp))
   {
      *ps_retCode = REQ_INVALID_BiGi;
      return (TRUE);
   }

   return(FALSE);
}


/*****************************************************************************
;      Subroutine Name: CalcNewBATGains(int16 s_Lp_delta, int16 s_DesiredMargin, int16 *ps_RetCode)
;
;      This subroutine updates the BAT and gain table as per the OLR request
;
;      Prototype:
;            void CalcNewBATGains(int16 s_Lp_delta, int16 s_DesiredMargin, int16 *ps_RetCode)
;
;      Input Arguments:
;
;      Output Arguments:
;
;      Return:
;
;******************************************************************************/

FlagT CalcNewBATGains(int16 s_Lp_delta, int16 s_DesiredMargin, int16 *ps_RetCode)
{
   int16 s_ActualDeltaSumLp=0;
   //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (START_END)
   int16 s_MarginCheck;
   uint8 uc_RetCode;
   int32 i;

   for(i = 0; i < (int16)(gs_RxNumTones>>3); i++)
   {
      guca_RxBitswapTones[i] = 0;
   }


   // Disable margin validation for OLR here. It is done by putting desired margin to NEG_INFINITY_DB dB,
   if (OPTNArray[OPTN_OLRControl_DS] & OPTN_Disable_MarginVal_OLR)
      s_DesiredMargin = NEG_INFINITY_DB;

   //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (START)
   //SMS00966303 SMS00954738 Feature_AB_DS_BISPlus_ALL_IncreaseAccuracySRAStep (START_END)
   if(gft_SRAUpShift_process||gft_SRADnShift_process)
      s_MarginCheck = 0; // remove limitations
   else
      s_MarginCheck = s_DesiredMargin;

   //XDSLRTFW-1727
   if(gft_Amd4_L2_Entry)
      uc_RetCode = ChangeL2BitGains(guca_RxBat, gsa_RxFineGains, -s_Lp_delta,gsa_RxShowtimeSnrBuf, (s_MarginCheck),p_MEDLEYset_DS, guca_RxBitswapTones,&s_ActualDeltaSumLp, FALSE, 0, 0);
   else
      uc_RetCode = ChangeLpKeepMaxMargin(guca_RxBat, gsa_RxFineGains, s_Lp_delta,gsa_RxShowtimeSnrBuf, s_MarginCheck,p_MEDLEYset_DS, guca_RxBitswapTones,&s_ActualDeltaSumLp, FALSE, 0, 0);
   //SMS00966298 SMS00951973 IOP_DS_BISPlus_ALL_SRATargetMarginFix (END)


   if (uc_RetCode != 0)
   {
      // Error
      if (uc_RetCode == CHGBAT_RETCODE_VIOLATES_MARGIN)
         *ps_RetCode = REQ_VIOLATES_MARGIN | RESP_INFEASIBLE_PARAMETERS;
      else
         *ps_RetCode = REQ_INVALID_Lp;
      return (FAIL);
   }

   PreSelectReverbSegueDetector();

   return (SUCCEED);
}
//XDSLRTFW-1727
#define DSPS_MAX(a,b) \
      ({ typeof (a) _a = (a); \
         typeof (b) _b = (b); \
       _a > _b ? _a : _b; })

#define DSPS_MIN(a,b) \
      ({ typeof (a) _a = (a); \
         typeof (b) _b = (b); \
       _a < _b ? _a : _b; })

#define MAX_L2_RATE_WITHOUT_AMD4 (1024)


#define MAX_GI_L2_AMD4 (640) //2.5*256
//#define MIN_GI_L2_AMD4 (-2125) //-8.3*256

//#define MIN_GI_L2_AMD4 (-3712) //-14.5*256
//#define MIN_GI_L2_AMD4 (-640) //-2.5*256
//#define MIN_GI_L2_AMD4 (-3400) //-13.281*256
//#define MIN_GI_L2_AMD4 (-1792) //-7*256

#define MIN_GI_L2_AMD4 (-2560) //-10*256


int16 GetL2Lp(uint8 *puca_buffer, int32 idx,int16 *ps_LpMaxCpy,int16 *ps_LpMinCpy, int16 *ps_sum_deltaLp)
{
   int16 s_ErrCode = 0;
   int16 s_L2_Min;
   int16 sa_Lp_delta[NUM_DATA_PATHS]={0};
   /* Read the min, max Lp values received from CO */
   int16 sa_LpMax[NUM_DATA_PATHS]={0};
   int16 sa_LpMin[NUM_DATA_PATHS]={0};
   int16 i;



   for(i = 0; i < gt_rx_config.s_Nlp; i++)
   {
      /* Get the Lp high octet */
      sa_LpMax[i] = (int16)(puca_buffer[idx++] << 8);
      /* Get the Lp low octet */
      sa_LpMax[i] |= puca_buffer[idx++];
   }

   *ps_LpMaxCpy = sa_LpMax[0]; // Store LpMax



   *ps_sum_deltaLp = 0;

   for(i = 0; i < gt_rx_config.s_Nlp; i++)
   {
      /* Get the Lp high octet */
      sa_LpMin[i] = (int16)(puca_buffer[idx++] << 8);
      /* Get the Lp low octet */
      sa_LpMin[i] |= puca_buffer[idx++];

      *ps_LpMinCpy = sa_LpMin[0];

      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
      // Check that LpMin <= LpMax and
      // if L2 AMD-4 is disabled, we cannot support L2 rate greater than 4Mbps.
      if ((sa_LpMin[i] > sa_LpMax[i]) ||
      ((sa_LpMin[i] > MAX_L2_RATE_WITHOUT_AMD4) && ((OPTNArray[OPTN_Power_Management] & OPTN_L2_Amd4_Enable) == 0)))
      {
         s_ErrCode |= REQ_INVALID_Lp|RESP_INVALID_PARAMETERS;
      return(s_ErrCode);
      }
      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

      #ifdef L2_AMD4_REDUNDANT_CODE
      // TODO: The below piece of code which enables Amd-4 only if LpMax is more than 50% or if   loop is greater than 1900 is spurious, Enable L2 Amd-4 for everything
      // @note: mahesh: If max L2 rate requested is less than 50% of L0 rate no need to enable L2-Amd4 . This may not be required
      // XDSLRTFW-1169 BugFix_All_DS_BisPlus_L2_HonourMaxLP [Start]
      if ( sa_LpMax[0] < ((gt_rx_config.s_Lp[0] + 1) >> 1))
      {
         gft_Amd4_L2_Entry = 0;
      }

      //if(OPTNArray[OPTN_Power_Management] & OPTN_L2_DataRate_Towards_Max)
      //@note: mahesh: Disable L2 Amd-4 for loops less than 1900m.
      {
#ifndef ISDN
         if (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_6250F)
#else
         if (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_1900M)
#endif
         {
            gft_Amd4_L2_Entry = 0;
            OPTNArray[OPTN_Power_Management] |= OPTN_L2_DataRate_Towards_Max;
         }
      }
      // XDSLRTFW-1169 BugFix_All_DS_BisPlus_L2_HonourMaxLP [End]
#endif
      OPTNArray[OPTN_Power_Management] |= OPTN_L2_DataRate_Towards_Max;


      // check framing constraints of available new Lp
      s_L2_Min = gt_DerivedFrameProperties_DS.PropPerLp[i].s_L2_LMin;

      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
      //the new L2 delay constraint (delay(L2)<=2*delay(L0) which means rate(L2)>=rate(L0)/2)

      //where L2_MIN1 = min(DerivedL2Min,L0Lp/2)

      if ((gft_Amd4_L2_Entry == 1) && ((TESTArray[TEST_Control3] & TEST_L2ModeAmd4G9923_L2LpConditionDIS) == 0) )
      {
         s_L2_Min = DSPS_MIN(((gt_rx_config.s_Lp[i] + 1) >> 1),s_L2_Min);
      }

      if (s_L2_Min > sa_LpMax[i])
      {
         s_ErrCode |= (REQ_INVALID_Lp | RESP_INFEASIBLE_PARAMETERS);
      return(s_ErrCode);
      }
      sa_LpMin[i] = DSPS_MAX(sa_LpMin[i] , s_L2_Min);


      // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
      // XDSLRTFW-1169 BugFix_All_DS_BisPlus_L2_HonourMaxLP [Start_End]
      if ((OPTNArray[OPTN_Power_Management] & OPTN_L2_DataRate_Towards_Max))
      {
         // sa_Lp_delta[i] = sa_LpMin[i] - gt_rx_config.s_Lp[i]; //comment old one
         // check framing constraints of available new Lp
         //s_L2(ie.,L2Lp) = min (L2_Lp_Max, DerivedLPMax)
         // This condition will ensure Data rate in L2 towards L2_LPMax

         int16 s_L2_Max = gt_DerivedFrameProperties_DS.PropPerLp[i].s_L2_LMax;


         if (s_L2_Max < sa_LpMin[i])
         {
            s_ErrCode |= REQ_INVALID_Lp | RESP_INFEASIBLE_PARAMETERS;

         return(s_ErrCode);
         }
         s_L2_Max = DSPS_MIN(s_L2_Max , sa_LpMax[i]);

         //if L2Lp is greater is greater than LoLp
         // Go to L2 entry with LpMin.
         if(s_L2_Max >= gt_rx_config.s_Lp[i])
         {
            s_L2_Max = sa_LpMin[i];
         }

         sa_Lp_delta[i] = s_L2_Max - gt_rx_config.s_Lp[i];

         //ADSLRTFW-1453 FEATURE_DS_BisPlus_ALL_PML2_MaxDataRate (end)
      }
      else
      {
         sa_Lp_delta[i] = sa_LpMin[i] - gt_rx_config.s_Lp[i];
      }
      *ps_sum_deltaLp += sa_Lp_delta[i];
   }//for (gt_rx_config.s_Nlp

   //gs_L2 = s_sum_deltaLp; //for Debug purpose
   // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]



   if (*ps_sum_deltaLp >= 0)
   {
      // Though not invalid, we're not interested in doing L2 transitions that increase Lp.
      s_ErrCode = REQ_INVALID_Lp|RESP_INFEASIBLE_PARAMETERS;
   }
   return(s_ErrCode);
}

void CalcOffSetSnr(int16 *psa_RxShowtimeSnrBuf, int16 *psa_OffsetSnr, int16 s_Pcb,uint8 *puca_RxBat,int16 *psa_RxFineGains,int16 *psa_NewRxFineGains ,RxToneFlags p_ModifiedTones )
{
   int16 s_ActualDeltaSumLp=0;
   int32 s_ch;

   int16 s_MinSnr;
   int16 s_MinFineGain;
   int16 s_Offset;
   int16 s_GiSnrMin;
   int16 s_ConstSnrOneBit = gsa_ConstellationSNR[1];
   s_MinSnr = 15360; //initialize minsnr to 60dB in 8.8 format
   s_MinFineGain = MAX_GI_L2_AMD4;//(2.5*256);
   gft_FineGainShaping = FALSE;


   // SNRv is a vector with the current SNRdownstream per tone at the time of L2 entry request
   // x would be the remaining SNRds(tone) if AddPCB_L2Entry would be applied for L2 entry
   // x=SNRv-AddPCB_L2Entry;

   // TODO: What happens if the bi = 0 & we cannot reduce snr below the gains - 14.5dB on it -
   // TODO:   should min snr after subtracting PCB be 0 or target margin?

   #define MIN_SNR_L2_AMD4     (0*256)


   for (s_ch=gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
   {
#if 1
      int16 s_DelPcb;
      int16 s_FG = psa_RxFineGains[s_ch] - s_Pcb;

      if(puca_RxBat[s_ch] >0)
      {

         if(s_FG < MIN_GI_L2_AMD4)
         {
            s_FG = MIN_GI_L2_AMD4;
         }

         if(s_FG > MAX_GI_L2_AMD4)
         {
            s_FG = MAX_GI_L2_AMD4;
         }

         s_DelPcb = psa_RxFineGains[s_ch] - s_FG;

         psa_OffsetSnr[s_ch] = psa_RxShowtimeSnrBuf[s_ch] - s_DelPcb;
#else
         psa_OffsetSnr[s_ch] = psa_RxShowtimeSnrBuf[s_ch] - s_Pcb;
#endif

         //Check if flat cutback is possible.
         if ((psa_OffsetSnr[s_ch] <=   MIN_SNR_L2_AMD4) && (puca_RxBat[s_ch] > 0))
         {

            gft_FineGainShaping = TRUE;
            //TODO: donot break here as we need to calculate offset SNR for all tones
         //break;
         }
         //x_min=min(x(find(BIv>0))); %% minimum of remaining SNRds(tone) for tones with bit loading in L0
         //if x_min<0   %% gi shaping
         //SNRvn=SNRv; snr in L0
         //SNRvn(find(BIv>0))=SNRv(find(BIv>0))-GIvlog(find(BIv>0)); %% normalized SNRv which would be seen if all gi values in L0 would be one for tones with bi>=0
         //xn=SNRvn-AddPCB_L2Entry; %% normalized SNR after PCB

         //MAHESH-BHADRA
         //psa_OffsetSnr[s_ch] = psa_OffsetSnr[s_ch] - psa_RxFineGains[s_ch];
         //MAHESH-BHADRA
         //xn_min=min(xn(find(BIv>0))) %% minimum of remaining normalized SNRds(tone) for tones with bit loading in L0
         if(s_MinSnr > psa_OffsetSnr[s_ch])      //TODO: MinSnr has to be TargetMargin //TODO:
         {
            s_MinSnr = psa_OffsetSnr[s_ch];

         }
         //Reduce the fine gains too by an amount of PCB
         //psa_RxFineGains[s_ch] = psa_RxFineGains[s_ch] - (s_Pcb);
         psa_RxFineGains[s_ch] = s_FG;
         //TODO: Saturate Fine gains to -14.5dB & move the rest to power cutback
#if 0
         if(psa_RxFineGains[s_ch] < MIN_GI_L2_AMD4)
         {
            psa_RxFineGains[s_ch] = MIN_GI_L2_AMD4;
         }

         if(psa_RxFineGains[s_ch] > MAX_GI_L2_AMD4)
         {
            psa_RxFineGains[s_ch] = MAX_GI_L2_AMD4;
         }

         if (s_MinFineGain > psa_RxFineGains[s_ch])
         {
            s_MinFineGain = psa_RxFineGains[s_ch];
         }
#endif
      }
      else
      {
         //TODO: For monitor (bi = 0) tones, check if the following is required
         psa_OffsetSnr[s_ch] = psa_RxShowtimeSnrBuf[s_ch];
      }
   }


   //if minimum of remaining SNRds(tone) for tones with bit loading in L0 >= 0 dB
   // then no gi shaping needed and flat add. PCB can be applied at L2 entry
   if (gft_FineGainShaping == FALSE)
      return;

   // "If (b i > 0) or (b i  = 0),    [PCB(L2)+g i (L2)] <= [PCB(L0)+RMSGI(L0)+2.5]" of Amd4 is wrong concerning the +/- signs
   // it has to be -PCB(L2)[dB]+gi(L2)[dB] <= -PCB(L0)[dB]+RMSGI(L0)[dB]+2.5
   // remark G.992.3 says "The RMSGI value shall not exceed the EXTGI value", i.e. if EXTGI=0  RMSGI_L0<=0dB

   // moving the min. point xn_min to zero via gi with max. possible value and a flat power offset (or also neg. PCB)
   s_Offset = -s_MinSnr - MAX_GI_L2_AMD4;
   s_GiSnrMin = MAX_GI_L2_AMD4;

   for (s_ch=gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
   {
      int16 s_temp;
      int16 s_OffsetSnr = 0;//psa_RxShowtimeSnrBuf[s_ch];

      if(puca_RxBat[s_ch] >0)
      {
         //xno=xn+offset; %% xn modified by offset
         s_OffsetSnr = psa_OffsetSnr[s_ch] + s_Offset; //xno(k)

         //for k=1:length(y) y(k)=max(min(0,xno(k)+MaxGi),xno(k)); end; %% remaining SNR shall not fall below 0 dB and MaxGi shall not be exceeded
         s_temp = DSPS_MIN(MIN_SNR_L2_AMD4, (s_OffsetSnr + MAX_GI_L2_AMD4));  //min(0,xno(k)+MaxGi)

         psa_OffsetSnr[s_ch] = DSPS_MAX(s_temp, s_OffsetSnr);    //y(k)

         //Check for SNR being greater than required to load atleast 1 bit
         if ((psa_RxShowtimeSnrBuf[s_ch] - s_Pcb) >= s_ConstSnrOneBit )
         {
            //i=find(x>=MINSNR_BI1); %% vector indices where L2 bit loading is done with flat PCB w/o gi shaping
            //for k=i y(k)=max(MINSNR_BI1,y(k)+MinGi); end;
            psa_OffsetSnr[s_ch] = DSPS_MAX(s_ConstSnrOneBit,(psa_OffsetSnr[s_ch] + MIN_GI_L2_AMD4));

         }
         else
         {
            // i=find(x<MINSNR_BI1); %% vector indices where no L2 bit loading is done with flat PCB w/o gi shaping
            //for k=i y(k)=max(min(0,xno(k)+MaxGi),y(k)+MinGi); end; %% maximize power reduction
            psa_OffsetSnr[s_ch] = DSPS_MAX(s_temp, (psa_OffsetSnr[s_ch] + MIN_GI_L2_AMD4));

         }

         SETTONEFLAG(p_ModifiedTones, s_ch);
         //for k=1:length(x) gi(k)=y(k)-xno(k); end; %% L2 gi values
         psa_RxFineGains[s_ch] = psa_OffsetSnr[s_ch] - s_OffsetSnr;
         if(psa_RxFineGains[s_ch] < MIN_GI_L2_AMD4)
         {
            psa_RxFineGains[s_ch] = MIN_GI_L2_AMD4;
         }
         if(psa_RxFineGains[s_ch] > MAX_GI_L2_AMD4)
         {
            psa_RxFineGains[s_ch] = MAX_GI_L2_AMD4;
         }
         psa_OffsetSnr[s_ch] = psa_RxShowtimeSnrBuf[s_ch] - (s_Pcb) - psa_RxFineGains[s_ch] ;
      }
   }
   return;
}
//plot(y,'k');
//%
//%

//grid on;
//
//end; %% end of "x_min<0"
//
//%% note for the real CPE implementation:
//%% after this step with an assumed flat PCB and resulting PCB = assumed PCB - offset with L2 gi values, it has to be calculated
//%% whether min. Lp(L2) can still be reached and
//%% whether the L2 entry related power reduction with PCB and gi is still in the limits of MaxPCB, i.e. AddPCB_L2Entry-offset-10*log10(sum((gi(L0)/gi(L2))^2)/NC) <= MaxPCB - PCB(L0) with NC = number of carrier in L2 with gi>0
//%% if one of both is true AddPCB_L2Entry has to be reduced by one dB and calculation has to be done again
//%
//PWRdiff=sum(y-x)/length(x)
//L2gimax=max(gi)
//L2gimin=min(gi)
//



/**<
In the ADSL2 standard, Sec 8.6.4 : Gain scaling

The RMSGI value shall not exceed the EXTGI value, where RMSGI and EXTGI are defined
in 8.5;
o   If b i > 0, then g i    shall be in the [-14.5 to +2.5 + EXTGI] (dB) range;
o   If b i  > 0, then g i  shall be in the [RMSGI - 2.5 to RMSGI + 2.5] (dB) range;
o   If b i  = 0, then g i  shall be equal to 0 (linear) or in the [-14.5 to RMSGI] (dB) range;
o   The   Nominal    Aggregate   Transmit    Power    (NOMATP,  see 8.5)   shall    not   exceed  the
Maximum Nominal Aggregate Transmit Power (MAXNOMATP, see 8.5);
o   The gain scalings shall be set such that the excess margin relative to the maximum noise
margin (MAXSNRM) is minimized.



And    in the Amd-4 of the ADSL2 992.3 standard

At entry    into    the   L2    state,   the  requirements    for   the  bits    table   are    unchanged   but    following
requirements on the gains table apply:
o   If (b i   > 0) or (b i  = 0), then g i   shall be in the [-14.5 to +2.5 + EXTGI] (dB) range;
o   If (b i   > 0) or (b i  = 0), then [PCB(L2)+g i (L2)] ? [PCB(L0)+ RMSGI(L0)+2.5];
o   The overall gains and PCB in L2 shall be such that ATP(L2) < ATP(L0);
o   If (g i (L0) ? 0) then (g i (L2) ? 0).
   NOTE - An ATU-R implemented according to previous versions of this Recommendation may send L2 entry
   grant response messages having a gains table according to L0 state constraints
*/

int16 VerifyL2Gains(uint8 *puca_RxBat, int16 *psa_RxFineGains, RxToneFlags p_ModifiedTones)
{
    int16 s_ErrCode = 0;
    return 0;
}
#define NEW_L2_CONV_CODE

C_SCOPE uint8 ChangeL2BitGains(uint8 *puca_RxBat, int16 *psa_RxFineGains, int16 s_DesiredDeltaSumLp,
                           int16 *psa_SNRBuffer, int16 s_MinToneMargin,
                           RxToneFlags p_ActiveTones, RxToneFlags p_ModifiedTones,
                           int16 *ps_ActualDeltaSumLp, FlagT ft_StopAtMarginThreshold,
                           FlagT ft_NotforceEven1Bit, FlagT ft_AddfineGainplusdeltaLp)
{


   uint8 uc_RetCode;         // Return value
   int16 s_TargetLp;
   int16 s_Dummy1ReturnValue, s_Dummy2ReturnValue,s_ch;
   int16 s_Initial_TCM_Ovhd, s_TCM_Ovhd_before, s_TCM_Ovhd_after, s_ActualMinToneMargin, s_InitialSumBi, s_FinalSumBi;
   FlagT ft_Result, ft_TcmFlag;
   RxToneFlags p_ActiveTones_ToConsider;
   int16 s_CodingGain = gsa_TotalCodingGain[LP0_DATA_PATH];
   int16 i;
   int16 s_totalbits = 0;
   int16 *paSnrBuf = NULL;
   int16 s_deltaLp,s_MinMarginReqd;
   uint8 uc_MarginDelta = 128;
   uint8 uc_iter_cnt = 0;
   uint8 FineGainAdj = 0;
   FlagT ft_FlagAnyToneLeft;
   int16 s_MinBitsPerTone = gs_RxMinBitsPerTone_BIS_TCM;
   int16 s_Margin=0,s_MinMargin_toComp = 0;
   int16 s_DeltaSumLp;
   int16 s_breakCh = 0;

   uc_RetCode=0;
   if (( gl_SelectedMode & (MODE_ADSL2)))
   ft_TcmFlag = gft_TcmFlag_bis_DS;
   else
   ft_TcmFlag = gft_TcmFlag;



   for(i = 0; i < (int16)(gs_RxNumTones>>3); i++)
   {
      p_ModifiedTones[i] = 0;
   }
   for (s_ch = 0; s_ch < (RX_NUM_TONES>>3); s_ch++)
   {
      p_ActiveTones_ToConsider[s_ch] = p_ActiveTones[s_ch];
#ifdef NEW_L2_CONV_CODE
#ifdef DUAL_LATENCY
      if (((STATArray[STAT_Mode] & STAT_ConfigMode_ADSL2_ALL) != 0) &&(gt_rx_config.s_Nlp==2) && (IS_TONEFLAGSET(p_TonesAllocatedtoLP1_DS,s_ch)))
         CLEARTONEFLAG(p_ActiveTones_ToConsider, s_ch);
#endif
#endif

   }
   #ifdef NEW_L2_CONV_CODE
   //if (gs_CurrentCoChipset == IFTN_CO_CHIPSET)
   //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (End)
   {
      // For interop with INFN PAR feature. Clear tones from set of tones considered for OLR/PM if their Rx FineGain is
      // negative infinity, i.e. if b=g=0 (linear).
      // These tones might otherwise be loaded during an OLR since their showtime SNR may be high enough.
      //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START_END)
      for (s_ch=gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
      {
         if (psa_RxFineGains[s_ch] == NEG_INFINITY_DB)
            CLEARTONEFLAG(p_ActiveTones_ToConsider, s_ch);
      }
   }
   #endif

   CalcOffSetSnr(gsa_RxShowtimeSnrBuf, gsa_OffsetSnrBuf, s_MinToneMargin,guca_RxBat,gsa_RxFineGains,NULL,
   p_ModifiedTones );

   if (gft_FineGainShaping)
   {
      paSnrBuf = gsa_OffsetSnrBuf;
   }
   else
   {
      paSnrBuf = gsa_RxShowtimeSnrBuf;
   }
   psa_SNRBuffer = gsa_OffsetSnrBuf;



   GetBatStats(puca_RxBat, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded, &s_Dummy2ReturnValue, &s_Initial_TCM_Ovhd, &s_InitialSumBi, LP0_DATA_PATH);

   s_TCM_Ovhd_before = s_Initial_TCM_Ovhd;

   s_FinalSumBi = s_InitialSumBi;

   s_TCM_Ovhd_after = s_TCM_Ovhd_before;

   //TODO:
   //Should this be in a while loop till we achieve the required DeltaSumLp
   s_MinMarginReqd = gs_RxDesiredMargin + (3<<8) + gs_DeltaPcb;

   s_TargetLp = s_InitialSumBi - s_Initial_TCM_Ovhd + s_DesiredDeltaSumLp;
   s_deltaLp = s_TargetLp;


#ifdef NEW_L2_CONV_CODE

   s_DeltaSumLp =    s_DesiredDeltaSumLp;

   while(s_DeltaSumLp !=0)
   {

      uc_MarginDelta = 128;
      ft_FlagAnyToneLeft = TRUE;   /* assume that there is at least one loaded tone
      this flag is important in case we ask for large deltaLp,
      and there is no more loaded tone, we return after removing as much as possible */
      if (s_DeltaSumLp < 0)
      {
         int16 s_absDeltaSumBi;
         // compute the min margin
         ft_Result = FindToneWithExtremeMargin(SMALLEST_MARGIN, puca_RxBat, psa_RxFineGains, psa_SNRBuffer,
         p_ActiveTones_ToConsider, s_MinBitsPerTone, (int16) guc_MaxAllocBitsPerTone, &s_ch, &s_Margin);

         // if min   margin is below 3dB, start with -3dB for removing bits
         //XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap (start)
         s_Margin = s_Margin - 2*(psa_RxFineGains[s_ch] + gsa_TempRxFineGains[s_ch]);

         s_absDeltaSumBi = abs_s(s_DeltaSumLp);
         if ((s_Margin < -768) &&(s_absDeltaSumBi > 10))  //Assumed if (sumbi >10) it will touch min margin tones also
            s_MinMargin_toComp = -768;
         else
            s_MinMargin_toComp = s_Margin;
         //XDSLRTFW-1086 / ADSLRTFW-1611 IOP_DS_ADSL2p_CNXT_RFITest_BitSwap (end)
      }

      while ((s_DeltaSumLp < 0) && (ft_FlagAnyToneLeft)    /*&& (s_Margin <s_MinToneMargin)*/)
      {
         // reset the flag
         ft_FlagAnyToneLeft = 0;
         for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
         {
            if (IS_TONEFLAGSET(p_ActiveTones_ToConsider, s_ch) && (s_DeltaSumLp < 0))
            {
               int16 s_bi;
               s_bi = puca_RxBat[s_ch];
               //TODO: spurious check below .. can be removed
               if (s_bi < s_MinBitsPerTone)
               continue;

               // if there is any tone with more than min bits
               ft_FlagAnyToneLeft = 1;

               { // for g.992.3/g.992.5
                  // Currently only supports single latency.
                  s_CodingGain = gsa_TotalCodingGain[LP0_DATA_PATH];
               }

               s_Margin = psa_SNRBuffer[s_ch];
               //s_Margin +=psa_RxFineGains[s_ch];
               // @mahesh: Already finegains are accounted for ...
               //if (s_bi!=0)
               // For bi=0 tones, its fine gain either is negative infinity db or 0db, so ignore its fine gain here
               // avoid the possible overflow problem (for negative inifinity) and also fine for 0db case.
               // @mahesh: Already finegains are accounted for ...
               // s_Margin += psa_RxFineGains[s_ch];


               s_Margin += s_CodingGain;

               // When subtracting bits and looking for the tone with the smallest margin, we use bi_delta = 0.
               s_Margin -= gsa_ConstellationSNR[s_bi];
               //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
               //removing margin fudge
               //TODO             s_Margin += OPTNArray[OPTN_MarginDelta] ;

               //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
               //Added check to enforce s_MinToneMargin bound


               // Check if themargin is better than margin to compare + threshold
               if (s_Margin > s_MinMargin_toComp + uc_MarginDelta)
               continue;

               else if (puca_RxBat[s_ch] == s_MinBitsPerTone)
               {
                  // update fine gain linear sum square
                  UpdateFineGainLinSumSq(-640,psa_RxFineGains[s_ch],gusa_DS_Tssi_Value[s_ch], &gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 1 );



                  puca_RxBat[s_ch] = 0;
                  if ( !IS_TONEFLAGSET(p_FINEGAINSKIPset, s_ch) )
                  psa_RxFineGains[s_ch] = 0;
                  gus_ncloaded--;
                  s_DeltaSumLp += s_MinBitsPerTone;
               }
               else
               {
                  puca_RxBat[s_ch]--;
                  s_DeltaSumLp++;

                  //End of the code which may not be required
                  UpdateFineGainLinSumSq(-640, psa_RxFineGains[s_ch], gusa_DS_Tssi_Value[s_ch],&gl_SumFGainLinSq, &gl_SumGiSqTssiSq, 0);
               }
               //XDSLRTFW-571:Enh_DS_ALL_ALL_BitSwap(start_end)
               //Disabling bitswap tones as it is used for marking tones which have margin
               //between min margin and min margin + delta
               //Marking of tones with bit swap is moved to the end of bitswap scheme

               SETTONEFLAG(p_ModifiedTones, s_ch);
               if(s_DeltaSumLp == 0)
               {
                  s_breakCh = s_ch;
                break;
               }
            }
         }//for

         // Check whether we now meet margin and break if that flag is set.
         ft_Result = FindToneWithExtremeMargin(SMALLEST_MARGIN, puca_RxBat, psa_RxFineGains, psa_SNRBuffer, p_ActiveTones_ToConsider, s_MinBitsPerTone, (int16) guc_MaxAllocBitsPerTone, &s_ch, &s_Margin);

         s_Margin = s_Margin - (psa_RxFineGains[s_ch]);
         //ADSLRTFW-1582 FEATURE_DS_BisPlus_ALL_GainScaleInL2Mode_Amd4G9923 (Start)


         // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]
         if ((s_Margin >= s_MinMarginReqd) && ft_StopAtMarginThreshold)
         break;
         /* if margin is still lower implies that we have not been able to touch the
         low margin tone, increase the threshold, instead of resetting the margin to compare*/
         if (s_Margin <=   s_MinMargin_toComp + uc_MarginDelta)
            uc_MarginDelta+= 128;
         else
            s_MinMargin_toComp = s_Margin;
      } //while(s_DeltaSumLp < 0

      GetBatStats(puca_RxBat, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded, &s_Dummy2ReturnValue, &s_TCM_Ovhd_after, &s_FinalSumBi, LP0_DATA_PATH);


      // Any change in TCM overhead results in further unwanted change to Lp.  This becomes a new delta Lp that we
      // need to implement.

      {
         s_DeltaSumLp = (s_TCM_Ovhd_after - s_TCM_Ovhd_before);
         s_TCM_Ovhd_before = s_TCM_Ovhd_after;
      }
   }//while(s_DeltaSumLp !=0)


   for(s_ch = s_breakCh; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
   {
      int16 s_temp = psa_SNRBuffer[s_ch];
      int16 s_bi = puca_RxBat[s_ch];
      s_temp = s_temp - gsa_ConstellationSNR[s_bi] + s_CodingGain;

      if((s_temp<500))
      {
         psa_RxFineGains[s_ch] = psa_RxFineGains[s_ch]+760;
         if(psa_RxFineGains[s_ch] > MAX_GI_L2_AMD4)
         {
            psa_RxFineGains[s_ch] = MAX_GI_L2_AMD4;
         }
      }
   }


#else
   memset(guca_RxBat,0,512);

   while (((s_deltaLp > 8) || (s_deltaLp < -8)) && (s_MinMarginReqd > 0x200))
   {
      gus_ncloaded = 0;
      s_totalbits =0;
      uc_iter_cnt++;
      for(s_ch = gs_RxBitLoadFirstChannel; s_ch <= gs_RxBitLoadLastChannel; s_ch++)
      {
      int16 s_SNR = paSnrBuf[s_ch];
      uint8 s_qc;


         if ((IS_TONEFLAGSET(p_ActiveTones_ToConsider, s_ch) ) && (s_SNR > 0))
         {
            s_SNR = paSnrBuf[s_ch];
            s_SNR += psa_RxFineGains[s_ch];
            s_SNR += s_CodingGain;
            s_SNR -= (s_MinMarginReqd);

            //TODO:OPTNArray[OPTN_MarginDelta]; What is this variable exactly used for
            SETTONEFLAG(p_ModifiedTones, s_ch);
            puca_RxBat[s_ch] = 0;
            for(s_qc = guc_MaxAllocBitsPerTone; s_qc >= gs_RxMinBitsPerTone_BIS_TCM; s_qc--)
            {
               if(s_SNR >= gsa_ConstellationSNR[s_qc])
               {
                  gus_ncloaded++ ;
                  s_totalbits += (int16) s_qc;

                  SETTONEFLAG(p_ModifiedTones, s_ch);
                  puca_RxBat[s_ch] = s_qc;
               break;
               }
            }//for (s_qc
         } //if(IS_TONEFLAGSET
      }//for (s_ch

      GetBatStats(puca_RxBat, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded, &s_Dummy2ReturnValue, &s_TCM_Ovhd_after, &s_FinalSumBi, LP0_DATA_PATH);

      *ps_ActualDeltaSumLp = s_FinalSumBi - s_TCM_Ovhd_after;
      s_deltaLp = s_TargetLp - *ps_ActualDeltaSumLp;

      if(uc_iter_cnt > 10)
         uc_MarginDelta = 64;

      if (uc_iter_cnt>16)
      {
         uc_MarginDelta = 16;
      }


      if(uc_iter_cnt > 20)
      {
         if(abs(s_deltaLp) < gs_DeltaMinMaxLp)
         {
            break;
         }
       uc_MarginDelta = 8;
      }

      if(*ps_ActualDeltaSumLp > s_TargetLp)
      {
         //Modified the bit table,increasing the margin
         s_MinMarginReqd +=uc_MarginDelta;
      }
      else
      {
         //Modified the bit table,decreasing the margin
         s_MinMarginReqd -=uc_MarginDelta;
      }
      if(s_MinMarginReqd > 0xe80)
      {
         s_MinMarginReqd = 0x800;
      }

      if(s_MinMarginReqd < 0x280)
      {
         s_MinMarginReqd = 0x800;
      }
   }//while

#endif
   //ForceEvenNum1BitTonesInBAT

   if((ft_TcmFlag) && (!ft_NotforceEven1Bit))
   {
      // Force an even number of 1-bit tones without changing Lp.

      ft_Result = ForceEvenNum1BitTonesInBAT(puca_RxBat, psa_RxFineGains,paSnrBuf,s_MinMarginReqd,
      p_ActiveTones_ToConsider, p_ModifiedTones);

      if (ft_Result == FAIL)
      {
         // Fail here if couldn't force even # of 1-bit tones while maintaining margin.
         // (Forcing an even # of 1-bit tones while maintaining Lp requires bits to be added to the BAT).

      return(CHGBAT_RETCODE_VIOLATES_MARGIN);
      }
   }

   GetBatStats(puca_RxBat, gs_RxNumTones, ft_TcmFlag, &gus_ncloaded, &s_Dummy2ReturnValue, &s_TCM_Ovhd_after, &s_FinalSumBi, LP0_DATA_PATH);
   // Any change in TCM overhead results in further unwanted change to Lp. This becomes a new delta Lp that we
   // need to implement.

   *ps_ActualDeltaSumLp = s_FinalSumBi - s_TCM_Ovhd_after - (s_InitialSumBi - s_Initial_TCM_Ovhd);

   gs_L2ActualDeltaSumLp = *ps_ActualDeltaSumLp;

   FindToneWithExtremeMargin(SMALLEST_MARGIN, puca_RxBat, psa_RxFineGains,psa_SNRBuffer, p_ModifiedTones, gs_RxMinBitsPerTone_BIS_TCM,(int16) guc_MaxAllocBitsPerTone,
   &s_Dummy1ReturnValue, &s_ActualMinToneMargin);

   s_ActualMinToneMargin = s_ActualMinToneMargin - psa_RxFineGains[s_ch]+s_MinToneMargin;


   gs_RxEstimatedMinMargin = s_ActualMinToneMargin;


   if (uc_RetCode != 0)
      return(uc_RetCode);

   return(0);            // No error.
}


/*****************************************************************************
;      Subroutine Name: void Perform_Self_test(void)
;
;      This subroutine performs the self test and updates the self_test_result
;
;      Prototype:
;            void Perform_Self_test(void)
;
;      Input Arguments:
;
;      Output Arguments:
;
;      Return:
;
;******************************************************************************/

void Perform_Self_test(void)
{
#ifndef TARGET_HW
   int16 i;

   for(i = 0; i <= SELF_TEST_REG_LENGTH; i++)
   {
      /* Update the register with the results */
      gt_TxOvhdRegister.uc_self_test_reg[i] = (uint8)(gl_self_test_result & 0xFF);
      gl_self_test_result >>= 8;
   }

#endif
   /* Clear the result */
   gl_self_test_result =0;
}

/*****************************************************************************
;      Subroutine Name: RxIbProcessor_bis(void)
;
;      This subroutine updates the far end information based on the received
;      indicator bits
;
;      Prototype:
;            RxIbProcessor_bis(void)
;
;      Input Arguments:
;
;      Output Arguments:
;
;      Return:
;
;******************************************************************************/

void RxIbProcessor_bis(void)
{
   uint8 uc_byte;

   if (gul_last_RxIbinfo != gul_RxIbInfo)
   {
      logShowtimeEventB( gul_RxIbInfo );
      gul_last_RxIbinfo = gul_RxIbInfo;
   }
   /* IB (7:0): received NTR octet */
   uc_byte = (uint8)gul_RxIbInfo;

   gt_rx_Anomaly.uc_ntr = uc_byte;

   /* IB (13:8): los sef lpr 1 1 1 1 1 */
   uc_byte = (uint8)(gul_RxIbInfo >> 8);

   /* Check for far end LOS defect */
   gt_rx_Anomaly.uc_flos_def = (uc_byte & 0x80) ? TERMINATED:PRESENT;

   /* Check for far end SEF defect */
   gt_rx_Anomaly.uc_fsef_def = (uc_byte & 0x40) ? TERMINATED:PRESENT;

   /* Check for far end LPR */
   gt_rx_Anomaly.uc_flpr_def = (uc_byte & 0x20) ? TERMINATED:PRESENT;

   /* IB (31:24): lcd(BC0) lcd(BC1) 1 1 1 1 1 1 */
   uc_byte = (uint8)(gul_RxIbInfo >> 24);

   /* Check for far end LCD defect */
   gt_rx_Anomaly.uc_flcd_def[0] = (uc_byte & 0x80) ? TERMINATED:PRESENT;

   gt_rx_Anomaly.uc_flcd_def[1] = (uc_byte & 0x40) ? TERMINATED:PRESENT;
}


/*****************************************************************************
;      Subroutine Name: Abandon_DS_OLRPM(void)
;
;      This subroutine abandon DS OLR/PM reconfiguration and restore the original setting
;
;      Prototype:
;            Abandon_DS_OLRPM(void)
;
;      Input Arguments:
;
;      Output Arguments:
;
;      Return:
;
;******************************************************************************/
void Abandon_DS_OLRPM(void)
{
   int32 i, j;

   // restore the s/w copy of original configure
   for(i = 0; i < NUM_DATA_PATHS; i++)
   {
      gt_rx_config.s_Lp[i] = gt_rx_config.s_currentLp[i];
      for(j = 0; j < NUM_DS_BEARER_CHANNELS_SUPPORTED; j++)
      {
         gt_rx_config.sa_Bpn[i][j] = gt_rx_config.sa_currentBpn[i][j];
      }
   }

   // restore the s/w copy of BAT table from the h/w tables.
   // Currently we restore gains from a software copy of the table.   To conserve
   // data memory this could be changed back to require restoration from h/w again.

   // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [Start]
   if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_RECV_SYNC_INDICATOR)
   {
      gt_RxOLRPMVars.uc_rxOLRPMState = L2_READ_TABLES;
   }
   else
   {
      gt_RxOLRPMVars.uc_rxOLRPMState = OLR_READ_TABLES;
   }
   // XDSLRTFW-494 Feature_All_DS_BisPlus_L2_Amd4 [End]

   gt_RxOLRPMVars.s_rxOLRPMEvent = READ_BAT | READ_GAIN;
}

/***************************************************************************************
;      Subroutine Name: ProcessRSErrorCnt_BIS(int16 s_LatencyPath, int16 s_count)
;
;      Description:
;            This function processes FEC counts obtained from Zephyr
;
;      Prototype:
;            void ProcessRSErrorCnt_BIS(int16 s_LatencyPath, int16 s_count)
;
;      Input Arguments:
;            s_LatencyPath
;            s_count
;      Output Arguments:
;            none
;      Return Value:
;            none
;
;***************************************************************************************/
void ProcessRSErrorCnt_BIS(int16 s_LatencyPath, uint16 us_fec_count, uint16 us_dec_stat)
{
   if (us_fec_count)
   {
      /* Counter of no. of FEC anomalies per second */
      gs_fec_ecs_cnt++;
   }

   gsa_CorrectedRSErrors[s_LatencyPath] += us_fec_count;

   if ((us_dec_stat & 0x0001) == 1)
   {
      // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
#ifdef ADSL_62
      gula_UncorrectableRSCodewordCnt[s_LatencyPath]++;
#else
      gs_UncorrectableRSCodewordCnt[s_LatencyPath]++;
#endif
      // XDSLRTFW-575: Counter Write back in ADSL mode (End)
   }
}

#ifdef LEAVE_TRAIL
/***************************************************************************************
;      Subroutine Name: ProcessCRCErrorCnt_BIS(int16 s_LatencyPath, uint16 us_CrcIndicator)
;
;      Description:
;            This function processes crc indicator obtained from Zephyr per PERp
;
;      Prototype:
;            void ProcessCRCErrorCnt_BIS(int16 s_LatencyPath, uint16 us_CrcIndicator)
;
;      Input Arguments:
;            s_LatencyPath
;            us_ZrRxIbRegValue
;      Output Arguments:
;            none
;      Return Value:
;            none
;
;***************************************************************************************/



void ProcessCRCErrorCnt_BIS(int16 s_LatencyPath, uint16 us_CrcIndicator)
{
#ifdef LEAVE_TRAIL
   if (!us_CrcIndicator)
   {
      fprintf(crc_fid,"\n There is a CRC error in SuperFrame %ld of LP%d data path", gl_rx_sframe_count, s_LatencyPath);
   }
#endif
}
#endif

/*^^^
 *------------------------------------------------------------------------
 *
 * Name : ProcessFramingBytes(void)
 *
 * Description:  Process framing bytes during data pump processing
 *
 * Prototype:
 *      void   ProcessFramingBytes(void)
 *
 * Input Arguments:
 *
 * Output Arguments:
 *
 * Return:
 *      None
 *
 * Global Variables Used:
 *
 * Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
// int16 gs_dbgMips=0;
#ifndef HERCULES_ADSL_CPE
void ProcessFramingBytes(void)
{
   int32 i, j, s_LatencyPath=0;
   uint16 us_crcIndicator, *pusa_FramingByteBufferRPtr = gusa_FramingByteBuffer;
   uint8 uc_framingByte;
   static uint8 uc_prevOvhdByte = OPENING_FLAG;

   //      int16 s_Mips;
   //      DisableADSLInterrupts();
   //      s_Mips = ReadRxTimer();
   for (i = 0; i < gs_ZARunTimes; i++)
   {
      // Process CRC, IB
      for (j = 0, s_LatencyPath = 0 ; j < gt_rx_config.s_Nlp; j++, s_LatencyPath++)
      {
         if (((*pusa_FramingByteBufferRPtr)>>s_LatencyPath) & 0x1)
         {
            // Process CRC indicator
            us_crcIndicator = (*(pusa_FramingByteBufferRPtr+1) & 0x1000);
            if (us_crcIndicator == 0)
            {
               gusa_CRC_count[s_LatencyPath]++; //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)

               /* Counter of no. of CRC anomalies per second */
               //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
               //For Universal ReTx CRCs are not counted, instead uncorrected DTUs are counted.
               if(gt_ReTxConfigInfo.ft_ReTxOn == 0)
               {
                  //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
                  gs_crc_cnt++;
                  gs_norm_crc_1sec += gsa_CRCincrement[s_LatencyPath];
                  //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
               }
               //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
            }
            else
            {
               gusa_good_count[s_LatencyPath]++;   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
            }

            // We could even process Indicator Bits here instead of during sync frame
            // and hence be more accurate wrt Rx IB update at the expense of Mips

            #ifdef LEAVE_TRAIL
            ProcessCRCErrorCnt_BIS((int16)s_LatencyPath, us_crcIndicator);
            #endif
         }
         // update buffer for next latency path
         *(pusa_FramingByteBufferRPtr+1) <<= 8;
      }
      // Process HDLC
      if ((*pusa_FramingByteBufferRPtr) & 0x4)
      {
         uc_framingByte = (*(pusa_FramingByteBufferRPtr+2) & 0xFF);
         /* A non-opening flag byte received; implies message started */
         /* A opening flag byte received after a non-opening flag; implies message ended */
         if ((uc_framingByte != OPENING_FLAG) ||(uc_prevOvhdByte != OPENING_FLAG && uc_framingByte == OPENING_FLAG))
         {
            gt_RxHDLCMsgFifo.MessageBuffer[gt_RxHDLCMsgFifo.NextAvailable] = uc_framingByte;
            gt_RxHDLCMsgFifo.NextAvailable++;
            if (gt_RxHDLCMsgFifo.NextAvailable==gt_RxHDLCMsgFifo.BufferSize)
               gt_RxHDLCMsgFifo.NextAvailable=0;
               uc_prevOvhdByte = uc_framingByte;
         }
      }

      pusa_FramingByteBufferRPtr += 3;
   }  // for loop
   gpusa_FramingByteBufferWPtr = gusa_FramingByteBuffer;
   gs_ZARunTimes = 0;
   //      s_Mips = ReadRxTimer() - s_Mips;
   //      if (s_Mips > gs_dbgMips)
   //            gs_dbgMips = s_Mips;
   //      EnableADSLInterrupts();
}
#endif

