/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  rx_ovhd_ini_bis.c
*
*  Functions to initialize the ovhd functions
*
****************************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "ovhd_bis.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "rx_ovrhd_bis.h"
#include <string.h>

/*****************************************************************************
*   Subroutine Name: RxOvhdInit
*
*   Description:
*     This subroutine initializes variables used by the Ovhd RX functions.
*
*   Prototype:
*       void RxOvhdInit(void);
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*
*
*******************************************************************************/
void RxOvhdInit(void)
{

   gft_receive_crc_corrupt_bits_flag = FALSE;
   gft_send_crc_corrupt_bits_flag = FALSE;

#ifdef HERCULES_ADSL_CPE
   gft_RxBpnReconfigAllowed[0] = FALSE;
   gft_RxBpnReconfigAllowed[1] = FALSE;
#else
   gft_RxBpnReconfigAllowed[0] = TRUE;
   gft_RxBpnReconfigAllowed[1] = TRUE;
#endif

   gft_escape_octet_received = FALSE;
   gus_rx_msg_index = 0;

   guc_HDLC_RxState = MONITOR;

   /* initialize the Rx HDLC structure */
   gt_RxHDLCMsg.message_priority = 3;     /*  Initialise with invalid entry */
    gt_RxHDLCMsg.cntrl_field = 4;         /*  HDLC message control field */
   gt_RxHDLCMsg.gus_FCS = 0;           /*  HDLC message FCS */

   // Zero out buffer before we try to receive msg
   memset(guca_RxHDLCMsgBuffer, 0, MAX_RX_HDLC_MSG_SIZE);
   memset(guca_rx_hdlc_msg_buffer, 0, MAX_RX_HDLC_MSG_SIZE);

   gt_RxHDLCMsgFifo.MessageBuffer = guca_RxHDLCMsgBuffer;
   gt_RxHDLCMsgFifo.BufferSize = MAX_RX_HDLC_MSG_SIZE;
   gt_RxHDLCMsgFifo.IndexOfOldest = 0;
   gt_RxHDLCMsgFifo.NextAvailable = 0;
   gt_RxHDLCMsgFifo.ErrorCode = 0;
   gt_RxHDLCMsgFifo.us_OvflowCnt = 0;

}

/*****************************************************************************
*   Subroutine Name: InitRxOvhdRegisters
*
*   Description:
*     This subroutine initializes variables used by the Ovhd RX functions.
*
*   Prototype:
*       void InitRxOvhdRegisters(void)
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*
*
*******************************************************************************/

void InitRxOvhdRegisters(void)
{

   int16 i;


   /* Initialise the Self test register */
   for(i = 0; i< SELF_TEST_REG_LENGTH; i++)
      gt_RxOvhdRegister.uc_self_test_reg[i] = 0;

}
