/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             rx_plam_bis.c
 * DESCRIPTION:      Functions that implement Rx PLAM
 *
 **********************************************************************/

// **********************************************************************/
// File : rx_plam_bis.c
//
// History
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
//**********************************************************************/


#include <string.h>
#include "common.h"
#include "gdata.h"
#include "ib.h"
#include "cmv.h"
#include "plam.h"
#include "rx_plam.h"
#include "rx_ib.h"
#include "gdata_bis.h"

#ifdef DO_PLAM
/* needed outside: cmv.c */
/* counts of problems that lasted 1sec */
extern int16 gs_ecs_fe_cnt;
extern int16 gs_loss_fe_cnt;
extern int16 gs_es_fe_cnt;
extern int16 gs_ses_fe_cnt;
extern int16 gs_uasl_fe_cnt;

extern uint32 gula_fe_tot_cell_cnt[MAX_ATM_SIZE];
extern uint32 gula_fe_tot_hec_cnt[MAX_ATM_SIZE];
extern uint32 gula_fe_bit_error_cnt[MAX_ATM_SIZE];

/* failure byte */
extern int16 gs_FarEndFailure;



/* needed only in this module */
extern int16 gs_fe_line_unavailable;
extern FailureCount_t gt_UaslFeFailureCount; /* not really a failure bit, but 1sec UASL intermediate */
/* counters to detect contiguous periods of failure-condition being present/absent */
extern FailureCount_t gt_NCDFfeFailureCount, gt_NCDIfeFailureCount;
extern FailureCount_t gt_LCDfeFailureCount[MAX_ATM_SIZE];
extern FailureCount_t gt_LOSfeFailureCount, gt_RDIfeFailureCount, gt_LPRfeFailureCount;


/***************************************************************************************
;  Subroutine Name: void RxPlamProcessor_bis(void)
;
;  Description:
;     This function processes the far end Anomaly/IB information
;
;  Prototype:
;     void RxPlamProcessor(void)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/
void RxPlamProcessor_bis(void)
{
   int16 i;

    for (i =0; i < NUM_DATA_PATHS; i++)
    {
      /*********************/
      /* Far end CRC count */
      /*********************/
        gsa_febe_cnt[i] = (int16)gt_rx_Anomaly.ul_fcrc_cnt[i];
        gla_febe_cnt[i] = gt_rx_Anomaly.ul_fcrc_cnt[i];


      /*********************/
      /* Far end FEC count */
      /*********************/

        gsa_ffec_cnt[i] = (int16)gt_rx_Anomaly.ul_ffec_cnt[i];
        gla_ffec_cnt[i] = gt_rx_Anomaly.ul_ffec_cnt[i];


    }

   /*********************/
   /* Far end HEC count */
   /*********************/
   memcpy(gula_fhec_cnt, &gt_rx_Anomaly.ul_fhec_err_cnt[0], 4*NUM_US_BEARER_CHANNELS_SUPPORTED);

   /****************************************/
   /* Far end User total cell count (CU-P) */
   /****************************************/
   memcpy(gula_fe_tot_cell_cnt, &gt_rx_Anomaly.ul_ftot_cell_cnt[0], 4*NUM_US_BEARER_CHANNELS_SUPPORTED);

   /**************************************************/
   /* Far end User Idle Cell Bit Error Count (IBE-P) */
   /**************************************************/
   memcpy(gula_fe_bit_error_cnt, &gt_rx_Anomaly.ul_fber_idle_cell_cnt[0], 4*NUM_US_BEARER_CHANNELS_SUPPORTED);

   /**********************************************/
   /* Far end delineated total cell count (CD-P) */
   /**********************************************/
   memcpy(gula_fe_tot_hec_cnt, &gt_rx_Anomaly.ul_ftot_hec_cell_cnt[0], 4*NUM_US_BEARER_CHANNELS_SUPPORTED);

   /******************************************/
   /* Far end severely errored seconds count */
   /******************************************/
   gs_ses_fe_cnt = (int16)gt_rx_Anomaly.ul_fsev_err_sec;
   gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_SESCnt = gt_rx_Anomaly.ul_fsev_err_sec; // XDSLRTFW-1562

   /*******************************/
   /* Far end unavailable seconds */
   /*******************************/

   gs_uasl_fe_cnt = (int16)gt_rx_Anomaly.ul_funavail_err_sec;
   gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_UASLCnt = gt_rx_Anomaly.ul_funavail_err_sec; // XDSLRTFW-1562


   /*************************************/
   /* Far end FEC errored seconds count */
   /*************************************/
   gs_ecs_fe_cnt = (int16)gt_rx_Anomaly.ul_ffec_err_sec;
   gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_FECSecCnt = gt_rx_Anomaly.ul_ffec_err_sec; // XDSLRTFW-1562

   /*********************************/
   /* Far end errored seconds count */
   /*********************************/
   gs_es_fe_cnt = (int16)gt_rx_Anomaly.ul_ferr_sec;
   gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_ESCnt = gt_rx_Anomaly.ul_ferr_sec; // XDSLRTFW-1562
   /*********************************/
   /* Far end LOS seconds count */
   /*********************************/
   gs_loss_fe_cnt = (int16) gt_rx_Anomaly.ul_flos_err_sec;
   gt_HercADSL_CNTRMap_g997_FE_LinePerfCount.ul_LOSSCnt = gt_rx_Anomaly.ul_flos_err_sec; // XDSLRTFW-1562

   /***********************/
   /* Far end LOS failure */
   /***********************/

   UpdateFailureInfo(gt_rx_Anomaly.uc_flos_def, &gt_LOSfeFailureCount, &gs_FarEndFailure,
               PLAM_LOS_FailureBit);

   /***********************/
   /* Far end LOF failure */
   /***********************/

   UpdateFailureCounts(gt_rx_Anomaly.uc_fsef_def, &gt_RDIfeFailureCount);

   /* Far end LOF failure is declared only if no LOS defect/failure present */
   /* and 2.5 seconds of contiguous RDI defect present */
   if((gt_rx_Anomaly.uc_flos_def != PRESENT) && ((gs_FarEndFailure & PLAM_LOS_FailureBit) == 0))
   {
      if (gt_RDIfeFailureCount.s_present == NUM_SFRAMES_2P5SEC)
      {
         /* Update te PLAM CMV for LOF failure */
         gs_FarEndFailure |= PLAM_LOF_FailureBit;
      }
   }
   else if(gs_FarEndFailure & PLAM_LOS_FailureBit)
   {
      /* Clear LOF failure if LOS failure declared */
      gs_FarEndFailure &= ~PLAM_LOF_FailureBit;
   }

   InitializeFailureCountPresent(&gt_RDIfeFailureCount, NUM_SFRAMES_2P5SEC);

   /* Terminate LOF failure if 10 s of contiguous no RDI defect */
   TerminateFailureBit(&gt_RDIfeFailureCount, &gs_FarEndFailure, PLAM_LOF_FailureBit, NUM_SFRAMES_10SEC);

   /***********************/
   /* Far end LPR failure */
   /***********************/
   if(gt_rx_Anomaly.uc_flpr_def == PRESENT)
   {
      /* Far end LPR failure is declared after the occurence of far end lpr primitive,  */
      /* followed by 2.5 seconds of contiguous near end LOS defect. It is cleared after */
      /* 10 sec of no near end LOS defect */
      UpdateFailureInfo(gt_tx_Anomaly.uc_los_def, &gt_LPRfeFailureCount, &gs_FarEndFailure,
                  PLAM_LPR_FailureBit);
   }

   /***********************/
   /* Far end LCD failure */
   /***********************/

   /* Check for how long the LCD defect has been sent on BC0 */
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
   if (gt_HercADSL_TPS_TC_Params[0].s_TPS_TC_Control & 0x2) // As per HERC_API.doc
   {
      UpdateFailureInfo(gt_rx_Anomaly.uc_flcd_def[0], &gt_LCDfeFailureCount[0], &gs_FarEndFailure,
               PLAM_LCD_BC0_FailureBit);
      // XDSLRTFW-1481 (Start_End)
      if (gs_FarEndFailure & PLAM_LCD_BC0_FailureBit)
      {
         gt_HercADSL_PLAMMap_g997_DataPathFailureStatus.s_LCD_NCD_Failure |= PLAM5_DATAPATH_LCD_FE_BC0;
      }


   /* Check for how long the LCD defect has been sent on BC1 */
      UpdateFailureInfo(gt_rx_Anomaly.uc_flcd_def[1], &gt_LCDfeFailureCount[1], &gs_FarEndFailure,
               PLAM_LCD_BC1_FailureBit);
        // XDSLRTFW-1481 (Start_End)
      if (gs_FarEndFailure & PLAM_LCD_BC1_FailureBit)
      {
         gt_HercADSL_PLAMMap_g997_DataPathFailureStatus.s_LCD_NCD_Failure |= PLAM5_DATAPATH_LCD_FE_BC1;
      }

   }
   //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)

}

#endif /* DO_PLAM */
