/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: tx_ib_b.c
;
;  Functions for BG Tasks from tx_ib.c
;
;***************************************************************************/
// ******************************************************************
// tx_ib_bis.h.c
// History
// 04/07/2012 Anantha: Added code to declare LCD, NCD defects,
//                removed old code
//          grep pattern XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
// ******************************************************************
#include "common.h"
#include "ib.h"
#include "gdata.h"
#include "xgdata.h"
#include "gdata_bis.h"
#include "mp.h"
#include "cmv.h"
#include "data_alloc.h"

#define FAR_END 0
#define NEAR_END 1


/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : void Update_Anamoly_bis(FlagT ft_FarEndOrNearEnd)
 *
 *  Description: This subroutine updates the near-end/far-end anomalies per PMD superframe
 *          to be used for IB and PLAM processing
 *
 *  Prototype:
 *     void Update_Anamoly_bis(FlagT ft_FarEndOrNearEnd)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
void Update_Anamoly_bis(FlagT ft_FarEndOrNearEnd)
{
   int i;
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
   uint8 *puca_TransferMode_bis, *puc_ncd_anom, *puc_ocd_anom, *puc_lcd_def, puc_sef_def;
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
   int16 *ps_cd_flag;
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
   int32 *pl_SymbolCountOH;
   int32 *pl_SymbolCountOHPeriod;
   int8 *pc_FourOHPeriodLCDInfo;
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
   //Differenciate far end or near end
   if (ft_FarEndOrNearEnd == FAR_END)
   {
      puca_TransferMode_bis = &guca_US_TransferMode_bis[0];
      ps_cd_flag = &(gt_rx_Anomaly.s_fcd_flag[0]);
      puc_ncd_anom = &(gt_rx_Anomaly.uc_fncd_anom[0]);
      puc_ocd_anom = &(gt_rx_Anomaly.uc_focd_anom[0]);
      puc_lcd_def = &(gt_rx_Anomaly.uc_flcd_def[0]);
      //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
      puc_sef_def = gt_rx_Anomaly.uc_fsef_def;
      pl_SymbolCountOH = gla_FESymbolCountOH;
      pl_SymbolCountOHPeriod = gla_FESymbolCountOHPeriod;
      pc_FourOHPeriodLCDInfo = gca_FEFourOHPeriodLCDInfo;
      //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
   }
   else // NEAR END
   {
      puca_TransferMode_bis = &guca_DS_TransferMode_bis[0];
      ps_cd_flag = &(gt_tx_Anomaly.s_cd_flag[0]);
      puc_ncd_anom = &(gt_tx_Anomaly.uc_ncd_anom[0]);
      puc_ocd_anom = &(gt_tx_Anomaly.uc_ocd_anom[0]);
      puc_lcd_def = &(gt_tx_Anomaly.uc_lcd_def[0]);
      //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
      puc_sef_def = gt_tx_Anomaly.uc_sef_def;

      pl_SymbolCountOH = gla_NESymbolCountOH;
      pl_SymbolCountOHPeriod = gla_NESymbolCountOHPeriod;
      pc_FourOHPeriodLCDInfo = gca_NEFourOHPeriodLCDInfo;
      //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
   }


   //According to the BIS spec:
   //An ocd-n anomaly occurs when the cell delineation process of receive ATM-TC sub-function #n transitions
   //from the SYNC state to the HUNT state. An ocd-n anomaly terminates when the cell delineation process
   //transitions from PRESYNC state to SYNC state or when the lcd-n defect is asserted.

   //An lcd-n defect occurs when at least one ocd-n anomaly is present in each of four consecutive overhead period
   //and no sef-n defect is present. An lcd-n defect terminates when no ocd-n anomaly is present in four
   //consecutive overhead period.

   //The following code tries to indicate ocd, lcd and ncd according to the above definition.
   //NCD defect implementation is stright forward if no cell delineation happens after entering
   //show time NCD anamoly is declared.
   //If There is no cell delineation then OCD anamoly is declared
   //Core of the code has a variable which keeps trak of history of four consicutive overhead
   //ocd-anamoly in order using sliding window concept. If at least one over head period out of
   //previous four over head period has ocd-anamoly then LCD defect is declared. If no previous four
   //overhead period has ocd-anamoly LCD defect is terminated.


   for (i = 0; i< NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
   {
      //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
      //To avoid uninitialized conditions don't process if BC is not used
      if (ft_FarEndOrNearEnd == NEAR_END) {
         if(gt_RxShowTimeVars.t_BCParms[i].sa_BC_LPath < 0)
            continue;
      } else {
         if(gt_TxShowTimeVars.t_BCParms[i].sa_BC_LPath < 0)
            continue;
      }
      if((puca_TransferMode_bis[i] == ATM))
      {
         //Reset ncd anomaly once cell delineation is achived after entering
         //showtime. Following code will set puc_ncd_anom variable to zero
         // if at least once cell delineation is acheived after entering show time
         puc_ncd_anom[i] = puc_ncd_anom[i] && (!ps_cd_flag[i]);
         //Set ocd anomaly after ncd anomaly is terminated and cell delineation
         //is lost
         puc_ocd_anom[i] = (!ps_cd_flag[i]) && (!puc_ncd_anom[i]);
         if(pl_SymbolCountOH[i] > pl_SymbolCountOHPeriod[i])
         {
            pl_SymbolCountOH[i] = 0;
            //if at least one over head period out of last 4 periods loss
            //of cell deliniation declare LCD defect is present
            //and no sef defect present
            puc_lcd_def[i] = (pc_FourOHPeriodLCDInfo[i] > 0) && (!puc_sef_def);
            //shift data to align overhead period order
            pc_FourOHPeriodLCDInfo[i] = (pc_FourOHPeriodLCDInfo[i]<<1)&0xE;
         }
         //Keep track of previous four overhead period loss of cell delineation
         //occured or not Bit0, Bit1, Bit2, Bit3 gives cell deliniation
         //happend or not in last 4 overhead periods in acending order
         pc_FourOHPeriodLCDInfo[i] |= puc_ocd_anom[i];
         //Terminate ocd-n if lcd anomaly is declared
         puc_ocd_anom[i] = puc_ocd_anom[i] && (!puc_lcd_def[i]);
         //Since this function is called once per superframe number of symbols
         //incriment symbol count by num of sybols for superframe + 1
         pl_SymbolCountOH[i] += RX_SYMBOLS_PER_SFRAME + 1;
      }
      //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)

   }/*end of for loop */



}

#undef FAR_END //0
#undef NEAR_END //1
