/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  tx_ib_ini_bis.c
*
*  Functions to initialize the ovhd functions
*
****************************************************************************/

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "ovhd_bis.h"
#include "fifo.h"
#include "DSLEngin.h"
#include "latency.h"

/*****************************************************************************
;  Subroutine Name: TxInitIb_bis(...)
;
;  This subroutine initializes the variables and structures required for
;   processing indicator bits and updating error counters
;
;  Prototype:
;     void TxInitIb_bis()
;
;  Input Arguments:
;     none
;
*******************************************************************************/
// ******************************************************************
// tx_ib_ini_bis.c
//
// History
//
// 04/07/2012 Anantha: Added LCD, NCD related initializaion.
//          grep pattern XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers
// ******************************************************************

void TxInitIb_bis(void)
{
   int i;
   //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (start)
   int8 c_NELPath;
   int8 c_FELPath;
   int16 s_NFECp;
   int32 l_SEQp;

   for ( i= 0; i< NUM_DS_BEARER_CHANNELS_SUPPORTED; i++)
   {
      c_FELPath =gt_RxShowTimeVars.t_BCParms[i].sa_BC_LPath;
      c_NELPath =gt_TxShowTimeVars.t_BCParms[i].sa_BC_LPath;
      //compute tx SEQp
      l_SEQp = ComputeSEQ(c_NELPath,&gt_tx_config);
      //calculate tx Nfec, Nfec = MP*Kp+Rp , Kp = sum(Bp) + 1
      s_NFECp = (gt_tx_config.s_Mp[c_NELPath] * (gt_tx_config.sa_Bpn[c_NELPath][i] + 1)
                  + gt_tx_config.s_Rp[c_NELPath]);
      gla_NESymbolCountOH[i] = 0;
      //Tx OH period in PHY symbols is equal to SEQp /((Tp / Mp)*Sp) Where Sp = (Nfec * 8)/Lp
      gla_NESymbolCountOHPeriod[i] = (gt_tx_config.s_Tp[c_NELPath] * s_NFECp * 8 * l_SEQp) /
                              (gt_tx_config.s_Mp[c_NELPath] * gt_tx_config.s_Lp[c_NELPath]);
      gca_NEFourOHPeriodLCDInfo[i] = 0;
      gla_FESymbolCountOH[i] = 0;
      //calculate Rx Nfec, Nfec = MP*Kp+Rp , Kp = sum(Bp) + 1
      s_NFECp = (gt_rx_config.s_Mp[c_FELPath] * (gt_rx_config.sa_Bpn[c_FELPath][i] + 1)
                  + gt_rx_config.s_Rp[c_FELPath]);
      //compute Tx SEQp
      l_SEQp = ComputeSEQ(c_FELPath,&gt_rx_config);
      //Rx OH period in PHY symbols is equal to SEQp /((Tp / Mp)*Sp) Where Sp = (Nfec * 8)/Lp
      gla_FESymbolCountOHPeriod[i] = (gt_rx_config.s_Tp[c_FELPath] * s_NFECp  * 8* l_SEQp)/
                                 (gt_rx_config.s_Mp[c_FELPath] * gt_rx_config.s_Lp[c_FELPath]);
      gca_FEFourOHPeriodLCDInfo[i] = 0;
      // Always indicate NCD anomaly even for the un-enabled bearer channel
      if(gt_RxShowTimeVars.t_BCParms[i].sa_BC_LPath >= 0) {
         gt_tx_Anomaly.uc_ncd_anom[i] = PRESENT;
      } else {
         gt_tx_Anomaly.uc_ncd_anom[i] = TERMINATED;
      }
      //XDSLRTFW-440:Feature_ALL_ALL_ALL_ReInit_Triggers (end)
#if 0
      //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
      if (guca_DS_TransferMode_bis[i] == PTM)
      {
         gt_tx_Anomaly.uc_ncd_anom[i] = PRESENT;
      }
      else
      {
         gt_tx_Anomaly.uc_ncd_anom[i] = TERMINATED;
      }
      //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)
#endif

      gt_tx_Anomaly.uc_ocd_anom[i] = TERMINATED;
      gt_tx_Anomaly.s_cd_flag[i] = FALSE;       /* Cell delineation flag */
      gt_tx_Anomaly.s_ocd_cnt[i] = TERMINATED;  /* Count of consecutice OCD anomalies */
      gt_tx_Anomaly.uc_lcd_def[i] = TERMINATED; /* LCD defect flag */

   }

   gt_tx_Anomaly.uc_los_def = TERMINATED;  /* LOS Defect flag */
   gt_tx_Anomaly.uc_sef_def = TERMINATED;  /* Severly Errored Frame (SEF) Defect flag */
}

