/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
*
* Aware BIS Technology. Proprietary and Confidential.
*
* ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:        781.276.4000
* FAX:              781.276.4001
* WEB:              http://www.aware.com
*
* FILE:             tx_ovhd_bis.c
* DESCRIPTION:      Functions showtime tx overhead processing
*
**********************************************************************/
//******************************************************************************
// tx_ovhd_bis.c
//
// History
//
// 09/08/2010 Nihar : Added the code changes to skip the excess margin reduction using finegains
//                                              for     pilot tone in ALL modes.
//                                      Grep for Perf_DS_ALL_ALL_Pll_NoExMarginReduction
//
// 15/11/2011 ChihWen/Bhadra: There is a special requirement that CPE should sync up in 2km loop with -90 dBm/Hz AWGN (normally DS rate is 600 Kbps),
//                                              and should be able to reach max capped rate of 6 Mbps by upshift SRA when noise power is decreased to -140 dBm/Hz AWGN.
//                With this special requirement, we need to load more bits not only on already loaded tones, but also on monitored tones,
//                                              in order to reach the max capped rate. A problem behind this requirement is that CNXT CO does not send signal on unloaded tones.
//                                              So the workaround to fulfill the requirement for all CO are as below.
//                                              1. For all CO, changing the threshold for setting monitored tones from 4 dB to 6 dB (SNR_THRESH_LOAD_MIN_BITS).
//                                              2. For all CO, not limiting number of monitored tones to 20 if SRA is enabled on CO site.
//                                              3. For all CO, making OLR (SRA and bitswap) only occurring on loaded/monitored tones.
//                                              4. For CNXT CO, no updating FDQ cofficients on unloaded tones.
//                                              5. For CNXT CO, measuring noise on monitored tones to get an estimation of SNR.
//                                              6. For CNXT CO, SNR on monitored tones are capped to 2-bits required SNR, in order to load two bits and get better SNR measurement.
//
//                                              7. When DS rate capped low, it took bitloading too long time to
//               find gs_deltaLp_max and failed the training. This is the root cause
//               of no-link with 3.5M capped profiles.
//               The solution is to use a larger searching step to find a valid
//               gs_deltaLp_max faster.
//
//                                              8. For CNXT CO, decreasing the Tx buffer size for overhead message by 2 if the tone number in the last segment of SRA message was 14.
//                                                       This was because CRC/link drop was always seen when there was 14 tones in the last segment of SRA message.
//
//            Grep for ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones
//
// 04/07/2012 Ram: Merged "ReTx" Bitswap code from ARX ADSL code base.
//                 Grep for "XDSLRTFW-443 FEATURE_DS_BisPlus_ALL_BitSwapReTx"
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
//
// 26/2/2013 Vinjam: Added new element "FE_ACTUAL_INP_ACT" to "guc_test_param_id[ ]". It is used to
//    send a overhed eoc message request to get the far-end actual INP value.
//    Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 27/2/2013 Vinjam: Added new elements "RETX_INP_ACT_SHINE" & "RETX_INP_ACT_REIN" to "guc_test_param_id[ ]".
//    It is used to send a overhed eoc message request to get the far-end Act_INP_SHINE & Act_INP_REIN values.
//    Grep for XDSLRTFW-738 Task_DS_BisPlus_All_ReportInpReinShineInReTx.
//
// 11/12/2013 Balabath: XDSLRTFW-1409: SRA counters mismatch
//  In segmented OLR requests,OLR request counters (SIMPLE_REQ_CNT)are incremented for every segment.
//  This is misleading to OLR request CNTRs not matching with perform+timeout+UTC counters.
//  Solution: increment Request count while sending the first segment. To find code changes grep for
//  " XDSLRTFW-1409 "

//******************************************************************************
#include "typedef.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "ovhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "gdata.h"
#include "cmv.h"
#include "tx_plam.h"
#include "decimalgain.h"
#include "bitload_const.h"
#include "states.h"

#ifdef HDLC_LEAVE_TRAIL
extern FILE *fp_HDLCdata;
#endif

#define BIS  0
#define PLUS 1


extern void Update_OLRPMCnt(OLRPMCntInfo_t* pt_OLRPMCnt, int16 s_OLRPMType, int16 s_countType);

extern FlagT gft_CorruptFCS;
FlagT gft_CorruptSRADRR = FALSE;

/*^^^
*------------------------------------------------------------------------------
*
*  Name : Tx_prior0_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Description:  This subroutine forms the OLR message
*
*  Prototype:
*     uint8 Tx_prior0_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*  Notes: These can be sent both by CO as well as RT
*
*------------------------------------------------------------------------
*^^^
*/
uint8 Tx_prior0_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{

    uint8 uc_comm_or_resp_bit = 2, uc_mod_msg_type;
    FlagT ft_isMode;
    int16 s_Nf;
    int32 i, j, k;

#ifdef HDLC_LEAVE_TRAIL
    uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif
    k = 0;
    puca_msg_buffer[k++] = RECONFIG_CMD_DESIG;

    /* Write the message type */
    puca_msg_buffer[k++] = pt_TxOvhdMsgInfo->uc_message_type;

    if(( gl_SelectedMode & (MODE_G992_5)  ))
    {
        ft_isMode = PLUS;
        uc_mod_msg_type = (uint8)((uint16)pt_TxOvhdMsgInfo->uc_message_type - SRA_REQ);
    }
    else
    {
        ft_isMode = BIS;
        uc_mod_msg_type = pt_TxOvhdMsgInfo->uc_message_type;
    }

    if (uc_mod_msg_type <= SRA_REQ)
    {
       if (gsa_RTXmit_OvhdMsgSegIndx[0] == -1) //XDSLRTFW-1409
       {
                //increment the counter
                Update_OLRPMCnt(&gt_DSOLRPMCnt, uc_mod_msg_type, SIMPLE_REQ_CNT);
       }

        if (((uc_mod_msg_type == DRR_REQ) || (uc_mod_msg_type == SRA_REQ)) && gft_CorruptSRADRR)
        gft_CorruptFCS = TRUE;

        uc_comm_or_resp_bit = 0; /* command */

#ifdef HDLC_LEAVE_TRAIL

        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (OLR msg)\n", RECONFIG_CMD_DESIG);

        if (uc_mod_msg_type == SRA_REQ)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (SRA Request)\n", pt_TxOvhdMsgInfo->uc_message_type);
        else if (uc_mod_msg_type == DRR_REQ)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (DRR Request)\n", pt_TxOvhdMsgInfo->uc_message_type);
        else    /* BITSWAP_REQ */
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Bitswap Request)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif

        /* Lp, Bpn */
        if (uc_mod_msg_type == DRR_REQ ||
                (uc_mod_msg_type == SRA_REQ && gsa_RTXmit_OvhdMsgSegIndx[0] == -1))
        {
            /* Write the 2 * Nlp octets for the new Lp values */
            for(i = 0; i < gt_rx_config.s_Nlp; i++)
            {
                /* Lp high octet */
                puca_msg_buffer[k++] = (uint8)(gt_rx_config.s_Lp[i] >> 8);

                /* Lp low octet */
                puca_msg_buffer[k++] = (uint8)(gt_rx_config.s_Lp[i] & 0xFF );

#ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "New Lp of Lp#%d:0x%02x 0x%02x\n", k, puca_msg_buffer[k-2], puca_msg_buffer[k-1]);
#endif

            }


            /* Write the new Bpn values */
            for (j = 0; j < gt_rx_config.s_Nbc; j++)
            {
                i = guca_rxBCnToLPp[j];

                puca_msg_buffer[k++] = (uint8)gt_rx_config.sa_Bpn[i][j];

#ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "NewBpn of BC#%d:0x%02x\n", j, puca_msg_buffer[k-1]);
#endif
            }
        }

        /* Start filling the bitswap information */
        s_Nf = FillBinsInfo(&puca_msg_buffer[k], ft_isMode, 0, pt_TxOvhdMsgInfo->uc_message_type);

        /* Write the tx message length */
        *pus_msg_length = k + s_Nf;
    }
    else if(pt_TxOvhdMsgInfo->uc_message_type >= DEFER_BITSWAP)
    {
        uc_comm_or_resp_bit = 0x1; /* response */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        if (pt_TxOvhdMsgInfo->uc_message_type == SRA_REJECT)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (SRA Reject)\n", pt_TxOvhdMsgInfo->uc_message_type);
        else if (pt_TxOvhdMsgInfo->uc_message_type == DRR_REJECT)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (DRR Reject)\n", pt_TxOvhdMsgInfo->uc_message_type);
        else if (pt_TxOvhdMsgInfo->uc_message_type == DEFER_BITSWAP)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Defer Bitswap)\n", pt_TxOvhdMsgInfo->uc_message_type);

        fprintf(fp_HDLCdata, "Reason Code:   0x%02x\n", pt_TxOvhdMsgInfo->uc_defer_reason_code);
#endif


        puca_msg_buffer[k++] = pt_TxOvhdMsgInfo->uc_defer_reason_code; /* Reason code */

        /* Write the tx message length */
        *pus_msg_length = (int16)k;
    }

    return(uc_comm_or_resp_bit);
}

/*^^^
*------------------------------------------------------------------------------
*
*  Name : Tx_prior1_ovhd_msg_handler
*
*  Description: This subroutine forms the mesage of priority 1
*
*  Prototype:
*   uint8 Tx_prior1_ovhd_msg_handler(void)
*
*  Input Arguments:
*
*  Output Arguments:
*               Returns the command /response code based on what the message type is
*
*  Global Variables Used:
*
*
*------------------------------------------------------------------------
*^^^
*/

uint8 Tx_prior1_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
    /* Initialise with an invalid value */
    uint8 uc_comm_or_resp_bit = 2;
    uint8 uc_message_designator;

    uint8 (*pF_FormMsgFunc[])(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo) = { &Form_EOC_msg,
        &Form_time_msg,
        &Form_Inventory_msg,
        &Form_Control_val_read_msg,
        &Form_mgmt_counter_read_msg,
        NULL,
        &Form_Power_Mgmt_msg,
        &Form_Clear_EOC_msg
    };

    int16 s_MsgType;

    uc_message_designator = pt_TxOvhdMsgInfo->uc_message_designator;
    puca_msg_buffer[0] = uc_message_designator;
    s_MsgType = (uc_message_designator & 0xF);
    puca_msg_buffer[1] = pt_TxOvhdMsgInfo->uc_message_type;

    /* Form the NSF message */
    if(uc_message_designator == NSF_FACILITY_CMD_DESIG)
    {
        uc_comm_or_resp_bit = Form_nsf_facility_msg(&puca_msg_buffer[0], pus_msg_length, puca_msg_buffer[1]);


    }
    else if (pF_FormMsgFunc[s_MsgType-1] != NULL)
    {
        uc_comm_or_resp_bit = (*pF_FormMsgFunc[s_MsgType-1])(&puca_msg_buffer[0], pus_msg_length, pt_TxOvhdMsgInfo);
    }

    return(uc_comm_or_resp_bit);

}


/*^^^
*------------------------------------------------------------------------------
*
*  Name : Form_Power_Mgmt_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Description:  This subroutine forms the management counter read message to be sent
*
*  Prototype:
*      uint8 Form_Power_Mgmt_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/
uint8 Form_Power_Mgmt_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{

    uint8 uc_comm_or_resp_bit = 2;
    int32 i;
    int32 idx;
    uint8 uc_message_type, uc_defer_reason_code;

#ifdef HDLC_LEAVE_TRAIL
    uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif

    idx = 2;
    uc_message_type = pt_TxOvhdMsgInfo->uc_message_type;
    uc_defer_reason_code = pt_TxOvhdMsgInfo->uc_defer_reason_code;

    switch(uc_message_type)
    {
    case STATE_TRANS_REQ:
        uc_comm_or_resp_bit = 0;

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Power Management msg)\n", POWER_MGMT_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (State Transition Request)\n", uc_message_type);
        fprintf(fp_HDLCdata, "Proposed State:0x00\n");
#endif

        //Required for Simple PM Commands
        puca_msg_buffer[idx++] = pt_TxOvhdMsgInfo->uc_TestParameterId;


        break;



    case STATE_TRANS_GRANT:
        uc_comm_or_resp_bit = 1;

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Power Management msg)\n", POWER_MGMT_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (State Transition Grant)\n", uc_message_type);
#endif
        break;

    case STATE_TRANS_REJECT:
        uc_comm_or_resp_bit = 1;

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Power Management msg)\n", POWER_MGMT_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (State Transition Reject)\n", uc_message_type);
        fprintf(fp_HDLCdata, "Reject Reason: 0x%02x\n", uc_defer_reason_code);
#endif


        /* Send 1 octet for the reason code */
        puca_msg_buffer[idx++] = uc_defer_reason_code;

        break;


        /* Only sent by RT */

    case L2_GRANT:
    case PLUS_L2_GRANT:
        uc_comm_or_resp_bit = 1;

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Power Management msg)\n", POWER_MGMT_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (L2 Grant)\n", uc_message_type);
#endif

        /* RT shall not send an L2 grant command if it has already sent */
        /* an OLR request command and is awaiting a response */
        //if(gt_Tx_ovhd_Message[0].ft_ack_expected)
        //      return(uc_comm_or_resp_bit);
        // We already check for OLRPMState before issuing L2 Grant or DS OLR request
        // Hence, this check seems redundant

        if (gsa_RTXmit_OvhdMsgSegIndx[1] == -1)
        {

            /* Fill in the actual Lp values */
            for(i = 0; i< gt_rx_config.s_Nlp; i++)
            {
                /* High Lp octet */
                puca_msg_buffer[idx++] = (uint8)(gt_rx_config.s_Lp[i] >> 8);

                /* Low Lp octet */
                puca_msg_buffer[idx++] = (uint8)(gt_rx_config.s_Lp[i] & 0xFF);

#ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "Act Lp of Lp#%d:0x%02x 0x%02x\n", i, puca_msg_buffer[idx-2], puca_msg_buffer[idx-1]);
#endif

            }

            /* Send 1 octet for the actual PCBds values */
            puca_msg_buffer[idx++] = (uint8)(gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols);
#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "Actual PCBds:  0x%02x\n", (uint8)(gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols));
#endif

            /* Send 1 octet for the exit symbol PCBds values */
            puca_msg_buffer[idx++] = (uint8)(gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols);
#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "ExitSymb PCBds:0x%02x\n", (uint8)(gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols));
#endif


            /* Send 1 octet for the exit symbol bi/gi table flag */
            puca_msg_buffer[idx++] = gt_RxOLRPMVars.t_L2PowerCutBack.ft_isL2Gain;
#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "ExitSymb BiGiF:0x%02x\n", (uint8)(gt_RxOLRPMVars.t_L2PowerCutBack.ft_isL2Gain));
#endif
        }


        /* Fill in the changed bins info */
        if (uc_message_type == L2_GRANT)
        idx += FillBinsInfo(&puca_msg_buffer[idx], BIS, 1, uc_message_type);
        if (uc_message_type == PLUS_L2_GRANT)
        {
            idx += FillBinsInfo(&puca_msg_buffer[idx], PLUS, 1, uc_message_type);
        }

        break;

    case L2_REJECT:
        uc_comm_or_resp_bit = 1;

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Power Management msg)\n", POWER_MGMT_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (L2 Reject)\n", uc_message_type);
        fprintf(fp_HDLCdata, "Reject Reason: 0x%02x\n", uc_defer_reason_code);
#endif

        /* Send 1 octet for the reason code */
        puca_msg_buffer[idx++] = uc_defer_reason_code;

        break;

    case L2_TRIM_GRANT:
        uc_comm_or_resp_bit = 1;

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Power Management msg)\n", POWER_MGMT_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (L2 Trim Grant)\n", uc_message_type);
        fprintf(fp_HDLCdata, "ExitSymb PCBds:0x%02x\n", (uint8)(gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols));
#endif


        /* Send 1 octet for the exit symbol PCB ds value */
        puca_msg_buffer[idx++] = (uint8)(gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols);


        break;

    case L2_TRIM_REJECT:
        uc_comm_or_resp_bit = 1;

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Power Management msg)\n", POWER_MGMT_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (L2 Trim Reject)\n", uc_message_type);
        fprintf(fp_HDLCdata, "Reject Reason: 0x%02x\n", uc_defer_reason_code);
#endif

        /* Send 1 octet for the reason code */
        puca_msg_buffer[idx++] = uc_defer_reason_code;

        break;


    }

    *pus_msg_length = (int16)idx;

    return(uc_comm_or_resp_bit);

}


/*^^^
*------------------------------------------------------------------------------
*
*  Name : Tx_prior2_ovhd_msg_handler
*
*  Description: This subroutine forms the mesage of priority 2
*
*  Prototype:
*   uint8 Tx_prior2_ovhd_msg_handler(void)
*
*  Input Arguments:
*
*  Output Arguments:
*               Returns the command /response code based on what the message type is
*
*  Global Variables Used:
*
*
*------------------------------------------------------------------------
*^^^
*/

uint8 Tx_prior2_ovhd_msg_handler(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
    /* Initialise with an invalid value */
    uint8 uc_comm_or_resp_bit = 2;
    uint8 uc_message_type;

    puca_msg_buffer[0] = pt_TxOvhdMsgInfo->uc_message_designator;
    uc_message_type = pt_TxOvhdMsgInfo->uc_message_type;
    puca_msg_buffer[1] = uc_message_type;

    /* Form the EOC message */
    if(pt_TxOvhdMsgInfo->uc_message_designator == NSF_FACILITY_LOW_CMD_DESIG)
    {

        uc_comm_or_resp_bit = Form_nsf_facility_msg(&puca_msg_buffer[0], pus_msg_length, uc_message_type);
    }

    /* Form the test parameter read message */
    else if(pt_TxOvhdMsgInfo->uc_message_designator == PMD_TEST_PAR_RD_CMD_DESIG)
    {
        uc_comm_or_resp_bit = Form_test_param_read_msg(&puca_msg_buffer[0], pus_msg_length, pt_TxOvhdMsgInfo);
    }


    return(uc_comm_or_resp_bit);
}




/*^^^
*------------------------------------------------------------------------------
*
*  Name : int16 FillBinsInfo(uint8 *puca_msg_buffer, FlagT isBisOrPlus, uint8 uc_priority, uint8 uc_message_type)
*
*  Description: This subroutine fills the bins info field of the transmit OLR message
*
*  Prototype:
*     int16 FillBinsInfo(uint8 *puca_msg_buffer, FlagT isBisOrPlus, uint8 uc_priority, uint8 uc_message_type)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*
*------------------------------------------------------------------------
*^^^
*/


int16 FillBinsInfo(uint8 *puca_msg_buffer, FlagT isBisOrPlus, uint8 uc_priority, uint8 uc_message_type)
{
    int32 i, k;
    int32 s_Nf = 0;
    int16 s_RxFineGain, s_Divisor;

#ifdef HDLC_LEAVE_TRAIL
    int16 j;
#endif
      //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
#ifndef ISDN
    int16 s_temp;
#endif
    int16 s_MaxTonePerOvhdMsg = gs_MaxTonePerOvhdMsg;
      //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)

    k = 0;

    // We will only do the inside part once for the whole ovhd msg, i.e, the first msg segment if we need to do
    // msg segmentation
    if (gsa_RTXmit_OvhdMsgSegIndx[uc_priority] == -1)
    {
        // check how many tones will be changed and decide whether to do msg segment or not
        for(i = gs_RxFirstChannel; i <= gs_RxLastChannel; i ++)
        {
            if(IS_TONEFLAGSET(guca_RxBitswapTones, i))
            s_Nf++;
        }

      //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
   //In the upshift SRA test (with CNXT CO in MPT lab), streaming CRC and link drop only happened when the tone number in SRA message
   //was 174 with the Tx buffer size for overhead message was 160. Here a special upshift SRA test was done as below.
   //
   //1. Loading two bits on every monitored tones starting from (last loaded tone+1) up to some different tone index when buffer size was 160 tones.
   //   1.1. No CRC/link drop was seen with loading 170, 171, 172, 173, 175, 176, 177, 178 tones (all would result in two-segment SRA message).
   //   1.2. CRC/link drop was always seen with loading 174 tones (would result in two-segment SRA message, and 14 tones in the second segment).
   //
   //2. Loading two bits on every monitored tones starting from (last loaded tone+1) up to some different tone index when buffer size was 148 tones.
   //   2.1. No CRC/link drop was seen with loading 161, 163 (all would result in two-segment SRA message).
   //   2.2. CRC/link drop was always seen with loading 162 tones (would result in two-segment SRA message, and 14 tones in the second segment).
   //
   //3. Loading two bits on every monitored tones starting from (last loaded tone+1) up to some different tone index when buffer size was 144 tones.
   //   3.1. No CRC/link drop was seen with loading 157, 159 (all would result in two-segment SRA message).
   //   3.2. CRC/link drop was always seen with loading 158 tones (would result in two-segment SRA message, and 14 tones in the second segment).
   //
   //4. No CRC and link drop was seen with no segmented SRA message (with larger Tx buffer).
   //
   //Once there are 14 tones in the second segment of SRA message, CRC and link would always happen.
   //So here we check if the tone number in the last segment of SRA message is 14. If so, the buffer size will be decreased by two.
#ifndef ISDN
                        if ((gs_CurrentCoChipset == GSI_CO_CHIPSET) && (s_Nf > gs_MaxTonePerOvhdMsg))
                        {
            s_temp = s_Nf;

                                while(s_temp > gs_MaxTonePerOvhdMsg)
                                        s_temp -= gs_MaxTonePerOvhdMsg;

                                if (s_temp == 14)
                                        s_MaxTonePerOvhdMsg = gs_MaxTonePerOvhdMsg - 2;
                                else
                                        s_MaxTonePerOvhdMsg = gs_MaxTonePerOvhdMsg;
                        }
#endif
         //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)
        if(isBisOrPlus == BIS)
        {
            k = 1;
            puca_msg_buffer[0] = (uint8)s_Nf;
        }
        else if (isBisOrPlus == PLUS)
        {
            // 2 bytes for Nf
            k = 2;
            puca_msg_buffer[0] = (uint8)((s_Nf>>8)&0xFF);
            puca_msg_buffer[1] = (uint8)(s_Nf&0xFF);

         if (//ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
                 ((s_Nf > s_MaxTonePerOvhdMsg) &&   /* Too long a message (possible in Plus mode only) */
              //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)
              (gl_SelectedMode & (MODE_G992_5)) &&    /* cpe segmentation enabled */
              //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
              ((uc_message_type != PLUS_BITSWAP_REQ) ||
               ((uc_message_type == PLUS_BITSWAP_REQ) &&
                (gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_FAST_BITSWAP))) &&
              //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
              //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (Start)
              (gt_ReTxConfigInfo.ft_ReTxOn == 0)) ||
             ((gt_ReTxConfigInfo.ft_ReTxOn == 1) && (s_Nf > gs_MaxTonePerOvhdMsg))
              //XDSLRTFW-443: FEATURE_DS_BisPlus_ALL_BitSwapReTx (End)
            )
         {
            // start doing msg segmentation
            //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
            //gsa_RTXmit_OvhdMsgSegIndx[uc_priority] =
            //   ((s_Nf - 1) / gs_MaxTonePerOvhdMsg) + 1;
            gsa_RTXmit_OvhdMsgSegIndx[uc_priority] =
               ((s_Nf - 1) / s_MaxTonePerOvhdMsg) + 1;
            //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)
            gfta_FirstOvhdMsgSeg[uc_priority] = TRUE;
         }
        }

        gs_OvhdMsgFirstTone = gs_RxFirstChannel;
    }

    s_Nf = 0;
    for(i = gs_OvhdMsgFirstTone; i <= gs_RxLastChannel; i ++)
    {
        if(IS_TONEFLAGSET(guca_RxBitswapTones, i))
        {
            if(isBisOrPlus == BIS)
            puca_msg_buffer[k++] = (uint8)i; /* DS Bin */
            else if (isBisOrPlus == PLUS)
            {
                puca_msg_buffer[k++] = (uint8)((i>>8)&0x7); /* DS Bin MSB 3bits*/
                puca_msg_buffer[k++] = (uint8)(i&0xFF);
            }
            s_Divisor = DecimalGain(gsa_RxFineGains[i]);

            // limit the gain value to -2.5 dB (.7498 * 8192) , except when it is '0', which is legal
            if ((s_Divisor !=0) && (s_Divisor < FG_MIN_VALUE))
               s_Divisor = FG_MIN_VALUE;

            // Use the same 12-bit fine gain value that will be sent to the far end.
            s_Divisor = (s_Divisor + (1<<3)) & 0xFFF0;

            s_RxFineGain = s_Divisor;
            if (!(OPTNArray[OPTN_PwrManControl] & OPTN_ExMarginRedDisable))
            {
                // Perf_DS_ALL_ALL_Pll_NoExMarginReduction (Start)
                if (i != gs_CPilotTone)
                {
                    s_RxFineGain = (int16)(((int32)s_RxFineGain * gt_FineGainInfo.s_ExcessMarFGReduction) >> 13);
                }
                // Perf_DS_ALL_ALL_Pll_NoExMarginReduction (End)
            }

            puca_msg_buffer[k++] = (uint8)(s_RxFineGain >> 8);          /* DS Bin: Gain */
            puca_msg_buffer[k++] = (uint8)((guca_RxBat[i] & 0xF) | ((s_RxFineGain + 0x8) & 0xF0)) ; /* DS Bin: # Bits */


            /* Increment the number of bins being swapped */
            s_Nf++;
        }
        // check whether the msg segment is full
      if ((gsa_RTXmit_OvhdMsgSegIndx[uc_priority] >= 1) &&
         //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (START)
          //((s_Nf == gs_MaxTonePerOvhdMsg) || (i == gs_RxLastChannel)))
          ((s_Nf == s_MaxTonePerOvhdMsg) || (i == gs_RxLastChannel)))
          //ADSLRTFW-1413 ENH_DS_BisPlus_All_SRA_LargerStep_MonitoredTones (END)
        {
            gsa_RTXmit_OvhdMsgSegIndx[uc_priority]--;
            gs_OvhdMsgFirstTone = i+1;
            break;
        }
    }



#ifdef HDLC_LEAVE_TRAIL
    if(isBisOrPlus == BIS)
    fprintf(fp_HDLCdata, "No. of Tones:  0x%02x\n", puca_msg_buffer[0]);
    else if (isBisOrPlus == PLUS)
    fprintf(fp_HDLCdata, "No. of Tones:  0x%02x 0x%02x\n", puca_msg_buffer[0], puca_msg_buffer[1]);

    fprintf(fp_HDLCdata, "BiGi Table:    ");
    for (i = 0; i < s_Nf; i++)
    {
        int16 blocksize;
        if(isBisOrPlus == BIS)
        blocksize = 3;
        else if (isBisOrPlus == PLUS)
        blocksize = 4;

        for (j = 0; j < blocksize; j++)
        {
            if (!i)
            fprintf(fp_HDLCdata, "0x%02x ", puca_msg_buffer[i*blocksize+j+1]);
            else
            {
                if (!j)
                fprintf(fp_HDLCdata, "               0x%02x ", puca_msg_buffer[i*blocksize+j+1]);
                else
                fprintf(fp_HDLCdata, "0x%02x ", puca_msg_buffer[i*blocksize+j+1]);
            }
        }

        if (!i)
        fprintf(fp_HDLCdata, "(ToneIndex  Gi(high 8bits) Gi(low 4bits)+Bi(4bits))");

        fprintf(fp_HDLCdata, "\n");

    }

#endif

    return((int16)k);
}





#undef BIS
#undef PLUS


#ifdef HDLC_POLL_TEST
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
#define MAX_PRIOR1_POLLS           2
//XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
//XDSLRTFW-738 Task_DS_BisPlus_All_ReportInpReinShineInReTx (Start_End)
#define MAX_PRIOR2_POLLS           12

FlagT gft_PollHDLC1 = FALSE;  //flag indicate when to poll HDLC priority 1 msg
FlagT gft_PollHDLC2 = FALSE;  //flag indicate when to poll HDLC priority 2 msg
uint8 guc_poll_index = 0 ;
uint8 guc_poll_once_msg = 0;
// Counters to keep track of Eoc Polling
uint8 guc_PollPrior1Messages = 0xF1; // Skip polling for initial few seconds after entering showtime
uint8 guc_PollPrior2Messages = 0xF3; // +2 -> so that Prio1/Prio2 polling will be out-of-sync by an offset of 2.

uint8 guc_test_param_id[MAX_PRIOR2_POLLS]={
(uint8)CHANNEL_TRANSFER_FUNCTION,
(uint8)QUIET_LINE_NOISE_PSD,
(uint8)SNR,
(uint8)LINE_ATTENUATION,
(uint8)SIGNAL_ATTENUATION,
(uint8)SIGNAL_TO_NOISE_MARGIN,
(uint8)ATTAIN_NET_DATA_RATE,
(uint8)NE_ACTUAL_TRANSMIT_POWER,
(uint8)FE_ACTUAL_TRANSMIT_POWER,
//XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
(uint8)FE_ACTUAL_INP_ACT,
//XDSLRTFW-738 Task_DS_BisPlus_All_ReportInpReinShineInReTx (Start)
(uint8)RETX_INP_ACT_SHINE,
(uint8)RETX_INP_ACT_REIN
//XDSLRTFW-738 Task_DS_BisPlus_All_ReportInpReinShineInReTx (End)
};


/*^^^
*------------------------------------------------------------------------------
*
*  Name : void Poll_prior1_test_messages()(void);

*
*  Description: This subroutine decides which priority message needs to be sent
*
*  Prototype:
*   Poll_prioir1_test_messages(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*
*------------------------------------------------------------------------
*^^^
*/
void Poll_prior1_test_messages(void)
{
    TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput;
    memset((void*)&t_TxOvhdMsgInfoInput, 0, sizeof(TxOvhdMsgInfoRequest_t));

    if ((gft_PollHDLC1)
        &&  (gta_TxHdlcControlInfo[1].ft_ack_expected == FALSE)
        && (gta_TxHdlcControlInfo[1].uca_MsgTypeCount[AUTO_CMD_SOURCE] == 0))
    {
        switch (guc_poll_once_msg)
        {
             case 0:
                 t_TxOvhdMsgInfoInput.uc_message_designator = INVENTORY_CMD_DESIG;
                 t_TxOvhdMsgInfoInput.uc_message_type = IDENT_READ;
                 t_TxOvhdMsgInfoInput.uc_Source = AUTO_CMD_SOURCE;
                 guc_poll_once_msg++;
                 break;

             case 1:
                 t_TxOvhdMsgInfoInput.uc_message_designator = INVENTORY_CMD_DESIG;
                 t_TxOvhdMsgInfoInput.uc_message_type = AUX_IDENT_READ;
                 t_TxOvhdMsgInfoInput.uc_Source = AUTO_CMD_SOURCE;
                 guc_poll_once_msg++;
                 break;

             default:
                 t_TxOvhdMsgInfoInput.uc_message_designator = MGMT_CNTR_RD_CMD_DESIG;
                 t_TxOvhdMsgInfoInput.uc_message_type = MGMT_CNTR_READ;
                 t_TxOvhdMsgInfoInput.uc_Source = AUTO_CMD_SOURCE;
                 break;
        }

        if (TxHdlcSendRequest(1 /* priority */, t_TxOvhdMsgInfoInput) == HDLC_QUEUE_ADDED)
        {
            gft_PollHDLC1 = FALSE;
        }
    }
}

/*^^^
*------------------------------------------------------------------------------
*
*  Name : void Poll_prior2_test_messages()(void);

*
*  Description: This subroutine decides which priority message needs to be sent
*
*  Prototype:
*   Poll_prior2_test_messages(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*
*------------------------------------------------------------------------
*^^^
*/


void Poll_prior2_test_messages(void)
{
    TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput;
    memset((void*)&t_TxOvhdMsgInfoInput, 0, sizeof(TxOvhdMsgInfoRequest_t));

    if (gft_PollHDLC2)
    {
        while ((guc_poll_index < MAX_PRIOR2_POLLS)
            && (gta_TxHdlcControlInfo[2].ft_ack_expected == FALSE)
            && (gta_TxHdlcControlInfo[2].uca_MsgTypeCount[AUTO_CMD_SOURCE] == 0))
        {
            t_TxOvhdMsgInfoInput.uc_message_designator = PMD_TEST_PAR_RD_CMD_DESIG;
            t_TxOvhdMsgInfoInput.uc_message_type = SINGLE_READ;
            t_TxOvhdMsgInfoInput.uc_TestParameterId = guc_test_param_id[guc_poll_index];
            t_TxOvhdMsgInfoInput.uc_Source = AUTO_CMD_SOURCE;
            if (TxHdlcSendRequest(2 /* priority */, t_TxOvhdMsgInfoInput) != HDLC_QUEUE_ADDED)
            {
                break;
            }

            guc_poll_index++;

            if (guc_poll_index >= MAX_PRIOR2_POLLS)
            {
                guc_poll_index = 0;
                gft_PollHDLC2 = FALSE;
            }
        }
    }
}
// XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)
#endif

/*^^^
*------------------------------------------------------------------------------
*
*  Name : void ME_HDLC_TxProcessor(void)
*
*
*  Description: This subroutine decides which hdlc message command ME wants cpe to send
*
*  Prototype:
*   void ME_HDLC_TxProcessor(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*
*------------------------------------------------------------------------
*^^^
*/


void ME_HDLC_TxProcessor(void)
{

    TxOvhdMsgInfoRequest_t t_TxOvhdMsgInfoInput;

    // commands EOC_CMD_DESIG, TIME_CMD_DESIG, INVENTORY_CMD_DESIG, CNTL_PAR_RD_CMD_DESIG, MGMT_CNTR_RD_CMD_DESIG
    // POWER_MGMT_CMD_DESIG, CLEAR_EOC_CMD_DESIG,NSF_FACILITY_CMD_DESIG have normal priority
    int16 s_message_priority = OVHD_NORMAL_PRIORITY;

    memset((void*)&t_TxOvhdMsgInfoInput, 0, sizeof(TxOvhdMsgInfoRequest_t));

    if ((CNTLArray[CNTL_ME_HDLC] & CNTL_ME_HDLC_ReturnToIdle) != 0)
    {
        STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_IDLE;
        CNTLArray[CNTL_ME_HDLC] &= ~CNTL_ME_HDLC_ReturnToIdle; // CLEAR BIT 2
    }
    else
    {

        if ((CNTLArray[CNTL_ME_HDLC] & CNTL_ME_HDLC_Send) != 0)
        {

            /* when ME is ready to send a message */

            /* Figure out the message priority based on the command designator */
            /* priority 0 messages should not be set by ME, hence we are not checking here. */
            if ( (guca_Tx_ME_HDLCMsgBuffer[0] == PMD_TEST_PAR_RD_CMD_DESIG)
                    || (guca_Tx_ME_HDLCMsgBuffer[0] == NSF_FACILITY_LOW_CMD_DESIG) )
            {
                s_message_priority = OVHD_LOW_PRIORITY;
            }

            /* queue the message */
            while ( (gta_TxHdlcControlInfo[s_message_priority].ft_ack_expected == FALSE)
            && (gta_TxHdlcControlInfo[s_message_priority].uca_MsgTypeCount[ME_CMD_SOURCE] == 0) )
            {
                t_TxOvhdMsgInfoInput.uc_message_designator = guca_Tx_ME_HDLCMsgBuffer[0];
                t_TxOvhdMsgInfoInput.uc_message_type = guca_Tx_ME_HDLCMsgBuffer[1];
                t_TxOvhdMsgInfoInput.uc_Source = ME_CMD_SOURCE;

                if (TxHdlcSendRequest(s_message_priority /* priority */, t_TxOvhdMsgInfoInput) != HDLC_QUEUE_ADDED)
                {
                    break;
                }

                /* will come here only if the message is queued */

                /* change ME_HDLC status */
                STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_MSG_QUEUED;

                /* clear the send bit of ME_HDLC Control cmv */
                CNTLArray[CNTL_ME_HDLC] &= ~CNTL_ME_HDLC_Send;

            } // while

        } // if ((CNTLArray[CNTL_ME_HDLC] & CNTL_ME_HDLC_Send) != 0)
    }
}

void OvhdMsg_Timeout_Handler(int32 l_PriorityIndex);
extern uint16 gusa_ovhd_msg_timeout[];
void CheckHdlcTimeOut(void)
{
    int32 l_PriorityIndex;
    TxHdlcControl_t *pt_TxHdlcControlInfo;

    for (l_PriorityIndex = 0; l_PriorityIndex < MAX_OVHD_PRIORITY; l_PriorityIndex++)
    {
        // Compute timeout length in # superframe (there is some approximation here)
        // to protect divide 0 exception

        pt_TxHdlcControlInfo = &gta_TxHdlcControlInfo[l_PriorityIndex];
        if ((pt_TxHdlcControlInfo->ft_ack_expected) &&
                (pt_TxHdlcControlInfo->us_ovhd_timer >= gusa_ovhd_msg_timeout[l_PriorityIndex]))
        {
            /* For priority 0 message, timeout after 400ms */
            /* For priority 1 message, timeout after 800ms */
            /* For priority 2 message, timeout after 1s */
            OvhdMsg_Timeout_Handler(l_PriorityIndex);
        }
    }
}

/*****************************************************************************
;       Subroutine Name: TxIbProcessor_bis()
;
;       This function processes Tx indicator bits
;
;       Prototype:
;               void TxIbProcessor_bis(void)
;
;       Input Arguments:
;
;       Output Arguments:
;
;       Global Variable used by this file:
;
;****************************************************************************/

void TxIbProcessor_bis(void)
{
    uint8 uc_byte = NO_INDICATIONS;

    /* NTR bits ib (7:0)  = 0xFF : upstream NTR will never be valid */

    /* ============================================ */
    /* ib15:  check for los defect                                      */
    /* ============================================ */
    if ((gt_tx_Anomaly.uc_los_def == PRESENT) && !(TESTArray[TEST_Control3] & TEST_SuppressLosIbToCO))
    {
        uc_byte &= LOS_IB;
    }
    /* ============================================ */
    /* ib14:  check for sef defect                                      */
    /* ============================================ */
    if ((gt_tx_Anomaly.uc_sef_def == PRESENT) && !(TESTArray[TEST_Control3] & TEST_SuppressSefIbToCO))
    {
        uc_byte &= SEF_IB;
    }

    /* ============================================ */
    /* ib14:  check for LPR primitive                           */
    /* ============================================ */

    if (gs_IB_lpr_cnt > 0)
    {
        gs_IB_lpr_cnt--;
        if (!(TESTArray[TEST_Control3] & TEST_SuppressLprIbToCO))
        uc_byte &= LPR_IB;
    }

    /* ib (15: 8)  = los sef lpr 1 1 1 1 */
    gus_TxIbInfoL = ((uc_byte << 8) | NO_INDICATIONS);

    /* PMS_TC indicator bits are not activated yet : reserved */

    /* Inactive channels have bit set to 1 */
    /* lcd(BC0) lcd(BC1) 1 1 1 1 1 1 1  */
    uc_byte = NO_INDICATIONS;

    if (!(TESTArray[TEST_Control3] & TEST_SuppressCdIbToCO)) {
        if((gt_tx_Anomaly.uc_lcd_def[0] == PRESENT) || (gt_tx_Anomaly.uc_ocd_anom[0] == PRESENT)
                ||(gt_tx_Anomaly.uc_ncd_anom[0] == PRESENT))
        uc_byte &= LCD_BC0_IB;

        if((gt_tx_Anomaly.uc_lcd_def[1] == PRESENT) || (gt_tx_Anomaly.uc_ocd_anom[1] == PRESENT)
                ||(gt_tx_Anomaly.uc_ncd_anom[1] == PRESENT))
        uc_byte &= LCD_BC1_IB;
    }

    gus_TxIbInfoH = ((uc_byte << 8) | NO_INDICATIONS);
}

/*^^^
*------------------------------------------------------------------------
*
*  Name : ProcessTxHDLCByte(void)
*
*  Description:  This subroutine gets the overhead byte to be transmitted next
*
*  Prototype:
*      void  ProcessTxHDLCByte(void)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Return:
*      None
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/

void ProcessTxHDLCByte(void)
{
    // If we've finished transmitting the last whole msg,
    // stop transmitting HDLC byte even if there might be some new HDLC
    // ovhd byte existing in the FIFO. We don't want to start transmitting
    // the new msg right away without knowing whether the new msg is completed
    // in the FIFO yet. This is to avoid the possible starving problem in the
    // HDLC ovhd fifo.

    /* If there is no message in the FIFO to be transmitted */
    if (!gft_Start_Transmit_HDLC ||
            !RemoveMessageFromOvhdFifo(&gt_TxHDLCMsgFifo, &guc_tx_ovhd_byte))
    {
        /* transmit the 0x7E flag */
        guc_tx_ovhd_byte = OPENING_FLAG;
    }
}

