/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware BIS Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             tx_ovhd_form_ctrl_msg_bis.c
 * DESCRIPTION:      Functions that form the BIS Tx overhead control parameter msg
 *
 **********************************************************************/

#include "typedef.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "ovhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "gdata.h"
#include "cmv.h"
#include "hs_misc.h"
#include "hndshk_Data.h"
#include "plam.h"
#include "rx_plam.h"
#include "tx_plam.h"
#include "snr.h"
#include <string.h>
#include "bitload.h"
#include "tx_ops_bis.h"
#include "decimalgain.h"
#include "rx_ovrhd_bis.h"

#ifdef HDLC_LEAVE_TRAIL
   extern FILE *fp_HDLCdata;
#endif

#define C_PARAMS_PMD    0
#define C_PARAMS_PMS_TC 1
/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Form_Control_val_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Description:  This subroutine forms the control value read message to be sent
 *
 *  Prototype:
 *      uint8 Form_Control_val_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

uint8 Form_Control_val_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
                     TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
   uint8 uc_comm_or_resp_bit;

#ifdef HDLC_LEAVE_TRAIL
   uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif

#ifdef ENABLE_ALL_HDLC_OVHD
   int16 i;
#endif

   int16 idx = 2; /* next available index */

   uc_comm_or_resp_bit = 1; /* response */

   switch(pt_TxOvhdMsgInfo->uc_message_type)
   {
#ifdef ENABLE_ALL_HDLC_OVHD //We don't intend to retrieve parameter during showtime, this will save us showtime memory
      case PMD_CNTRL_PAR_READ:
      case PMS_TC_PAR_READ:
      case TPS_TC_PAR_READ:
         uc_comm_or_resp_bit = 0; /* command */

#ifdef HDLC_LEAVE_TRAIL
         /* Toggle the LSB for every new message sent */
         uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
         uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

         uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

         fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
         if (!uc_comm_or_resp_bit)
            fprintf(fp_HDLCdata, "(Command)\n");
         else
            fprintf(fp_HDLCdata, "(Response)\n");

         //Designator byte
         fprintf(fp_HDLCdata, "Designator:    0x%02x  (Control Parameter msg)\n", CNTL_PAR_RD_CMD_DESIG);

         if (pt_TxOvhdMsgInfo->uc_message_type == PMD_CNTRL_PAR_READ)
            fprintf(fp_HDLCdata, "Message Type:  0x%02x  (PMD Control Parameter msg)\n", pt_TxOvhdMsgInfo->uc_message_type);
         else if (pt_TxOvhdMsgInfo->uc_message_type == PMS_TC_PAR_READ)
            fprintf(fp_HDLCdata, "Message Type:  0x%02x  (PMS-TC Parameter msg)\n", pt_TxOvhdMsgInfo->uc_message_type);
         else if (pt_TxOvhdMsgInfo->uc_message_type == TPS_TC_PAR_READ)
            fprintf(fp_HDLCdata, "Message Type:  0x%02x  (TPS-TC Parameter msg)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif

         break;
#endif //ENABLE_ALL_HDLC_OVHD

      case PMD_CNTRL_PAR_READ_ACK:

#ifdef ENABLE_ALL_HDLC_OVHD //We don't intend to send the parameter during showtime, this will save us showtime memory

#ifdef HDLC_LEAVE_TRAIL
         /* Toggle the LSB for every new message sent */
         uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
         uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

         uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

         fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
         if (!uc_comm_or_resp_bit)
            fprintf(fp_HDLCdata, "(Command)\n");
         else
            fprintf(fp_HDLCdata, "(Response)\n");

         //Designator byte
         fprintf(fp_HDLCdata, "Designator:    0x%02x  (Control Parameter msg)\n", CNTL_PAR_RD_CMD_DESIG);
         fprintf(fp_HDLCdata, "Message Type:  0x%02x  (PMD Control Parameter Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif

         /***********************************************/
         /* Fill the PMD parameter info from MS message */
         /***********************************************/
         // According to Table 8-23/G992.3, transmit SI_3A_NPar2 byte not including NTR bit
         puca_msg_buffer[idx++] = (gt_BisInfoSave.uc_SI_NPar2 & 0xFE) | DELIMIT_2 | DELIMIT_1;
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "MS PMD Info:   0x%02x\n", puca_msg_buffer[idx-1]);
#endif
         /****************************************************/
         /* Fill the PMD parameter info related to C_MSG_PCB */
         /****************************************************/
         idx = Fill_C_MSG_PCB_PMD_Info(&puca_msg_buffer[0], idx);

         /*****************************************************/
         /* Fill the PMD parameter info from C_PARAMS message */
         /*****************************************************/

         idx = Fill_C_PARAMS_Info(&puca_msg_buffer[0], idx, C_PARAMS_PMD);
#endif //ENABLE_ALL_HDLC_OVHD

         break;

      case PMS_TC_PAR_READ_ACK:

#ifdef ENABLE_ALL_HDLC_OVHD //We don't intend to send the parameter during showtime, this will save us showtime memory

#ifdef HDLC_LEAVE_TRAIL
         /* Toggle the LSB for every new message sent */
         uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
         uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

         uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

         fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
         if (!uc_comm_or_resp_bit)
            fprintf(fp_HDLCdata, "(Command)\n");
         else
            fprintf(fp_HDLCdata, "(Response)\n");

         //Designator byte
         fprintf(fp_HDLCdata, "Designator:    0x%02x  (Control Parameter msg)\n", CNTL_PAR_RD_CMD_DESIG);
         fprintf(fp_HDLCdata, "Message Type:  0x%02x  (PMS-TC Parameter Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif


         /**************************************************/
         /* Fill the PMS-TC parameter info from MS message */
         /**************************************************/
         idx = Fill_MS_MSG_PMS_TC_Info(&puca_msg_buffer[0],idx);

         /********************************************************/
         /* Fill the PMS-TC parameter info from C_PARAMS message */
         /********************************************************/

         idx = Fill_C_PARAMS_Info(&puca_msg_buffer[0], idx, C_PARAMS_PMS_TC);

#endif //ENABLE_ALL_HDLC_OVHD

         break;

      case TPS_TC_PAR_READ_ACK:

#ifdef ENABLE_ALL_HDLC_OVHD //We don't intend to send the parameter during showtime, this will save us showtime memory

#ifdef HDLC_LEAVE_TRAIL
         /* Toggle the LSB for every new message sent */
         uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
         uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

         uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

         fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
         if (!uc_comm_or_resp_bit)
            fprintf(fp_HDLCdata, "(Command)\n");
         else
            fprintf(fp_HDLCdata, "(Response)\n");

         //Designator byte
         fprintf(fp_HDLCdata, "Designator:    0x%02x  (Control Parameter msg)\n", CNTL_PAR_RD_CMD_DESIG);
         fprintf(fp_HDLCdata, "Message Type:  0x%02x  (TPS-TC Parameter Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif


         /**************************************************/
         /* Fill the TPS-TC parameter info from MS message */
         /**************************************************/
         // SPar2 bit
         puca_msg_buffer[idx++] = gt_BisInfoSave.uc_SI_SPar2[2];
         puca_msg_buffer[idx++] = 0x00;
         puca_msg_buffer[idx++] = gt_BisInfoSave.uc_SI_SPar2[4]| DELIMIT_2;

#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "MS TPS-TC Info:0x%02x 0x%02x 0x%02x\n", puca_msg_buffer[idx-3], puca_msg_buffer[idx-2],puca_msg_buffer[idx-1]);
#endif
         for(i = 0; i < 4; i++)
         {
            idx = AddTpsTcInfo(i, &gt_BisInfoSave, &puca_msg_buffer[0], idx);
         }

#endif //ENABLE_ALL_HDLC_OVHD

         break;
   }
    *pus_msg_length = idx;

   return(uc_comm_or_resp_bit);
}




/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Fill_C_MSG_PCB_PMD_Info
 *
 *  Description: This subroutine fills the PMD parameter Info from C_MSG_PCB message
 *          and returns the next avaialable write index
 *
 *  Prototype:
 *   void Fill_C_MSG_PCB_PMD_Info(uint8 *puca_msg_buffer, int16 idx)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */

int16 Fill_C_MSG_PCB_PMD_Info(uint8 *puca_msg_buffer, int16 idx)
{
#ifdef ENABLE_ALL_HDLC_OVHD



   int16 i;

   /* ATU-R shall set the C_MIN_PCB_DS to zero */
   /* ATU-R shall set C_MIN_PCB_US to PCBus */
   /* ATU-R shall set HOOK_STATUS to zero */

   /* Bits 7:6 = C_MIN_PCB_US Bits 5: 0 = C_MIN_PCB_DS */
   puca_msg_buffer[idx++] = guca_RCMsgPCBTab[0] & 0xC0;

   /* Bits 15:14 = reserved 13:12 = HOOK_STATUS 11:8 = C_MIN_PCB_US */
   puca_msg_buffer[idx++] = guca_RCMsgPCBTab[1] & 0xCF;

#ifdef HDLC_LEAVE_TRAIL
   fprintf(fp_HDLCdata, "C_MSG_PCB Info:0x%02x 0x%02x", puca_msg_buffer[idx-2], puca_msg_buffer[idx-1]);
#endif

   for(i = 2; i < gs_C_PCB_Frame_Len; i++)
   {
         puca_msg_buffer[idx++] = guca_RCMsgPCBTab[i];

#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "0x%02x ", puca_msg_buffer[idx-1]);
#endif
   }

#ifdef HDLC_LEAVE_TRAIL
   fprintf(fp_HDLCdata, "\n");
#endif //HDLC_LEAVE_TRAIL



#endif //ENABLE_ALL_HDLC_OVHD

   return(idx);

}


/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : Fill_C_PARAMS_PMD_Info
 *
 *  Description: This subroutine fills the PMD parameter Info from C_PARAMS message
 *          and returns the next avaialable write index
 *
 *  Prototype:
 *   void Fill_C_PARAMS_PMD_Info(uint8 *puca_msg_buffer, int16 idx)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */

int16 Fill_C_PARAMS_Info(uint8 *puca_msg_buffer, int16 idx, uint8 info)
{
#ifdef ENABLE_ALL_HDLC_OVHD

   int16 i, s_LEN_C_PARAMS_PMD_BYTES;

#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "C_PARAMS Info:");
#endif

   if (( gl_SelectedMode & (MODE_G992_5)  ))
      s_LEN_C_PARAMS_PMD_BYTES = LEN_C_PARAMS_PMD_HEADER + 4*gs_TxNumTones - 2;
   else
      s_LEN_C_PARAMS_PMD_BYTES = LEN_C_PARAMS_PMD_HEADER + 3*gs_TxNumTones - 2;

   if (info == C_PARAMS_PMD)
   {
      /* Fill the PMD info based on the received C_PARAMS message */
      for(i= 0; i< s_LEN_C_PARAMS_PMD_BYTES ; i++)
      {
         puca_msg_buffer[idx++] = guca_R_C_PARAMS_bis[i];

#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "0x%02x ", puca_msg_buffer[idx-1]);
#endif
      }
   }
   else if (info == C_PARAMS_PMS_TC)
   {
      /* Fill the PMS-TC info based on the received C_PARAMS message */
      for(i= s_LEN_C_PARAMS_PMD_BYTES; i< ( s_LEN_C_PARAMS_PMD_BYTES + LEN_C_PARAMS_CRC); i++)
      {
         puca_msg_buffer[idx++] = guca_R_C_PARAMS_bis[i];
#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "0x%02x ", puca_msg_buffer[idx-1]);
#endif
      }
   }
#ifdef HDLC_LEAVE_TRAIL
      fprintf(fp_HDLCdata, "\n");
#endif //HDLC_LEAVE_TRAIL

#endif //ENABLE_ALL_HDLC_OVHD
   return(idx);
}




/*^^^
 *------------------------------------------------------------------------------
 *
 *  Name : int16 Fill_MS_MSG_PMS_TC_Info(uint8 *puca_msg_buffer, int16 idx)
 *
 *  Description: This subroutine fills the PMS-TC parameter Info from MS Message
 *          and returns the next avaialable write index
 *
 *  Prototype:
 *   int16 Fill_MS_MSG_PMS_TC_Info(uint8 *puca_msg_buffer, int16 idx)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */

#ifdef ENABLE_ALL_HDLC_OVHD
int16 Fill_MS_MSG_PMS_TC_Info(uint8 *puca_msg_buffer, int16 idx)
{


#ifdef HDLC_LEAVE_TRAIL
         fprintf(fp_HDLCdata, "MS PMS-TC Info:");
#endif

   // According to Table 7_19/G992.3, transmit SI_3A_NPar2 byte that only includes NTR bit
   puca_msg_buffer[idx++] = (gt_BisInfoSave.uc_SI_NPar2 & 0x1) | DELIMIT_2;

   // transmit SI_3A_SPar2 bytes and associated NPar3 bits
   puca_msg_buffer[idx++] = 0x00;   //SPar2 octet1
   puca_msg_buffer[idx++] = gt_BisInfoSave.uc_SI_SPar2[1] | DELIMIT_2;

   /* DS overhead data rate */
   puca_msg_buffer[idx++] = ((uint8)((gt_BisInfoSave.t_Overhead.s_DSMSGOvhdMinRate -1) & 0x3F)) | DELIMIT_2;

   /* US overhead data rate */
   puca_msg_buffer[idx++] = ((uint8)((gt_BisInfoSave.t_Overhead.s_USMSGOvhdMinRate -1) & 0x3F)) | DELIMIT_2 | DELIMIT_1;

#ifdef HDLC_LEAVE_TRAIL
   fprintf(fp_HDLCdata, "0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\n", puca_msg_buffer[idx-5], puca_msg_buffer[idx-4], puca_msg_buffer[idx-3], puca_msg_buffer[idx-2], puca_msg_buffer[idx-1]);
#endif

   return(idx);
}
#endif //ENABLE_ALL_HDLC_OVHD





#undef C_PARAMS_PMD
#undef C_PARAMS_PMS_TC
