/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
*
* Aware BIS Technology. Proprietary and Confidential.
*
* ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:        781.276.4000
* FAX:              781.276.4001
* WEB:              http://www.aware.com
*
* FILE:             tx_ovhd_form_msg_bis.c
* DESCRIPTION:      Functions that form BIS Tx overhead msgs.
*
**********************************************************************/
// ******************************************************************
//  tx_ovhd_form_msg_bis.c
//
// History
//
// 05/08/2010 Nihar : Compute and Report the Impulse Noise protection in 0.1 DMT symbol representation
//       format for erasure decoding ON and OFF.
//       Grep for Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting
//
// 10/01/2012 Shakil/Bhadra: Random link drops seen in ADSL2p mode in a noisy line of DTAG customer house.CPE dropped the link
//             due to near end LOS generated by excessive Downstream CRCs. According to our reboot criterion it
//             requires more than 1000 downstream CRCs to declare LOS from the CPE side but while we supressed
//             the LOS generation (cw test 29 0 0x4) we did not see the issue and the maximum CRC was less
//             than 300. Since we expected more than 1000 CRCs when the LOS was supressed the root cause was in
//             the LOS based on CRC block of the code where we did not increase gsa_good_count_ variable atall which
//             trigerred LOS if CRC is increased by more than 40 in 20 seconds interval. The reason that gsa_good_count
//             did not increased is, it resides in a function called ProcessFramingBytes() which was excluded in the VR9
//             compilation process(executes only ifndef HERCULES_ADSL_CPE). Asa fix this variable was moved to the
//             correct place to be compiled and incremented correctly.
//             Code Grep: XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// 07/01/2013 Ram: Fix added for JIRA 574. Modified 16 bit CRC/FEC counters to 32 bit.
//                 Grep for  XDSLRTFW-574: 16 bit CRC/FEC counters are reported instead of 32bit counters
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 05/3/2013 Vinjam: Report ReTx Actual Delay in milli seconds granularity to the far-end
//           Grep for XDSLRTFW-437:Enh_BisPlus_ALL_ALL_IntlvDelayIn1By100ms
//
// 24/5/2013 Vinjam: Added mapping of "HERC CMV INFO 85" to "Showtime SNR with out Virtual Noise" and the existing
//                   HERC/SOC CMV INFO 85 (INFO_RX_CLEAR_EOC) is moved to HERC/SOC CMV INFO 130
//                   Grep for XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85
// 10/09/2014 Balabath: Modifications in handling of CRC's and FEC counters for API reporting and reporting to DSLAM through OHM
//            Report always running counters to API and control thorugh CMV DSL 22 0 bit#0 for DSLAM Reporting
//            Bit#0 of DSL 22 0 is 1 and will report only per session counters (default)
//            if Bit#0 of DSL 22 0 is reset running counter will be reported.
//            Grep for XDSLRTFW-2003
// ******************************************************************************************************************************************

#include <string.h>
#include "typedef.h"
#include "gdata_bis.h"
#include "fifo.h"
#include "ovhd_bis.h"
#include "tx_ovrhd_bis.h"
#include "gdata.h"
#include "cmv.h"
#include "hs_misc.h"
#include "hndshk_Data.h"
#include "plam.h"
#include "rx_plam.h"
#include "tx_plam.h"
#include "snr.h"
#include "bitload.h"
#include "tx_ops_bis.h"
#include "decimalgain.h"
#include "rx_ovrhd_bis.h"
#include "gdata_bis_diag.h"
#include "diagparam_bis.h"
#include "rx_plam.h"
#include "pll.h"

#ifdef HDLC_LEAVE_TRAIL
extern FILE *fp_HDLCdata;
#endif


//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): Increase QLN points to 512
//extern uint8 guca_QLN[RX_NUM_TONES>>1];
extern uint8 guca_QLN[RX_NUM_TONES];
#define HLOG   0
/*
*------------------------------------------------------------------------------
*
*  Name : int16 InterpPLUSValue(uint16 us_carrier_index)
*
*  Description: This subroutine interpolate the ADSL2+ test parameter Hlog values
*
*     The on-the-fly interpolation for ADSL2+ value because of data memory limitation(for now only 256 tones can be saved)
*
*     1. s_value = OUT_OF_RANGE_value;   if ADSL2+_carrier_index is 0
*     2. s_value = (A+B)/2; if ADSL2+_carrier_index is even number
*     3. s_value = B; if ADSL2+_carrier_index is odd number
*
*   where
*     A = gsa_RxHlogDS[ADSL2+_carrier_index/2 - 1];
*     B = gsa_RxHlogDS[ADSL2+_carrier_index/2];
*  Prototype:
*     uint8 int16 InterpPLUSValue(uint16 us_carrier_index)
*
*  Input Arguments:
*        us_carrier_index: ADSL2+ carrier index
*
*  Output Arguments:
*        s_value: the corresponding interpolated value
*
*  Global Variables Used:
*        gsa_RxHlogDS: DS Hlog value, max size 256 words
*
*------------------------------------------------------------------------
*^^^
*/

int16 InterpPLUSValue(uint16 us_carrier_index, void *pa_Value, uint16 s_OutOfRange, FlagT ft_HlogOrQLN)
{
    int16 s_value, s_ch;
    int16 us_Temp1, us_Temp2;


    s_ch = us_carrier_index/2;
    if (ft_HlogOrQLN == HLOG)
    {
        us_Temp1 = *(((int16*)pa_Value)+s_ch-1);
        us_Temp2 = *((int16*)pa_Value+s_ch);
    }
    else
    {
        us_Temp1 = *(((uint8*)pa_Value)+s_ch-1);
        us_Temp2 = *((uint8*)pa_Value+s_ch);
    }

    if (s_ch*2 == us_carrier_index) //even
    {
        if (us_carrier_index == 0)
        s_value = s_OutOfRange;
        else
        {
            if ((us_Temp1 == s_OutOfRange) || (us_Temp2 == s_OutOfRange))
            s_value = s_OutOfRange;
            else
            s_value = (us_Temp1 + us_Temp2 + 0x1) >> 1;
        }
    }
    else
    s_value = us_Temp2;

    return (s_value);
}



/*^^^
*------------------------------------------------------------------------------
*
*  Name : uint8 Form_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Description: This subroutine forms the transmit EOC message
*
*  Prototype:
*     uint8 Form_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length);
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*
*------------------------------------------------------------------------
*^^^
*/

uint8 Form_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
    /* Initialise with invalid entry */
    uint8 uc_comm_or_resp_bit;
    int16 k;

#ifdef HDLC_LEAVE_TRAIL
    uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif

    k = 2;
    uc_comm_or_resp_bit = 1; /* response code */
    switch(pt_TxOvhdMsgInfo->uc_message_type)
    {


        /* Self test acknowledge only sent by RT */
    case SELF_TEST_ACK:

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (EOC msg)\n", EOC_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Self Test Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);
        fprintf(fp_HDLCdata, "Time to Wait:  0x%02x\n", 0xFE);
#endif
        puca_msg_buffer[k++] = 0xFE; /* Time to wait before requested self test result */
        break;


    case EOC_ACK:
#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (EOC msg)\n", EOC_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (EOC Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif

        break;

    default:
        uc_comm_or_resp_bit = 2;
        break;
    }

    /* Write the tx message length */
    *pus_msg_length = k;

    return(uc_comm_or_resp_bit);
}

/*^^^
*------------------------------------------------------------------------------
*
*  Name : Form_time_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Description:  This subroutine forms the time command to be sent
*
*  Prototype:
*      uint8 Form_time_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/

uint8 Form_time_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
    uint8 uc_comm_or_resp_bit;
    int32 i, j;
    //uint8* puca_timer[3] = {&(gt_Timer.uc_hour), &(gt_Timer.uc_minute), &(gt_Timer.uc_second)};
    uint8* puca_timer[3];
    int32 l_DeciDigit;

#ifdef HDLC_LEAVE_TRAIL
    uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif

    puca_timer[0] = &(gt_Timer.uc_hour);
    puca_timer[1] = &(gt_Timer.uc_minute);
    puca_timer[2] = &(gt_Timer.uc_second);
    uc_comm_or_resp_bit = 1;

    i = 2;
    switch(pt_TxOvhdMsgInfo->uc_message_type)
    {

        /* These commands only sent by RT */

#ifdef HDLC_POLL_TEST
    case TIME_READ:
        uc_comm_or_resp_bit = 0; /* command */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Time msg)\n", TIME_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Read Time)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif

        break;
#endif


    case TIME_READ_ACK:

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Time msg)\n", TIME_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Time Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);
        fprintf(fp_HDLCdata, "Time Read:     ");
#endif

        // change the internal timer value to the 8 octets formatted as HH:MM:SS per ISO8601
        for (j = 0; j < 3; j++)
        {
            // transform integer to ASCII digit
            //MSB first

            #if 0
            puca_msg_buffer[i++] = (*(puca_timer[j]))/10+48;
            puca_msg_buffer[i++] = (*(puca_timer[j])) - (*(puca_timer[j]))/10*10 + 48;
            #else
            l_DeciDigit = (*(puca_timer[j]))/10;
            puca_msg_buffer[i++] = (uint8)(l_DeciDigit + 48);
            puca_msg_buffer[i++] = (uint8)((int32)(*(puca_timer[j])) - l_DeciDigit*10 + 48);
            #endif

            // the last extra (:) will be overwritten as long as we set the msg length correct.
            puca_msg_buffer[i++] = 58; // (:)
        }


#ifdef HDLC_LEAVE_TRAIL
        for (i=0; i < TIME_REG_LENGTH; i++)
        fprintf(fp_HDLCdata, "0x%02x ", puca_msg_buffer[2+i]);

        fprintf(fp_HDLCdata, "\n");
#endif

        break;


    case TIME_ACK:
#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Time msg)\n", TIME_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Time Set Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif

        break;


    default:
        uc_comm_or_resp_bit = 2;
        break;
    }

    /* Write the tx message length */
    *pus_msg_length = (uint16)i;

    return(uc_comm_or_resp_bit);

}


/*^^^
*------------------------------------------------------------------------------
*
*  Name : Form_Inventory_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Description:  This subroutine forms the inventory message to be sent
*
*  Prototype:
*      uint8 Form_Inventory_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/

uint8 Form_Inventory_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
    uint8 uc_comm_or_resp_bit;
    int16 k;

#ifdef HDLC_LEAVE_TRAIL
    int16 i;
    uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif

#ifndef HDLC_LEAVE_TRAIL

    int16 sa_Length[3][3] = {VENDOR_ID_LENGTH, VERSION_NUM_LENGTH, SERIAL_NUM_LENGTH,
        VENDOR_ID_LENGTH, 0, 0,
        SELF_TEST_REG_LENGTH, 0, 0};

    uint8 *puca_Buffer_ToCopyFrom[3][3] = {guca_ne_SystemVendorID, guca_ne_SystemVersionNum, guca_ne_SystemSerialNum,
        guca_ne_SystemVendorID, NULL, NULL,
        gt_TxOvhdRegister.uc_self_test_reg, NULL, NULL};

    uint8 uc_message_type;
    //int16 sa_NumMessages[3] = {3, 1, 1};
    int16 sa_NumMessages[3];
    int16 s_MsgType, s_Length, j;

    sa_NumMessages[0] = 3;
    sa_NumMessages[1] = 1;
    sa_NumMessages[2] = 1;
    uc_message_type = pt_TxOvhdMsgInfo->uc_message_type;

    uc_comm_or_resp_bit = (uc_message_type & 0x80) >> 7; /* command  or response */

    s_MsgType = (uc_message_type & 0xF);

    k=2; // First two bytes are header.

    switch(uc_message_type)
    {
    case IDENT_READ_ACK:
    case AUX_IDENT_READ_ACK:
    case SELF_TEST_RES_READ_ACK:

        for (j = 0; j < sa_NumMessages[s_MsgType-1]; j++)
        {
            s_Length = sa_Length[s_MsgType-1][j];
            memcpy(puca_msg_buffer+k, puca_Buffer_ToCopyFrom[s_MsgType-1][j], s_Length);
            k += s_Length;
        }

        break;

#ifdef HDLC_POLL_TEST
    case IDENT_READ:
    case AUX_IDENT_READ:
        uc_comm_or_resp_bit = 0; /* command */
        break;
#endif
    }

#else
    k=2; // First two bytes are header.
    switch(pt_TxOvhdMsgInfo->uc_message_type)
    {
    case IDENT_READ:
    case AUX_IDENT_READ:
    case SELF_TEST_RES_READ:
    case PMD_CAP_READ:
    case PMS_TC_CAP_READ:
    case TPS_TC_CAP_READ:
        uc_comm_or_resp_bit = 0; /* command */

        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Inventory msg)\n", INVENTORY_CMD_DESIG);

        if (pt_TxOvhdMsgInfo->uc_message_type == IDENT_READ)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Identification Read)\n", pt_TxOvhdMsgInfo->uc_message_type);
        else if (pt_TxOvhdMsgInfo->uc_message_type == AUX_IDENT_READ)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Auxiliary Identification Read)\n", pt_TxOvhdMsgInfo->uc_message_type);
        else if (pt_TxOvhdMsgInfo->uc_message_type == SELF_TEST_RES_READ)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Self Test Result Read)\n", pt_TxOvhdMsgInfo->uc_message_type);
        else if (pt_TxOvhdMsgInfo->uc_message_type == PMD_CAP_READ)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (PMD Capability Read)\n", pt_TxOvhdMsgInfo->uc_message_type);
        else if (pt_TxOvhdMsgInfo->uc_message_type == PMS_TC_CAP_READ)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (PMS-TC_Capability Read)\n", pt_TxOvhdMsgInfo->uc_message_type);
        else if (pt_TxOvhdMsgInfo->uc_message_type == TPS_TC_CAP_READ)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (TPS-TC Capability Read)\n", pt_TxOvhdMsgInfo->uc_message_type);

        break;

    case IDENT_READ_ACK:
        uc_comm_or_resp_bit = 1; /* response */

        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Inventory msg)\n", INVENTORY_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Identification Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);

        fprintf(fp_HDLCdata, "Vendor ID:     ");
        /* Send 8 octets of vendor id */
        for(i = 0; i< VENDOR_ID_LENGTH; i++)
        {
            puca_msg_buffer[k++] = guca_ne_SystemVendorID[i];
            fprintf(fp_HDLCdata, "0x%02x ", guca_ne_SystemVendorID[i]);
        }
        fprintf(fp_HDLCdata, "\n");

        fprintf(fp_HDLCdata, "Version Number:");

        /* Send 16 octets of version number */
        for(i = 0; i< VERSION_NUM_LENGTH; i++)
        {
            puca_msg_buffer[k++] = guca_ne_SystemVersionNum[i];
            fprintf(fp_HDLCdata, "0x%02x ", guca_ne_SystemVersionNum[i]);
        }

        fprintf(fp_HDLCdata, "\n");

        fprintf(fp_HDLCdata, "Serial Number: ");
        /* Send 32 octets of serial number */
        for(i = 0; i< SERIAL_NUM_LENGTH; i++)
        {
            puca_msg_buffer[k++] = guca_ne_SystemSerialNum[i];
            fprintf(fp_HDLCdata, "0x%02x ", guca_ne_SystemSerialNum[i]);
        }

        fprintf(fp_HDLCdata, "\n");


        break;

    case AUX_IDENT_READ_ACK:
        uc_comm_or_resp_bit = 1; /* response */

        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Inventory msg)\n", INVENTORY_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Auxiliary Identification Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);

        fprintf(fp_HDLCdata, "Vendor ID:     ");
        /* Send 8 octets of vendor id */
        for(i = 0; i< VENDOR_ID_LENGTH; i++)
        {
            puca_msg_buffer[k++] = guca_ne_SystemVendorID[i];
            fprintf(fp_HDLCdata, "0x%02x ", guca_ne_SystemVendorID[i]);
        }
        fprintf(fp_HDLCdata, "\n");

        break;

    case SELF_TEST_RES_READ_ACK:
        uc_comm_or_resp_bit = 1; /* response */

        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Inventory msg)\n", INVENTORY_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Self Test Result Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);


        fprintf(fp_HDLCdata, "SelfTestResult:");
        /* Send the self test result */
        for(i = 0; i< SELF_TEST_REG_LENGTH; i++)
        {
            puca_msg_buffer[k++] = gt_TxOvhdRegister.uc_self_test_reg[i];
            fprintf(fp_HDLCdata, "0x%02x ", gt_TxOvhdRegister.uc_self_test_reg[i]);
        }

        fprintf(fp_HDLCdata, "\n");

        break;

    case PMD_CAP_READ_ACK:
        uc_comm_or_resp_bit = 1; /* response */

        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Inventory msg)\n", INVENTORY_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (PMD Capability Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);



        break;

    case PMS_TC_CAP_READ_ACK:
        uc_comm_or_resp_bit = 1; /* response */

        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Inventory msg)\n", INVENTORY_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (PMS-TC Capability Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);

        break;

    case TPS_TC_CAP_READ_ACK:
        uc_comm_or_resp_bit = 1; /* response */

        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Inventory msg)\n", INVENTORY_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (TPS-TC Capability Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);


        break;

    }

#endif
    *pus_msg_length = k;

    return(uc_comm_or_resp_bit);

}


/*^^^
*------------------------------------------------------------------------------
*
*  Name : Form_mgmt_counter_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Description:  This subroutine forms the management counter read message to be sent
*
*  Prototype:
*      uint8 Form_mgmt_counter_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/

// depends on input format, read them as either int16 or int32 and packed them
// in the puca_msg_buffer.
int16 FormMgmtCountBytes(int16 index, void *pv_Counts, uint8* puca_msg_buffer, int32 l_Length, int32 l_LongFormat)
{
    int32 i, j;
    uint32 uc_Temp;

    for(j = 0; j < l_Length; j++)
    {
        /* Send the MSB of the FEC errored seconds counter */
        if (l_LongFormat)  // input is of type long
        {
            uc_Temp = *((uint32 *)pv_Counts)++;
        }
        else // input is of type short
        {
            uc_Temp = *((uint16 *)pv_Counts)++;
        }

        for (i = 24; i >= 0; i = i - 8)
        {
            puca_msg_buffer[index++] = (uint8)((uc_Temp >> i) & 0xFF);
            #ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "0x%02x ", (uint8)((uc_Temp >> i) & 0xFF));
            #endif
        }
        #ifdef HDLC_LEAVE_TRAIL
        fprintf(fp_HDLCdata, "\n");
        #endif
    }
    return (index);

}

uint8 Form_mgmt_counter_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
    //uint8 uc_comm_or_resp_bit = 2, j;
    uint8 uc_comm_or_resp_bit, j;
    int16 i;
    int16 k;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
   uint16 us_NumberOfCounters;
   uint32 ula_TempCounts[10]; //buffer size increased to accomodate new counters as per G.998.4
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

#ifdef HDLC_LEAVE_TRAIL
    uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif

    uc_comm_or_resp_bit = 2;
    k = 2;
    switch(pt_TxOvhdMsgInfo->uc_message_type)
    {
    // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
    case MGMT_CNTR_READ:
        uc_comm_or_resp_bit = 0; /* command */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Management Parameter msg)\n", MGMT_CNTR_RD_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Management Counter Read)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif


        break;
    // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
    case MGMT_CNTR_READ_ACK:
        uc_comm_or_resp_bit = 1; /* response */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Management Parameter msg)\n", MGMT_CNTR_RD_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Management Counter Read Ack)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif


        /* Clear the message buffer */
        memset (&puca_msg_buffer[2], 0, 100);

        if(TESTArray[TEST_Control3] & TEST_SuppressPmsMngmtCntrsToCO)
        {

            k += ((gt_rx_config.s_Nlp<<3)+20); // Suppress errors by skipping these bytes, leaving them all zero.
        }
        else
        {
            /* Send the 32 bit FEC and CRC counter values for all latency paths : MSB first */
            /******************************/
            /* Send the FEC counter value */
            /******************************/

#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "FEC of LP:   ");
#endif
            //XDSLRTFW-2003 (start)
            for(j=0; j < gt_rx_config.s_Nlp; j++)
            {
               ula_TempCounts[j] = gula_CorrectedRSErrors[j];
               if((gt_InteropOptions.us_InterOp_Bits0 & RESET_CRC_FEC_COUNTERS_AT_LINKSTART_TO_0_FOR_EOC_REPORTING) == 0)
               {
                  ula_TempCounts[j] += gula_CorrectedRSErrors_Prev[j];
               }

            }
            // XDSLRTFW-574: 16 bit CRC/FEC counters are reported instead of 32bit counters (Start)
            //k = FormMgmtShortCountBytes(k, gsa_CorrectedRSErrors, puca_msg_buffer, gt_rx_config.s_Nlp);
            k = FormMgmtCountBytes(k, ula_TempCounts, puca_msg_buffer, gt_rx_config.s_Nlp, 1);
            // XDSLRTFW-574: 16 bit CRC/FEC counters are reported instead of 32bit counters (End)
            //XDSLRTFW-2003 (end)

            /******************************/
            /* Send the CRC counter value */
            /******************************/
#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "CRC of LP:   ");
#endif

            //XDSLRTFW-2003 (start)
            //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
            //k = FormMgmtShortCountBytes(k, gusa_CRC_count, puca_msg_buffer, gt_rx_config.s_Nlp);
            // XDSLRTFW-574: 16 bit CRC/FEC counters are reported instead of 32bit counters (Start)
            ula_TempCounts[0] = (uint32) gula_CRC_count[0]; //LP0

            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
            if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
               ula_TempCounts[1] = gul_CRC_count_ReTx;
            else
               ula_TempCounts[1] = (uint32) gula_CRC_count[1]; //LP1
            // XDSLRTFW-574: 16 bit CRC/FEC counters are reported instead of 32bit counters (End)
            if((gt_InteropOptions.us_InterOp_Bits0 & RESET_CRC_FEC_COUNTERS_AT_LINKSTART_TO_0_FOR_EOC_REPORTING) == 0)
            {
               ula_TempCounts[0] += gula_CRC_count_Prev[0];
               ula_TempCounts[1] += gula_CRC_count_Prev[1];
            }
            //XDSLRTFW-2003 (end)
            k = FormMgmtCountBytes(k, ula_TempCounts, puca_msg_buffer, gt_rx_config.s_Nlp, 1);
            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
            //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (End)

#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "FEC Error Sec, ");
            fprintf(fp_HDLCdata, "Error Sec Cnt, ");
            fprintf(fp_HDLCdata, "SeverelyErrSec,");
            fprintf(fp_HDLCdata, "LOS Error Sec, ");
            fprintf(fp_HDLCdata, "Unavail_ErrSec.");
#endif
            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
            if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
            {
               us_NumberOfCounters = 10;
               ula_TempCounts[0] = gul_RxDtuCorrectedCNT;
               ula_TempCounts[1] = gul_RxReTxDtuUncorrectedCNT;
               ula_TempCounts[2] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_FECSecCnt; // XDSLRTFW-1562
               ula_TempCounts[3] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_ESCnt;  // XDSLRTFW-1562
               ula_TempCounts[4] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_SESCnt;  // XDSLRTFW-1562
               ula_TempCounts[5] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_LOSSCnt; // XDSLRTFW-1562
               ula_TempCounts[6] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt; // XDSLRTFW-1562
               ula_TempCounts[7] = gul_LEFTR_Defect_sec_cnt;
               ula_TempCounts[8] = gul_error_free_bit_cnt;
               ula_TempCounts[9] = gul_RETX_EFTR_min;
//FEATURE_DS_BisPlus_ALL_ReTx_CMV_for_EFTR_Min Begin
               gt_ReTxConfigInfo.us_EFTR_Min = (uint16)gul_RETX_EFTR_min;
//FEATURE_DS_BisPlus_ALL_ReTx_CMV_for_EFTR_Min End
//EFTR_Min_issue Begin
//Reset gul_RETX_EFTR_min & gul_prev_EFTR to max vaue( which is ndr) in order
// to find min value between two succesive mgmt counter read responses
               gul_RETX_EFTR_min = (gt_ReTxConfigInfo.us_ndr); //1kbits/sec
               gul_prev_EFTR = gul_RETX_EFTR_min;
//EFTR_Min_issue End
            }
            else
            {
               us_NumberOfCounters = 5;
               ula_TempCounts[0] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_FECSecCnt; // XDSLRTFW-1562
               ula_TempCounts[1] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_ESCnt; // XDSLRTFW-1562
               ula_TempCounts[2] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_SESCnt; // XDSLRTFW-1562
               ula_TempCounts[3] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_LOSSCnt; // XDSLRTFW-1562
               ula_TempCounts[4] = gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt; // XDSLRTFW-1562
            }
            k = FormMgmtCountBytes(k, ula_TempCounts, puca_msg_buffer, us_NumberOfCounters , 1);
            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
        }

        if(TESTArray[TEST_Control3] & TEST_SuppressTpsMngmtCntrsToCO)
        {
            k+= gt_rx_config.s_Nbc<<4; // Suppress errors by skipping these bytes, leaving them all zero.
        }
        else
        {
            for (i = 0; i< gt_rx_config.s_Nbc; i++)
            {

                //Check if this bearer channel is mapped to any latency path or not
                j = guca_rxBCnToLPp[i];
                if (j == 0xF)
                continue;

                #ifdef HDLC_LEAVE_TRAIL
                /***********************************/
                /* Send HEC anomaly counter value  */
                /***********************************/
                fprintf(fp_HDLCdata, "HECError BC#%d, ", i);

                /******************************/
                /* Send total HEC cell count  */
                /******************************/
                fprintf(fp_HDLCdata, "HEC Cnt BC#%d,  ", i);

                /******************************/
                /* Send total user cell count  */
                /******************************/
                fprintf(fp_HDLCdata, "Tot Cnt BC#%d,  ", i);

                /******************************/
                /* Send counters of the total bit errors detected in ATM idle cells payload  */
                /******************************/
                fprintf(fp_HDLCdata, "BER Cnt BC#%d.\n", i);
                #endif
                ula_TempCounts[0] = gula_hec_error_cnt[i];
                ula_TempCounts[1] = gula_tot_hec_cnt[i];
                ula_TempCounts[2] = gula_tot_cell_cnt[i];
                ula_TempCounts[3] = gula_bit_error_cnt[i];
                k = FormMgmtCountBytes(k, ula_TempCounts, puca_msg_buffer, 4, 1);
            }

        }

        break;
    }

    *pus_msg_length = k;
    return(uc_comm_or_resp_bit);

}


/*^^^
*------------------------------------------------------------------------------
*
*  Name : Form_nsf_facility_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, uint8 uc_message_type)
*
*  Description:  This subroutine forms the management counter read message to be sent
*
*  Prototype:
*      uint8 Form_nsf_facility_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, uint8 uc_message_type)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/

uint8 Form_nsf_facility_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, uint8 uc_message_type)
{
    uint8 uc_comm_or_resp_bit;

#ifdef HDLC_LEAVE_TRAIL
    uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif

    uc_comm_or_resp_bit = 2;
    switch(uc_message_type)
    {
#ifdef HDLC_POLL_TEST
    case NSF:
        uc_comm_or_resp_bit = 0; /* command */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        if (puca_msg_buffer[0] == NSF_FACILITY_CMD_DESIG)
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (NSF msg)\n", puca_msg_buffer[0]);
        else if (puca_msg_buffer[0] == NSF_FACILITY_LOW_CMD_DESIG)
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (NSF Low Priority msg)\n", puca_msg_buffer[0]);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (NSF msg)\n", uc_message_type);
#endif

        *pus_msg_length = 0x8;

        break;
#endif //#ifdef ENABLE_ALL_HDLC_OVHD

    case NSF_ACK:
    case NSF_NEG_ACK:
        uc_comm_or_resp_bit = 1; /* response */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        if (puca_msg_buffer[0] == NSF_FACILITY_CMD_DESIG)
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (NSF msg)\n", puca_msg_buffer[0]);
        else if (puca_msg_buffer[0] == NSF_FACILITY_LOW_CMD_DESIG)
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (NSF Low Priority msg)\n", puca_msg_buffer[0]);

        if (uc_message_type == NSF_ACK)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (NSF Ack msg)\n", uc_message_type);
        else if (uc_message_type == NSF_NEG_ACK)
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (NSF NAck msg)\n", uc_message_type);

#endif
        *pus_msg_length = 0x2;

        break;


    }

    return(uc_comm_or_resp_bit);

}

/*^^^
*------------------------------------------------------------------------------
*
*  Name : Form_test_param_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Description:  This subroutine forms the management counter read message to be sent
*
*  Prototype:
*      uint8 Form_test_param_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/
uint8 Form_test_param_read_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length, TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
    uint8 uc_comm_or_resp_bit;
    uint8 uc_MessageType;
    uint8 uc_TestParameterId;
    uint8 *puca_temp;
    int16 s_value;
    int16 s_startTone, s_endTone, s_numTones;
    int16 temp, i,s_Margin;
    int32 l_PlusMode;
    uint16 us_ComputedINP, j, k;
    int16 s_ErasureGains[7] = {0x0100, 0x0180, 0x019A, 0x01B3, 0x01CD, 0x01E6, 0x0200};

#ifdef HDLC_LEAVE_TRAIL
    uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif

    l_PlusMode = 0;        // default to BIS mode
    if (( gl_SelectedMode & (MODE_G992_5)  ))
    {
        l_PlusMode = 1;
    }
    uc_comm_or_resp_bit = 2;
    k = 2;

    uc_TestParameterId = pt_TxOvhdMsgInfo->uc_TestParameterId;
    uc_MessageType = pt_TxOvhdMsgInfo->uc_message_type;

    switch(uc_MessageType)
    {
#ifdef HDLC_POLL_TEST //We don't intend to retrieve TEST parameter during showtime, this will save us showtime memory
        case SINGLE_READ:
            /* Send single read request to far-end */
            uc_comm_or_resp_bit = 0;/* command code */
#ifdef HDLC_LEAVE_TRAIL
            /* Toggle the LSB for every new message sent */
            uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
            uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

            uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

            fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
            if (!uc_comm_or_resp_bit)
            {
                fprintf(fp_HDLCdata, "(Command)\n");
            }
            else
            {
                fprintf(fp_HDLCdata, "(Response)\n");
            }
            //Designator byte
            fprintf(fp_HDLCdata, "Designator:    0x%02x  (PMD Test Parameter msg)\n", puca_msg_buffer[0] );
            fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Single Read)\n", uc_MessageType);
#endif
            /* Set message length based on last index used here in puca_msg_buffer) */
            puca_msg_buffer[k++] = uc_TestParameterId;
            break;
#endif

        // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (START)
        case MULT_READ:
            uc_comm_or_resp_bit = 0;/* command code */
#ifdef HDLC_LEAVE_TRAIL
            /* Toggle the LSB for every new message sent */
            uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
            uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

            uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

            fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
            if (!uc_comm_or_resp_bit)
            {
                fprintf(fp_HDLCdata, "(Command)\n");
            }
            else
            {
                fprintf(fp_HDLCdata, "(Response)\n");
            }
            //Designator byte
            fprintf(fp_HDLCdata, "Designator:    0x%02x  (PMD Test Parameter msg)\n", puca_msg_buffer[0] );
            fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Multiple Read)\n", uc_MessageType);
#endif
            /* Set message length based on last index used here in puca_msg_buffer) */
            puca_msg_buffer[k++] = (uint8)pt_TxOvhdMsgInfo->us_param_rd_carrier_index;
            break;

    case PLUS_MULT_READ:
            uc_comm_or_resp_bit = 0;/* command code */
#ifdef HDLC_LEAVE_TRAIL
            /* Toggle the LSB for every new message sent */
            uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
            uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

            uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

            fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
            if (!uc_comm_or_resp_bit)
            {
                fprintf(fp_HDLCdata, "(Command)\n");
            }
            else
            {
                fprintf(fp_HDLCdata, "(Response)\n");
            }
            //Designator byte
            fprintf(fp_HDLCdata, "Designator:    0x%02x  (PMD Test Parameter msg)\n", puca_msg_buffer[0] );
            //fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Multiple Read)\n", uc_MessageType);
#endif
            // Unfortunately, standard doesnt specify unique message types between
            // bis/plus modes. PLUS_MULT_READ and BIS_BLOCK_READ both have a value 4
            if (l_PlusMode)
            {
                puca_msg_buffer[k++] = (uint8)((pt_TxOvhdMsgInfo->us_param_rd_carrier_index >>8) & 0xFF);
                puca_msg_buffer[k++] = (uint8)(pt_TxOvhdMsgInfo->us_param_rd_carrier_index & 0xFF);
            }
            else
            {
                puca_msg_buffer[k++] = (uint8)pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index;
                puca_msg_buffer[k++] = (uint8)pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index;
            }
            break;

        case NEXT_MULT_READ:
            uc_comm_or_resp_bit = 0;/* command code */
#ifdef HDLC_LEAVE_TRAIL
            /* Toggle the LSB for every new message sent */
            uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
            uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

            uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

            fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
            if (!uc_comm_or_resp_bit)
            {
                fprintf(fp_HDLCdata, "(Command)\n");
            }
            else
            {
                fprintf(fp_HDLCdata, "(Response)\n");
            }
            //Designator byte
            fprintf(fp_HDLCdata, "Designator:    0x%02x  (PMD Test Parameter msg)\n", puca_msg_buffer[0] );
            fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Next Multiple Read)\n", uc_MessageType);
#endif
            break;

        case PLUS_BLOCK_READ:
            uc_comm_or_resp_bit = 0;/* command code */
#ifdef HDLC_LEAVE_TRAIL
            /* Toggle the LSB for every new message sent */
            uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
            uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

            uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

            fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
            if (!uc_comm_or_resp_bit)
            {
                fprintf(fp_HDLCdata, "(Command)\n");
            }
            else
            {
                fprintf(fp_HDLCdata, "(Response)\n");
            }
            //Designator byte
            fprintf(fp_HDLCdata, "Designator:    0x%02x  (PMD Test Parameter msg)\n", puca_msg_buffer[0] );
            //fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Multiple Read)\n", uc_MessageType);
#endif
            puca_msg_buffer[k++] = (uint8)((pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index >>8) & 0xFF);
            puca_msg_buffer[k++] = (uint8)(pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index & 0xFF);
            puca_msg_buffer[k++] = (uint8)((pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index >>8) & 0xFF);
            puca_msg_buffer[k++] = (uint8)(pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index & 0xFF);
            break;

        // XDSLRTFW-213_Feature_AB_ALL_ALL_FE_CounterRead (END)
        case SINGLE_READ_ACK:
        case MULT_READ_ACK:
        case BLOCK_READ_ACK:
            uc_comm_or_resp_bit = 1;/* response code */
#ifdef HDLC_LEAVE_TRAIL
            /* Toggle the LSB for every new message sent */
            uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
            uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

            uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

            fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
            if (!uc_comm_or_resp_bit)
            {
                fprintf(fp_HDLCdata, "(Command)\n");
            }
            else
            {
                fprintf(fp_HDLCdata, "(Response)\n");
            }
            //Designator byte
            fprintf(fp_HDLCdata, "Designator:    0x%02x  (PMD Test Parameter msg)\n", puca_msg_buffer[0] );
            if (uc_MessageType == SINGLE_READ_ACK)
            {
                fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Single Read Ack)\n", uc_MessageType);
            }
            else if (uc_MessageType == MULT_READ_ACK)
            {
                fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Multiple Read Ack)\n", uc_MessageType);
            }
            else if (uc_MessageType == BLOCK_READ_ACK)
            {
                fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Block Read Ack)\n", uc_MessageType);
            }
#endif
        /* Single Read Ack */
        if (uc_MessageType == SINGLE_READ_ACK)
        {
            s_startTone = 0;
            s_endTone = gs_RxNumTones-1;

            if (gsa_RTXmit_OvhdMsgSegIndx[2] == -1)
            {
                // not in the middle of segmentations for this message type
                if (uc_TestParameterId == CHANNEL_TRANSFER_FUNCTION)
                {
                    if (s_endTone > 255)
                    {
                        gsa_RTXmit_OvhdMsgSegIndx[2] = 1;
                        gfta_FirstOvhdMsgSeg[2] = TRUE;
                        s_endTone = 255;
                    }
                }
            }
            else
            {
                // must be segmented Hlog.
                // Recall that test parameter ID is no longer available in
                // the segmented ACK message(s) from CO.
                uc_TestParameterId = CHANNEL_TRANSFER_FUNCTION;
                gsa_RTXmit_OvhdMsgSegIndx[2] = 0;
                s_startTone = 256;
            }
        }
        /* Multiple Read Ack */
        else if (uc_MessageType == MULT_READ_ACK)
        {
            s_startTone = pt_TxOvhdMsgInfo->us_param_rd_carrier_index;
            s_endTone = pt_TxOvhdMsgInfo->us_param_rd_carrier_index;
        }
        /* Block Read Ack */
        else
        {
            s_startTone = pt_TxOvhdMsgInfo->us_param_rd_start_carrier_index;
            s_endTone = pt_TxOvhdMsgInfo->us_param_rd_stop_carrier_index;
        }

        s_numTones = (s_endTone - s_startTone + 1);

        //** form Hlog data if it's a Hlog request or if it's a multi/block read.
        if (uc_MessageType != SINGLE_READ_ACK ||            /* implies multiple read or block read */
                uc_TestParameterId == CHANNEL_TRANSFER_FUNCTION)  /* implies single read */
        {
            //Hlog(f) measurement period will not be formed for the 2nd segmented hlog response.
            if (!((uc_TestParameterId == CHANNEL_TRANSFER_FUNCTION) && (s_startTone > 0)))
            {
                puca_msg_buffer[k++] = (uint8)(gt_DS_MeasurementPeriod.us_Hlogf_measurement_period >>8);
                puca_msg_buffer[k++] = (uint8)(gt_DS_MeasurementPeriod.us_Hlogf_measurement_period & 0xFF);
#ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "Hlog MeasurementPer:%d\n", ((uint16)puca_msg_buffer[k-2]<<8) | puca_msg_buffer[k-1]);
#endif
            }

            //Hlog(f) content
            //memcpy((puca_msg_buffer+k), gsa_RxHlogDS, 2*s_numTones);
            //Shouldnt use memcpy becos standard requires we send MSB first
#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "Hlog(f) for tone range [%d,%d]:\n ",s_startTone, s_endTone);
#endif

            for (i = s_startTone; i <= s_endTone; i++)
            {
                if (l_PlusMode)
                s_value = InterpPLUSValue(i, gsa_RxHlogDS, (uint16)OUT_OF_RANGE_HLOG, 0);
                else
                s_value = gsa_RxHlogDS[i];
                s_value -=gs_HLogReportDelta; //XDSLRTFW-4022 Hlog REPORTING calibration in ADSL


               // XDSLRTFW-3974 Wrong of Hlog reporting
               // By default report special value for tones with low Medley SNR, since we can't measure reliably HLOG on these tones.
               if (!(gt_DS_LDParam.us_HlogFlags & DISABLE_BLACKOUT_HLOG_OF_TONES_WITH_LOW_SNR))
               {
                  // We can't measure HLOG on tones with negative margin precisely enough -> black them out with special value
                  // US tones have a MedleySnr value of 0, so we black-out here also HLOG values where the Medley Snr is 0
                  if ( (gsa_MedleySnrBuf[i] <= 0) &&
                        (i != gs_PilotToneIdx)   ) // Avoid blacking out pilot tone
                  {
                        s_value = OUT_OF_RANGE_HLOG;
                  }
               }

                puca_msg_buffer[k++] = (uint8)(s_value >>8);
                puca_msg_buffer[k++] = (uint8)(s_value & 0xFF);

#ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "%d ", ((uint16)puca_msg_buffer[k-2]<<8) | puca_msg_buffer[k-1]);
#endif
            }
#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "\n ");
#endif
        }
        // end of Hlog(f) data

        if (uc_MessageType != SINGLE_READ_ACK ||   /* implies multiple read or block read */
                uc_TestParameterId == QUIET_LINE_NOISE_PSD) /* implies single read */
        {
            //QLN measurement period
            puca_msg_buffer[k++] = (uint8)(gt_DS_MeasurementPeriod.us_QLN_measurement_period >>8);
            puca_msg_buffer[k++] = (uint8)(gt_DS_MeasurementPeriod.us_QLN_measurement_period & 0xFF);
#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "QLN MeasurementPer:%d\n", ((uint16)puca_msg_buffer[k-2]<<8) | puca_msg_buffer[k-1]);
#endif

#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "QLN(f) for tone range [%d,%d]:\n ",s_startTone, s_endTone);
#endif

            //QLN content
            //QLN content
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start_End): interpolate for PLUS only if 512pt QLN is disabled
            if ((l_PlusMode)&& (!(STATArray[STAT_QLN_Performance] & STAT_512Bin_QLN_ON)))
            {
                /* In PLUS interpolate guca_QLN. */
                for (i = s_startTone; i <= s_endTone; i++)
                puca_msg_buffer[k++] = (uint8)InterpPLUSValue(i, guca_QLN, (uint16)OUT_OF_RANGE_QUIETLINE_PSD, 1);
            }
            else
            {
                /* In BIS send guca_QLN. */
                memcpy((puca_msg_buffer+k), &guca_QLN[s_startTone], s_numTones);
                k+=s_numTones;
            }

#ifdef HDLC_LEAVE_TRAIL
            for (i = 0; i < s_numTones; i++)
            fprintf(fp_HDLCdata, "%d ", (uint8)puca_msg_buffer[k-s_numTones+i]);
            fprintf(fp_HDLCdata, "\n");
#endif
        }

        if (uc_MessageType != SINGLE_READ_ACK ||   /* implies multiple read or block read */
                uc_TestParameterId == SNR)   /* implies single read */
        {
            int16 *psa_RxSnrBuf_ovhd;
         uint8 uc_SNR_ReportedValue;

            /* Send the SNR per subcarrier */
            /* Send the MSB first */
            puca_msg_buffer[k++] = (uint8)(gt_DS_MeasurementPeriod.us_snr_measurement_period >> 8);

            /* Send the LSB next */
            puca_msg_buffer[k++] = (uint8)(gt_DS_MeasurementPeriod.us_snr_measurement_period & 0xFF);

#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "SNR MeasurementPer:%d\n", ((uint16)puca_msg_buffer[k-2]<<8) | puca_msg_buffer[k-1]);
#endif

#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "SNR(f) for tone range [%d,%d]:\n ",s_startTone, s_endTone);
#endif

            if(TESTArray[TEST_Control3] & TEST_SuppressPmdTestParamsToCO)
            psa_RxSnrBuf_ovhd = gsa_MedleySnrBuf;
            else
            psa_RxSnrBuf_ovhd = gpsa_RxSnrBuf_ovhd;

            for(i = s_startTone; i <= s_endTone; i++)
            {
                /* Convert SNR array in dB (Q8.8) to proper reperesentation of Test parameter format*/
                //snr(i)=round[2*(32+SNR_dB(i))], Range for SNR_dB is [-32dB, 95dB],
                //snr(i) range is [0, 254], 255 is special value, meaning out of range
                if (i < gs_RxFirstChannel || i > gs_RxLastChannel
                        || psa_RxSnrBuf_ovhd[i] < LOWEST_SNR_VALUE || psa_RxSnrBuf_ovhd[i] > HIGHEST_SNR_VALUE)
            {
               puca_msg_buffer[k++] = OUT_OF_RANGE_SNR;
               //XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85 (Start_End)
               guca_SNRBuf_NE[i] = OUT_OF_RANGE_SNR;
            }
                else
            {
               //XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85 (Start)
                  uc_SNR_ReportedValue = (int8)(((psa_RxSnrBuf_ovhd[i] + (32<<8)) + (1<<6))>> 7)&0xFF;
               puca_msg_buffer[k++]= uc_SNR_ReportedValue;
               guca_SNRBuf_NE[i] = uc_SNR_ReportedValue;
               //XDSLRTFW-965 Task_DS_BisPlus_All_AttachHercCMVINFO85 (End)
            }
#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "0x%02x ", (uint8)puca_msg_buffer[k-1]);

#endif
            }

#ifdef HDLC_LEAVE_TRAIL
            fprintf(fp_HDLCdata, "\n");
#endif
        }

        if (uc_MessageType == SINGLE_READ_ACK)
        {
            switch(uc_TestParameterId)
            {
            case LINE_ATTENUATION:

                /* Send the MSB first */
                puca_msg_buffer[k++] = guc_LoopAtten_MSB;

                /* Send the LSB next */
                puca_msg_buffer[k++] = guc_LoopAtten_LSB;

                #ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "LATN:          %d (=10*Actual LATN) \n", ((uint16)puca_msg_buffer[k-2]<<8) | puca_msg_buffer[k-1]);
                #endif
                break;

            case SIGNAL_ATTENUATION:

                /* Send the MSB first */
                puca_msg_buffer[k++] = guc_SigAtten_MSB;

                /* Send the LSB next */
                puca_msg_buffer[k++] = guc_SigAtten_LSB;

                #ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "SATN:          %d (=10*Actual SATN) \n", ((uint16)puca_msg_buffer[k-2]<<8) | puca_msg_buffer[k-1]);
                #endif
                break;

            case SIGNAL_TO_NOISE_MARGIN:

                s_Margin = gs_RxSNRM_ovhd;

                if(TESTArray[TEST_Control3] & TEST_SuppressPmdTestParamsToCO)
                s_Margin = gs_RxDesiredMargin;

                temp = FormSNRM(s_Margin);



                /* Send the MSB first */
                puca_msg_buffer[k++] = (uint8)((temp >> 8) & 0x3);

                /* Send the LSB next */
                puca_msg_buffer[k++] = (uint8)(temp & 0xFF);

                #ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "SNR Margin:          %d (=10*Actual SNRM) \n", ((uint16)puca_msg_buffer[k-2]<<8) | puca_msg_buffer[k-1]);
                #endif
                break;

            case ATTAIN_NET_DATA_RATE:
                puca_temp = ((uint8*)(void *)&gt_NearEndParam.ul_AttainableDataRate)+3;

                if(TESTArray[TEST_Control3] & TEST_SuppressPmdTestParamsToCO)
                puca_temp = ((uint8*)(void *)&gl_ATTNDRds_Initial)+3;

                puca_msg_buffer[k++] = *puca_temp--;
                puca_msg_buffer[k++] = *puca_temp--;
                puca_msg_buffer[k++] = *puca_temp--;
                puca_msg_buffer[k++] = *puca_temp--;

                #ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "Attain NDR:%ld\n", (((uint16)puca_msg_buffer[k-4]<<24)
                | (puca_msg_buffer[k-3]<<16)
                | (puca_msg_buffer[k-2]<<8)
                | (puca_msg_buffer[k-1])));
                #endif

                break;

            case NE_ACTUAL_TRANSMIT_POWER:

                /* Send the MSB first */
                puca_msg_buffer[k++] = (gt_FarEndParam.s_ActualAggregateXmtPwr >> 8) & 0xFF;

                /* Send the LSB next */
                puca_msg_buffer[k++] = (gt_FarEndParam.s_ActualAggregateXmtPwr & 0xFF);

                #ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "NE ACTATP:     0x00 0x00 (=10*Actual NE ACTATP)\n");
                #endif
                break;

            case FE_ACTUAL_TRANSMIT_POWER:

                /* Send the MSB first */
                puca_msg_buffer[k++] = (gt_NearEndParam.s_ActualAggregateXmtPwr >> 8) & 0xFF;

                /* Send the LSB next */
                puca_msg_buffer[k++] = gt_NearEndParam.s_ActualAggregateXmtPwr & 0xFF;

                #ifdef HDLC_LEAVE_TRAIL
                fprintf(fp_HDLCdata, "FE ACTATP:          %d (=10*Actual ACTATP) \n", ((uint16)puca_msg_buffer[k-2]<<8) | puca_msg_buffer[k-1]);
                #endif

                break;
                // SMS00847294:Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting ( Start)
            case FE_ACTUAL_INP_ACT:
               if (gs_DSL_EDcontrol & DSL_Enable_ERASUREDECODING_REPORTING)
               {

                  //Assumption: Firmware supports one latency & one bearer channel only.
                  //code is written under this assumption.
                  //code is not tested nfor dual latency & dual bearer.
                  for (j = 0; j < gt_rx_config.s_Nbc; j++)
                  {
                     i = guca_rxBCnToLPp[j];
                     //SMS00855449 CR_DS_ALL_ALL_MoveErasureDecoderControlsToDSLgroup (Start_End)
                     //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
                     /*INPp = INP_no_erasurep.*/
                     /*4* Rp * Dp / Lp*/
                     /* Use the Reporting representation format (in terms of 0.1 DMT symbol)*/
                     us_ComputedINP = (40 * (gt_rx_config.s_Dp[i] ) * (gt_rx_config.s_Rp[i]))/gt_rx_config.s_Lp[i];
                     if(us_ComputedINP > 0x00FE)  //capping as per the standard
                        us_ComputedINP = 0x00FF;
                     // XDSLRTFW-1502 (start)
                      //if ((gt_ErasureDecoding_Reprt.ft_INP_no_erasure_not_reqd == TRUE) && ((gs_DSL_EDcontrol & (ERASURE_DECODING_ENABLE| ERASURE_MAX_INP)) == (ERASURE_DECODING_ENABLE|ERASURE_MAX_INP)))
                      if((gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE) &&
                           (gt_ErasureDecoding_Reprt.ft_Report_ED == TRUE)
                         )
                       {
#if 0
                           //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start)
                           //As per VR9 bitloading algorithm
                           //Effective INP with erasure decoding (ActINPerasure) = 8* Rp * Dp / Lp;
                           /*INP = 8* (Rp) * Dp / Lp */
                           /* Use the Reporting representation format (in terms of 0.1 DMT symbol)*/
                           //us_ComputedINP = (80 * (gt_rx_config.s_Dp[i] ) * (gt_rx_config.s_Rp[i]))/gt_rx_config.s_Lp[i];
                           us_ComputedINP <<= 1; // erasure gain of 2
#else
                           int16 s_idx;
                           s_idx = TESTArray[Test_ErasureGains];
                           us_ComputedINP   = (us_ComputedINP *s_ErasureGains[s_idx]+0x80)>>8;
#endif
                           if(us_ComputedINP > 0x00FE) //capping as per the standard
                              us_ComputedINP = 0x00FF;
                           /* INP != INP_no_erasure*/
                           puca_msg_buffer[k++] = us_ComputedINP;
                           gt_ErasureDecoding_Reprt.uc_showtime_INP_w_EDR[i] = (uint8 ) us_ComputedINP;
                           //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (End)
                        }
                        else
                        {
                           puca_msg_buffer[k++] = us_ComputedINP;
                           gt_ErasureDecoding_Reprt.uc_showtime_INP_wo_EDR[i] = (uint8 ) us_ComputedINP;
                        }
                     }

                     /*Indicates bearer channel is disabled */
                     for (j = gt_rx_config.s_Nbc; j < 4; j++)
                     {
                        puca_msg_buffer[k++] = 0xFF;
                     }
                  }
                  //XDSLRTFW-1502 (end)
                break;
                // SMS00847294:Feature_AB_ALL_BisPlus_ALL_ErasureDecodingReporting ( End)
            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
            case RETX_ETR:
                gul_ReTx_ETR = ((uint32) gt_ReTxConfigInfo.us_etr);
                puca_temp = ((uint8 *)(void *)&gul_ReTx_ETR) + 3;
                puca_msg_buffer[k++] = *puca_temp--;
                puca_msg_buffer[k++] = *puca_temp--;
                puca_msg_buffer[k++] = *puca_temp--;
                puca_msg_buffer[k++] = *puca_temp--;

                break;

            case RETX_DELAY_ACT:
            //Old code from ARx Firmware
                //puca_msg_buffer[k++] = (uint8) (guc_delay_act_RETX & 0xFF);

            //XDSLRTFW-437:Enh_BisPlus_ALL_ALL_IntlvDelayIn1By100ms (Start_End)
            //Report Delay in milli seconds granularity to the far-end
                puca_msg_buffer[k++] = (uint8)(gt_ReTXStats.us_ReTX_ReceiverActualDelay/100);
                break;
            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
            }
        }

        if (k == 2)
        {
            // protect sending msg which doesn't have valid test parameter ID
            uc_comm_or_resp_bit = 2;
        }

        break;

    case PMD_TEST_PAR_READ_NACK:
        uc_comm_or_resp_bit = 1;/* response code */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (PMD Test Parameter msg)\n", puca_msg_buffer[0] );
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (PMD Test Parameter Read NACK)\n", uc_MessageType);
#endif

        break;


    }


    *pus_msg_length = k;
    return(uc_comm_or_resp_bit);

}

/*^^^
*------------------------------------------------------------------------------
*
*  Name : Form_Clear_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Description:  This subroutine forms the management counter read message to be sent
*
*  Prototype:
*      uint8 Form_Clear_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Global Variables Used:
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/

uint8 Form_Clear_EOC_msg(uint8 *puca_msg_buffer, uint16 *pus_msg_length,
TxOvhdMsgInfoStruct_t *pt_TxOvhdMsgInfo)
{
    //uint8 uc_comm_or_resp_bit = 2;
    uint8 uc_comm_or_resp_bit, k;
#ifdef ENABLE_ALL_HDLC_OVHD
    int16 i;
#endif

#ifdef HDLC_LEAVE_TRAIL
    uint8 uc_new_or_old_bit, uc_ctrl_field;
#endif

    uc_comm_or_resp_bit = 2;
    k = 2;
    switch(pt_TxOvhdMsgInfo->uc_message_type)
    {
#ifdef ENABLE_ALL_HDLC_OVHD
    case CLEAR_EOC_MSG:
        uc_comm_or_resp_bit = 0;/* command code */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Clear EOC msg)\n", CLEAR_EOC_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Clear EOC msg)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif


        for (i = 0; i <= CLEAR_EOC_DATA_SIZE; i++)
        puca_msg_buffer[k++] = guca_tx_clear_eoc_buff[i];

        break;
#endif //ENABLE_ALL_HDLC_OVHD

    case CLEAR_EOC_ACK:
        uc_comm_or_resp_bit = 1;/* response code */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Clear EOC msg)\n", CLEAR_EOC_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Clear EOC Ack msg)\n", pt_TxOvhdMsgInfo->uc_message_type);
#endif

        break;

    case CLEAR_EOC_NACK:
        uc_comm_or_resp_bit = 1;/* response code */

#ifdef HDLC_LEAVE_TRAIL
        /* Toggle the LSB for every new message sent */
        uc_new_or_old_bit = gt_TxHDLCMsg.cntrl_field & 0x1;
        uc_new_or_old_bit = (~uc_new_or_old_bit) & 0x1;

        uc_ctrl_field = (uc_comm_or_resp_bit << 1) |uc_new_or_old_bit;

        fprintf(fp_HDLCdata, "Control Field: 0x%02x  ", uc_ctrl_field);
        if (!uc_comm_or_resp_bit)
        fprintf(fp_HDLCdata, "(Command)\n");
        else
        fprintf(fp_HDLCdata, "(Response)\n");

        //Designator byte
        fprintf(fp_HDLCdata, "Designator:    0x%02x  (Clear EOC msg)\n", CLEAR_EOC_CMD_DESIG);
        fprintf(fp_HDLCdata, "Message Type:  0x%02x  (Clear EOC NAck msg)\n", pt_TxOvhdMsgInfo->uc_message_type);
        fprintf(fp_HDLCdata, "NACK Reason:   0x%02x  (Not Support)\n", CLEAR_EOC_NOT_SUPPORT);
#endif
        puca_msg_buffer[k++] = CLEAR_EOC_NOT_SUPPORT;

        break;

    }
    *pus_msg_length = k;

    return(uc_comm_or_resp_bit);
}






