/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
*  Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*  Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*  tx_ovhd_ini_bis.c
*
*  Functions to initialize the ovhd functions
*
****************************************************************************/

//******************************************************************************
// tx_ovhd_ini_bis.c
//
// History
//
// 05/07/2012 Ram: Merged "ReTx" Segmented Bitswap Request code from ARX ADSL code base.
//   To cope with sweeping and fixed RFI, the following changes are done.
//   1. Below changes #2,#4,#5,#6 are under cmv control INFO 103 23 bitmask(0x0040). This bit is one (enabled) by default.
//   2. Modify the maximum number of bits for bitswap (gs_REDUCE_LP_DELTA_BITSWAP) from 20 to 120.
//   3. Increase Tx HDLC buffer size (MAX_TX_HDLC_MSG_SIZE, MAX_TX_HDLC_BUFFER_SIZE) from 700 to 1000.
//   4. Increase the maximum tone number (gs_MaxTonePerOvhdMsg) in one HDLC segment from 160 to 240.
//   5. Enable segmented bitswap request.
//   6. Change gs_DD_RxChannelsPerSymbol from 16 to 32 to improve SNR updating frequency.
//   7. Once marign on tones were ever dropped to below -6 dB, then bitswap is triggered when minimum margin is below 0 dB.
//      The threshold (-6dB by default) can be changed with cmv INFO 119 0.
//   8. Do not move bits to the tones whose margin were ever dropped to below -6 dB since these tones were very likely
//      to be affected by RFI before, and will be affected by RFI again. This mechanism is under cmv control
//      INFO 103 23 bitmask(0x0080). This bit is one (enabled) by default.
//   9. If bitswap is failed, checking of #7 condition will be ignored. Then bitswap will be tried again.
//   10. Include fix SMS01320806 IOP_A_BisPlus_CNXT_ImprovedBitSwap.
//   Grep for "XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest"
//******************************************************************************

#include "common.h"
#include "rt_state.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "ovhd_bis.h"
#include "fifo.h"
#include "DSLEngin.h"
#include <string.h>
#include "cmv.h"

/*****************************************************************************
*   Subroutine Name: TxOvhdInit
*
*   Description:
*     This subroutine initializes variables used by the Ovhd TX functions.
*
*   Prototype:
*       void TxOvhdInit(void);
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*
*
*******************************************************************************/
#ifdef HDLC_QUEUE_LOGGING
FILE *gfp_hdlc_out;
#endif

extern int8 none_to_send;
extern int8 one_to_send;
extern int8 fifo_empty;
extern int8 fifo_full;
extern int8 bgjunk;

extern TxHdlcControl_t gta_TxHdlcControlInfo[MAX_OVHD_PRIORITY];     // per priority
void TxOvhdInit(void)
{
   int32 l_Index;

   gft_TxBpnReconfigAllowed[0] = TRUE;
   gft_TxBpnReconfigAllowed[1] = TRUE;

   guca_tx_clear_eoc_buff[0] =  1;
   guca_tx_clear_eoc_buff[1] =  2;
   guca_tx_clear_eoc_buff[2] =  3;
   guca_tx_clear_eoc_buff[3] =  4;
   guca_tx_clear_eoc_buff[4] =  5;
   guca_tx_clear_eoc_buff[5] =  6;
   guca_tx_clear_eoc_buff[6] =  7;
   guca_tx_clear_eoc_buff[7] =  8;
   guca_tx_clear_eoc_buff[8] =  9;
   guca_tx_clear_eoc_buff[9] =  10;

   /* initialize the Tx HDLC structure */
   gt_TxHDLCMsg.message_priority = 3;  /*  Invalid HDLC message priority */
    gt_TxHDLCMsg.cntrl_field = 1;      /*  HDLC message control field */
   gt_TxHDLCMsg.gus_FCS = 0;        /*  HDLC message FCS */

   gt_TxHDLCMsgFifo.MessageBuffer = guca_TxHDLCMsgBuffer;
   gt_TxHDLCMsgFifo.BufferSize = MAX_TX_HDLC_MSG_SIZE;
   gt_TxHDLCMsgFifo.IndexOfOldest = 0;
   gt_TxHDLCMsgFifo.NextAvailable = 0;
   gt_TxHDLCMsgFifo.ErrorCode = 0;
   gt_TxHDLCMsgFifo.us_OvflowCnt = 0;

   if(( gl_SelectedMode & (MODE_G992_5)  ))
   {
      /* a # > 64 i.e. the least # of tones that would prevent the number
      of msg segments being more than 8 */
      //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (Start)
      if (gt_INFX_CMV.us_OperatorSpBits3 & CMV_TO_ENABLE_FAST_BITSWAP)
        gs_MaxTonePerOvhdMsg = 240;
      else
        gs_MaxTonePerOvhdMsg = 160;
      //XDSLRTFW-443: Feature_DS_BisPlus_ALL_SegmentedBitswapRequest (End)
   }
   else
   {
      /* large # -- ensures no segmentation in ADSL2 mode */
      gs_MaxTonePerOvhdMsg = 0x7fff;
   }

   // Initialize Tx ovhd msg buffer
   memset(guca_TxHDLCMsgBuffer, 0, MAX_TX_HDLC_MSG_SIZE);


    memset(gta_TxHdlcControlInfo, 0, sizeof(gta_TxHdlcControlInfo));

   for (l_Index = 0; l_Index < MAX_OVHD_PRIORITY; l_Index++)
   {
        if (l_Index == 0)
        {
         // ME cannot request priority messages.
         gta_TxHdlcControlInfo[l_Index].uca_MaxMsgTypeCount[AUTO_CMD_SOURCE] = MAX_HDLC_AUTO_CMD + MAX_HDLC_ME_CMD;
         //gta_TxHdlcControlInfo[l_Index].uca_MaxMsgTypeCount[ME_CMD_SOURCE] = 0;
        }
        else
        {
         gta_TxHdlcControlInfo[l_Index].uca_MaxMsgTypeCount[AUTO_CMD_SOURCE] = MAX_HDLC_AUTO_CMD;
         gta_TxHdlcControlInfo[l_Index].uca_MaxMsgTypeCount[ME_CMD_SOURCE] = MAX_HDLC_ME_CMD;
        }
        gta_TxHdlcControlInfo[l_Index].uca_MaxMsgTypeCount[RESPONSE_SOURCE] = MAX_HDLC_RESPONSE;

   }
}

/*****************************************************************************
*   Subroutine Name: InitTxOvhdRegisters
*
*   Description:
*     This subroutine initializes variables used by the Ovhd TX functions.
*
*   Prototype:
*       void InitTxOvhdRegisters(void)
*
*   Input Arguments: none
*
*   Output Arguments: none
*
*   Return: none
*
*
*
*******************************************************************************/

void InitTxOvhdRegisters(void)
{

   int i;

   /* Initialise the Self test register */
   for(i = 0; i< SELF_TEST_REG_LENGTH; i++)
      gt_TxOvhdRegister.uc_self_test_reg[i] = 0;


}
