/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             Tx_plam_bis.c
 * DESCRIPTION:      Functions that implement Tx PLAM
 *
 **********************************************************************/

// *****************************************************************************
// tx_plam_bis.c
//
// History
//
// 19/06/2012 Ram: Merged "ReTx" related MGMT counters and Test Params code from
//                 ARX ADSL code base (Grep: FEATURE_DS_BisPlus_ALL_ReTx_MGMTCntrs_TestParams)
//                 Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 07/01/2013 Ram: Fix added for JIRA 575. Making sure that counter 'gs_contiguous_good_sec_cnt'
//                 is incremented after both Modem Tx and Rx enters showtime.
//                 Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
// 29/01/2013 ChihWen:
//          1. Modify reported ETR from 16-bit kbps format to 32-bit bps format.
//          2. Fix DS rate calculation when ReTx is on and Tp[1]=-1.
//          Grep for XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr
//
// 18/06/2013 Anantha Ramu:
//          Mapped ReTx EFTR defect seconds & EFTR to CNTR[43] CMV.
//          Grep for  XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters
//
// 30/03/2015 Sriram Shastry:Fail in TR-105i2a1 7.9 Performance Monitoring Counters during G.998.4 retransmission.
//       Grep for : XDSLRTFW-2070
//
// *****************************************************************************

#include "common.h"
#include "gdata.h"
#include "ib.h"
#include "cmv.h"
#include "plam.h"
#include "tx_plam.h"
#include "tx_plam_bis.h"
#include "const_bis.h"
#include "gdata_bis.h"
#include "data_alloc.h"
#include "states.h"

#ifdef DO_PLAM

//===========================================================================
// [G.997.1] 7.2.4.1.1 Near-end HEC violation count (HEC-P)
//The near-end HEC_violation_count performance parameter is a count of the
// number of occurrences of a near-end HEC anomaly in the ATM Data Path.
uint32 gula_hec_error_cnt[MAX_ATM_SIZE] = {0,0,0,0};
//===========================================================================

DATA_MAP_BIS
int16 gs_IB_lpr_cnt = 0;
DATA_MAP_END

/*****************************************************************************
;  Subroutine Name: void TxPlamProcessor_bis(void)
;
;; Prototype:
;     void TxPlamProcessor_bis(void)
;
;  Input Arguments:
;       none
;
;  Output Arguments:
;     none
;
;  Return:
;     none
;
*******************************************************************************/

void TxPlamProcessor_bis(void)
{

   int s_los_sef_lpr_tot;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
   uint32 ul_EFTR;
   int16 s_temp;
   FlagT ft_SES_ReTx;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

    /* Sum LOS, SEF & LPR into a single variable to save program memory */
    s_los_sef_lpr_tot = gs_los_cnt + gs_sef_cnt + gs_lpr_detect;

    /*===========================================================================*/
   /*Update the various error counts during showtime to populate the PLAM cmv*/
   /*===========================================================================*/

   /*******   1-second counts **********/
   // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
   // Make sure that both Rx and Tx are in showtime
   // if ((!gus_1Sec_RxShowtimeFrameCnt) && (isShowtime()))
   // XDSLRTFW-2070(Start)
   gus_1Sec_TxShowtimeFrameCnt++;
   if ((gus_1Sec_TxShowtimeFrameCnt== FRAME_COUNT_FOR_ONE_SEC) && (isShowtime()))   // XDSLRTFW-2070(Start_End)
   // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
   {
      gus_1Sec_TxShowtimeFrameCnt = 0;
      // XDSLRTFW-2070(End)

      /* Compute FEC errored seconds */
      if (gs_fec_ecs_cnt >=1)
      {
         gs_fec_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_FECSecCnt++; // XDSLRTFW-1562
      }

      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
      if(gt_ReTxConfigInfo.ft_ReTxOn == 0)
      {
         //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
         /* Compute errored seconds */
         if(gs_crc_cnt > 0 || s_los_sef_lpr_tot > 0)
         {
            gs_err_sec_cnt++;
            gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_ESCnt++; // XDSLRTFW-1562
         }
         //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
      }
      //Changes as per section 11 of G.INP
      //As there is no CRC on the latecncy path carrying the DTUs, the CRC-8 anomaly is redefined by
      //the detection of at least one uncorrected DTU(s) per time unit(17 ms).
      else
      {
         if (gul_DTUuc > 0 || s_los_sef_lpr_tot > 0)
         {
            gs_err_sec_cnt++;
            gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_ESCnt++; // XDSLRTFW-1562
         }

#if 0
         //Error-free bits counter
         //ul_EFTR => error free through put in bits per sec.
         //ul_EFTR = (ul_EFD*Q*S1*NDR)/(4) here NDR is in kbps
         //    =  (ul_EFD*Q*8*(H+R)*NDR)/4Lp

         //or (Implemented)
         // gul_EFD is error free DTU out of retransmission layer duing the
         //latest 1 second interval.
         // So convert these DTU's into error free bits.
         // x DTUs => x*(H*Q -2 -V) bytes
         //        => x*(H*Q -2 -V)*8 bits

         ul_EFTR = gul_EFD;
         ul_EFTR = (ul_EFTR * ((gt_ReTxConfigInfo.us_H * gt_ReTxConfigInfo.us_Q) - 2 - gt_ReTxConfigInfo.us_V)) << 3;
#else
         /* Taking the EFTR implementation from g997.c (VDSL implementation of EFTR) as gul_EFD is
          * not computed.
          */
         ul_EFTR = (gt_ReTxConfigInfo.us_ndr * 1000) - gt_ReTXStats.ul_ErroredBitsPerSec;
#endif

         gt_ReTXStats.ul_ErrorFreeBits_Prev = gul_error_free_bit_cnt;
         gul_error_free_bit_cnt += (ul_EFTR >>16);
         gt_ReTXStats.ul_ErrorFreeBits = gul_error_free_bit_cnt;


         // Actual error free through put in kbps steps.
         ul_EFTR = ul_EFTR / 1000;
//XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters (Start)
         gt_ReTXStats.ul_EFTR = ul_EFTR;
//XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters (End)
#if 0
         // Check EFTR if gul_EFD is non zero and after 2s
         if((gl_tx_sframe_count < 0x90)|| gul_EFD == 0 )
#else
         // Check EFTR after 2s
         if ((uint32)gl_tx_sframe_count < 0x90)
#endif
         {
            ul_EFTR = gul_prev_EFTR;
         }

         gul_curr_EFTR = ul_EFTR;
         if(ul_EFTR < gul_prev_EFTR)
         {
            gul_prev_EFTR =  ul_EFTR;
            gul_RETX_EFTR_min = ul_EFTR;
         }

         gt_ReTXStats.ul_EFTR_min_Prev = gul_prev_EFTR;
         gt_ReTXStats.ul_EFTR_min = gul_RETX_EFTR_min;
         //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (START)
         //gt_ReTXStats.ul_ReTX_ReceiverETR = gt_ReTxConfigInfo.us_etr;
         gt_ReTXStats.ul_ReTX_ReceiverETR = gt_ReTxConfigInfo.ul_etr;
         //XDSLRTFW-704 Feature_DS_BisPlus_All_ReTxCalulateNdrEtr (END)

         // gt_ReTxConfigInfo.us_etr is in kbps
         if(ul_EFTR < gul_leftr_thresh)
            gul_LEFTR_Defect_sec_cnt++;

         if(gul_LEFTR_Defect_sec_cnt == 0xFFFFFFFF)
            gul_LEFTR_Defect_sec_cnt = 0;
//XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters (Start)
         gt_ReTXStats.ul_LEFTR_Cntr = gul_LEFTR_Defect_sec_cnt;
//XDSLRTFW-974 Fix_DS_DS_BisPlus_All_Reporting_ReTx_Counters (End)
      }
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

      /* Compute LOS errored seconds */
      if(gs_los_cnt > 0)
      {
         gs_los_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_LOSSCnt++; // XDSLRTFW-1562
      }

      /* Compute SEF errored seconds */
      if(gs_sef_cnt > 0)
      {
         gs_sef_err_sec_cnt++;
      }

      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)

      ft_SES_ReTx = FAIL;//Initialise to FAIL
      s_temp = gs_norm_crc_1sec;
      if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {
         s_temp = gs_norm_DTUuc_1sec;
         //The severe loss of error-free throughput rate (seftr)
         //defect occurs when EFTR<ETR/2 and terminates when EFTR=ETR/2
         if( gul_curr_EFTR < (gt_ReTxConfigInfo.us_etr >> 1))
         {
            gul_sev_eftr++;
            ft_SES_ReTx = SUCCEED;
            //TODO : enable the below line only after thorough testing.
//SMS01527676:FIX_DS_BisPlus_ALL_ReTx_No_Reinit_with_persistent_SES Begin
               guc_consecutive_sev_err_sec_cnt++;
//SMS01527676:FIX_DS_BisPlus_ALL_ReTx_No_Reinit_with_persistent_SES End
         }
         else
         {
            //TODO: Needs to be terminated. Don't clear it for time being to
            // how many SES are generated due to seftr.
//SMS01527676:FIX_DS_BisPlus_ALL_ReTx_No_Reinit_with_persistent_SES Begin
            gul_sev_eftr = 0;
            //TODO : enable the below line only after thorough testing.

            guc_consecutive_sev_err_sec_cnt = 0;
//SMS01527676:FIX_DS_BisPlus_ALL_ReTx_No_Reinit_with_persistent_SES
         }
      }

      /*  Compute the severely errored seconds.  0x1200 = 18 in 8.8 format, because
            normalized crc's are in 8.8  */
      //if(gs_norm_crc_1sec >=0x1200 || s_los_sef_lpr_tot > 0)
      if ((s_temp >= 0x1200) || (s_los_sef_lpr_tot > 0 ) || (ft_SES_ReTx == SUCCEED))
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
      {
         gs_contiguous_good_sec_cnt = 0;  /* Reset the contiguous good sec counter */
         gs_contiguous_bad_sec_cnt++;
         gs_sev_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_SESCnt++; // XDSLRTFW-1562
      }
      else
      {
         gs_contiguous_good_sec_cnt++;    /* Increment the contiguous good sec counter */
         gs_contiguous_bad_sec_cnt = 0;   /* Reset the contiguous sev errored sec count */
      }

      /* Compute the line unavailable seconds count */
      if(gft_line_unavailable == TRUE)
      {
         gs_unavail_err_sec_cnt++;
         gt_HercADSL_CNTRMap_g997_NE_LinePerfCount.ul_UASLCnt++; // XDSLRTFW-1562
      }

      /****************************/
      /* Reset the 1 second count */
      /****************************/

      gs_fec_ecs_cnt = 0;

      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
      if(gt_ReTxConfigInfo.ft_ReTxOn == 0)
      {
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)
         gs_crc_cnt = 0;
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (Start)
      }
      else
      {
         gul_DTUuc = 0;
         gs_norm_DTUuc_1sec = 0;
         gt_ReTXStats.ul_ErroredBitsPerSec = 0;
      }
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (End)

      gs_norm_crc_1sec = 0;
      gs_los_cnt = 0;
      gs_sef_cnt = 0;
      gs_lpr_detect = 0;

   }
}

#endif /* DO_PLAM */
