/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
*
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:        781.276.4000
* FAX:              781.276.4001
* WEB:              http://www.aware.com
*
* FILE:             DoRxSyncSymbolOLRPM.c
* DESCRIPTION:
*
**********************************************************************/
// ******************************************************************
// DoRxSyncSymbolOLRPM.c
//
// History
//
// 06/08/10 Nihar: Added code to delay DS BitSwap
//       for all DSLAMs in DMT mode. Grep for the following
//       (i) IOP_DS_DMT_ALL_EnableDsBitSwap
//
// 12/08/2010 AdeelJ/Sriram/Bhadra: To use the existing SRA code for 1 step SRA based on CMV
//           INFO 103 20 bit mask 0x0001.The SRA step size is increased
//           to maximum if this cmv is set.
//             In this file we add overshoot check for both SRA Up- and DnShifts.
//             Grep for SMS01221899 Feature_DS_All_All_EnableOneStepSRA
// 18/06/2012 Raghu L2 changes grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 22/03/2013 Ram: Call ReverbSegueDetectorSetup() in 'Data symbol 1'
//                 (during L0 to L2 transition) to avoid Mips Peaking.
//                 Grep for XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
//
// 09/09/2014 ChihWen: HW acceleration for FDQ adaptation and SNR measurement.
//            Grep for XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ
//
// 09/09/2014 ChihWen: Avoid MIPs peaking in L2 entry and exit by moving calculation of FDQ coefficients to background tasks.
//            Grep for XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit
// ******************************************************************
#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "tx_ovrhd_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "showtime_bis.h"
#include "fifo.h"
#include "tx_ops2.h"
#include "cmv.h"
#include "mul.h"
// IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
#define FIRST_BITSWAP_SFRAMES_DELAY 50
#define NEXT_BITSWAP_SFRAMES_DELAY  20
#endif // ifndef ISDN


// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start End)
extern uint8 guc_IntoL2;

// IOP_DS_DMT_ALL_EnableDsBitSwap (End)

/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void Update_OLRPMCnt(OLRPMCntInfo_t* pt_OLRPMCnt, int16 s_OLRPMType, int16 s_countType)
*
*   Description:
*     Update couter info of OLRPMCnt_t structure
*
*  Arguments:
*
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void Update_OLRPMCnt(OLRPMCntInfo_t* pt_OLRPMCnt, int16 s_OLRPMType, int16 s_countType)
{
    int16 *p_addr;
    int32 l_temp;

    //to cover the PLUS OLR type
    if(s_OLRPMType > 3)
    s_OLRPMType -= 3;

    MULS16(l_temp, s_OLRPMType-1, gt_StructureSizeInfo.s_OLRPMCntStructOffset);
    p_addr = (int16*)(void *)pt_OLRPMCnt + l_temp + s_countType;

    (*p_addr)++;

}


/*^^^
*------------------------------------------------------------------------
*
*  Name : OvhdMsg_Timeout_Handler(uint8 uc_priority_index )
*
*  Description:  This subroutine handles the HDLC ovhd request timeout
*
*  Prototype:
*      void  OvhdMsg_Timeout_Handler(uint8 uc_priority_index )
*
*  Input Arguments:
*       uc_priority_index: the ovhd msg priority index
*
*  Output Arguments:
*
*  Return:
*      None
*
*
*  Notes:
*
*------------------------------------------------------------------------
*^^^
*/
#ifdef HDLC_QUEUE_LOGGING
extern FILE *gfp_hdlc_out;
#endif
void OvhdMsg_Timeout_Handler(int32 l_PriorityIndex)
{

    if(gta_TxHdlcControlInfo[l_PriorityIndex].uc_Source == ME_CMD_SOURCE)
    STATArray[STAT_ME_HDLC] = STAT_ME_HDLC_RESP_TIMEOUT;

    // No retransmission functionality for now, currently we just abandon msg.

    //reset the ovhd segment info
    gsa_RTXmit_OvhdMsgSegIndx[l_PriorityIndex] = -1;
    gsa_COReq_OvhdMsgSegIndx[l_PriorityIndex] = -1;
    gfta_FirstOvhdMsgSeg[l_PriorityIndex] = FALSE;

    gt_HDLCInfo.ft_InvertedSyncSymbol_expected = FALSE;
    gt_HDLCInfo.ft_SegmentedMsgProgress = FALSE;

    // For OLR or PM, we need to further restore the original showtime configuration
    if ((l_PriorityIndex == 0) || (gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedDesignator == POWER_MGMT_CMD_DESIG))
    {
        STATArray[STAT_OLRStatus_DS + (l_PriorityIndex<<1)] |= STAT_OLRPM_ABORTED;
        STATArray[STAT_OLRError_DS + (l_PriorityIndex<<1)] |= SYNCFRAME_INDICATOR_TIMEOUT;

        if (l_PriorityIndex == 0)   // OLR
        {
            Update_OLRPMCnt(&gt_DSOLRPMCnt, gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedMsgType, TIMEOUT_CNT);
            Abandon_DS_OLRPM();
        }
        else   // Power management.
        {
            if (gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedMsgType == L2_TRIM_GRANT)
            {
                //for L2 Trim, we postpone to set L2toL0Exit PCB until we receive the inverted sync symbol, therefore
                //the s_pcbDsL2toL0ExitSymbols still contains the PCB value prior to this timeout L2 trim. In this way,
                //we can restore the s_pcbDsL2Symbols back to its previous value.
                gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols;
                gt_RxOLRPMVars.s_rxOLRPMEvent = 0;
                OLRPM_RxPostProcessing(STAT_PMStatus);
            }
            else if (gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedMsgType == STATE_TRANS_REQ )
            /*ENABLE_L3_CODE*/
            {
                // Assume L3 request grant
                guc_PM_L3_Response = PM_L3_RESPONSE_TIMEOUT; //honored only if(guc_PM_L3_InternalState == WAITING_FOR_L3_RESPONSE)
                PM_L3_State_Machine();
            }
            else
            {//for L2 grant, we restore the s_pcbDsL2Symbols and s_pcbDsL2toL0ExitSymbols back to s_pcbDsL0Symbols because
                //both of them have changed right before we send the L2 grant message.
                gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols;
                gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL0Symbols;
                Abandon_DS_OLRPM();
            }

            //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (START)
            //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (START)
            #ifdef HW_SNR_FDQ
            gt_RxOLRPMVars.s_rxOLRPMEvent |= (READ_FDQ1 | READ_FDQ2);
            #endif
            //XDSLRTFW-1130 Enhance_DS_BisPlus_ALL_AvoidMipsPeakInL2EntryExit (END)
            //XDSLRTFW-1100 Enhance_DS_ALL_ALL_HW_SNR_FDQ (END)
        }


    }
#ifdef HDLC_QUEUE_LOGGING
    printf("P%d - timed out: designator = 0x%x, msg_type = 0x%x\n",
    l_PriorityIndex, gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedDesignator,
    gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedMsgType);

    fprintf(gfp_hdlc_out, "P%d - timed out]: designator = 0x%x, msg_type = 0x%x\n",
    l_PriorityIndex, gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedDesignator,
    gta_TxHdlcControlInfo[l_PriorityIndex].uc_ExpectedMsgType);
#endif
    // Reset message-expected control
#ifdef HDLC_QUEUE_LOGGING
    ClearExpectedResponse(l_PriorityIndex);
#endif
    gta_TxHdlcControlInfo[l_PriorityIndex].ft_ack_expected = FALSE;
    gta_TxHdlcControlInfo[l_PriorityIndex].us_ovhd_timer = 0;

#ifdef HDLC_STAT
    gta_TxHdlcControlInfo[l_PriorityIndex].s_TimedOutMsgCount++;
#endif
}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void DoRxSyncSymbolOLRPM(void)
*
*   Description:
*     Rx Sync Symbol OLR/PM NTC POST-Processing
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
void DoRxSyncSymbolOLRPM(void)
{
    /* phase inverted sync signal recieved -- do olr/l2 reconfiguration or l2 power trim */

    /* OLR and L0 to L2 changes bi/gi table -- setup Iridia Reverb Segue Detector again */

   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start)
   //During L2, Call ReverbSegueDetectorSetup() during 'Data symbol 1' (i.e. one symbol before going to L2) to avoid Mips Peaking
   //Search for 'L2_SETUP_REVSEQ_DETECTOR' in file 'showtime_rx_bis.c'
   if ( //(gt_RxOLRPMVars.uc_rxOLRPMState == L2_RECV_SYNC_INDICATOR) ||
      (gt_RxOLRPMVars.uc_rxOLRPMState == OLR_RECV_SYNC_INDICATOR) )  //XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2
      ReverbSegueDetectorSetup();

   // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (End)

    gt_HDLCInfo.ft_InvertedSyncSymbol_expected = FALSE;

    /* OLR Reconfiguration */
    if(gt_RxOLRPMVars.uc_rxOLRPMState == OLR_RECV_SYNC_INDICATOR)
    {
        /* Update Iridias Reverb Segue Detector to do sync symbol detection */
        // ReverbSegueDetectorSelect((int16)!gs_RxSyncToneType); Not needed for VR9 XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2

        //Increase the bitswap actual performed counter
        Update_OLRPMCnt(&gt_DSOLRPMCnt, gta_TxHdlcControlInfo[0].uc_ExpectedMsgType, PERFORM_CNT);

        // IOP_DS_DMT_ALL_EnableDsBitSwap (Start)
#ifndef ISDN   // Only for Anx-A
        if (!(OPTNArray[OPTN_AlgControl] & OPTN_DSAutoBitSwapDisable))
        {
            // Avoid DS Bitswap for next 20 super frames
            guc_TimeWindow_DS_BitSwaps = NEXT_BITSWAP_SFRAMES_DELAY;
            OPTNArray[OPTN_AlgControl] |= OPTN_DSAutoBitSwapDisable;
        }
#endif // ifndef ISDN
        // IOP_DS_DMT_ALL_EnableDsBitSwap (End)

        /* Sync indicator is received. Hence, don't wait for any HDLC message response */
        gta_TxHdlcControlInfo[0].ft_ack_expected = FALSE;

        /* change OLR state to Reconfigure */
        gt_RxOLRPMVars.uc_rxOLRPMState = OLR_RECONFIGURE;
    }
    /* else L0 to L2 or L2 Low Power Trim */
    else
    {
        // We have to disable this check because current CO send back SYNC indicator longer than 800ms
        gta_TxHdlcControlInfo[1].ft_ack_expected = FALSE;

        /* if L0 to L2 */
        if(gt_RxOLRPMVars.uc_rxOLRPMState == L2_RECV_SYNC_INDICATOR)
        {
            /* Setup Iridia Reverb Segue Detector to do l2 data symbol detection */
            ReverbSegueDetectorSelect(R_REVERB);

        }
        else //if L2 trim
        {
            /* Setting the L2 symbol PCB value here to the same as L2 to L0 Exit PCB value until inverted Sync symbol is received*/
            gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2Symbols = gt_RxOLRPMVars.t_L2PowerCutBack.s_pcbDsL2toL0ExitSymbols;
        }

        /* change PM state to Reconfigure */
        gt_RxOLRPMVars.uc_rxOLRPMState = L2_RECONFIGURE;

        // XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (Start End)
        //Set flag to capture 'Cycles' consumed during L0 to L2 transfer symbols
        guc_IntoL2 = 1;

        /* Time to reconfigure FFT/FDQ related DSP variables */
        OLRPM_RxInit((int16)(gt_RxOLRPMVars.s_rxOLRPMEvent & RECONFIG_PCB));
        /* Reconfig FFT at next interrupt, and will take effect two frames from now */
        AddFunctionToFifo(gp_RxLoadingFunctionFifo,OLRPM_RxIridiaReconfigDataPumpSetup);
    }
}
