/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             RShowtimeTxF_bis.c
 * DESCRIPTION:      Functions that implement the showtime TX non-time critical tasks for g.dmt.bis.
 *
 **********************************************************************/

 // ************************************************************************************
// RShowtimeTxF_bis.c
//
// History
//
// 20/06/2013 Varun : Added code(Debug option) to capture important showtime variables
//                   Grep for "XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 25/06/2013 Kannan: Added code to debug DEC struck issue.
//                   Grep for "XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest"
//*************************************************************************************************

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "xgdata.h"
#include "tx_ops.h"
#include "rx_ops.h"
#include "pn_tab.h"
#include "states.h"
#include "mtkernel.h"
#include "enc_gain.h"
#include "dec_gain.h"
#include "tx_m3oh.h"
#include "rx_m3oh.h"
#include "rt_tones.h"
#include "rt_state.h"
#include "synsymbl.h"
#include "tone_ord.h"
#include "bitload.h"
#include "fifo.h"
#include "cmv.h"
#include "mp.h"
#include "dslengin.h"
#include "qos.h"
#include "dec_adap.h"
#include "pll.h"
#include "timercov.h"
#include "bitswap.h"
#include "tx_plam_bis.h"
#include "prf_man.h"
#include "bert.h"
#include "detect.h"
#include "showtime_bis.h"
#include "tx_ovrhd_bis.h"
#include "ovhd_ini_bis.h"
#include "rx_ovrhd_bis.h"
#include "showinit.h"
#include "memory.h"
#include "ApplyFineGains.h"
#include "CalcRate_BIS.h"
#include "trail.h"
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
#include "dec_adap_Data.h"
#include "str_memmap.h"
#include "LL_IOf.h"
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)

// Function Prototypes
void DoTxSyncSymbolOLR(void);
void BgTxShowtimePreProc(void);
extern void  Decode_Config_Info(void);
extern void updateShowtimeBuffSymbol(void);
extern void updateShowtimeBuffSuperframe(void);

/*****************************************************************************
;  Subroutine Name: RShowtimeTxF_BIS
;
;  This subroutine controls TX showtime state to perform the following
;   ADSL-TX side operations:
;     process the interleaved path
;       process the fast path
;     perform QAM encoding
;     perform IFFT
;     generate cyclic prefix
;     generate synchronization symbol
;
;  Prototype:
;     void RShowtimeTxF_BIS(void);
;
;  Input Arguments:
;     None

;  Output Arguments:
;       None

;  Global Variables:
;     gt_TxShowTimeVars -- structure containing all following global variables used by tx.c:
;
;       s_D_tx              --  D for interleave depth
:       s_S_tx              --  number of DMT symbols per FEC codeword,
;                               intreleaved path
:       t_FastParms_tx      --  structure of fast path parameters
:       t_InlvParms_tx      --  structure of fast path parameters
;       s_FastPathType_tx   --  = FAST_DATA_PATH
;       s_InlvPathType_tx   --  = INTERLEAVED_DATA_PATH
:       s_Rf_tx             --  number of FEC redundancy bytes, fast path
:       s_Ri_tx             --  number of FEC redundancy bytes, interleaved path
:       s_RawFrameSizef_tx  --  number of payload data bytes per frame,
;                               fast path
:       s_RawFrameSizei_tx  --  number of payload data bytes per frame,
;                               interleaved path
:       s_MuxFrameSizef     --  payload bytes + overhead bytes, fast path
:       s_MuxFrameSizei    --  payload bytes + overhead bytes, interleaved path
:       s_Af_tx             --  Number of AEX bytes in the fast path
:       s_Ai_tx             --  Number of AEX bytes in the interleaved path
:       s_Lf_tx             --  Number of LEX bytes in the fast path
:       s_Li_tx             --  Number of LEX bytes in the interleaved path
:       sa_Bf_alloc         --  Array of bearer channel byte allocations for
;                               the fast path
:       sa_Bi_alloc         --  Array of bearer channel byte allocations for
;                               the interleaved path
:       sa_Bf_out           --  Array of bearer channel bytes to transmit for
;                               the fast path
:       sa_Bi_out           --  Array of bearer channel bytes to transmit for
;                               the interleaved path
;       Ft_C_Chan_Enabledf_tx -- indicates if the 'C' channel is enabled on
;                                LS0 for the fast path
;       Ft_C_Chan_Enabledi_tx -- indicates if the 'C' channel is enabled on
;                                LS0 for the interleaved path
:       s_CodewordSize      --  number of bytes per codeword, interleaved path
:       s_FecFrameSize      --  CodewordSize/S
:       s_CodewordSize_Odd  --  = CodewordSize + 1-(s_CodewordSize&1)
:       psa_BAT_tx          --  pointer to bit loading table
:       psa_FineGains_tx    --  pointer to a table fine gains
;
;   Other Global Variables Used:
;     gsa_TxToneBuf[TX_FFT_LENGTH+2]      - (O) buffer to monitor TX tone
;                                               modified in PostQAMProc()
;     gs_Tx_OutBuf_Size             - (I/O) number of samples written out per frame
;
;****************************************************************************/
int16 gs_CyclesToWaste=0;
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
extern DbgDec *gt_DbgDec;
extern FlagT gft_DbgDecLogEnable;
extern uint16 gus_DbgDecUpdateCount;
extern uint16 gt_DbgIdx;
FlagT gft_DbgTriggerDec =FALSE;
extern int16 gs_DECAdaptationCnt;
int32 *gpDecCapture=(int32*)0x20c62c;
int32 *gpDecAdaptCtrl=(int32*)0x20c630;
int16 gs_DecWaitCnt=0,gs_ConfigDecWaitCnt=50;
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)

void RShowtimeTxF_BIS(void)
{
   int32    l_StartTime, l_ElapsedCycles=0;

   l_StartTime = ReadTxTimer();

   while ((l_ElapsedCycles >= 0) && (l_ElapsedCycles < gs_CyclesToWaste))
   {
      l_ElapsedCycles = ReadTxTimer() - l_StartTime;
   }


#ifndef DISABLE_BERT
   if ((TESTArray[TEST_Control] & TEST_BertControl) != 0)
      if (gs_TxPMDFrameCnt != (TX_SYMBOLS_PER_SFRAME - 1))
         TxPNSequenceSetup();
#endif

    /* If we have just switched to showtime, re-init buffer sizes */
   /* and switch to use showtime time critical function        */
   if (gft_ShowTimeFirstPassTx==0)
    {
      AddFunctionToBkgdFifo((PtrToBkgdFunc)BgTxShowtimePreProc);

      gft_ShowTimeFirstPassTx=1;
      gt_TaskArray[TX_FRAME_START].TimeCriticalTask=RShowtimeTxTC_BIS_A;
   }


   //==============================
   // OLR NTC processing
   //==============================
   /* Check if time to set up OLR Reconfiguration */
#ifdef ADSL_62
   if (gs_TxPMDFrameCnt == OLR_US_ReconfigPMDSymbolCount-2)
   {
      switch(gt_TxOLRVars.uc_txOLRState)
      {
      case OLR_RECONFIGURE:
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,OLR_TxLoadTables);
         break;
      }
   }
#endif
   if (gs_TxPMDFrameCnt == OLR_US_ReconfigPMDSymbolCount-1)
   {
      switch(gt_TxOLRVars.uc_txOLRState)
      {
      case OLR_RECONFIGURE:
         OLR_TxInit();
         AddFunctionToFifo(gp_TxLoadingFunctionFifo,OLR_TxDataPumpSetup);
         //Update the net data rate and ovhd msg rate
         CalcRate_BitsPerSecond(&gt_tx_config, gla_USDataRate, gsa_USOvhdRate);

         break;
      }
   }

#ifdef DEBUG_TRACES
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (START)
//   Decode_Config_Info();
// XDSLRTFW-1782 : CAPTURE_CONFIGURATION_MESSAGES (END)

//XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(START)
   //one is added to TxPMDFrameCnt to make sure that log Per 'X' is not always true at gs_TxPMDFrameCnt=0
   if(((STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState) || (STATArray[STAT_MacroState] == STAT_ShowTimeState)) && (((gs_TxPMDFrameCnt+1)%gt_DebugBuffControl.s_debugBuffer_STCaptureXSymbol)==0) && (guc_IntoL2!=1))
   {
      updateShowtimeBuffSymbol();

   }
   if ((gs_TxPMDFrameCnt == TX_SYMBOLS_PER_SFRAME) && ((STATArray[STAT_MacroState] == STAT_ShowTimeTCSyncState) || (STATArray[STAT_MacroState] == STAT_ShowTimeState))&& (guc_IntoL2!=1))
   {
      updateShowtimeBuffSuperframe();
   }
   //XDSLRTFW-599 FEATURE_ALL_ALL_ALL_Debug_Buffer(END)
#endif //#ifdef DEBUG_TRACES

   //==============================
   // Sync frame pre-processing
   //==============================
    if (gs_TxPMDFrameCnt == (TX_SYMBOLS_PER_SFRAME-1))
    {

      /* The gs_TxPMDFrameCnt is read during the   prior */
      /* TC task.  Therefore the current NTC task is actually setting up s_out_frame_number + 1 */

      /* Update super frame count */
      gl_tx_sframe_count++;
      gs_tx_sframe_count_lsw = (gl_tx_sframe_count) & 0x0000FFFF;
      gs_tx_sframe_count_msw = ((gl_tx_sframe_count) >> 16) & 0x0000FFFF;

      gs_bitswap_tx_sframe_count++;

      if(gs_bitswap_tx_sframe_count == MAX_SFRAME_COUNT)
         gs_bitswap_tx_sframe_count = 0;


#ifdef DO_PLAM
      /* Tx PLAM function */
   UpdateFailure_bis();
#endif

      DoTxSyncSymbolOLR();
   }

#ifdef DO_PLAM
      /* Tx PLAM function */
      TxPlamProcessor_bis();
#endif /* DO_PLAM */

//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start)
#ifdef DEBUG_DEC_ADAPT
//DBG CODE
         if(gft_DbgDecLogEnable)
         {
            uint32 ul_data;// DecCapture = (int16)(*gpDecCapture) & 0xffff;
            ReadCoreReg((uint32)V_DEC_CAPTURE_ADDR, &ul_data);

            if (((ul_data >> 11) & 0x3)==0)
            {
               gs_DecWaitCnt++;
            }
            else
            {
               gs_DecWaitCnt =0;
               gft_DbgDecLogEnable=TRUE;
            }


            {
              // Log All debug dumps - for DEC
               gus_DbgDecUpdateCount = gus_ShowtimeDECUpdateCount;
               gt_DbgDec[gt_DbgIdx].DbgPhaseError = (gft_SynchSymbolChange<<8) | gft_CorruptedSynchFrame;
               gt_DbgDec[gt_DbgIdx].SefLosPilot= gus_ShowtimeDECUpdateCount;
               gt_DbgDec[gt_DbgIdx].NoisyPilot= (guc_DECTxCaptureFlag << 8) | guc_DECRxCaptureFlag;
               gt_DbgDec[gt_DbgIdx].DecUpdateState= guc_DECAdaptationState;
               gt_DbgDec[gt_DbgIdx].DecCoefUpdateFlag = (guc_DECCoefUpdateFlag <<8)|guc_DECCoefDnloadFlag;
               gt_DbgDec[gt_DbgIdx].DecCoefDnloadFlag= (int16)((*gpDecAdaptCtrl) & 0xffff);
               gt_DbgDec[gt_DbgIdx].DECCoefDnloadState = guc_DECCoefDnloadState;
               gt_DbgDec[gt_DbgIdx].frame_with_low_metric= ul_data & 0xffff;
               gt_DbgDec[gt_DbgIdx].RxAvgMar= gs_TxPMDFrameCnt;
               gt_DbgDec[gt_DbgIdx].PmdSymCount = gs_RxPMDFrameCnt;
               gt_DbgIdx= (gt_DbgIdx+1) & 0xff;
            }
            if ((gus_DbgDecUpdateCount == gus_ShowtimeDECUpdateCount) && (gus_ShowtimeDECUpdateCount !=0)
                  && (gs_DecWaitCnt > gs_ConfigDecWaitCnt))
            {
               gft_DbgDecLogEnable = FALSE;
            }
         }
//DBG CODE
#endif //#ifdef DEBUG_DEC_ADAPT
//XDSLRTFW-959: BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (End)

   /* DEC adaptation state machine */
   if (guc_DECAdaptationState != DEC_ADAPTATION_DISABLED)
   {
      ControlDECAdaptation();
   }

}


