/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             olr_Bpn_check_rx.c
 * DESCRIPTION:      Functions that checks Bpn reconfig.
 *
 **********************************************************************/

#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "dslengin.h"
#include "cmv.h"
#include "bitload.h"
#include "gdata_bis.h"
#include "trailend.h"
#include "states.h"
#include "mul.h"


/********************************************************************************
;  Subroutine Name: FlagT isValidFramingConfiguration(Config_t t_config, uint8 *puca_BCnToLPp,
;                             DerivedFrameProp_t* t_DerivedFrameProperties,
;                             int16* sa_deltaLp, int16* sa_deltaBpn, int16* ps_retCode)
;
;  Prototype:
;     FlagT isValidFramingConfiguration(Config_t t_config, uint8 *puca_BCnToLPp,
;                             DerivedFrameProp_t* t_DerivedFrameProperties,
;                             int16* sa_deltaLp, int16* sa_deltaBpn, int16* ps_retCode)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/

C_SCOPE FlagT isValidFramingConfiguration(Config_t* t_config, uint8 *puca_BCnToLPp,
                              DerivedFrameProp_t* t_DerivedFrameProperties,
                              int16* sa_deltaLp, int16* sa_deltaBpn, int16* ps_retCode)
{
   int16 s_retCode;
   int s_lpath, s_bc, s_newLp, s_TotalDeltaBpn;
   int16 s_latency_path;
   FlagT ft_BpnChange;
   FlagT ft_Skip;
   DerivedFramePropLatencyPath_t *pt_PropPerLp;

   pt_PropPerLp = t_DerivedFrameProperties->PropPerLp;

   for (s_lpath = 0; s_lpath < t_config->s_Nlp; s_lpath++, pt_PropPerLp++)
   {

      ft_BpnChange = FALSE;
      ft_Skip = FALSE;
      s_TotalDeltaBpn = 0;
      for(s_bc = 0; s_bc < t_config->s_Nbc; s_bc++)
      {
         s_latency_path = puca_BCnToLPp[s_bc];
         if (s_latency_path == s_lpath)
         {
            if (sa_deltaBpn[s_bc] != 0)
            {
               ft_BpnChange = TRUE;
               s_TotalDeltaBpn += sa_deltaBpn[s_bc];
            }
            else if (sa_deltaLp[s_lpath] == 0)
            {
               ft_Skip = TRUE;
            }
         }
      }

      if (ft_Skip == TRUE)
         continue;
      //From the review it appears that framing configuration
      // check for LP change (with no Bpn change) never occurs
      // because of above continue statement.

      s_retCode = 0;
      s_newLp = t_config->s_Lp[s_lpath] + sa_deltaLp[s_lpath];
      if (ft_BpnChange == FALSE)    //with no Bpn change
      {
         if ( s_newLp >pt_PropPerLp->s_OLR_LMaxNoBpn)
            s_retCode = REQ_VIOLATE_MAXLConstraint;

         if (s_newLp < pt_PropPerLp->s_OLR_LMinNoBpn)
            s_retCode |= REQ_VIOLATE_MINLConstraint;
      }
      else //with Bpn change
      {
         if (sa_deltaLp[s_lpath] != (s_TotalDeltaBpn<<3))
            s_retCode = REQ_VIOLATE_CWSizeConstraint;

         if ( s_newLp >pt_PropPerLp->s_OLR_LMaxBpn)
            s_retCode |= REQ_VIOLATE_MAXLConstraint;

         if (s_newLp < pt_PropPerLp->s_OLR_LMinBpn)
            s_retCode |= REQ_VIOLATE_MINLConstraint;
      }

      if (s_retCode != 0)
      {
         // record error code and error status in OLR cmv
         *ps_retCode |= ((s_retCode<<(s_lpath<<2)) | REQ_INVALID_FRAMING_CONSTRAINT);
         return(FALSE);
      }
   }

   return(TRUE);
}

/********************************************************************************
;  Subroutine Name: FlagT isBpnReconfigValid(int16* sa_deltaBpn,int8 *puca_BCnToLPp, FlagT *pta_BpnReconfigAllowed, Config_t *pt_config, FlagT isDownstream, int16 *ps_retCode)
;
;
;  Prototype:
;     FlagT isBpnReconfigValid(int16* sa_deltaBpn, int8 *puca_BCnToLPp, FlagT *pta_BpnReconfigAllowed, Config_t *pt_config, FlagT isDownstream, int16 *ps_retCode)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/

C_SCOPE FlagT isBpnReconfigValid(int16* sa_deltaBpn, int8 *puca_BCnToLPp, FlagT *pta_BpnReconfigAllowed,
                        Config_t *pt_config, FlagT isDownstream, int16 *ps_retCode)
{
   int i;
   int s_latency_path;
   int sa_Bpn;

   for(i = 0; i < pt_config->s_Nbc; i++)
   {
      /* Check if Bpn change requested for disabled bearer channel */
      if (sa_deltaBpn[i])
      {
         /* latency path to which Bearer channel is assigned */
         s_latency_path = puca_BCnToLPp[i];

         sa_Bpn = pt_config->sa_Bpn[s_latency_path][i]+sa_deltaBpn[i];

         /* Check if Bpn change is allowed */
         if(   pta_BpnReconfigAllowed[s_latency_path] == FALSE ||
            sa_Bpn < 0 ||
            sa_Bpn > 254)
         {
            *ps_retCode = REQ_INVALID_Bpn;
            return(FALSE);
         }
      }

   }

   *ps_retCode = 0;
   return(TRUE);
}


/********************************************************************************
;  Subroutine Name: void VerifyAndUpdateRxFramerParameters(void)
;
;
;  Prototype:
;     void VerifyAndUpdateRxFramerParameters(void)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/

C_SCOPE void VerifyAndUpdateRxFramerParameters(void)
{
   int i;
   int32 l_temp;
   for(i=0; i < NUM_DATA_PATHS; i++)
   {
      /* ===================================================================== */
      /*  Determine the Mux data frame size (payload + framing overhead) */
      /*  for LP0 and LP1 paths */
      /* ===================================================================== */

      if (gt_rx_config.s_Lp[i] > 0)
         gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize = gt_RxShowTimeVars.t_FrameParms[i].s_RawFrameSize + 1;
      else
         gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize = 0;

      MULS16(l_temp,gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize, gt_rx_config.s_Mp[i]);

      gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize = (int16)l_temp + gt_rx_config.s_Rp[i];

      // For faster Rx Data Pump processing -- ZA Run Count Mechanism
      gsa_RxMuxFrameSize[i][0] = gt_RxShowTimeVars.t_FrameParms[i].s_MuxFrameSize;
      gsa_RxMuxFrameSize[i][1] = (gsa_RxMuxFrameSize[i][0] + gt_rx_config.s_Rp[i]);
      if (gsa_RxMuxFrameCount[i] == 0)
      {
         gusa_PreconfigIRSize[i] = gsa_RxMuxFrameSize[i][1];
      }
      else
      {
         gusa_PreconfigIRSize[i] = gsa_RxMuxFrameSize[i][0];
      }

      /* ========================================================================== */
      /* Following assignment is to take care of the case having even size codeword */
      /* ========================================================================== */
      gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize_Odd = gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize | 0x1;

      if(gt_RxShowTimeVars.t_FrameParms[i].s_CodewordSize_Odd > 255)
      {
         gs_RxNextState = FAIL_RX;
         gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

         /* Set exception handler variable */
         gus_ExceptionState   = gs_RxState;
         gus_ExceptionCode = E_CODE_CONFIGURATION_PARAMETERS_ERROR;
      }
   }
}
