/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             olr_Lp_check.c
 * DESCRIPTION:      Functions that checks Lp reconfig.
 *
 **********************************************************************/

#include "common.h"
#include "gdata.h"
#include "cmv.h"
#include "gdata_bis.h"
#include "mul.h"

/********************************************************************************
;  Subroutine Name: FlagT isLpReconfigValid(int16* sa_deltaLp, Config_t *pt_config, int16* ps_retCode,FlagT ft_isDownstream)
;
;
;  Prototype:
;     FlagT isLpReconfigValid(int16* sa_deltaLp, Config_t *pt_config, int16* ps_retCode,FlagT ft_isDownstream)
;
;  Input Arguments:
;
;
;  Output Arguments:
;
;
;  Return:
;
;
;  Global Variable used by this file:
;
;****************************************************************************/
FlagT isLpReconfigValid(int16* sa_deltaLp, Config_t *pt_config, int16 *ps_retCode,FlagT ft_isDownstream)
{


   int i;
   int16 sa_Lp;
   int i_summation_Lp = 0;
   int32 l_MaxBitsPerFrame;
// XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode (Start)
   int16 s_NumTones;

   if(ft_isDownstream == TRUE)
      s_NumTones = gs_RxNumTones;
   else
      s_NumTones = gs_TxNumTones;
// XDSLRTFW-721 Enhance_DS_BisPlus_ALL_OptimizedSRACode (End)
   MULS16(l_MaxBitsPerFrame, 15, s_NumTones - 1);

   for(i = 0; i < pt_config->s_Nlp; i++)
   {
         sa_Lp = pt_config->s_Lp[i]+sa_deltaLp[i];

         /* Check if Lp of each latency path is valid */

         if(sa_Lp < 1)
         {
            *ps_retCode = REQ_INVALID_Lp;
            return(FALSE);
         }

         i_summation_Lp += sa_Lp;
   }

   /* Check if summation Lp satisfies the constraints */
   if(   (i_summation_Lp < 8) ||
      (i_summation_Lp > l_MaxBitsPerFrame))
   {
      *ps_retCode = REQ_INVALID_Lp;
      return(FALSE);
   }

   return(TRUE);


}

